/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.concurrent.atomic.LongAdder;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.tag.Tag;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class TagExportToFastqPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(TagExportToFastqPlugin.class);
    private PluginParameter<String> myDBFile = new PluginParameter.Builder<String>("db", null, String.class).guiName("Input DB").required(true).inFile().description("Input database file with tags and taxa distribution").build();
    private PluginParameter<String> myOutputFile = new PluginParameter.Builder<String>("o", null, String.class).guiName("Output File").required(true).outFile().description("Output fastq file to use as input for BWA or bowtie2").build();
    private PluginParameter<Integer> myMinCount = new PluginParameter.Builder<Integer>("c", 1, Integer.class).guiName("Min Count").description("Minimum count of reads for a tag to be output").build();

    public TagExportToFastqPlugin() {
        super(null, false);
    }

    public TagExportToFastqPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public TagExportToFastqPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        try {
            BufferedWriter bw = Utils.getBufferedWriter(this.outputFile());
            TagDataSQLite tagData = new TagDataSQLite(this.inputDB());
            LongAdder count = new LongAdder();
            tagData.getTagsWithDepth(this.minCount()).forEach((tag, depth) -> {
                this.writeFASTQ(bw, (Tag)tag);
                count.increment();
            });
            bw.close();
            tagData.close();
            myLogger.info((Object)("Finished converting binary tag count file to fastq.\nTotal number of tags written: " + count.longValue() + " (above minCount of " + this.minCount() + ")\nOuput fastq file: " + this.outputFile() + "\n\n"));
        }
        catch (Exception e) {
            myLogger.info((Object)("Catch in reading TagCount file e=" + e));
            e.printStackTrace();
        }
        return null;
    }

    private void writeFASTQ(BufferedWriter outStream, Tag tag) {
        try {
            StringBuilder sb = new StringBuilder("@tagSeq=" + tag.sequence() + "\n");
            sb.append(tag.sequence() + "\n+\n");
            for (int i = 0; i < tag.seqLength(); ++i) {
                sb.append("f");
            }
            sb.append("\n");
            outStream.write(sb.toString());
        }
        catch (IOException e) {
            myLogger.info((Object)("Catch in writing TagCount file e=" + e));
            e.printStackTrace();
        }
    }

    @Override
    public String getToolTipText() {
        return "Export unique tags to fastQ file in a format readable by aligners";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Tag Export to Fastq";
    }

    public String runPlugin(DataSet input) {
        return (String)this.performFunction(input).getData(0).getData();
    }

    public String inputDB() {
        return this.myDBFile.value();
    }

    public TagExportToFastqPlugin inputDB(String value) {
        this.myDBFile = new PluginParameter<String>(this.myDBFile, value);
        return this;
    }

    public String outputFile() {
        return this.myOutputFile.value();
    }

    public TagExportToFastqPlugin outputFile(String value) {
        this.myOutputFile = new PluginParameter<String>(this.myOutputFile, value);
        return this;
    }

    public Integer minCount() {
        return this.myMinCount.value();
    }

    public TagExportToFastqPlugin minCount(Integer value) {
        this.myMinCount = new PluginParameter<Integer>(this.myMinCount, value);
        return this;
    }
}

