/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gbs.v2;

import java.awt.Frame;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListIOUtils;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import org.apache.log4j.Logger;

public class UpdateSNPPositionQualityPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(UpdateSNPPositionQualityPlugin.class);
    private PluginParameter<String> myDBFile = new PluginParameter.Builder<String>("db", null, String.class).guiName("Input DB").required(true).inFile().description("Input database file with SNP positions stored").build();
    private PluginParameter<String> myQSFile = new PluginParameter.Builder<String>("qsFile", null, String.class).guiName("Quality Score File").required(true).inFile().description("tab-delimited txt file containing headers CHROM(String), POS(Integer) and QUALITYSCORE(Float) for filtering SNP positions from database").build();

    public UpdateSNPPositionQualityPlugin() {
        super(null, false);
    }

    public UpdateSNPPositionQualityPlugin(Frame parentFrame) {
        super(parentFrame, false);
    }

    public UpdateSNPPositionQualityPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        try {
            Path qsPath = Paths.get(this.qsFile(), new String[0]).toAbsolutePath();
            PositionList posListWithQS = PositionListIOUtils.readQualityScoreFile(qsPath.toString());
            if (posListWithQS == null) {
                String errMsg = "Error: no data read from file  " + qsPath.toString();
                myLogger.error((Object)errMsg);
                return null;
            }
            TagDataSQLite tdw = new TagDataSQLite(this.inputDB());
            tdw.putSNPPositionQS(posListWithQS);
            tdw.close();
            myLogger.info((Object)"UupdateSNPPositionQualityPlugin: Finished writing quality scores file to snpposition table.\n");
        }
        catch (Exception exc) {
            myLogger.error((Object)("Caught error adding quality scores to the database " + exc));
            exc.printStackTrace();
        }
        return null;
    }

    @Override
    public String getToolTipText() {
        return "Update SNP Position quality score";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Update SNP Position Quality";
    }

    public String runPlugin(DataSet input) {
        return (String)this.performFunction(input).getData(0).getData();
    }

    public String inputDB() {
        return this.myDBFile.value();
    }

    public UpdateSNPPositionQualityPlugin inputDB(String value) {
        this.myDBFile = new PluginParameter<String>(this.myDBFile, value);
        return this;
    }

    public String qsFile() {
        return this.myQSFile.value();
    }

    public UpdateSNPPositionQualityPlugin qsFile(String value) {
        this.myQSFile = new PluginParameter<String>(this.myQSFile, value);
        return this;
    }
}

