/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gobii;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.StringTokenizer;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.util.Utils;

public class GOBII_IFLUtils {
    public static int getChromFromLine(String mline, boolean isVCF, int[] tabPos) {
        int chrom = isVCF ? Integer.parseInt(mline.substring(0, tabPos[0])) : Integer.parseInt(mline.substring(tabPos[1] + 1, tabPos[2]));
        return chrom;
    }

    public static String getMarkerNameFromLine(String mline, boolean isVCF, int[] tabPos, String mapsetname) {
        String name = null;
        if (isVCF) {
            name = mline.substring(tabPos[1] + 1, tabPos[2]);
            if (name.equals(".")) {
                String pos = mline.substring(tabPos[0] + 1, tabPos[1]);
                String chrom = mline.substring(0, tabPos[0]);
                String mapset = "";
                if (mapsetname.toUpperCase().equals("AGPV2")) {
                    mapset = "2";
                } else if (mapsetname.toUpperCase().equals("AGPV3")) {
                    mapset = "3";
                } else if (mapsetname.toUpperCase().equals("AGPV4")) {
                    mapset = "4";
                } else {
                    System.out.println("WARNING: getMarkerNameFromLine - bad mapset name: " + mapsetname);
                }
                name = "PZ." + mapset + "." + chrom + "." + pos;
            }
        } else {
            name = mline.substring(0, tabPos[0]);
            if (name == null) {
                System.out.println("WARNING: getMarkerNameFromLine: hmp name rs field is NULL");
            }
        }
        return name;
    }

    public static int getPosFromLine(String mline, boolean isVCF, int[] tabPos) {
        int pos = isVCF ? Integer.parseInt(mline.substring(tabPos[0] + 1, tabPos[1])) : Integer.parseInt(mline.substring(tabPos[2] + 1, tabPos[3]));
        return pos;
    }

    public static String getStrandFromLine(String mline, boolean isVCF, int[] tabPos) {
        String strand = null;
        strand = isVCF ? "Unknown" : ((strand = mline.substring(tabPos[3] + 1, tabPos[4])).equals("+") ? "Forward" : (strand.equals("-") ? "Reverse" : "Unknown"));
        return strand;
    }

    public static String addMonetdbVariantData(String ref, String altsOrig, String mline, boolean isVCF, int[] tabPos) {
        StringBuilder variantsSB = new StringBuilder();
        if (isVCF) {
            String alts = altsOrig.substring(1, altsOrig.length() - 1);
            String[] altsTokens = alts.split("/");
            char[] alleles = new char[altsTokens.length + 1];
            alleles[0] = ref.charAt(0);
            int idx = 1;
            int altsIdx = 0;
            while (idx < alleles.length) {
                alleles[idx] = altsTokens[altsIdx].charAt(0);
                ++idx;
                ++altsIdx;
            }
            String taxaString = mline.substring(tabPos[8] + 1);
            StringTokenizer taxaValues = new StringTokenizer(taxaString);
            boolean firstTaxa = true;
            while (taxaValues.hasMoreTokens()) {
                if (!firstTaxa) {
                    variantsSB.append("\t");
                } else {
                    firstTaxa = false;
                }
                String nextTaxa = taxaValues.nextToken();
                if (nextTaxa.equals(".") || nextTaxa.equals("./.")) {
                    byte unknown = -1;
                    variantsSB.append(NucleotideAlignmentConstants.getNucleotideIUPAC(unknown));
                    continue;
                }
                int end = nextTaxa.indexOf(":");
                if (end != -1) {
                    nextTaxa = nextTaxa.substring(0, end);
                }
                int a1 = nextTaxa.charAt(0) - 48;
                int a2 = nextTaxa.charAt(2) - 48;
                if (a1 < 0 || a2 < 0) {
                    System.out.println("LCJ - OOPS negative values!! set to N  for nextTaxa " + nextTaxa);
                    System.out.println("  mline: " + mline.substring(0, tabPos[8]));
                    variantsSB.append(NucleotideAlignmentConstants.getNucleotideIUPAC((byte)-1));
                    continue;
                }
                byte highbyte = NucleotideAlignmentConstants.getNucleotideAlleleByte(alleles[a1]);
                byte lowbyte = NucleotideAlignmentConstants.getNucleotideAlleleByte(alleles[a2]);
                String iupacByte = NucleotideAlignmentConstants.getNucleotideIUPAC((byte)(highbyte << 4 | lowbyte));
                variantsSB.append(iupacByte);
            }
            variantsSB.append("\n");
        } else {
            String taxaString = mline.substring(tabPos[10] + 1);
            StringTokenizer taxaValues = new StringTokenizer(taxaString);
            boolean firstTaxa = true;
            while (taxaValues.hasMoreTokens()) {
                if (!firstTaxa) {
                    variantsSB.append("\t");
                } else {
                    firstTaxa = false;
                }
                variantsSB.append(taxaValues.nextToken());
            }
            variantsSB.append("\n");
        }
        return variantsSB.toString();
    }

    public static String getAltsForRef(String ref) {
        StringBuilder alts = new StringBuilder();
        String[] aTokens = new String[]{"A", "C", "G", "T"};
        boolean first = true;
        alts.append("{");
        for (String allele : aTokens) {
            if (allele.equals(ref)) continue;
            if (!first) {
                alts.append("/");
            }
            alts.append(allele);
            first = false;
        }
        alts.append("}");
        return alts.toString();
    }

    public static String getAltsFromLine(String mline, String ref, boolean isVCF, int[] tabPos) {
        StringBuilder alts = new StringBuilder();
        if (isVCF) {
            String vcfRef = mline.substring(tabPos[2] + 1, tabPos[3]);
            String alleles = mline.substring(tabPos[3] + 1, tabPos[4]);
            String[] aTokens = alleles.split(",");
            alts.append("{");
            boolean first = true;
            for (String allele : aTokens) {
                if (allele.equals(ref)) continue;
                if (!first) {
                    alts.append("/");
                }
                if (allele.startsWith("<")) {
                    String val = allele.substring(1, allele.length() - 1);
                    if (val.equals("INS")) {
                        alts.append("+");
                    } else if (val.equals("DEL")) {
                        alts.append("-");
                    }
                } else {
                    alts.append(allele);
                }
                first = false;
            }
            if (!vcfRef.equals(ref)) {
                alts.append(vcfRef);
            }
            alts.append("}");
        } else {
            String alleles = mline.substring(tabPos[0] + 1, tabPos[1]);
            String[] aTokens = alleles.split("/");
            alts.append("{");
            boolean first = true;
            for (String allele : aTokens) {
                if (allele.equals(ref)) continue;
                if (!first) {
                    alts.append("/");
                }
                alts.append(allele);
                first = false;
            }
            alts.append("}");
        }
        return alts.toString();
    }

    public static void splitIFLFile(String infile, String outdir, int maxSize) {
        BufferedReader br = Utils.getBufferedReader(infile, 0x400000);
        DataOutputStream bw = null;
        StringBuilder sb = new StringBuilder();
        int fileCount = 1;
        Path filePath = Paths.get(infile, new String[0]);
        String fileName = filePath.getFileName().toString();
        String[] fileparts = fileName.split("\\.");
        System.out.println("LCJ - fileName is " + fileName + ", fileparts.length " + fileparts.length + "\n");
        if (fileparts.length != 2) {
            System.out.println("LCJ - input file must have 1 and only 1 period in the name to differentiate dataset name from table name");
            System.out.println("Inputfile example:  DS_4.marker");
        }
        try {
            String line = br.readLine();
            String headerLine = line + "\n";
            int linecount = 0;
            int totalLines = 0;
            int maxBuffer = 10000;
            String outfile = outdir + fileparts[0] + "_" + fileCount + "." + fileparts[1];
            bw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfile)));
            bw.writeBytes(headerLine);
            ++fileCount;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
                if (++totalLines != maxSize && ++linecount != maxBuffer) continue;
                bw.writeBytes(sb.toString());
                sb.setLength(0);
                if (totalLines == maxSize) {
                    System.out.println("LCJ - linecout " + linecount + " is max size, close out file " + outfile);
                    bw.close();
                    System.out.println("LCJ - wrote file " + outfile + " with lines " + linecount);
                    outfile = outdir + fileparts[0] + "_" + fileCount + "." + fileparts[1];
                    bw = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfile)));
                    bw.writeBytes(headerLine);
                    ++fileCount;
                    totalLines = 0;
                }
                linecount = 0;
            }
            if (linecount > 0) {
                bw.writeBytes(sb.toString());
            }
            bw.close();
        }
        catch (Exception exc) {
            System.out.println("LCJ - whoops - error reading/writing file " + infile + " or outfile " + fileCount);
        }
    }
}

