/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gobii;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gobii.PreProcessGOBIIMappingFilePlugin;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class HapBreakpoints_IFLFilePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(PreProcessGOBIIMappingFilePlugin.class);
    private PluginParameter<String> breakFile = new PluginParameter.Builder<String>("breakFile", null, String.class).guiName("Breakpoint File").required(true).description("Full path to a single file containing breakpoint blocks for projection alignment OR to a directory containing breakpoint files,\n Files must end with *.pa.txt or *.pa.txt.gz").build();
    private PluginParameter<String> setName = new PluginParameter.Builder<String>("setName", null, String.class).guiName("Breakpoint Set Name").required(true).description("Name to be given to this set of breakpoints.  This name will be stored in the breakpointSet table.").build();
    private PluginParameter<String> mapset = new PluginParameter.Builder<String>("mapset", null, String.class).guiName("mapset").required(true).description("Name of the mapset to which these breakpoints refer.  Must match an existing name in the mapset table, e.g AGPV3").build();
    private PluginParameter<String> src_dataset = new PluginParameter.Builder<String>("src_dataset", null, String.class).guiName("Source Data Set").required(true).description("Name of the dataset from which these breakpoints were created.  Must match an existing name in the dataset table").build();
    private PluginParameter<String> outputDir = new PluginParameter.Builder<String>("outputDir", null, String.class).guiName("Path of output directory").required(true).description("Full path name of directory to which output files will be written, must end with a /").build();
    private PluginParameter<String> method = new PluginParameter.Builder<String>("method", null, String.class).guiName("Breakpoint Method").required(true).description("Method used to created the breakpoints, e.g. FILLIN, beagle, etc").build();
    private PluginParameter<String> donorMapFile = new PluginParameter.Builder<String>("donorMapFile", null, String.class).guiName("mappingFile").required(true).description("tab-delimited File containing a TaxaColumn name to be used to map breakFile donors with a GID. \nThis may be the same file that was used for adding germplasm and marker data.").build();
    private PluginParameter<String> taxaMapFile = new PluginParameter.Builder<String>("taxaMapFile", null, String.class).guiName("mappingFile").required(true).description("tab-delimited File containing a TaxaColumn name to be used to map breakFile taxa with a GID. \nThis may be a different file than was used for adding germplasm and marker data.").build();
    List<Path> infiles;
    boolean printTaxa = false;

    public HapBreakpoints_IFLFilePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public HapBreakpoints_IFLFilePlugin() {
        super(null, false);
    }

    @Override
    protected void postProcessParameters() {
        File dirList;
        File out = new File(this.outputDir.value());
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
        }
        if (!(dirList = new File(this.breakFile())).exists()) {
            throw new IllegalStateException("Input file or directory not found !! " + this.breakFile());
        }
        if (dirList.isDirectory()) {
            System.out.println("LCJ - breakfile is a directory, creating list of files ...");
            String inputFileGlob = "glob:*{pa.txt,pa.txt.gz}";
            this.infiles = DirectoryCrawler.listPaths(inputFileGlob, Paths.get(this.breakFile.value(), new String[0]).toAbsolutePath());
            if (this.infiles.size() < 1) {
                throw new IllegalStateException("no .txt files found in input directory !!");
            }
        } else {
            this.infiles = new ArrayList<Path>();
            Path filePath = Paths.get(this.breakFile(), new String[0]).toAbsolutePath();
            this.infiles.add(filePath);
        }
        Collections.sort(this.infiles);
        System.out.println("LCJ - size of infiles: " + this.infiles.size());
    }

    public HashMap<String, String> createNameGidMap(String mappingFile, String taxaField) {
        HashMap<String, String> taxaMapArray = new HashMap<String, String>();
        BufferedReader taxaMapFilebr = Utils.getBufferedReader(mappingFile, 0x400000);
        try {
            int taxaIdx = -1;
            int gidIdx = -1;
            String taxaMapLine = taxaMapFilebr.readLine();
            if (taxaMapLine != null) {
                String[] headers = taxaMapLine.split("\\t");
                int idx = 0;
                for (String header : headers) {
                    if (header.trim().toUpperCase().equals(taxaField)) {
                        taxaIdx = idx;
                    } else if (header.trim().toUpperCase().equals("GID")) {
                        gidIdx = idx;
                    }
                    ++idx;
                }
                if (taxaIdx == -1 || gidIdx == -1) {
                    System.out.println("LCJ - createNameGIDMap returning NULL!! taxaIdx: " + taxaIdx + " gidIdx: " + gidIdx);
                    return null;
                }
            }
            while ((taxaMapLine = taxaMapFilebr.readLine()) != null) {
                String[] data = taxaMapLine.split("\\t");
                String taxaname = data[taxaIdx].trim();
                int colonIndex = taxaname.indexOf(":");
                if (colonIndex > 0) {
                    taxaname = taxaname.substring(0, colonIndex);
                }
                String gid = data[gidIdx].trim();
                if (this.printTaxa) {
                    System.out.println("   createNameGIDMap, adding taxa:" + taxaname + " with gid " + gid);
                }
                taxaMapArray.put(taxaname, gid);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("LCJ - size of taxaMapARray: " + taxaMapArray.entrySet().size());
        return taxaMapArray;
    }

    @Override
    public DataSet processData(DataSet input) {
        try {
            System.out.println("LCJ - calling createNameGidMap for taxaMapFile");
            HashMap<String, String> taxaNameGidMap = this.createNameGidMap(this.taxaMapFile(), "NAME");
            if (taxaNameGidMap == null) {
                System.out.println("ERROR - could not create taxaname-gid mapping");
                return null;
            }
            System.out.println("\nLCJ - calling createNameGIDMap for donorMapFile");
            HashMap<String, String> donorNameGidMap = this.createNameGidMap(this.donorMapFile(), "TAXACOLUMN");
            if (donorNameGidMap == null) {
                System.out.println("ERROR - could not create taxaname-gid mapping");
                return null;
            }
            System.out.println("HapBreakpoints:processData begin\n");
            String hapbrkFile = this.outputDir() + this.setName() + ".hapbreakpoints";
            String breakSetFile = this.outputDir() + this.setName() + ".breakpoint_set";
            BufferedWriter writerhap = Utils.getBufferedWriter(hapbrkFile);
            BufferedWriter writerbrkset = Utils.getBufferedWriter(breakSetFile);
            BufferedWriter taxaNotFoundbw = Utils.getBufferedWriter("/Users/lcj34/notes_files/gobiiANDBms/gobii_loading/gobii_ifl_files/gobii_hapbreakpoints/taxaNotFound.txt");
            BufferedWriter taxaFoundbw = Utils.getBufferedWriter("/Users/lcj34/notes_files/gobiiANDBms/gobii_loading/gobii_ifl_files/gobii_hapbreakpoints/taxaFound.txt");
            StringBuilder hapSB = new StringBuilder();
            StringBuilder brksetSB = new StringBuilder();
            hapSB.append("taxa\tchr\tposition_range\tdonor1\tdonor2\tstatus\tbreakpoint_set_name\n");
            writerhap.write(hapSB.toString());
            hapSB.setLength(0);
            brksetSB.append("name\tmethod\tmapset_name\tsource_dataset_name\tstatus\n");
            brksetSB.append(this.setName());
            brksetSB.append("\t");
            brksetSB.append(this.method());
            brksetSB.append("\t");
            brksetSB.append(this.mapset());
            brksetSB.append("\t");
            brksetSB.append(this.src_dataset());
            brksetSB.append("\t1\n");
            writerbrkset.write(brksetSB.toString());
            writerbrkset.close();
            BufferedReader breakerbr = null;
            String[] donorList = null;
            int totalTaxaFound = 0;
            int totalTaxaNOTFound = 0;
            System.out.println("processData: number of infiles: " + this.infiles.size());
            for (Path filepath : this.infiles) {
                String curFile = filepath.toString();
                System.out.println("LCJ - processing file: " + curFile);
                breakerbr = Utils.getBufferedReader(curFile, 0x400000);
                String mline = breakerbr.readLine();
                int numDonors = Integer.parseInt(mline.substring(0, mline.indexOf("\t")).trim());
                int numBlocks = Integer.parseInt(mline.substring(mline.indexOf("\t") + 1).trim());
                System.out.println(" ... creatingDonorLists ..., number of donors is " + numDonors);
                donorList = new String[numDonors];
                boolean allFound = true;
                int donorCount = 0;
                int idx = 0;
                while (donorCount < numDonors) {
                    mline = breakerbr.readLine();
                    if (!mline.startsWith("#")) {
                        String[] donorInfo = mline.split("\\t");
                        String donorGid = donorNameGidMap.get(donorInfo[1].trim());
                        if (donorGid == null) {
                            System.out.println("LCJ - no donorGId found in donorMap for donor " + donorInfo[1]);
                            donorList[donorCount] = "49999999";
                            allFound = false;
                        } else {
                            donorList[donorCount] = donorGid;
                        }
                        ++donorCount;
                    }
                    ++idx;
                }
                if (!allFound) {
                    return null;
                }
                System.out.println("Processing the breakpoint file ...");
                while ((mline = breakerbr.readLine()) != null) {
                    hapSB.setLength(0);
                    if (mline.startsWith("#")) continue;
                    String[] tokens = mline.split("\t");
                    String gidForTaxa = "-1";
                    String taxa = tokens[0].trim();
                    if (taxaNameGidMap.containsKey(taxa)) {
                        gidForTaxa = taxaNameGidMap.get(taxa);
                    }
                    if (gidForTaxa.equals("-1")) {
                        ++totalTaxaNOTFound;
                        taxaNotFoundbw.write(taxa);
                        taxaNotFoundbw.write("\n");
                        gidForTaxa = "49999999";
                    }
                    ++totalTaxaFound;
                    taxaFoundbw.write(taxa);
                    taxaFoundbw.write("\n");
                    for (int blockIdx = 1; blockIdx < tokens.length; ++blockIdx) {
                        hapSB.append(gidForTaxa);
                        hapSB.append("\t");
                        String block = tokens[blockIdx];
                        String[] blockTokens = block.split(":");
                        hapSB.append(blockTokens[0]);
                        hapSB.append("\t");
                        String posRange = "[" + blockTokens[1] + "," + blockTokens[2] + ")\t";
                        hapSB.append(posRange);
                        int donor1 = Integer.parseInt(blockTokens[3]);
                        if (donor1 >= 0 && donor1 < donorList.length) {
                            hapSB.append(donorList[donor1]);
                        } else {
                            System.out.println("LCJ - donor1 in block is out of range: " + block);
                            hapSB.append("-1");
                        }
                        hapSB.append("\t");
                        int donor2 = Integer.parseInt(blockTokens[4]);
                        if (donor2 >= 0 && donor2 < donorList.length) {
                            hapSB.append(donorList[donor2]);
                        } else {
                            System.out.println("LCJ - donor2 in block is out of range: " + block);
                            hapSB.append("-1");
                        }
                        hapSB.append("\t1\t");
                        hapSB.append(this.setName());
                        hapSB.append("\n");
                    }
                    writerhap.write(hapSB.toString());
                }
            }
            if (breakerbr != null) {
                breakerbr.close();
            }
            writerhap.close();
            taxaFoundbw.close();
            taxaNotFoundbw.close();
            System.out.println("LCJ - end of plugin, total taxa found within blocks: " + totalTaxaFound + " total taxa NOT found: " + totalTaxaNOTFound);
        }
        catch (Exception exc) {
            System.out.println("processData: caught exception processing or writing files");
            exc.printStackTrace();
        }
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(HapBreakpoints_IFLFilePlugin.class);
    }

    public String breakFile() {
        return this.breakFile.value();
    }

    public HapBreakpoints_IFLFilePlugin breakFile(String value) {
        this.breakFile = new PluginParameter<String>(this.breakFile, value);
        return this;
    }

    public String setName() {
        return this.setName.value();
    }

    public HapBreakpoints_IFLFilePlugin setName(String value) {
        this.setName = new PluginParameter<String>(this.setName, value);
        return this;
    }

    public String mapset() {
        return this.mapset.value();
    }

    public HapBreakpoints_IFLFilePlugin mapset(String value) {
        this.mapset = new PluginParameter<String>(this.mapset, value);
        return this;
    }

    public String src_dataset() {
        return this.src_dataset.value();
    }

    public HapBreakpoints_IFLFilePlugin src_dataset(String value) {
        this.src_dataset = new PluginParameter<String>(this.src_dataset, value);
        return this;
    }

    public String outputDir() {
        return this.outputDir.value();
    }

    public HapBreakpoints_IFLFilePlugin outputDir(String value) {
        this.outputDir = new PluginParameter<String>(this.outputDir, value);
        return this;
    }

    public String method() {
        return this.method.value();
    }

    public HapBreakpoints_IFLFilePlugin method(String value) {
        this.method = new PluginParameter<String>(this.method, value);
        return this;
    }

    public String donorMapFile() {
        return this.donorMapFile.value();
    }

    public HapBreakpoints_IFLFilePlugin donorMapFile(String value) {
        this.donorMapFile = new PluginParameter<String>(this.donorMapFile, value);
        return this;
    }

    public String taxaMapFile() {
        return this.taxaMapFile.value();
    }

    public HapBreakpoints_IFLFilePlugin taxaMapFile(String value) {
        this.taxaMapFile = new PluginParameter<String>(this.taxaMapFile, value);
        return this;
    }
}

