/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gobii;

import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gobii.GOBIIDbUtils;
import net.maizegenetics.analysis.gobii.GOBII_IFLUtils;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GenomeSequence;
import net.maizegenetics.dna.map.GenomeSequenceBuilder;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Utils;

public class MarkerDNARun_IFLFilePlugin
extends AbstractPlugin {
    private PluginParameter<String> dbConfigFile = new PluginParameter.Builder<String>("dbConfigFile", null, String.class).guiName("dbConfigFile").required(true).description("DB connection config file").build();
    private PluginParameter<String> inputFile = new PluginParameter.Builder<String>("inputFile", null, String.class).guiName("inputFile").required(true).description("Full path of file or directory, each file including the header line. Files with format *.hmp.txt, *.hmp.txt.gz,*.vcf, *.vcf.gz will be processed.").build();
    private PluginParameter<String> outputFileDir = new PluginParameter.Builder<String>("outputFileDir", null, String.class).guiName("outputFileDir").required(true).description("Directory where created files will be written.  Should end with /").build();
    private PluginParameter<String> refFile = new PluginParameter.Builder<String>("refFile", null, String.class).guiName("Reference File").required(true).description("Species reference file used to determine ref allele at marker position").build();
    private PluginParameter<String> mappingFile = new PluginParameter.Builder<String>("mappingFile", null, String.class).guiName("mappingFile").required(true).description("tab-delimited File containing columns: TaxaColumn, name, source,MGID, GID,libraryID, plate_code, well, species, type and project").build();
    private PluginParameter<String> mapsetName = new PluginParameter.Builder<String>("mapsetName", null, String.class).guiName("Mapset Name").required(true).description("mapset name from the mapset table.  Used to identify correct linkage group, e.g. chrom 1 from agpv2 vs chrom 1 from agpv3").build();
    private PluginParameter<String> expName = new PluginParameter.Builder<String>("expName", null, String.class).guiName("Experiment Name").required(true).description("Name of experiment to which this data belongs.  Must match an experiment name from the db experiment table.").build();
    private PluginParameter<String> platformName = new PluginParameter.Builder<String>("platformName", null, String.class).guiName("Platform Name").required(true).description("THe platform on which this data set was run, e.g. GBSv27.  Must match a platform name from the platform db table").build();
    private PluginParameter<String> refName = new PluginParameter.Builder<String>("refName", null, String.class).guiName("Reference Name").required(true).description("Name of referenece, e.g agpv2.  Must match name from entry in reference table in db.").build();
    private PluginParameter<String> datasetName = new PluginParameter.Builder<String>("datasetName", null, String.class).guiName("Dataset Name").required(true).description("Name of dataset for this data.  Must match the name of one of the administered datasets in the db.").build();
    static int datasetId = -1;
    static int projectId = -1;
    static int platformId = -1;
    static int mapsetId = -1;

    public MarkerDNARun_IFLFilePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public MarkerDNARun_IFLFilePlugin() {
        super(null, false);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
    }

    @Override
    protected void postProcessParameters() {
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public DataSet processData(DataSet input) {
        DataOutputStream writerMarker = null;
        DataOutputStream writerMarkerProp = null;
        DataOutputStream writerMarkerLink = null;
        DataOutputStream writerDSMarker = null;
        DataOutputStream writerVariants = null;
        DataOutputStream writerMarkerAlts = null;
        int marker_idx = 0;
        long totalTime = System.nanoTime();
        File dataFile = new File(this.inputFile());
        if (!dataFile.exists()) {
            System.out.println("ERROR - input file doesn't exit: " + this.inputFile());
            return null;
        }
        List<Object> directoryFiles = new ArrayList<Path>();
        String inputFileGlob = "glob:*{hmp.txt,hmp.txt.gz,vcf,vcf.gz}";
        if (dataFile.isDirectory()) {
            System.out.println("LCJ - input file is a directory");
            directoryFiles = DirectoryCrawler.listPaths(inputFileGlob, Paths.get(this.inputFile.value(), new String[0]).toAbsolutePath());
            Collections.sort(directoryFiles);
        } else {
            Path inputPath = Paths.get(this.inputFile(), new String[0]).toAbsolutePath();
            directoryFiles.add(inputPath);
        }
        System.out.println("LCJ - postProcessParamers: size of DirectoryFiles is " + directoryFiles.size());
        for (int idx = 0; idx < directoryFiles.size(); ++idx) {
            System.out.println("File " + idx + ": " + directoryFiles.get(idx));
        }
        Connection dbConnection = GOBIIDbUtils.connectToDB(this.dbConfigFile());
        if (dbConnection == null) {
            throw new IllegalStateException("MarkerDNARun_IFLFilePlugin:process_data: Problem connecting to database.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select dataset_id from dataset where name = '");
        sb.append(this.datasetName());
        sb.append("';");
        datasetId = MarkerDNARun_IFLFilePlugin.getTableId(dbConnection, sb.toString(), "dataset_id");
        sb.setLength(0);
        sb.append("select platform_id from platform where name='");
        sb.append(this.platformName());
        sb.append("';");
        platformId = MarkerDNARun_IFLFilePlugin.getTableId(dbConnection, sb.toString(), "platform_id");
        sb.setLength(0);
        sb.append("select mapset_id from mapset where name='");
        sb.append(this.mapsetName());
        sb.append("';");
        mapsetId = MarkerDNARun_IFLFilePlugin.getTableId(dbConnection, sb.toString(), "mapset_id");
        HashMap<String, HmpTaxaData> taxaDataMap = this.createTaxaMap(dbConnection, this.mappingFile());
        if (taxaDataMap == null) {
            return null;
        }
        System.out.println("MarkerDNARunMGID: finished creating taxaDataMap, size: " + taxaDataMap.size());
        String markerOutFile = this.outputFileDir() + "DS_" + datasetId + ".marker";
        String markerPropOutFile = this.outputFileDir() + "DS_" + datasetId + ".marker_prop";
        String markerLinkOutFile = this.outputFileDir() + "DS_" + datasetId + ".marker_linkage_group";
        String dsMarkerOutFile = this.outputFileDir() + "DS_" + datasetId + ".dataset_marker";
        String dnarunOutFile = this.outputFileDir() + "DS_" + datasetId + ".dnarun";
        String dsdnarunOutFile = this.outputFileDir() + "DS_" + datasetId + ".dataset_dnarun";
        String variantOutFile = this.outputFileDir() + "DS_" + datasetId + ".variant";
        String markerAltsFile = this.outputFileDir() + "DS_" + datasetId + "_markerAlts.txt";
        BufferedReader markerbr = null;
        GenomeSequence myRefSequence = GenomeSequenceBuilder.instance(this.refFile());
        byte[] refChromBytes = null;
        StringBuilder markerSB = new StringBuilder();
        StringBuilder markerPropSB = new StringBuilder();
        StringBuilder markerLinkageSB = new StringBuilder();
        StringBuilder dsMarkerSB = new StringBuilder();
        StringBuilder variantsSB = new StringBuilder();
        StringBuilder markerAltsSB = new StringBuilder();
        try {
            writerMarker = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(markerOutFile)));
            writerMarkerProp = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(markerPropOutFile)));
            writerMarkerLink = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(markerLinkOutFile)));
            writerDSMarker = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dsMarkerOutFile)));
            writerVariants = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(variantOutFile)));
            writerMarkerAlts = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(markerAltsFile)));
            markerSB.append("platform_name\tvariant_id\tname\tcode\tref\talts\tsequence\treference_name\tprimers\tprobsets\tstrand_name\tstatus\n");
            writerMarker.writeBytes(markerSB.toString());
            markerPropSB.append("marker_name\tprops\n");
            writerMarkerProp.writeBytes(markerPropSB.toString());
            markerLinkageSB.append("marker_name\tplatform_id\tstart\tstop\tlinkage_group_name\tmap_id\n");
            writerMarkerLink.writeBytes(markerLinkageSB.toString());
            dsMarkerSB.append("dataset_name\tmarker_name\tplatform_id\tcall_rate\tmaf\treproducibility\tscores\tmarker_idx\n");
            writerDSMarker.writeBytes(dsMarkerSB.toString());
            markerAltsSB.append("name\tplatform_id\talts\n");
            markerSB.setLength(0);
            markerPropSB.setLength(0);
            markerLinkageSB.setLength(0);
            dsMarkerSB.setLength(0);
            variantsSB.setLength(0);
            markerAltsSB.setLength(0);
            int prevChrom = -1;
            int curChrom = -1;
            int[] tabPos = new int[11];
            System.out.println("LCJ - size of directoryFiles: " + directoryFiles);
            for (int idx = 0; idx < directoryFiles.size(); ++idx) {
                String mline;
                int totalLines = 0;
                long time = System.nanoTime();
                Path infile = (Path)directoryFiles.get(idx);
                String infileString = infile.toString();
                System.out.println("\nMarkerDNARun_IFLFilePlugin: processing file " + infileString);
                markerbr = Utils.getBufferedReader(infileString, 0x400000);
                boolean isVCF = false;
                boolean wroteHeader = false;
                if (infileString.endsWith("vcf.gz") || infileString.endsWith("vcf")) {
                    isVCF = true;
                }
                while ((mline = markerbr.readLine()) != null) {
                    ++totalLines;
                    if (mline.startsWith("##")) continue;
                    if (!wroteHeader) {
                        boolean dnaSuccess = MarkerDNARun_IFLFilePlugin.createDNARunFiles(dbConnection, mline, dnarunOutFile, dsdnarunOutFile, this.expName(), projectId, this.datasetName(), taxaDataMap, isVCF);
                        if (!dnaSuccess) {
                            System.out.println("ERROR processing dnarun and dataset_dnarun tables - time to quit!");
                            writerMarker.close();
                            writerMarkerProp.close();
                            writerMarkerLink.close();
                            writerDSMarker.close();
                            writerVariants.close();
                            writerMarkerAlts.close();
                            return null;
                        }
                        wroteHeader = true;
                        System.out.println("LCJ - found header at line " + totalLines);
                        continue;
                    }
                    int len = mline.length();
                    int tabIndex = 0;
                    for (int i = 0; tabIndex < 11 && i < len; ++i) {
                        if (mline.charAt(i) != '\t') continue;
                        tabPos[tabIndex++] = i;
                    }
                    curChrom = GOBII_IFLUtils.getChromFromLine(mline, isVCF, tabPos);
                    if (curChrom < 1 || curChrom > 10) continue;
                    if (curChrom != prevChrom) {
                        System.out.println("LCJ - processing chromosome : " + curChrom);
                        Chromosome newChrom = new Chromosome(Integer.toString(curChrom));
                        try {
                            refChromBytes = myRefSequence.chromosomeSequence(newChrom);
                        }
                        catch (Exception exc) {
                            System.out.println("LCJ - no data for chrom " + curChrom + " continuing ...");
                            continue;
                        }
                        if (refChromBytes == null) {
                            System.out.println("LCJ - NO BYTES found for chrom " + curChrom);
                            continue;
                        }
                        prevChrom = curChrom;
                    }
                    String linkageGroupName = Integer.toString(curChrom);
                    markerSB.append(this.platformName());
                    markerSB.append("\t");
                    markerSB.append("\t");
                    int position = GOBII_IFLUtils.getPosFromLine(mline, isVCF, tabPos);
                    String markerName = GOBII_IFLUtils.getMarkerNameFromLine(mline, isVCF, tabPos, this.mapsetName());
                    if (markerName == null) {
                        System.out.println("LCJ - failure from call to Gobii_IFLUtils.getMarkerNameFromLine !!!");
                        writerMarker.close();
                        writerMarkerProp.close();
                        writerMarkerLink.close();
                        writerDSMarker.close();
                        writerVariants.close();
                        writerMarkerAlts.close();
                        return null;
                    }
                    markerSB.append(markerName);
                    markerSB.append("\t");
                    markerSB.append("dummycode\t");
                    byte[] oneAllele = new byte[]{refChromBytes[position - 1]};
                    String ref = NucleotideAlignmentConstants.nucleotideBytetoString(oneAllele);
                    markerSB.append(ref);
                    markerSB.append("\t");
                    String alts = GOBII_IFLUtils.getAltsForRef(ref);
                    markerSB.append(alts);
                    markerSB.append("\t");
                    markerSB.append("\t");
                    markerSB.append(this.refName());
                    markerSB.append("\t");
                    markerSB.append("\t\t");
                    String strand = GOBII_IFLUtils.getStrandFromLine(mline, isVCF, tabPos);
                    markerSB.append(strand);
                    markerSB.append("\t");
                    markerSB.append("1\n");
                    String altsFromFile = GOBII_IFLUtils.getAltsFromLine(mline, ref, isVCF, tabPos);
                    markerAltsSB.append(markerName);
                    markerAltsSB.append("\t");
                    markerAltsSB.append(platformId);
                    markerAltsSB.append("\t");
                    markerAltsSB.append(altsFromFile);
                    markerAltsSB.append("\n");
                    markerPropSB.append(markerName);
                    markerPropSB.append("\t");
                    String propsString = "\"{\"\"23\"\": \"\"2\"\",\"\"24\"\": \"\"Zea Mays\"\",\"\"25\"\": \"\"Maize282_GBSv27_raw_MAF02\"\"}\"";
                    markerPropSB.append(propsString);
                    markerPropSB.append("\n");
                    markerLinkageSB.append(markerName);
                    markerLinkageSB.append("\t");
                    markerLinkageSB.append(platformId);
                    markerLinkageSB.append("\t");
                    markerLinkageSB.append(position);
                    markerLinkageSB.append("\t");
                    markerLinkageSB.append(position);
                    markerLinkageSB.append("\t");
                    markerLinkageSB.append(linkageGroupName);
                    markerLinkageSB.append("\t");
                    markerLinkageSB.append(mapsetId);
                    markerLinkageSB.append("\n");
                    dsMarkerSB.append(this.datasetName());
                    dsMarkerSB.append("\t");
                    dsMarkerSB.append(markerName);
                    dsMarkerSB.append("\t");
                    dsMarkerSB.append(platformId);
                    dsMarkerSB.append("\t\t\t\t\t");
                    dsMarkerSB.append(Integer.toString(marker_idx));
                    dsMarkerSB.append("\n");
                    ++marker_idx;
                    String variantLine = GOBII_IFLUtils.addMonetdbVariantData(ref, altsFromFile, mline, isVCF, tabPos);
                    if (variantLine == null) {
                        System.out.println("LCJ - failure from call to Gobii_IFLUtils.addMonetdbVariantData !!!");
                        writerMarker.close();
                        writerMarkerProp.close();
                        writerMarkerLink.close();
                        writerDSMarker.close();
                        writerVariants.close();
                        writerMarkerAlts.close();
                        return null;
                    }
                    variantsSB.append(variantLine);
                    if (totalLines <= 1000) continue;
                    writerMarker.writeBytes(markerSB.toString());
                    writerMarkerProp.writeBytes(markerPropSB.toString());
                    writerMarkerLink.writeBytes(markerLinkageSB.toString());
                    writerDSMarker.writeBytes(dsMarkerSB.toString());
                    writerVariants.writeBytes(variantsSB.toString());
                    markerSB.setLength(0);
                    markerPropSB.setLength(0);
                    markerLinkageSB.setLength(0);
                    dsMarkerSB.setLength(0);
                    variantsSB.setLength(0);
                    markerAltsSB.setLength(0);
                    totalLines = 0;
                }
                if (totalLines > 0) {
                    writerMarker.writeBytes(markerSB.toString());
                    writerMarkerProp.writeBytes(markerPropSB.toString());
                    writerMarkerLink.writeBytes(markerLinkageSB.toString());
                    writerDSMarker.writeBytes(dsMarkerSB.toString());
                    writerVariants.writeBytes(variantsSB.toString());
                    markerSB.setLength(0);
                    markerPropSB.setLength(0);
                    markerLinkageSB.setLength(0);
                    dsMarkerSB.setLength(0);
                    variantsSB.setLength(0);
                    markerAltsSB.setLength(0);
                }
                System.out.println("Process took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds for file " + infileString);
            }
            writerMarker.close();
            writerMarkerProp.close();
            writerMarkerLink.close();
            writerDSMarker.close();
            writerVariants.close();
            writerMarkerAlts.close();
            if (markerbr != null) {
                markerbr.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("Caugh exception reading or writing hmp.txt files");
            ioe.printStackTrace();
        }
        System.out.println("Total time to process all files: " + (double)(System.nanoTime() - totalTime) / 1.0E9 + " seconds ");
        return null;
    }

    public HashMap<String, HmpTaxaData> createTaxaMap(Connection conn, String mappingFile) {
        HashMap<String, HmpTaxaData> taxaDataMap = new HashMap<String, HmpTaxaData>();
        BufferedReader mappingbr = Utils.getBufferedReader(mappingFile);
        System.out.println("MarkerDNARunMGID: creating taxaDataMap from mapping file");
        try {
            int taxaIdx = -1;
            int nameIdx = -1;
            int sourceIdx = -1;
            int mgidIdx = -1;
            int gidIdx = -1;
            int libIdx = -1;
            int plateIdx = -1;
            int wellIdx = -1;
            int speciesIdx = -1;
            int typeIdx = -1;
            int projectIdx = -1;
            int sampleIdx = -1;
            String mappingLine = mappingbr.readLine();
            String[] headers = mappingLine.split("\\t");
            int idx = 0;
            for (String header : headers) {
                if (header.trim().toUpperCase().equals("TAXACOLUMN")) {
                    taxaIdx = idx;
                } else if (header.trim().toUpperCase().equals("NAME")) {
                    nameIdx = idx;
                } else if (header.trim().toUpperCase().equals("SOURCE")) {
                    sourceIdx = idx;
                } else if (header.trim().toUpperCase().equals("MGID")) {
                    mgidIdx = idx;
                } else if (header.trim().toUpperCase().equals("GID")) {
                    gidIdx = idx;
                } else if (header.trim().toUpperCase().equals("LIBRARYID")) {
                    libIdx = idx;
                } else if (header.trim().toUpperCase().equals("PLATE_CODE")) {
                    plateIdx = idx;
                } else if (header.trim().toUpperCase().equals("WELL")) {
                    wellIdx = idx;
                } else if (header.trim().toUpperCase().equals("SPECIES")) {
                    speciesIdx = idx;
                } else if (header.trim().toUpperCase().equals("TYPE")) {
                    typeIdx = idx;
                } else if (header.trim().toUpperCase().equals("PROJECT")) {
                    projectIdx = idx;
                } else if (header.trim().toUpperCase().equals("SAMPLENAME")) {
                    sampleIdx = idx;
                }
                ++idx;
            }
            if (taxaIdx == -1 || nameIdx == -1 || sourceIdx == -1 || mgidIdx == -1 || gidIdx == -1 || libIdx == -1 || plateIdx == -1 || wellIdx == -1 || speciesIdx == -1 || typeIdx == -1 || projectIdx == -1 || sampleIdx == -1) {
                System.out.println("Mappingfile is missing required header line.  Expecting columns: TaxaColumn, name, source, MGID, GID, libraryID, plate_code, well, species, type, project, SampleName");
                return null;
            }
            boolean first = true;
            while ((mappingLine = mappingbr.readLine()) != null) {
                String[] data = mappingLine.split("\\t");
                if (first) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("select project_id from project where name = '");
                    sb.append(data[projectIdx].trim());
                    sb.append("';");
                    projectId = MarkerDNARun_IFLFilePlugin.getTableId(conn, sb.toString(), "project_id");
                    first = false;
                }
                String taxa = data[taxaIdx].trim();
                String mgid = data[mgidIdx].trim();
                String libID = data[libIdx].trim();
                String plateName = data[plateIdx].trim();
                String well = data[wellIdx].trim();
                String gid = data[gidIdx].trim();
                String sampleName = null;
                sampleName = sampleIdx == -1 || data[sampleIdx].trim().equals("") ? data[gidIdx].trim() + ":" + data[plateIdx].trim() + ":" + data[wellIdx].trim() : data[sampleIdx].trim();
                HmpTaxaData taxaDataItem = new HmpTaxaData(mgid, gid, libID, plateName, well, sampleName);
                taxaDataMap.put(taxa, taxaDataItem);
            }
        }
        catch (IOException ioe) {
            System.out.println("Caught exception reading mapping file");
            ioe.printStackTrace();
            return null;
        }
        return taxaDataMap;
    }

    private static int getTableId(Connection conn, String query, String column) {
        try {
            ResultSet rs = conn.createStatement().executeQuery(query);
            if (rs.next()) {
                int id = rs.getInt(column);
                return id;
            }
        }
        catch (SQLException sqle) {
            System.out.println("getTableId barfed on query: " + query);
            sqle.printStackTrace();
            return -1;
        }
        return -1;
    }

    private static boolean createDNARunFiles(Connection dbConnection, String hdrLine, String dnarunOutFile, String dsdnarunOutFile, String expName, int projectId, String dsName, HashMap<String, HmpTaxaData> taxaDataMap, boolean isVCF) {
        System.out.println("LCJ - createDNARunFiles - begin ");
        int dnarun_idx = 0;
        boolean returnVal = true;
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("select experiment_id from experiment where name= '");
            builder.append(expName);
            builder.append("';");
            int experiment_id = MarkerDNARun_IFLFilePlugin.getTableId(dbConnection, builder.toString(), "experiment_id");
            if (experiment_id == -1) {
                return false;
            }
            DataOutputStream writerDNARun = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dnarunOutFile)));
            DataOutputStream writerDSdnaRun = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dsdnarunOutFile)));
            String[] hdrTokens = hdrLine.split("\t");
            System.out.println("LCJ - createDNARunFiles: size of hdrTokens: " + hdrTokens.length);
            StringBuilder dsDNArunSB = new StringBuilder();
            StringBuilder dnaRunSB = new StringBuilder();
            dnaRunSB.append("experiment_name\tdnasample_name\tproject_id\tname\tcode\n");
            writerDNARun.writeBytes(dnaRunSB.toString());
            dsDNArunSB.append("dataset_name\tdnarun_name\texperiment_id\tdnarun_idx\n");
            writerDSdnaRun.writeBytes(dsDNArunSB.toString());
            int idx = 11;
            if (isVCF) {
                idx = 9;
            }
            while (idx < hdrTokens.length) {
                dsDNArunSB.setLength(0);
                dnaRunSB.setLength(0);
                HmpTaxaData taxaData = taxaDataMap.get(hdrTokens[idx].trim());
                if (taxaData == null) {
                    System.out.println("LCJ - createDNARunFiles - NO DATA FOR taxa " + hdrTokens[idx]);
                    returnVal = false;
                } else {
                    dnaRunSB.append(expName);
                    dnaRunSB.append("\t");
                    dnaRunSB.append(taxaData.getDnasampleName());
                    dnaRunSB.append("\t");
                    dnaRunSB.append(projectId);
                    dnaRunSB.append("\t");
                    String dnarun_name = taxaData.getLibraryID();
                    dnaRunSB.append(dnarun_name);
                    dnaRunSB.append("\t");
                    dnaRunSB.append("dummycode");
                    dnaRunSB.append("\n");
                    writerDNARun.writeBytes(dnaRunSB.toString());
                    dsDNArunSB.append(dsName);
                    dsDNArunSB.append("\t");
                    dsDNArunSB.append(dnarun_name);
                    dsDNArunSB.append("\t");
                    dsDNArunSB.append(experiment_id);
                    dsDNArunSB.append("\t");
                    dsDNArunSB.append(Integer.toString(dnarun_idx));
                    dsDNArunSB.append("\n");
                    ++dnarun_idx;
                    writerDSdnaRun.writeBytes(dsDNArunSB.toString());
                }
                ++idx;
            }
            writerDNARun.close();
            writerDSdnaRun.close();
        }
        catch (IOException ioe) {
            System.out.println("LCJ - error processing IFL files for dnarun or dataset_dnarun table");
            ioe.printStackTrace();
            return false;
        }
        System.out.println("LCJ - successful creation of DNARun and dataset_dnarun files");
        return returnVal;
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(MarkerDNARun_IFLFilePlugin.class);
    }

    public String dbConfigFile() {
        return this.dbConfigFile.value();
    }

    public MarkerDNARun_IFLFilePlugin dbConfigFile(String value) {
        this.dbConfigFile = new PluginParameter<String>(this.dbConfigFile, value);
        return this;
    }

    public String inputFile() {
        return this.inputFile.value();
    }

    public MarkerDNARun_IFLFilePlugin inputFile(String value) {
        this.inputFile = new PluginParameter<String>(this.inputFile, value);
        return this;
    }

    public String outputFileDir() {
        return this.outputFileDir.value();
    }

    public MarkerDNARun_IFLFilePlugin outputFileDir(String value) {
        this.outputFileDir = new PluginParameter<String>(this.outputFileDir, value);
        return this;
    }

    public String refFile() {
        return this.refFile.value();
    }

    public MarkerDNARun_IFLFilePlugin refFile(String value) {
        this.refFile = new PluginParameter<String>(this.refFile, value);
        return this;
    }

    public String mappingFile() {
        return this.mappingFile.value();
    }

    public MarkerDNARun_IFLFilePlugin mappingFile(String value) {
        this.mappingFile = new PluginParameter<String>(this.mappingFile, value);
        return this;
    }

    public String mapsetName() {
        return this.mapsetName.value();
    }

    public MarkerDNARun_IFLFilePlugin mapsetName(String value) {
        this.mapsetName = new PluginParameter<String>(this.mapsetName, value);
        return this;
    }

    public String expName() {
        return this.expName.value();
    }

    public MarkerDNARun_IFLFilePlugin expName(String value) {
        this.expName = new PluginParameter<String>(this.expName, value);
        return this;
    }

    public String platformName() {
        return this.platformName.value();
    }

    public MarkerDNARun_IFLFilePlugin platformName(String value) {
        this.platformName = new PluginParameter<String>(this.platformName, value);
        return this;
    }

    public String refName() {
        return this.refName.value();
    }

    public MarkerDNARun_IFLFilePlugin refName(String value) {
        this.refName = new PluginParameter<String>(this.refName, value);
        return this;
    }

    public String datasetName() {
        return this.datasetName.value();
    }

    public MarkerDNARun_IFLFilePlugin datasetName(String value) {
        this.datasetName = new PluginParameter<String>(this.datasetName, value);
        return this;
    }

    public static class HmpTaxaData {
        private String MGID;
        private String libraryID;
        private String plateName;
        private String dnasampleName;
        private String num;

        HmpTaxaData(String MGID, String GID, String libraryID, String plateName, String well, String sampleName) {
            this.MGID = MGID;
            this.libraryID = libraryID;
            this.plateName = plateName;
            this.dnasampleName = sampleName;
            this.num = "";
        }

        public String getMGID() {
            return this.MGID;
        }

        public String getLibraryID() {
            return this.libraryID;
        }

        public String getPlateName() {
            return this.plateName;
        }

        public String getDnasampleName() {
            return this.dnasampleName;
        }

        public String getNum() {
            return this.num;
        }
    }
}

