/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.gobii;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gobii.GOBIIDbUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class PreProcessGOBIIMappingFilePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(PreProcessGOBIIMappingFilePlugin.class);
    private PluginParameter<String> dbConfigFile = new PluginParameter.Builder<String>("dbConfigFile", null, String.class).guiName("dbConfigFile").required(true).description("DB connection config file").build();
    private PluginParameter<String> datasetName = new PluginParameter.Builder<String>("datasetName", null, String.class).guiName("dataset name").required(true).description("Name of existing database dataset.  Will be used to pull dataset_id from the db.  This id is incorporated into the output file names.").build();
    private PluginParameter<String> mappingFile = new PluginParameter.Builder<String>("mappingFile", null, String.class).guiName("mappingFile").required(true).description("tab-delimited File containing columns: taxaColumn, name, source,MGID, GID,libraryID, plate_code, well, species, type, project").build();
    private PluginParameter<String> outputDir = new PluginParameter.Builder<String>("outputDir", null, String.class).guiName("Path of output directory").required(true).description("Full path name of output directory, must end with a /").build();

    public PreProcessGOBIIMappingFilePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public PreProcessGOBIIMappingFilePlugin() {
        super(null, false);
    }

    @Override
    public DataSet processData(DataSet input) {
        try {
            Connection dbConnection = GOBIIDbUtils.connectToDB(this.dbConfigFile());
            if (dbConnection == null) {
                throw new IllegalStateException("PreProcessGOBIIMappingFilePlugin: Problem connecting to database.");
            }
            StringBuilder sb = new StringBuilder();
            sb.append("select dataset_id from dataset where name = '");
            sb.append(this.datasetName());
            sb.append("';");
            ResultSet rs = dbConnection.createStatement().executeQuery(sb.toString());
            int datasetId = -1;
            while (rs.next()) {
                datasetId = rs.getInt("dataset_id");
            }
            if (datasetId < 0) {
                System.out.println("Could not find datasetId from datasetName " + this.datasetName() + " please check name and try again !!");
                return null;
            }
            System.out.println("LCJ - processing dataset number " + datasetId);
            String germplasmFile = this.outputDir() + "DS_" + datasetId + ".germplasm";
            String dnasampleFile = this.outputDir() + "DS_" + datasetId + ".dnasample";
            String dupLibIDFile = this.outputDir() + "DS_" + datasetId + ".dup_libraryPrepIds";
            BufferedWriter writergp = Utils.getBufferedWriter(germplasmFile);
            BufferedWriter writerdna = Utils.getBufferedWriter(dnasampleFile);
            BufferedWriter writerlib = Utils.getBufferedWriter(dupLibIDFile);
            StringBuilder builder = new StringBuilder();
            builder.append("select external_code from germplasm;");
            String query = builder.toString();
            myLogger.info((Object)("processData: query statement: " + query));
            System.out.println("PreProcessGOBIIMappingFilePlugin: execute query: " + query);
            rs = dbConnection.createStatement().executeQuery(query);
            ArrayList<String> existingGermplasm = new ArrayList<String>();
            while (rs.next()) {
                existingGermplasm.add(rs.getString("external_code"));
            }
            builder = new StringBuilder();
            builder.append("select name from dnasample;");
            query = builder.toString();
            myLogger.info((Object)("processData: query statement: " + query));
            System.out.println("PreProcessGOBIIMappingFilePlugin: execute query: " + query);
            rs = dbConnection.createStatement().executeQuery(query);
            ArrayList<String> existingDNASample = new ArrayList<String>();
            while (rs.next()) {
                existingDNASample.add(rs.getString("name"));
            }
            builder = new StringBuilder();
            builder.append("select name from dnarun;");
            query = builder.toString();
            myLogger.info((Object)("processData: query statement: " + query));
            System.out.println("PreProcessGOBIIMappingFilePlugin: execute query: " + query);
            rs = dbConnection.createStatement().executeQuery(query);
            ArrayList<String> existingLib = new ArrayList<String>();
            while (rs.next()) {
                existingLib.add(rs.getString("name"));
            }
            StringBuilder germplasmSB = new StringBuilder();
            StringBuilder dnasampleSB = new StringBuilder();
            germplasmSB.append("name\texternal_code\tspecies_name\ttype_name\tcreated_by\tcreated_date\tmodified_by\tmodified_date\tstatus\tcode\n");
            writergp.write(germplasmSB.toString());
            dnasampleSB.append("name\tcode\tplatename\tnum\twell_row\twell_col\tproject_name\texternal_code\tcreated_by\tcreated_date\tmodified_by\tmodified_date\tstatus\n");
            writerdna.write(dnasampleSB.toString());
            int taxaIdx = -1;
            int nameIdx = -1;
            int sourceIdx = -1;
            int mgidIdx = -1;
            int gidIdx = -1;
            int libIdx = -1;
            int plateIdx = -1;
            int wellIdx = -1;
            int speciesIdx = -1;
            int typeIdx = -1;
            int projectIdx = -1;
            int sampleNameIdx = -1;
            BufferedReader germplasmBR = Utils.getBufferedReader(this.mappingFile());
            String mline = germplasmBR.readLine();
            writerlib.write(mline);
            System.out.println("\nPreprocessGObii: getting header columns from mline: " + mline);
            String[] headers = mline.split("\\t");
            if (mline.contains("TaxaColumn")) {
                int idx = 0;
                for (String header : headers) {
                    if (header.trim().toUpperCase().equals("TAXACOLUMN")) {
                        taxaIdx = idx;
                    } else if (header.trim().toUpperCase().equals("NAME")) {
                        nameIdx = idx;
                    } else if (header.trim().toUpperCase().equals("SOURCE")) {
                        sourceIdx = idx;
                    } else if (header.trim().toUpperCase().equals("MGID")) {
                        mgidIdx = idx;
                    } else if (header.trim().toUpperCase().equals("GID")) {
                        gidIdx = idx;
                    } else if (header.trim().toUpperCase().equals("LIBRARYID")) {
                        libIdx = idx;
                    } else if (header.trim().toUpperCase().equals("PLATE_CODE")) {
                        plateIdx = idx;
                    } else if (header.trim().toUpperCase().equals("WELL")) {
                        wellIdx = idx;
                    } else if (header.trim().toUpperCase().equals("SPECIES")) {
                        speciesIdx = idx;
                    } else if (header.trim().toUpperCase().equals("TYPE")) {
                        typeIdx = idx;
                    } else if (header.trim().toUpperCase().equals("PROJECT")) {
                        projectIdx = idx;
                    } else if (header.trim().toUpperCase().equals("SAMPLENAME")) {
                        sampleNameIdx = idx;
                    }
                    ++idx;
                }
            } else {
                System.out.println("Mappingfile is missing header line !!!");
                return null;
            }
            if (taxaIdx == -1 || nameIdx == -1 || sourceIdx == -1 || mgidIdx == -1 || gidIdx == -1 || libIdx == -1 || plateIdx == -1 || wellIdx == -1 || speciesIdx == -1 || typeIdx == -1 || projectIdx == -1 || sampleNameIdx == -1) {
                System.out.println("\nMappingfile is missing required header line.  Expecting columns: TaxaColumn, name, source, MGID, GID, libraryID, plate_code, well, species, type, project, SampleName\n");
                return null;
            }
            System.out.println("PreprocessGobii: processing mapping file: " + this.mappingFile());
            int dnaNotAdded = 0;
            int germplasmNotAdded = 0;
            int totalLines = 0;
            ArrayList<String> addedGermplasm = new ArrayList<String>();
            while ((mline = germplasmBR.readLine()) != null) {
                String[] data = mline.split("\\t");
                ++totalLines;
                if (data[gidIdx].trim() != null && !existingGermplasm.contains(data[gidIdx].trim()) && !addedGermplasm.contains(data[gidIdx].trim())) {
                    String gpentry = "\t" + data[gidIdx].trim() + "\t" + data[speciesIdx].trim() + "\t" + data[typeIdx].trim() + "\t\t\t\t\t1\t0\n";
                    writergp.write(gpentry);
                    addedGermplasm.add(data[gidIdx].trim());
                } else {
                    System.out.println("LCJ - not adding " + data[nameIdx].trim() + " to germplasm file");
                    ++germplasmNotAdded;
                }
                String sampleName = null;
                sampleName = sampleNameIdx == -1 || data[sampleNameIdx].trim().equals("") ? data[gidIdx].trim() + ":" + data[plateIdx].trim() + ":" + data[wellIdx].trim() : data[sampleNameIdx].trim();
                if (data[gidIdx] != null && !existingDNASample.contains(sampleName)) {
                    String wellRow = data[wellIdx].trim();
                    String wellCol = "";
                    if (!wellRow.equals("")) {
                        wellRow = wellRow.substring(0, 1);
                        wellCol = data[wellIdx].substring(1);
                    }
                    String dnaentry = sampleName + "\tdummycode\t" + data[plateIdx].trim() + "\t\t" + wellRow + "\t" + wellCol + "\t" + data[projectIdx].trim() + "\t" + data[gidIdx].trim() + "\t6\t\t\t\t1\n";
                    writerdna.write(dnaentry);
                } else {
                    System.out.println("LCJ - not adding " + data[nameIdx].trim() + " to dnasample file");
                    ++dnaNotAdded;
                }
                if (data[gidIdx].trim() == null || !existingLib.contains(data[libIdx].trim())) continue;
                writerlib.write(mline);
            }
            writergp.close();
            writerdna.close();
            writerlib.close();
            System.out.println("\nFiles written to " + germplasmFile + " and " + dnasampleFile);
            System.out.println("Total mapping file lines: " + totalLines + " Not added to germplasm:" + germplasmNotAdded + ", not added to dnasample:" + dnaNotAdded + "\n");
        }
        catch (Exception exc) {
            System.out.println("PreProcessGOBIIMappingFilePlugin:  caught exception processing or writing files");
            exc.printStackTrace();
        }
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return null;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public String dbConfigFile() {
        return this.dbConfigFile.value();
    }

    public PreProcessGOBIIMappingFilePlugin dbConfigFile(String value) {
        this.dbConfigFile = new PluginParameter<String>(this.dbConfigFile, value);
        return this;
    }

    public String datasetName() {
        return this.datasetName.value();
    }

    public PreProcessGOBIIMappingFilePlugin datasetName(String value) {
        this.datasetName = new PluginParameter<String>(this.datasetName, value);
        return this;
    }

    public String mappingFile() {
        return this.mappingFile.value();
    }

    public PreProcessGOBIIMappingFilePlugin mappingFile(String value) {
        this.mappingFile = new PluginParameter<String>(this.mappingFile, value);
        return this;
    }

    public String outputDir() {
        return this.outputDir.value();
    }

    public PreProcessGOBIIMappingFilePlugin outputDir(String value) {
        this.outputDir = new PluginParameter<String>(this.outputDir, value);
        return this;
    }
}

