/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.maizegenetics.analysis.imputation.BackwardForwardAlgorithm;
import net.maizegenetics.analysis.imputation.EmissionProbability;
import net.maizegenetics.analysis.imputation.TransitionProbability;
import org.apache.log4j.Logger;

public class BackwardForwardVariableStateNumber {
    private static final Logger myLogger = Logger.getLogger(BackwardForwardAlgorithm.class);
    private int[] myObservations;
    private int[] myPositions;
    private TransitionProbability myTransitions;
    private EmissionProbability myEmissions;
    private double[] initialStateProbability;
    private List<double[]> alpha;
    private List<double[]> beta;

    public BackwardForwardVariableStateNumber calculateAlpha() {
        this.myTransitions.setNode(0);
        int nStates = this.myTransitions.getNumberOfStates();
        int nObs = this.myObservations.length;
        this.alpha = new LinkedList<double[]>();
        double[] aPrior = new double[nStates];
        for (int s = 0; s < nStates; ++s) {
            aPrior[s] = this.initialStateProbability[s] * this.myEmissions.getProbObsGivenState(s, this.myObservations[0], 0);
        }
        this.alpha.add(aPrior);
        for (int t = 1; t < nObs; ++t) {
            this.myTransitions.setNode(t);
            int nPreviousStates = nStates;
            nStates = this.myTransitions.getNumberOfStates();
            double[] aT = new double[nStates];
            for (int j = 0; j < nStates; ++j) {
                double sumTrans = 0.0;
                for (int i = 0; i < nPreviousStates; ++i) {
                    sumTrans += aPrior[i] * this.myTransitions.getTransitionProbability(i, j);
                }
                aT[j] = sumTrans * this.myEmissions.getProbObsGivenState(j, this.myObservations[t], t);
            }
            aT = this.multiplyArrayByConstantIfSmall(aT);
            this.alpha.add(aT);
            aPrior = aT;
        }
        return this;
    }

    private double[] multiplyArrayByConstantIfSmall(double[] dblArray) {
        double maxval;
        double minval = Arrays.stream(dblArray).min().getAsDouble();
        if (minval < 1.0E-50 && (maxval = Arrays.stream(dblArray).max().getAsDouble()) < 1.0E-25) {
            return Arrays.stream(dblArray).map(d -> d * 1.0E25).toArray();
        }
        return dblArray;
    }

    public BackwardForwardVariableStateNumber calculateBeta() {
        int nObs = this.myObservations.length;
        LinkedList<double[]> betaTemp = new LinkedList<double[]>();
        this.myTransitions.setNode(nObs - 1);
        int nStates = this.myTransitions.getNumberOfStates();
        double[] bNext = new double[nStates];
        Arrays.fill(bNext, 1.0);
        betaTemp.add(bNext);
        for (int t = nObs - 2; t >= 0; --t) {
            this.myTransitions.setNode(t);
            int nNextStates = nStates;
            nStates = this.myTransitions.getNumberOfStates();
            double[] bT = new double[nStates];
            this.myTransitions.setNode(t + 1);
            for (int i = 0; i < nStates; ++i) {
                double sumStates = 0.0;
                for (int j = 0; j < nNextStates; ++j) {
                    sumStates += this.myTransitions.getTransitionProbability(i, j) * this.myEmissions.getProbObsGivenState(j, this.myObservations[t + 1], t + 1) * bNext[j];
                }
                bT[i] = sumStates;
            }
            bT = this.multiplyArrayByConstantIfSmall(bT);
            betaTemp.addFirst(bT);
            bNext = bT;
        }
        this.beta = betaTemp;
        return this;
    }

    public List<double[]> gamma() {
        ArrayList<double[]> gamma = new ArrayList<double[]>();
        Iterator<double[]> itAlpha = this.alpha.iterator();
        Iterator<double[]> itBeta = this.beta.iterator();
        while (itAlpha.hasNext()) {
            double[] alphaArray = itAlpha.next();
            double[] betaArray = itBeta.next();
            int n = alphaArray.length;
            double[] gammaArray = new double[n];
            for (int i = 0; i < n; ++i) {
                gammaArray[i] = alphaArray[i] * betaArray[i];
            }
            double divisor = Arrays.stream(gammaArray).sum();
            int i = 0;
            while (i < n) {
                int n2 = i++;
                gammaArray[n2] = gammaArray[n2] / divisor;
            }
            gamma.add(gammaArray);
        }
        return gamma;
    }

    public BackwardForwardVariableStateNumber emission(EmissionProbability emission) {
        this.myEmissions = emission;
        return this;
    }

    public BackwardForwardVariableStateNumber transition(TransitionProbability transition) {
        this.myTransitions = transition;
        return this;
    }

    public BackwardForwardVariableStateNumber observations(int[] observations) {
        this.myObservations = observations;
        return this;
    }

    public BackwardForwardVariableStateNumber positions(int[] positions) {
        this.myPositions = positions;
        return this;
    }

    public BackwardForwardVariableStateNumber initialStateProbability(double[] probs) {
        this.initialStateProbability = probs;
        return this;
    }

    public List<double[]> alpha() {
        return this.alpha;
    }

    public List<double[]> beta() {
        return this.beta;
    }
}

