/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import net.maizegenetics.analysis.imputation.EmissionProbability;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableUtils;

public class CrossProgenyEmissionMatrix
extends EmissionProbability {
    private static final byte N = 15;
    private static final byte NN = -1;
    private byte[][][] parentHaplotypes;
    private GenotypeTable progenyGenotypes;
    private double[][] parentHaplotypeProbabilities;
    private double[][] obsGivenState = new double[3][3];
    private int myTaxonIndex;
    private int[] mySiteIndices;
    private boolean useProbabilityTables;

    public CrossProgenyEmissionMatrix(byte[][][] hap, GenotypeTable originalGenotypes, int taxonIndex, int[] siteIndices) {
        this.parentHaplotypes = hap;
        this.progenyGenotypes = originalGenotypes;
        this.useProbabilityTables = false;
        this.myTaxonIndex = taxonIndex;
        this.mySiteIndices = siteIndices;
    }

    public CrossProgenyEmissionMatrix(double[][] hapProbs, GenotypeTable originalGenotypes, double[][] stateByObs, int taxonIndex, int[] siteIndices) {
        this.parentHaplotypeProbabilities = hapProbs;
        this.progenyGenotypes = originalGenotypes;
        this.obsGivenState = stateByObs;
        this.useProbabilityTables = true;
        this.myTaxonIndex = taxonIndex;
        this.mySiteIndices = siteIndices;
    }

    @Override
    public double getProbObsGivenState(int state, int obs) {
        return Double.NaN;
    }

    @Override
    public double getProbObsGivenState(int state, int obs, int site) {
        if (this.useProbabilityTables) {
            return this.probObsStateFromPhasedProgeny(state, obs, this.mySiteIndices[site]);
        }
        return this.probObsStateUsingParentHaps(state, obs, this.mySiteIndices[site]);
    }

    private double probObsStateUsingParentHaps(int state, int obs, int site) {
        byte obsgeno = (byte)obs;
        byte h00 = this.parentHaplotypes[0][0][site];
        byte h01 = this.parentHaplotypes[0][1][site];
        byte h10 = this.parentHaplotypes[1][0][site];
        byte h11 = this.parentHaplotypes[1][1][site];
        if (h00 == 15 || h01 == 15 || h10 == 15 || h11 == 15) {
            return 0.25;
        }
        byte h00h10 = GenotypeTableUtils.getUnphasedDiploidValue(h00, h10);
        byte h00h11 = GenotypeTableUtils.getUnphasedDiploidValue(h00, h11);
        byte h01h10 = GenotypeTableUtils.getUnphasedDiploidValue(h01, h10);
        byte h01h11 = GenotypeTableUtils.getUnphasedDiploidValue(h01, h11);
        switch (state) {
            case 0: {
                if (GenotypeTableUtils.isHeterozygous(h00h10)) {
                    if (GenotypeTableUtils.isEqual(h00h10, obsgeno)) {
                        return 1.0 - this.probHetAsHom(site);
                    }
                    if (!GenotypeTableUtils.isHeterozygous(obsgeno)) {
                        return this.probHetAsHom(site);
                    }
                    return 1.0E-4;
                }
                if (obsgeno == h00h10) {
                    return 0.998;
                }
                if (GenotypeTableUtils.isHeterozygous(obsgeno)) {
                    return 0.001;
                }
                return 0.001;
            }
            case 1: {
                if (GenotypeTableUtils.isHeterozygous(h00h11)) {
                    if (GenotypeTableUtils.isEqual(h00h11, obsgeno)) {
                        return 1.0 - this.probHetAsHom(site);
                    }
                    if (!GenotypeTableUtils.isHeterozygous(obsgeno)) {
                        return this.probHetAsHom(site);
                    }
                    return 1.0E-4;
                }
                if (obsgeno == h00h11) {
                    return 0.998;
                }
                if (GenotypeTableUtils.isHeterozygous(obsgeno)) {
                    return 0.001;
                }
                return 0.001;
            }
            case 2: {
                if (GenotypeTableUtils.isHeterozygous(h01h10)) {
                    if (GenotypeTableUtils.isEqual(h01h10, obsgeno)) {
                        return 1.0 - this.probHetAsHom(site);
                    }
                    if (!GenotypeTableUtils.isHeterozygous(obsgeno)) {
                        return this.probHetAsHom(site);
                    }
                    return 1.0E-4;
                }
                if (obsgeno == h01h10) {
                    return 0.998;
                }
                if (GenotypeTableUtils.isHeterozygous(obsgeno)) {
                    return 0.001;
                }
                return 0.001;
            }
            case 3: {
                if (GenotypeTableUtils.isHeterozygous(h01h11)) {
                    if (GenotypeTableUtils.isEqual(h01h11, obsgeno)) {
                        return 1.0 - this.probHetAsHom(site);
                    }
                    if (!GenotypeTableUtils.isHeterozygous(obsgeno)) {
                        return this.probHetAsHom(site);
                    }
                    return 1.0E-4;
                }
                if (obsgeno == h01h11) {
                    return 0.998;
                }
                if (GenotypeTableUtils.isHeterozygous(obsgeno)) {
                    return 0.001;
                }
                return 0.001;
            }
        }
        throw new IllegalArgumentException("Illegal state as input to probObsStateUsingParentHaps().");
    }

    private double probObsStateFromPhasedProgeny(int state, int obs, int site) {
        double pHomMinor;
        double pHet;
        double pHomMajor;
        byte obsgeno = (byte)obs;
        byte[] obsAlleles = GenotypeTableUtils.getDiploidValues(obsgeno);
        byte major = this.progenyGenotypes.majorAllele(site);
        byte minor = this.progenyGenotypes.minorAllele(site);
        double pMajorh00 = this.parentHaplotypeProbabilities[0][site];
        double pMajorh01 = this.parentHaplotypeProbabilities[1][site];
        double pMajorh10 = this.parentHaplotypeProbabilities[2][site];
        double pMajorh11 = this.parentHaplotypeProbabilities[3][site];
        switch (state) {
            case 0: {
                pHomMajor = pMajorh00 * pMajorh10;
                pHet = pMajorh00 * (1.0 - pMajorh10) + (1.0 - pMajorh00) * pMajorh10;
                pHomMinor = (1.0 - pMajorh00) * (1.0 - pMajorh10);
                break;
            }
            case 1: {
                pHomMajor = pMajorh00 * pMajorh11;
                pHet = pMajorh00 * (1.0 - pMajorh11) + (1.0 - pMajorh00) * pMajorh11;
                pHomMinor = (1.0 - pMajorh00) * (1.0 - pMajorh11);
                break;
            }
            case 2: {
                pHomMajor = pMajorh01 * pMajorh10;
                pHet = pMajorh01 * (1.0 - pMajorh10) + (1.0 - pMajorh01) * pMajorh10;
                pHomMinor = (1.0 - pMajorh01) * (1.0 - pMajorh10);
                break;
            }
            case 3: {
                pHomMajor = pMajorh01 * pMajorh11;
                pHet = pMajorh01 * (1.0 - pMajorh11) + (1.0 - pMajorh01) * pMajorh11;
                pHomMinor = (1.0 - pMajorh01) * (1.0 - pMajorh11);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal state as input to probObsStateFromPhasedProgeny().");
            }
        }
        if (obsgeno == GenotypeTableUtils.getDiploidValue(major, major)) {
            return this.obsGivenState[0][0] * pHomMajor + this.obsGivenState[1][0] * pHet + this.obsGivenState[2][0] * pHomMinor;
        }
        if (GenotypeTableUtils.isEqual(obsgeno, GenotypeTableUtils.getDiploidValue(major, minor))) {
            return this.obsGivenState[0][1] * pHomMajor + this.obsGivenState[1][1] * pHet + this.obsGivenState[2][1] * pHomMinor;
        }
        if (obsgeno == GenotypeTableUtils.getDiploidValue(minor, minor)) {
            return this.obsGivenState[0][2] * pHomMajor + this.obsGivenState[1][2] * pHet + this.obsGivenState[2][2] * pHomMinor;
        }
        return Double.NaN;
    }

    private double probObsAtSite(int site, int obs) {
        double pval;
        double dtotal = this.progenyGenotypes.totalNonMissingForSite(site);
        byte obsgeno = (byte)obs;
        if (GenotypeTableUtils.isHeterozygous(obsgeno)) {
            int obscount = 0;
            for (int t = 0; t < this.progenyGenotypes.numberOfTaxa(); ++t) {
                if (!GenotypeTableUtils.isEqual(obsgeno, this.progenyGenotypes.genotype(t, site))) continue;
                ++obscount;
            }
            pval = (double)obscount / dtotal;
        } else {
            int obscount = 0;
            for (int t = 0; t < this.progenyGenotypes.numberOfTaxa(); ++t) {
                if (this.progenyGenotypes.genotype(t, site) != obsgeno) continue;
                ++obscount;
            }
            pval = (double)obscount / dtotal;
        }
        return pval;
    }

    private double probHetAsHom(int site) {
        int totalDepth = this.progenyGenotypes.depth().depth(this.myTaxonIndex, site);
        if (totalDepth == 1) {
            return 0.99;
        }
        return Math.pow(0.5, totalDepth - 1);
    }
}

