/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.Random;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;

public class FILLINImputationAccuracy {
    private GenotypeTable maskKey = null;
    private GenotypeTable unimp = null;
    private GenotypeTable imputed = null;
    private GenotypeTable[] donor = null;
    private String outFile = null;
    private double propSitesMask = 0.01;
    private int depthToMask = 7;
    private double propDepthSitesToMask = 0.2;
    public int[] MAF = null;
    private double[][] all = null;
    private double[][][] mafAll = null;
    private double[] MAFClass = null;
    private boolean verboseOutput = true;

    public FILLINImputationAccuracy(GenotypeTable unimp, GenotypeTable maskKey, GenotypeTable[] donors, double propSitesMask, int depthToMask, double propDepthSitesToMask, String outFileName, double[] MAFClass, boolean verbose) {
        this.unimp = unimp;
        this.maskKey = maskKey;
        this.donor = donors;
        this.propSitesMask = propSitesMask;
        this.depthToMask = depthToMask;
        this.propDepthSitesToMask = propDepthSitesToMask;
        this.MAFClass = MAFClass;
        this.verboseOutput = verbose;
        this.outFile = outFileName;
    }

    public FILLINImputationAccuracy(GenotypeTable unimp, GenotypeTable maskKey, String outFileName, boolean verbose) {
        this.unimp = unimp;
        this.maskKey = maskKey;
        this.verboseOutput = verbose;
        this.outFile = outFileName;
    }

    public FILLINImputationAccuracy(GenotypeTable unimp, GenotypeTable maskKey, GenotypeTable[] donor, String outFileName, boolean verbose) {
        this.unimp = unimp;
        this.maskKey = maskKey;
        this.donor = donor;
        this.verboseOutput = verbose;
        this.outFile = outFileName;
    }

    public FILLINImputationAccuracy(GenotypeTable unimp, GenotypeTable maskKey, GenotypeTable[] donor, double[] MAFClass, String outFileName, boolean verbose) {
        this.unimp = unimp;
        this.maskKey = maskKey;
        this.donor = donor;
        this.MAFClass = MAFClass;
        this.verboseOutput = verbose;
        this.outFile = outFileName;
    }

    public GenotypeTable initiateAccuracy() {
        boolean works;
        if (this.MAFClass != null) {
            this.generateMAF();
            this.mafAll = new double[this.MAFClass.length][3][5];
            if (this.verboseOutput) {
                System.out.println("Calculating accuracy within supplied MAF categories.");
            }
        }
        if (this.maskKey != null) {
            if (this.verboseOutput) {
                System.out.println("File already masked. Use input key file for calculating accuracy");
            }
            boolean goodKey = true;
            if (!Arrays.equals(this.maskKey.physicalPositions(), this.unimp.physicalPositions())) {
                goodKey = this.filterKeySites();
            }
            if (!goodKey && this.verboseOutput) {
                System.out.println("Problem with input key file. Masking unimputed input");
            } else {
                return this.unimp;
            }
        }
        if (this.unimp.hasDepth() && this.depthToMask > 0 && (works = this.maskFileByDepth())) {
            return this.unimp;
        }
        this.maskPropSites();
        return this.unimp;
    }

    private boolean generateMAF() {
        this.MAF = new int[this.unimp.numberOfSites()];
        for (GenotypeTable don : this.donor) {
            for (int site = 0; site < don.numberOfSites(); ++site) {
                int search;
                int unimpSite = this.unimp.positions().indexOf(don.positions().get(site));
                this.MAF[unimpSite] = unimpSite < 0 ? -1 : ((search = Arrays.binarySearch(this.MAFClass, don.minorAlleleFrequency(site))) < 0 ? Math.abs(search) - 1 : search);
            }
        }
        return true;
    }

    private boolean maskFileByDepth() {
        if (this.verboseOutput) {
            System.out.println("Masking file using depth\nSite depth to mask: " + this.depthToMask + "\nProportion of depth sites to be masked: " + this.propDepthSitesToMask);
        }
        GenotypeCallTableBuilder mask = GenotypeCallTableBuilder.getInstance(this.unimp.numberOfTaxa(), this.unimp.numberOfSites());
        GenotypeCallTableBuilder key = GenotypeCallTableBuilder.getInstance(this.unimp.numberOfTaxa(), this.unimp.numberOfSites());
        int cnt = 0;
        for (int taxon = 0; taxon < this.unimp.numberOfTaxa(); ++taxon) {
            int taxaCnt = 0;
            mask.setBaseRangeForTaxon(taxon, 0, this.unimp.genotypeAllSites(taxon));
            for (int site = 0; site < this.unimp.numberOfSites(); ++site) {
                int[] currD;
                if (GenotypeTableUtils.isEqual((byte)-1, this.unimp.genotype(taxon, site)) || (currD = this.unimp.depthForAlleles(taxon, site))[0] + currD[1] != this.depthToMask || Math.random() > this.propDepthSitesToMask || this.unimp.isHeterozygous(taxon, site) && (this.depthToMask <= 3 || currD[0] <= 1 || currD[1] <= 1) && this.depthToMask >= 4) continue;
                mask.setBase(taxon, site, (byte)-1);
                key.setBase(taxon, site, this.unimp.genotype(taxon, site));
                ++taxaCnt;
            }
            if (this.verboseOutput) {
                System.out.println(taxaCnt + " sites masked for " + this.unimp.taxaName(taxon));
            }
            cnt += taxaCnt;
        }
        if (cnt < 2000 && this.verboseOutput) {
            System.out.println("Insufficient sites masked with depth. Calculate accuracy by proportion");
            return false;
        }
        if (this.verboseOutput) {
            System.out.println(cnt + " sites masked at a depth of " + this.depthToMask);
        }
        this.maskKey = GenotypeTableBuilder.getInstance(key.build(), this.unimp.positions(), this.unimp.taxa());
        this.unimp = GenotypeTableBuilder.getInstance(mask.build(), this.unimp.positions(), this.unimp.taxa());
        return true;
    }

    private boolean maskPropSites() {
        if (this.verboseOutput) {
            System.out.println("Masking file without depth\nMasking " + this.propSitesMask + " proportion of sites");
        }
        GenotypeCallTableBuilder mask = GenotypeCallTableBuilder.getInstance(this.unimp.numberOfTaxa(), this.unimp.numberOfSites());
        GenotypeCallTableBuilder key = GenotypeCallTableBuilder.getInstance(this.unimp.numberOfTaxa(), this.unimp.numberOfSites());
        int presGenos = 0;
        for (int taxon = 0; taxon < this.unimp.numberOfTaxa(); ++taxon) {
            presGenos += this.unimp.totalNonMissingForTaxon(taxon);
        }
        int expected = (int)(this.propSitesMask * (double)presGenos);
        int cnt = 0;
        for (int taxon = 0; taxon < this.unimp.numberOfTaxa(); ++taxon) {
            int taxaCnt = 0;
            mask.setBaseRangeForTaxon(taxon, 0, this.unimp.genotypeAllSites(taxon));
            for (int site = 0; site < this.unimp.numberOfSites(); ++site) {
                if (!(Math.random() < this.propSitesMask) || GenotypeTableUtils.isEqual((byte)-1, this.unimp.genotype(taxon, site))) continue;
                mask.setBase(taxon, site, (byte)-1);
                key.setBase(taxon, site, this.unimp.genotype(taxon, site));
                ++taxaCnt;
            }
            cnt += taxaCnt;
        }
        if (this.verboseOutput) {
            System.out.println(cnt + " sites masked randomly not based on depth (" + expected + " expected at " + this.propSitesMask + ")");
        }
        this.maskKey = GenotypeTableBuilder.getInstance(key.build(), this.unimp.positions(), this.unimp.taxa());
        this.unimp = GenotypeTableBuilder.getInstance(mask.build(), this.unimp.positions(), this.unimp.taxa());
        return true;
    }

    private boolean filterKeySites() {
        GenotypeTable filter;
        long time = System.currentTimeMillis();
        if (this.verboseOutput) {
            System.out.println("Filtering user input key file...\nsites in original Key file: " + this.maskKey.numberOfSites());
        }
        ArrayList<String> keepSites = new ArrayList<String>();
        boolean working = true;
        if (!Arrays.equals(this.unimp.chromosomes(), this.maskKey.chromosomes())) {
            working = this.matchChromosomes();
        }
        if (!working) {
            System.out.println("No overlapping chromosomes");
            return false;
        }
        PositionList maskPos = this.maskKey.positions();
        for (Position p : this.unimp.positions()) {
            if (maskPos.contains(p)) {
                keepSites.add(p.getSNPID());
                continue;
            }
            System.out.println("Not all sites in target imputation file contained in mask key. Not using mask");
            return false;
        }
        this.maskKey = filter = FilterGenotypeTable.getInstance(this.maskKey, keepSites.toArray(new String[keepSites.size()]));
        if (this.verboseOutput) {
            System.out.println("Sites in new mask: " + this.maskKey.numberOfSites());
        }
        if (!this.maskKey.taxa().equals(this.unimp.taxa())) {
            if (this.maskKey.taxa().containsAll(this.unimp.taxa())) {
                this.maskKey = FilterGenotypeTable.getInstance(this.maskKey, this.unimp.taxa());
            } else {
                System.out.println("Not all taxa in target imputation file contained in mask key. Not using mask");
                return false;
            }
        }
        System.out.println("Filtering key took " + (System.currentTimeMillis() - time) + " milliseconds");
        return true;
    }

    private boolean matchChromosomes() {
        GenotypeTable filter;
        Object[] unimpChr = this.unimp.chromosomes();
        Object[] keyChr = this.maskKey.chromosomes();
        ArrayList<Integer> keepSites = new ArrayList<Integer>();
        for (Chromosome chromosome : unimpChr) {
            if (Arrays.binarySearch(keyChr, chromosome) >= 0) continue;
            return false;
        }
        for (Chromosome chromosome : keyChr) {
            if (Arrays.binarySearch(unimpChr, chromosome) <= -1) continue;
            int[] startEnd = this.maskKey.firstLastSiteOfChromosome(chromosome);
            for (int site = startEnd[0]; site <= startEnd[1]; ++site) {
                keepSites.add(site);
            }
        }
        this.maskKey = filter = FilterGenotypeTable.getInstance(this.maskKey, ArrayUtils.toPrimitive((Integer[])keepSites.toArray(new Integer[keepSites.size()])));
        if (this.verboseOutput) {
            System.out.println(this.maskKey.numberOfSites() + " sites retained after chromsome filter");
        }
        return true;
    }

    private double pearsonR2(double[][] all, boolean verbose) {
        int size = 0;
        for (int x = 0; x < 3; ++x) {
            size = (int)((double)size + (all[x][4] - all[x][3]));
        }
        double[][] xy = new double[2][size];
        int last = 0;
        for (double x = 0.0; x < 3.0; x += 1.0) {
            for (double y = 0.0; y < 3.0; y += 1.0) {
                int fill = last;
                while ((double)fill < (double)last + all[(int)x][(int)y]) {
                    xy[0][fill] = x;
                    xy[1][fill] = y;
                    ++fill;
                }
                last += (int)all[(int)x][(int)y];
            }
        }
        double meanX = 0.0;
        double meanY = 0.0;
        double varX = 0.0;
        double varY = 0.0;
        double covXY = 0.0;
        double r2 = 0.0;
        for (int i = 0; i < xy[0].length; ++i) {
            meanX += xy[0][i];
            meanY += xy[1][i];
        }
        meanX /= (double)(xy[0].length - 1);
        meanY /= (double)(xy[1].length - 1);
        for (int i = 0; i < xy[0].length; ++i) {
            double currX = xy[0][i] - meanX;
            double currY = xy[1][i] - meanY;
            varX += currX * currX;
            varY += currY * currY;
            covXY += currX * currY;
        }
        r2 = covXY / (Math.sqrt(varX) * Math.sqrt(varY)) * (covXY / (Math.sqrt(varX) * Math.sqrt(varY)));
        if (verbose) {
            System.out.println("Unadjusted R2 value for " + size + " comparisons: " + r2);
        }
        return r2;
    }

    private void accuracyOut(double time) {
        block6: {
            DecimalFormat df = new DecimalFormat("0.########");
            double r2 = this.pearsonR2(this.all, this.verboseOutput);
            try {
                String ext = FilenameUtils.getExtension((String)this.outFile);
                File outputFile = new File(this.outFile.replace(ext, "Accuracy.txt"));
                DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
                outStream.writeBytes("##Taxon\tTotalSitesMasked\tTotalSitesCompared\tTotalPropUnimputed\tNumMinor\tCorrectMinor\tMinorToHet\tMinorToMajor\tUnimpMinor\tNumHets\tHetToMinor\tCorrectHet\tHetToMajor\tUnimpHet\tNumMajor\tMajorToMinor\tMajorToHet\tCorrectMajor\tUnimpMajor\tR2\n");
                outStream.writeBytes("##TotalByImputed\t" + (this.all[0][4] + this.all[1][4] + this.all[2][4]) + "\t" + (this.all[0][4] + this.all[1][4] + this.all[2][4] - this.all[0][3] - this.all[1][3] - this.all[2][3]) + "\t" + (this.all[0][3] + this.all[1][3] + this.all[2][3]) / (this.all[0][4] + this.all[1][4] + this.all[2][4]) + "\t" + this.all[0][4] + "\t" + this.all[0][0] + "\t" + this.all[0][1] + "\t" + this.all[0][2] + "\t" + this.all[0][3] + "\t" + this.all[1][4] + "\t" + this.all[1][0] + "\t" + this.all[1][1] + "\t" + this.all[1][2] + "\t" + this.all[1][3] + "\t" + this.all[2][4] + "\t" + this.all[2][0] + "\t" + this.all[2][1] + "\t" + this.all[2][2] + "\t" + this.all[2][3] + "\t" + r2 + "\n");
                outStream.writeBytes("#Minor=0,Het=1,Major=2;x is masked(known), y is predicted\nx\ty\tN\tprop\n0\t0\t" + this.all[0][0] + "\t" + df.format(this.all[0][0] / (this.all[0][0] + this.all[0][1] + this.all[0][2])) + "\n" + 0 + "\t" + 0.5 + "\t" + this.all[0][1] + "\t" + df.format(this.all[0][1] / (this.all[0][0] + this.all[0][1] + this.all[0][2])) + "\n" + 0 + "\t" + 1 + "\t" + this.all[0][2] + "\t" + df.format(this.all[0][2] / (this.all[0][0] + this.all[0][1] + this.all[0][2])) + "\n" + 0.5 + "\t" + 0 + "\t" + this.all[1][0] + "\t" + df.format(this.all[1][0] / (this.all[1][0] + this.all[1][1] + this.all[1][2])) + "\n" + 0.5 + "\t" + 0.5 + "\t" + this.all[1][1] + "\t" + df.format(this.all[1][1] / (this.all[1][0] + this.all[1][1] + this.all[1][2])) + "\n" + 0.5 + "\t" + 1 + "\t" + this.all[1][2] + "\t" + df.format(this.all[1][2] / (this.all[1][0] + this.all[1][1] + this.all[1][2])) + "\n" + 1 + "\t" + 0 + "\t" + this.all[2][0] + "\t" + df.format(this.all[2][0] / (this.all[2][0] + this.all[2][1] + this.all[2][2])) + "\n" + 1 + "\t" + 0.5 + "\t" + this.all[2][1] + "\t" + df.format(this.all[2][1] / (this.all[2][0] + this.all[2][1] + this.all[2][2])) + "\n" + 1 + "\t" + 1 + "\t" + this.all[2][2] + "\t" + df.format(this.all[2][2] / (this.all[2][0] + this.all[2][1] + this.all[2][2])) + "\n");
                outStream.writeBytes("#Proportion unimputed:\n#minor <- " + this.all[0][3] / this.all[0][4] + "\n#het<- " + this.all[1][3] / this.all[1][4] + "\n#major<- " + this.all[2][3] / this.all[2][4] + "\n");
                outStream.writeBytes("#Time to impute and calculate accuracy: " + time + " seconds");
                if (this.verboseOutput) {
                    System.out.println("##Taxon\tTotalSitesMasked\tTotalSitesCompared\tTotalPropUnimputed\tNumMinor\tCorrectMinor\tMinorToHet\tMinorToMajor\tUnimpMinor\tNumHets\tHetToMinor\tCorrectHet\tHetToMajor\tUnimpHet\tNumMajor\tMajorToMinor\tMajorToHet\tCorrectMajor\tUnimpMajor\tR2");
                }
                if (this.verboseOutput) {
                    System.out.println("TotalByImputed\t" + (this.all[0][4] + this.all[1][4] + this.all[2][4]) + "\t" + (this.all[0][4] + this.all[1][4] + this.all[2][4] - this.all[0][3] - this.all[1][3] - this.all[2][3]) + "\t" + (this.all[0][3] + this.all[1][3] + this.all[2][3]) / (this.all[0][4] + this.all[1][4] + this.all[2][4]) + "\t" + this.all[0][4] + "\t" + this.all[0][0] + "\t" + this.all[0][1] + "\t" + this.all[0][2] + "\t" + this.all[0][3] + "\t" + this.all[1][4] + "\t" + this.all[1][0] + "\t" + this.all[1][1] + "\t" + this.all[1][2] + "\t" + this.all[1][3] + "\t" + this.all[2][4] + "\t" + this.all[2][0] + "\t" + this.all[2][1] + "\t" + this.all[2][2] + "\t" + this.all[2][3] + "\t" + r2);
                }
                if (this.verboseOutput) {
                    System.out.println("Proportion unimputed:\nminor: " + this.all[0][3] / this.all[0][4] + "\nhet: " + this.all[1][3] / this.all[1][4] + "\nmajor: " + this.all[2][3] / this.all[2][4]);
                }
                if (this.verboseOutput) {
                    System.out.println("#Minor=0,Het=1,Major=2;x is masked(known), y is predicted\nx\ty\tN\tprop\n0\t0\t" + this.all[0][0] + "\t" + this.all[0][0] / (this.all[0][0] + this.all[0][1] + this.all[0][2]) + "\n" + 0 + "\t" + 0.5 + "\t" + this.all[0][1] + "\t" + this.all[0][1] / (this.all[0][0] + this.all[0][1] + this.all[0][2]) + "\n" + 0 + "\t" + 1 + "\t" + this.all[0][2] + "\t" + this.all[0][2] / (this.all[0][0] + this.all[0][1] + this.all[0][2]) + "\n" + 0.5 + "\t" + 0 + "\t" + this.all[1][0] + "\t" + this.all[1][0] / (this.all[1][0] + this.all[1][1] + this.all[1][2]) + "\n" + 0.5 + "\t" + 0.5 + "\t" + this.all[1][1] + "\t" + this.all[1][1] / (this.all[1][0] + this.all[1][1] + this.all[1][2]) + "\n" + 0.5 + "\t" + 1 + "\t" + this.all[1][2] + "\t" + this.all[1][2] / (this.all[1][0] + this.all[1][1] + this.all[1][2]) + "\n" + 1 + "\t" + 0 + "\t" + this.all[2][0] + "\t" + this.all[2][0] / (this.all[2][0] + this.all[2][1] + this.all[2][2]) + "\n" + 1 + "\t" + 0.5 + "\t" + this.all[2][1] + "\t" + this.all[2][1] / (this.all[2][0] + this.all[2][1] + this.all[2][2]) + "\n" + 1 + "\t" + 1 + "\t" + this.all[2][2] + "\t" + this.all[2][2] / (this.all[2][0] + this.all[2][1] + this.all[2][2]) + "\n");
                }
                outStream.close();
            }
            catch (Exception e) {
                if (!this.verboseOutput) break block6;
                System.out.println(e);
            }
        }
    }

    private void accuracyMAFOut() {
        block6: {
            DecimalFormat df = new DecimalFormat("0.########");
            if (this.MAF != null && this.MAFClass != null) {
                try {
                    int i;
                    String ext = FilenameUtils.getExtension((String)this.outFile);
                    File outputFile = new File(this.outFile.replace(ext, "MAFAccuracy.txt"));
                    DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
                    outStream.writeBytes("##\tMAFClass\tTotalSitesMasked\tTotalSitesCompared\tTotalPropUnimputed\tNumHets\tHetToMinor\tHetToMajor\tCorrectHet\tUnimpHet\tNumMinor\tMinorToMajor\tMinorToHet\tCorrectMinor\tUnimpMinor\tNumMajor\tMajorToMinor\tMajorToHet\tCorrectMajor\tUnimputedMajor\tr2\n");
                    for (i = 0; i < this.MAFClass.length; ++i) {
                        outStream.writeBytes("##TotalByImputed\t" + this.MAFClass[i] + "\t" + (this.mafAll[i][0][4] + this.mafAll[i][1][4] + this.mafAll[i][2][4]) + "\t" + (this.mafAll[i][0][4] + this.mafAll[i][1][4] + this.mafAll[i][2][4] - this.mafAll[i][0][3] - this.mafAll[i][1][3] - this.mafAll[i][2][3]) + "\t" + (this.mafAll[i][0][3] + this.mafAll[i][1][3] + this.mafAll[i][2][3]) / (this.mafAll[i][0][4] + this.mafAll[i][1][4] + this.mafAll[i][2][4]) + "\t" + this.mafAll[i][0][4] + "\t" + this.mafAll[i][0][0] + "\t" + this.mafAll[i][0][1] + "\t" + this.mafAll[i][0][2] + "\t" + this.mafAll[i][0][3] + "\t" + this.mafAll[i][1][4] + "\t" + this.mafAll[i][1][0] + "\t" + this.mafAll[i][1][1] + "\t" + this.mafAll[i][1][2] + "\t" + this.mafAll[i][1][3] + "\t" + this.mafAll[i][2][4] + "\t" + this.mafAll[i][2][0] + "\t" + this.mafAll[i][2][1] + "\t" + this.mafAll[i][2][2] + "\t" + this.mafAll[i][2][3] + "\t" + this.pearsonR2(this.mafAll[i], false) + "\n");
                    }
                    outStream.writeBytes("#MAFClass,Minor=0,Het=1,Major=2;x is masked(known), y is predicted\nMAF\tx\ty\tN\tprop\n");
                    for (i = 0; i < this.MAFClass.length; ++i) {
                        outStream.writeBytes(this.MAFClass[i] + "\t" + 0 + "\t" + 0 + "\t" + this.mafAll[i][0][0] + "\t" + df.format(this.mafAll[i][0][0] / (this.mafAll[i][0][0] + this.mafAll[i][0][1] + this.mafAll[i][0][2])) + "\n" + this.MAFClass[i] + "\t" + 0 + "\t" + 0.5 + "\t" + this.mafAll[i][0][1] + "\t" + df.format(this.mafAll[i][0][1] / (this.mafAll[i][0][0] + this.mafAll[i][0][1] + this.mafAll[i][0][2])) + "\n" + this.MAFClass[i] + "\t" + 0 + "\t" + 1 + "\t" + this.mafAll[i][0][2] + "\t" + df.format(this.mafAll[i][0][2] / (this.mafAll[i][0][0] + this.mafAll[i][0][1] + this.mafAll[i][0][2])) + "\n" + this.MAFClass[i] + "\t" + 0.5 + "\t" + 0 + "\t" + this.mafAll[i][1][0] + "\t" + df.format(this.mafAll[i][1][0] / (this.mafAll[i][1][0] + this.mafAll[i][1][1] + this.mafAll[i][1][2])) + "\n" + this.MAFClass[i] + "\t" + 0.5 + "\t" + 0.5 + "\t" + this.mafAll[i][1][1] + "\t" + df.format(this.mafAll[i][1][1] / (this.mafAll[i][1][0] + this.mafAll[i][1][1] + this.mafAll[i][1][2])) + "\n" + this.MAFClass[i] + "\t" + 0.5 + "\t" + 1 + "\t" + this.mafAll[i][1][2] + "\t" + df.format(this.mafAll[i][1][2] / (this.mafAll[i][1][0] + this.mafAll[i][1][1] + this.mafAll[i][1][2])) + "\n" + this.MAFClass[i] + "\t" + 1 + "\t" + 0 + "\t" + this.mafAll[i][2][0] + "\t" + df.format(this.mafAll[i][2][0] / (this.mafAll[i][2][0] + this.mafAll[i][2][1] + this.mafAll[i][2][2])) + "\n" + this.MAFClass[i] + "\t" + 1 + "\t" + 0.5 + "\t" + this.mafAll[i][2][1] + "\t" + df.format(this.mafAll[i][2][1] / (this.mafAll[i][2][0] + this.mafAll[i][2][1] + this.mafAll[i][2][2])) + "\n" + this.MAFClass[i] + "\t" + 1 + "\t" + 1 + "\t" + this.mafAll[i][2][2] + "\t" + df.format(this.mafAll[i][2][2] / (this.mafAll[i][2][0] + this.mafAll[i][2][1] + this.mafAll[i][2][2])) + "\n");
                    }
                    outStream.writeBytes("#Proportion unimputed:\n#MAF\tminor\thet\tmajor\n");
                    for (i = 0; i < this.MAFClass.length; ++i) {
                        outStream.writeBytes("#" + this.MAFClass[i] + "\t" + this.mafAll[i][0][3] / this.mafAll[i][0][4] + "\t" + this.mafAll[i][1][3] / this.mafAll[i][1][4] + "\t" + this.mafAll[i][2][3] / this.mafAll[i][2][4] + "\n");
                    }
                    outStream.flush();
                    outStream.close();
                }
                catch (Exception e) {
                    if (!this.verboseOutput) break block6;
                    System.out.println(e);
                }
            }
        }
    }

    public double calcAccuracy(GenotypeTable imputed, double runtime) {
        this.imputed = imputed;
        this.all = new double[3][5];
        byte diploidN = -1;
        boolean use = false;
        boolean mafOn = false;
        int maf = -1;
        if (this.mafAll != null) {
            use = true;
            mafOn = true;
        }
        for (int taxon = 0; taxon < this.imputed.numberOfTaxa(); ++taxon) {
            int keyTaxon = this.maskKey.taxa().indexOf(this.imputed.taxaName(taxon));
            if (keyTaxon < 0) continue;
            for (int site = 0; site < this.imputed.numberOfSites(); ++site) {
                byte known;
                boolean bl = use = mafOn && this.MAF[site] > -1;
                if (use) {
                    maf = this.MAF[site];
                }
                if ((known = this.maskKey.genotype(keyTaxon, site)) == diploidN) continue;
                byte imp = this.imputed.genotype(taxon, site);
                if (GenotypeTableUtils.isHeterozygous(known)) {
                    double[] dArray = this.all[1];
                    dArray[4] = dArray[4] + 1.0;
                    if (use) {
                        double[] dArray2 = this.mafAll[maf][1];
                        dArray2[4] = dArray2[4] + 1.0;
                    }
                    if (imp == diploidN) {
                        double[] dArray3 = this.all[1];
                        dArray3[3] = dArray3[3] + 1.0;
                        if (!use) continue;
                        double[] dArray4 = this.mafAll[maf][1];
                        dArray4[3] = dArray4[3] + 1.0;
                        continue;
                    }
                    if (GenotypeTableUtils.isEqual(imp, known)) {
                        double[] dArray5 = this.all[1];
                        dArray5[1] = dArray5[1] + 1.0;
                        if (!use) continue;
                        double[] dArray6 = this.mafAll[maf][1];
                        dArray6[1] = dArray6[1] + 1.0;
                        continue;
                    }
                    if (!GenotypeTableUtils.isHeterozygous(imp) && GenotypeTableUtils.isPartiallyEqual(imp, this.unimp.minorAllele(site))) {
                        double[] dArray7 = this.all[1];
                        dArray7[0] = dArray7[0] + 1.0;
                        if (!use) continue;
                        double[] dArray8 = this.mafAll[maf][1];
                        dArray8[0] = dArray8[0] + 1.0;
                        continue;
                    }
                    if (!GenotypeTableUtils.isHeterozygous(imp) && GenotypeTableUtils.isPartiallyEqual(imp, this.unimp.majorAllele(site))) {
                        double[] dArray9 = this.all[1];
                        dArray9[2] = dArray9[2] + 1.0;
                        if (!use) continue;
                        double[] dArray10 = this.mafAll[maf][1];
                        dArray10[2] = dArray10[2] + 1.0;
                        continue;
                    }
                    double[] dArray11 = this.all[1];
                    dArray11[4] = dArray11[4] - 1.0;
                    if (!use) continue;
                    double[] dArray12 = this.mafAll[maf][1];
                    dArray12[4] = dArray12[4] - 1.0;
                    continue;
                }
                if (known == GenotypeTableUtils.getDiploidValue(this.unimp.minorAllele(site), this.unimp.minorAllele(site))) {
                    double[] dArray = this.all[0];
                    dArray[4] = dArray[4] + 1.0;
                    if (use) {
                        double[] dArray13 = this.mafAll[maf][0];
                        dArray13[4] = dArray13[4] + 1.0;
                    }
                    if (imp == diploidN) {
                        double[] dArray14 = this.all[0];
                        dArray14[3] = dArray14[3] + 1.0;
                        if (!use) continue;
                        double[] dArray15 = this.mafAll[maf][0];
                        dArray15[3] = dArray15[3] + 1.0;
                        continue;
                    }
                    if (GenotypeTableUtils.isEqual(imp, known)) {
                        double[] dArray16 = this.all[0];
                        dArray16[0] = dArray16[0] + 1.0;
                        if (!use) continue;
                        double[] dArray17 = this.mafAll[maf][0];
                        dArray17[0] = dArray17[0] + 1.0;
                        continue;
                    }
                    if (GenotypeTableUtils.isHeterozygous(imp) && GenotypeTableUtils.isPartiallyEqual(imp, known)) {
                        double[] dArray18 = this.all[0];
                        dArray18[1] = dArray18[1] + 1.0;
                        if (!use) continue;
                        double[] dArray19 = this.mafAll[maf][0];
                        dArray19[1] = dArray19[1] + 1.0;
                        continue;
                    }
                    double[] dArray20 = this.all[0];
                    dArray20[2] = dArray20[2] + 1.0;
                    if (!use) continue;
                    double[] dArray21 = this.mafAll[maf][0];
                    dArray21[3] = dArray21[3] + 1.0;
                    continue;
                }
                if (known != GenotypeTableUtils.getDiploidValue(this.unimp.majorAllele(site), this.unimp.majorAllele(site))) continue;
                double[] dArray = this.all[2];
                dArray[4] = dArray[4] + 1.0;
                if (use) {
                    double[] dArray22 = this.mafAll[maf][2];
                    dArray22[4] = dArray22[4] + 1.0;
                }
                if (imp == diploidN) {
                    double[] dArray23 = this.all[2];
                    dArray23[3] = dArray23[3] + 1.0;
                    if (!use) continue;
                    double[] dArray24 = this.mafAll[maf][2];
                    dArray24[3] = dArray24[3] + 1.0;
                    continue;
                }
                if (GenotypeTableUtils.isEqual(imp, known)) {
                    double[] dArray25 = this.all[2];
                    dArray25[2] = dArray25[2] + 1.0;
                    if (!use) continue;
                    double[] dArray26 = this.mafAll[maf][2];
                    dArray26[2] = dArray26[2] + 1.0;
                    continue;
                }
                if (GenotypeTableUtils.isHeterozygous(imp) && GenotypeTableUtils.isPartiallyEqual(imp, known)) {
                    double[] dArray27 = this.all[2];
                    dArray27[1] = dArray27[1] + 1.0;
                    if (!use) continue;
                    double[] dArray28 = this.mafAll[maf][2];
                    dArray28[1] = dArray28[1] + 1.0;
                    continue;
                }
                double[] dArray29 = this.all[2];
                dArray29[0] = dArray29[0] + 1.0;
                if (!use) continue;
                double[] dArray30 = this.mafAll[maf][2];
                dArray30[0] = dArray30[0] + 1.0;
            }
        }
        this.accuracyOut(runtime);
        if (this.MAFClass != null) {
            this.accuracyMAFOut();
        }
        return this.pearsonR2(this.all, this.verboseOutput);
    }

    @Deprecated
    public static int[] compareAlignment(String origFile, String maskFile, String impFile, boolean noMask) {
        boolean taxaOut = false;
        GenotypeTable oA = ImportUtils.readGuessFormat(origFile);
        System.out.printf("Orig taxa:%d sites:%d %n", oA.numberOfTaxa(), oA.numberOfSites());
        GenotypeTable mA = null;
        if (!noMask) {
            mA = ImportUtils.readGuessFormat(maskFile);
            System.out.printf("Mask taxa:%d sites:%d %n", mA.numberOfTaxa(), mA.numberOfSites());
        }
        GenotypeTable iA = ImportUtils.readGuessFormat(impFile);
        System.out.printf("Imp taxa:%d sites:%d %n", iA.numberOfTaxa(), iA.numberOfSites());
        int correct = 0;
        int errors = 0;
        int unimp = 0;
        int hets = 0;
        int gaps = 0;
        for (int t = 0; t < iA.numberOfTaxa(); ++t) {
            int e = 0;
            int c = 0;
            int u = 0;
            int h = 0;
            int oATaxa = oA.taxa().indexOf(iA.taxaName(t));
            for (int s = 0; s < iA.numberOfSites(); ++s) {
                if (!noMask && oA.genotype(oATaxa, s) == mA.genotype(t, s)) continue;
                byte ib = iA.genotype(t, s);
                byte ob = oA.genotype(oATaxa, s);
                if (ib == -1 || ob == -1) {
                    ++unimp;
                    ++u;
                    continue;
                }
                if (ib == 85) {
                    ++gaps;
                    continue;
                }
                if (ib == ob) {
                    ++correct;
                    ++c;
                    continue;
                }
                if (GenotypeTableUtils.isHeterozygous(ob) || GenotypeTableUtils.isHeterozygous(ib)) {
                    ++hets;
                    ++h;
                    continue;
                }
                ++errors;
                ++e;
            }
            if (!taxaOut) continue;
            System.out.printf("%s %d %d %d %d %n", iA.taxaName(t), u, h, c, e);
        }
        System.out.println("MFile\tIFile\tGap\tUnimp\tUnimpHets\tCorrect\tErrors");
        System.out.printf("%s\t%s\t%d\t%d\t%d\t%d\t%d%n", maskFile, impFile, gaps, unimp, hets, correct, errors);
        return new int[]{gaps, unimp, hets, correct, errors};
    }

    @Deprecated
    public static double[] compareAlignment(GenotypeTable impGT, GenotypeTable keyGT, String taxaPrefix) {
        int hetKeys = 0;
        int hetCompared = 0;
        int hetRight = 0;
        int homoKeys = 0;
        int homoCompared = 0;
        int homoRight = 0;
        if (impGT.numberOfSites() != keyGT.numberOfSites()) {
            throw new InputMismatchException("Number of Sites do not match");
        }
        Random r = new Random();
        for (int t = 0; t < impGT.numberOfTaxa(); ++t) {
            if (taxaPrefix != null && !impGT.taxaName(t).startsWith(taxaPrefix)) continue;
            int tCompStart = homoCompared;
            int tHomoRightStart = homoRight;
            int key_t = keyGT.taxa().indexOf(impGT.taxaName(t));
            if (key_t < 0) continue;
            boolean report = impGT.taxaName(t).startsWith("XZ009E0126");
            for (int s = 0; s < impGT.numberOfSites(); ++s) {
                byte keyB = keyGT.genotype(key_t, s);
                if (keyB == -1) continue;
                byte impB = impGT.genotype(t, s);
                if (GenotypeTableUtils.isHeterozygous(keyB)) {
                    ++hetKeys;
                    if (impB == -1) continue;
                    ++hetCompared;
                    if (keyB != impB) continue;
                    ++hetRight;
                    continue;
                }
                ++homoKeys;
                if (impB == -1) continue;
                ++homoCompared;
                if (keyB == impB) {
                    ++homoRight;
                }
                if (!report) continue;
                if (keyB != impB) {
                    System.out.print("Wrong\t");
                } else {
                    System.out.print("Right\t");
                }
                System.out.printf("%s %d %s %s %n", impGT.chromosome(s).getName(), impGT.chromosomalPosition(s), NucleotideAlignmentConstants.getNucleotideIUPAC(keyB), NucleotideAlignmentConstants.getNucleotideIUPAC(impB));
            }
        }
        double totalKey = hetKeys + homoKeys;
        double propImp = (double)(hetCompared + homoCompared) / totalKey;
        double homoRightProp = (double)homoRight / (double)homoCompared;
        double hetRightProp = (double)hetRight / (double)hetCompared;
        return new double[]{propImp, homoRightProp, hetRightProp};
    }
}

