/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import net.maizegenetics.dna.map.DonorHaplotypes;
import net.maizegenetics.util.BitSet;

class ImputedTaxon {
    private final int taxon;
    private final boolean isProjection;
    private boolean segmentSolved = false;
    private final byte[] origGeno;
    byte[] impGeno;
    byte[] resolveGeno;
    byte[] chgHis;
    BitSet[] modBitsOfTarget;
    private final NavigableSet<DonorHaplotypes> breakPoints;
    private int blocksSolved = 0;

    public ImputedTaxon(int taxon, byte[] origGeno, boolean isProjection) {
        this.taxon = taxon;
        this.origGeno = origGeno;
        this.isProjection = isProjection;
        this.impGeno = Arrays.copyOf(origGeno, origGeno.length);
        this.resolveGeno = Arrays.copyOf(origGeno, origGeno.length);
        this.chgHis = new byte[origGeno.length];
        this.breakPoints = new TreeSet<DonorHaplotypes>();
    }

    public void addBreakPoint(DonorHaplotypes dh) {
        this.breakPoints.add(dh);
    }

    public int taxon() {
        return this.taxon;
    }

    public NavigableSet<DonorHaplotypes> getBreakPoints() {
        ImmutableSortedSet.Builder result = new ImmutableSortedSet.Builder((Comparator)Ordering.natural());
        if (this.breakPoints.size() == 0) {
            return result.build();
        }
        DonorHaplotypes currDH = (DonorHaplotypes)this.breakPoints.first();
        for (DonorHaplotypes dhEn : this.breakPoints) {
            if (currDH.getParent1index() == dhEn.getParent1index() && currDH.getParent2index() == dhEn.getParent2index() && currDH.getChromosome() == dhEn.getChromosome()) {
                currDH = DonorHaplotypes.getMergedInstance(currDH, dhEn);
                continue;
            }
            result.add((Object)currDH);
            currDH = dhEn;
        }
        result.add((Object)currDH);
        return result.build();
    }

    public byte[] getOrigGeno() {
        return this.origGeno;
    }

    public byte getOrigGeno(int site) {
        return this.origGeno[site];
    }

    public byte[] getImpGeno() {
        return this.impGeno;
    }

    public byte getImpGeno(int site) {
        return this.impGeno[site];
    }

    public void setImpGeno(int site, byte diploidGenotype) {
        this.impGeno[site] = diploidGenotype;
    }

    public boolean isProjection() {
        return this.isProjection;
    }

    public boolean isSegmentSolved() {
        return this.segmentSolved;
    }

    public void setSegmentSolved(boolean segmentSolved) {
        this.segmentSolved = segmentSolved;
    }

    public int getBlocksSolved() {
        return this.blocksSolved;
    }

    public void incBlocksSolved() {
        ++this.blocksSolved;
    }
}

