/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.primitives.Bytes;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.popgen.LDResult;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.Tuple;
import org.apache.log4j.Logger;

public class LDKNNiImputationHetV2Plugin
extends AbstractPlugin {
    private static int minAlleleDivisorForLDMin = 3;
    private PluginParameter<Integer> highLDSSites = new PluginParameter.Builder<Integer>("highLDSSites", 30, Integer.class).range((Range<Comparable<Integer>>)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(2000))).guiName("High LD Sites").description("Number of sites in high LD to use in imputation").build();
    private PluginParameter<Integer> knnTaxa = new PluginParameter.Builder<Integer>("knnTaxa", 10, Integer.class).range((Range<Comparable<Integer>>)Range.closed((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(200))).guiName("Number of nearest neighbors").description("Number of neighbors to use in imputation").build();
    private PluginParameter<Integer> maxDistance = new PluginParameter.Builder<Integer>("maxLDDistance", -1, Integer.class).guiName("Max distance between site to find LD").description("Maximum physical distance between sites to search for LD (-1 for no distance cutoff - unlinked chromosomes will be tested)").build();
    private PluginParameter<Double> maxDistanceFromNN = new PluginParameter.Builder<Double>("maxDistanceFromNN", 0.1, Double.class).guiName("Maximum distance from Nearest Neighbor").description("Maximum distance from Nearest Neighbor").build();
    private PluginParameter<Double> duplicateHetsThreshold = new PluginParameter.Builder<Double>("hetThreshold", 0.05, Double.class).guiName("HeterozygousThreshold").description("Threshold for defining heterozygous sites").build();
    private PluginParameter<Double> automaticMajorMAF = new PluginParameter.Builder<Double>("autoMajorMAF", 0.01, Double.class).guiName("Automatic MajorGenotype if MAF").description("Set to Major genotype if no imputation result and MAF is below threshold").build();
    private PluginParameter<Double> minCoverageForDonors = new PluginParameter.Builder<Double>("minCoverageForDonors", 0.5, Double.class).guiName("Minimum coverage for donors and LD").description("Minimum coverage for donor genotype and LD calculation").build();
    private PluginParameter<Double> minCallBestGenoRatio = new PluginParameter.Builder<Double>("minCallBestGenoRatio", 10.0, Double.class).guiName("Minimum support ratio for best genotype").description("Minimum ratio between best and second best genotype to make a call").build();
    private PluginParameter<Integer> maxCores = new PluginParameter.Builder<Integer>("maxCores", 8, Integer.class).guiName("Maximum number of cores for processing").description("Maximum number of cores to be used for processing").build();
    private static final Logger myLogger = Logger.getLogger(LDKNNiImputationHetV2Plugin.class);

    public LDKNNiImputationHetV2Plugin() {
        super(null, false);
    }

    public LDKNNiImputationHetV2Plugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
        if (alignInList.size() != 1) {
            throw new IllegalArgumentException("LDKNNiImputationPlugin: preProcessParameters: Please select one Genotype Table.");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        Datum genoDatum = input.getDataOfType(GenotypeTable.class).get(0);
        GenotypeTable genotypeTable = (GenotypeTable)genoDatum.getData();
        System.out.println("genotypeTable = " + genotypeTable.toString());
        StatsOnSites statsOnSites = new StatsOnSites();
        int numberSites = genotypeTable.numberOfSites();
        int numberTaxa = genotypeTable.numberOfTaxa();
        double[] taxaCoverage = IntStream.range(0, numberTaxa).mapToDouble(taxaIndex -> (double)genotypeTable.totalNonMissingForTaxon(taxaIndex) / (double)numberSites).toArray();
        double[] siteCoverage = IntStream.range(0, numberSites).mapToDouble(siteIndex -> (double)genotypeTable.totalNonMissingForSite(siteIndex) / (double)numberTaxa).toArray();
        double[] weightHets = IntStream.range(0, numberSites).parallel().mapToDouble(siteIndex -> {
            double weightedHets = 0.0;
            double weightHomozygous = 0.0;
            for (int taxaIndex = 0; taxaIndex < genotypeTable.numberOfTaxa(); ++taxaIndex) {
                byte g = genotypeTable.genotype(taxaIndex, siteIndex);
                if (g == -1) continue;
                if (GenotypeTableUtils.isHeterozygous(g)) {
                    weightedHets += taxaCoverage[taxaIndex];
                    continue;
                }
                weightHomozygous += taxaCoverage[taxaIndex];
            }
            return weightedHets / (weightedHets + weightHomozygous);
        }).toArray();
        GenotypeTableBuilder incSiteBuilder = GenotypeTableBuilder.getSiteIncremental(genotypeTable.taxa());
        long time = System.nanoTime();
        LongAdder sitesDone = new LongAdder();
        IntStream.range(0, this.maxCores()).parallel().forEach(core -> IntStream.range(0, genotypeTable.numberOfSites()).filter(posIndex -> posIndex % this.maxCores() == core).forEach(posIndex -> {
            sitesDone.increment();
            Position position = (Position)genotypeTable.positions().get(posIndex);
            PositionList positionList = this.getHighLDPositionList(genotypeTable, posIndex, this.highLDSSites(), weightHets, siteCoverage);
            double maf = genotypeTable.minorAlleleFrequency(posIndex);
            byte majorAllele = genotypeTable.majorAllele(posIndex);
            byte minorAllele = genotypeTable.minorAllele(posIndex);
            if (!genotypeTable.isPolymorphic(posIndex)) {
                System.out.println(Arrays.toString(genotypeTable.genotypeAllTaxa(posIndex)));
            }
            StatsOnOneSite statsOnOneSite = new StatsOnOneSite(genotypeTable.minorAlleleFrequency(posIndex), weightHets[posIndex], genotypeTable.isPolymorphic(posIndex), positionList.size(), majorAllele, minorAllele);
            byte[] currGenos = genotypeTable.genotypeAllTaxa(posIndex);
            byte[] impGenos = new byte[currGenos.length];
            GenotypeTable ldGenoTable = GenotypeTableBuilder.getGenotypeCopyInstance(FilterGenotypeTable.getInstance(genotypeTable, positionList));
            int numberLDSites = ldGenoTable.numberOfSites();
            double[] taxaLDCoverage = IntStream.range(0, ldGenoTable.numberOfTaxa()).sequential().mapToDouble(t -> (double)ldGenoTable.totalNonMissingForTaxon(t) / (double)numberLDSites).toArray();
            for (int taxon = 0; taxon < currGenos.length; ++taxon) {
                Multimap<Double, Byte> closeGenotypes = this.getClosestNonMissingTaxa((Taxon)genotypeTable.taxa().get(taxon), genotypeTable, ldGenoTable, position, taxaLDCoverage, this.knnTaxa());
                int n = impGenos[taxon] = closeGenotypes.isEmpty() ? -1 : (int)this.impute(closeGenotypes, this.highLDSSites());
                if (impGenos[taxon] == -1 && maf < this.automaticMajorMAF()) {
                    impGenos[taxon] = GenotypeTableUtils.getDiploidValue(majorAllele, majorAllele);
                }
                statsOnOneSite.updateStats(currGenos[taxon], impGenos[taxon]);
            }
            byte[] resolvedGeno = this.resolveGenotypes(currGenos, impGenos, statsOnOneSite.hetFreq() > this.duplicateHetsThreshold());
            GeneralPosition.Builder gpb = new GeneralPosition.Builder(position).addAnno("ImpHomoAccuracy", statsOnOneSite.homozygousAcc()).addAnno("ImpMinorAccuracy", statsOnOneSite.minorAcc());
            if (weightHets[posIndex] > this.duplicateHetsThreshold()) {
                gpb.addAnno("DUP");
            }
            incSiteBuilder.addSite(gpb.build(), resolvedGeno);
            statsOnSites.addStats(statsOnOneSite.hetFreq(), statsOnOneSite.getCnts());
            if ((posIndex + 1) % 100 == 0) {
                this.fireProgress(33 + (int)(66L * sitesDone.longValue()) / genotypeTable.numberOfSites());
                System.out.println(sitesDone.longValue() + ": ms/site" + (System.nanoTime() - time) / 1000000L / sitesDone.longValue());
                statsOnSites.printToStdOut();
                System.out.println(this.reportingParameters() + statsOnSites.homozygousAcc(2) + "\t" + statsOnSites.recallPowerOfHomozgyous(2));
            }
        }));
        statsOnSites.printToStdOut();
        System.out.println("Final\t" + this.reportingParameters() + statsOnSites.homozygousAcc(2) + "\t" + statsOnSites.recallPowerOfHomozgyous(2));
        GenotypeTable impGenotypeTable = incSiteBuilder.build();
        return new DataSet(new Datum(genoDatum.getName() + "_KNNimp", impGenotypeTable, "Imputed genotypes by KNN imputation"), (Plugin)this);
    }

    private byte[] resolveGenotypes(byte[] currGenos, byte[] impGenos, boolean isDuplicated) {
        byte[] resolvedGeno = new byte[currGenos.length];
        for (int taxaIndex = 0; taxaIndex < resolvedGeno.length; ++taxaIndex) {
            resolvedGeno[taxaIndex] = currGenos[taxaIndex] == impGenos[taxaIndex] ? currGenos[taxaIndex] : (currGenos[taxaIndex] == -1 ? impGenos[taxaIndex] : (isDuplicated ? currGenos[taxaIndex] : currGenos[taxaIndex]));
        }
        return resolvedGeno;
    }

    private String reportingParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.highLDSSites() + "\t");
        sb.append(this.knnTaxa() + "\t");
        sb.append(this.maxDistance() + "\t");
        sb.append(this.maxDistanceFromNN() + "\t");
        sb.append(this.duplicateHetsThreshold() + "\t");
        return sb.toString();
    }

    private Multimap<Double, Byte> getClosestNonMissingTaxa(Taxon inputTaxon, GenotypeTable genotypeTable, GenotypeTable ldGenoTable, Position targetPosition, double[] inputCoverage, int numberOfTaxa) {
        int targetPosIdx = genotypeTable.positions().indexOf(targetPosition);
        int inputTaxonIdx = genotypeTable.taxa().indexOf(inputTaxon);
        byte[] inputTaxonGenotypes = ldGenoTable.genotypeAllSites(inputTaxonIdx);
        MinMaxPriorityQueue topTaxa = IntStream.range(0, genotypeTable.numberOfTaxa()).filter(closeTaxonIdx -> closeTaxonIdx != inputTaxonIdx).filter(closeTaxonIdx -> inputCoverage[closeTaxonIdx] > this.minCoverageForDonors()).filter(closeTaxonIdx -> inputCoverage[closeTaxonIdx] * inputCoverage[inputTaxonIdx] * (double)ldGenoTable.numberOfSites() > 10.0).filter(closeTaxonIdx -> genotypeTable.genotype(closeTaxonIdx, targetPosIdx) != -1).mapToObj(closeTaxonIdx -> new Tuple<Double, Byte>(LDKNNiImputationHetV2Plugin.dist(inputTaxonGenotypes, ldGenoTable.genotypeAllSites(closeTaxonIdx), 10)[0], genotypeTable.genotype(closeTaxonIdx, targetPosIdx))).filter(distanceTaxon -> !Double.isNaN((Double)distanceTaxon.x)).filter(distanceTaxon -> (Double)distanceTaxon.x <= this.maxDistanceFromNN()).collect(Collectors.toCollection(() -> MinMaxPriorityQueue.maximumSize((int)numberOfTaxa).create()));
        ArrayListMultimap distGenoMap = ArrayListMultimap.create();
        topTaxa.stream().forEach(arg_0 -> LDKNNiImputationHetV2Plugin.lambda$getClosestNonMissingTaxa$15((Multimap)distGenoMap, arg_0));
        return distGenoMap;
    }

    private PositionList getHighLDPositionList(GenotypeTable genotypeTable, int posIndex, int numberOfSNPs, double[] hetFreq, double[] coverage) {
        MinMaxPriorityQueue highestLD = MinMaxPriorityQueue.orderedBy((Comparator)LDResult.byR2Ordering.reverse()).maximumSize(numberOfSNPs).create();
        int minorAlleleCnt = (int)genotypeTable.allelePresenceForAllTaxa(posIndex, WHICH_ALLELE.Minor).cardinality();
        if ((minorAlleleCnt /= minAlleleDivisorForLDMin) < 2) {
            minorAlleleCnt = 2;
        }
        for (int site2 = 0; site2 < genotypeTable.numberOfSites(); ++site2) {
            LDResult ld;
            if (posIndex == site2 || coverage[site2] < this.minCoverageForDonors() || this.maxDistance() > -1 && Math.abs(genotypeTable.chromosomalPosition(posIndex) - genotypeTable.chromosomalPosition(site2)) > this.maxDistance() || hetFreq[site2] > this.duplicateHetsThreshold() || Double.isNaN((ld = LinkageDisequilibrium.calculateBitLDForHaplotype(20, minorAlleleCnt, genotypeTable, posIndex, site2)).r2())) continue;
            highestLD.add((Object)ld);
        }
        ArrayList<Position> positionList = new ArrayList<Position>();
        for (LDResult result : highestLD) {
            positionList.add((Position)genotypeTable.positions().get(result.site2()));
        }
        return PositionListBuilder.getInstance(positionList);
    }

    private byte impute(Multimap<Double, Byte> distGeno, int useLDSites) {
        double bestWeightedCount;
        double[] weightedCount = new double[256];
        distGeno.entries().forEach(entry -> {
            int n = (Byte)entry.getValue() + 128;
            weightedCount[n] = weightedCount[n] + 1.0 / (1.0 + (double)useLDSites * (Double)entry.getKey());
        });
        int bestGeno = 0;
        double secondBest = bestWeightedCount = weightedCount[0];
        for (int i = 1; i < 256; ++i) {
            if (!(weightedCount[i] > bestWeightedCount)) continue;
            secondBest = bestWeightedCount;
            bestWeightedCount = weightedCount[i];
            bestGeno = i;
        }
        if (bestWeightedCount < this.minCallBestGenoRatio() * secondBest) {
            return -1;
        }
        return (byte)(bestGeno - 128);
    }

    @Override
    public String getCitation() {
        return "Daniel Money, Kyle Gardner, Heidi Schwaninger, Gan-Yuan Zhong, Sean Myles. (In Review)  LinkImpute: fast and accurate genotype imputation for non-model organisms";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "LD KNNi Imputation";
    }

    @Override
    public String getToolTipText() {
        return "LD KNNi Imputation";
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(LDKNNiImputationHetV2Plugin.class);
    }

    public GenotypeTable runPlugin(DataSet input) {
        return (GenotypeTable)this.performFunction(input).getData(0).getData();
    }

    public Integer highLDSSites() {
        return this.highLDSSites.value();
    }

    public LDKNNiImputationHetV2Plugin highLDSSites(Integer value) {
        this.highLDSSites = new PluginParameter<Integer>(this.highLDSSites, value);
        return this;
    }

    public Integer knnTaxa() {
        return this.knnTaxa.value();
    }

    public LDKNNiImputationHetV2Plugin knnTaxa(Integer value) {
        this.knnTaxa = new PluginParameter<Integer>(this.knnTaxa, value);
        return this;
    }

    public Integer maxDistance() {
        return this.maxDistance.value();
    }

    public LDKNNiImputationHetV2Plugin maxDistance(Integer value) {
        this.maxDistance = new PluginParameter<Integer>(this.maxDistance, value);
        return this;
    }

    public Double maxDistanceFromNN() {
        return this.maxDistanceFromNN.value();
    }

    public LDKNNiImputationHetV2Plugin maxDistanceFromNN(Double value) {
        this.maxDistanceFromNN = new PluginParameter<Double>(this.maxDistanceFromNN, value);
        return this;
    }

    public Double duplicateHetsThreshold() {
        return this.duplicateHetsThreshold.value();
    }

    public LDKNNiImputationHetV2Plugin duplicateHetsThreshold(Double value) {
        this.duplicateHetsThreshold = new PluginParameter<Double>(this.duplicateHetsThreshold, value);
        return this;
    }

    public Double automaticMajorMAF() {
        return this.automaticMajorMAF.value();
    }

    public LDKNNiImputationHetV2Plugin automaticMajorMAF(Double value) {
        this.automaticMajorMAF = new PluginParameter<Double>(this.automaticMajorMAF, value);
        return this;
    }

    public Double minCoverageForDonors() {
        return this.minCoverageForDonors.value();
    }

    public LDKNNiImputationHetV2Plugin minCoverageForDonors(Double value) {
        this.minCoverageForDonors = new PluginParameter<Double>(this.minCoverageForDonors, value);
        return this;
    }

    public Double minCallBestGenoRatio() {
        return this.minCallBestGenoRatio.value();
    }

    public LDKNNiImputationHetV2Plugin minCallBestGenoRatio(Double value) {
        this.minCallBestGenoRatio = new PluginParameter<Double>(this.minCallBestGenoRatio, value);
        return this;
    }

    public Integer maxCores() {
        return this.maxCores.value();
    }

    public LDKNNiImputationHetV2Plugin maxCores(Integer value) {
        this.maxCores = new PluginParameter<Integer>(this.maxCores, value);
        return this;
    }

    public static double[] dist(byte[] b1, byte[] b2, int min) {
        int distance = 0;
        int count = 0;
        for (int i = 0; i < b1.length; ++i) {
            byte p1 = GenotypeTableUtils.getUnphasedSortedDiploidValue(b1[i]);
            byte p2 = GenotypeTableUtils.getUnphasedSortedDiploidValue(b2[i]);
            if (p1 == -1 || p2 == -1) continue;
            ++count;
            if (p1 == p2) continue;
            if (GenotypeTableUtils.isHeterozygous(p1) || GenotypeTableUtils.isHeterozygous(p2)) {
                ++distance;
                continue;
            }
            distance += 2;
        }
        if (count < min) {
            return new double[]{Double.NaN, count};
        }
        return new double[]{(double)distance / (double)(2 * count), count};
    }

    private static /* synthetic */ void lambda$getClosestNonMissingTaxa$15(Multimap distGenoMap, Tuple distGeno) {
        distGenoMap.put(distGeno.x, distGeno.y);
    }

    class StatsOnOneSite {
        private int[][] cnts = new int[6][6];
        private final double maf;
        private final double hetFreq;
        private final boolean isPolymorphic;
        private final int ldSiteCnt;
        Map<Byte, Integer> genotypeToIndexMap = new HashMap<Byte, Integer>();
        List<Byte> headers;

        private StatsOnOneSite(double maf, double hetFreq, boolean isPolymorphic, int ldSiteCnt, byte majorAllele, byte minorAllele) {
            this.maf = maf;
            this.hetFreq = hetFreq;
            this.isPolymorphic = isPolymorphic;
            this.ldSiteCnt = ldSiteCnt;
            if (!isPolymorphic) {
                System.out.println(majorAllele + ":" + minorAllele);
            }
            this.genotypeToIndexMap.put(GenotypeTableUtils.getDiploidValue(majorAllele, majorAllele), 0);
            this.genotypeToIndexMap.put(GenotypeTableUtils.getDiploidValue(majorAllele, minorAllele), 1);
            this.genotypeToIndexMap.put(GenotypeTableUtils.getDiploidValue(minorAllele, majorAllele), 1);
            this.genotypeToIndexMap.put(GenotypeTableUtils.getDiploidValue(minorAllele, minorAllele), 2);
            this.genotypeToIndexMap.put((byte)-1, 3);
            this.genotypeToIndexMap.put((byte)85, 4);
            this.headers = Bytes.asList((byte[])new byte[]{GenotypeTableUtils.getDiploidValue(majorAllele, majorAllele), GenotypeTableUtils.getDiploidValue(majorAllele, minorAllele), GenotypeTableUtils.getDiploidValue(minorAllele, minorAllele), -1, 85, -18});
        }

        void updateStats(byte origGeno, byte impGeno) {
            int originalIndex = this.genotypeToIndexMap.getOrDefault(origGeno, 5);
            int impIndex = this.genotypeToIndexMap.getOrDefault(impGeno, 5);
            int[] nArray = this.cnts[originalIndex];
            int n = impIndex;
            nArray[n] = nArray[n] + 1;
        }

        double minorAcc() {
            return (double)this.cnts[2][2] / ((double)(this.cnts[2][0] + this.cnts[2][1] + this.cnts[2][2]) + 0.5);
        }

        double homozygousAcc() {
            return (double)(this.cnts[0][0] + this.cnts[2][2]) / ((double)(this.cnts[0][0] + this.cnts[0][1] + this.cnts[0][2] + this.cnts[2][0] + this.cnts[2][1] + this.cnts[2][2]) + 0.5);
        }

        double hetAcc() {
            return (double)this.cnts[1][1] / ((double)(this.cnts[1][0] + this.cnts[1][1] + this.cnts[1][2]) + 0.5);
        }

        double hetFreq() {
            return this.hetFreq;
        }

        double gapCallRatioOnMajor() {
            return (double)this.cnts[0][4] / (double)IntStream.of(this.cnts[0]).sum();
        }

        double gapCallRatioOnMissing() {
            return (double)this.cnts[3][4] / (double)IntStream.of(this.cnts[3]).sum();
        }

        double recallPowerOfHomozgyous() {
            return (double)(this.cnts[0][0] + this.cnts[2][2]) / (double)(IntStream.of(this.cnts[0]).sum() + IntStream.of(this.cnts[2]).sum());
        }

        int[][] getCnts() {
            return this.cnts;
        }

        void printToStdOut() {
            System.out.printf("isPolymorphic:%s MAF:%g LDSites:%d %n", this.isPolymorphic, this.maf, this.ldSiteCnt);
            for (int i = 0; i < this.cnts[0].length; ++i) {
                byte label = this.headers.get(i);
                System.out.print(NucleotideAlignmentConstants.getNucleotideIUPAC(label) + "\t");
                for (int j = 0; j < this.cnts[0].length; ++j) {
                    System.out.print(this.cnts[i][j] + "\t");
                }
                System.out.println();
            }
        }
    }

    class StatsOnSites {
        private int[][][] totalCnts = new int[3][5][5];
        private int siteCnt = 0;
        private int[] classCnt = new int[3];

        private StatsOnSites() {
        }

        synchronized void addStats(double hetFreq, int[][] cnts) {
            ++this.siteCnt;
            double hetAcc = (double)cnts[1][1] / (double)(cnts[1][0] + cnts[1][1] + cnts[1][2]);
            int classIndex = hetFreq > LDKNNiImputationHetV2Plugin.this.duplicateHetsThreshold() ? (hetAcc > 0.5 ? 0 : 1) : 2;
            int n = classIndex;
            this.classCnt[n] = this.classCnt[n] + 1;
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 5; ++j) {
                    int[] nArray = this.totalCnts[classIndex][i];
                    int n2 = j;
                    nArray[n2] = nArray[n2] + cnts[i][j];
                }
            }
        }

        double homozygousAcc(int siteClass) {
            return (double)(this.totalCnts[siteClass][0][0] + this.totalCnts[siteClass][2][2]) / (double)(this.totalCnts[siteClass][0][0] + this.totalCnts[siteClass][0][1] + this.totalCnts[siteClass][0][2] + this.totalCnts[siteClass][2][0] + this.totalCnts[siteClass][2][1] + this.totalCnts[siteClass][2][2]);
        }

        double recallPowerOfHomozgyous(int siteClass) {
            return (double)(this.totalCnts[siteClass][0][0] + this.totalCnts[siteClass][2][2]) / (double)(IntStream.of(this.totalCnts[siteClass][0]).sum() + IntStream.of(this.totalCnts[siteClass][2]).sum());
        }

        void printToStdOut() {
            for (int siteClass = 0; siteClass < 3; ++siteClass) {
                System.out.println("SiteClass" + siteClass + " Count:" + this.classCnt[siteClass]);
                for (int i = 0; i < this.totalCnts[0].length; ++i) {
                    for (int j = 0; j < this.totalCnts[0][0].length; ++j) {
                        System.out.print(this.totalCnts[siteClass][i][j] + "\t");
                    }
                    System.out.println();
                }
                System.out.printf("Homozygous Acc:%.4g %n", this.homozygousAcc(siteClass));
            }
            System.out.println("StatsOnSites siteCnt = " + this.siteCnt);
        }
    }
}

