/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.analysis.imputation.ImputationUtils;
import net.maizegenetics.analysis.imputation.PhaseHighCoverage;
import net.maizegenetics.analysis.imputation.RephaseParents;
import net.maizegenetics.analysis.imputation.SelfedHaplotypeFinder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportBuilder;
import org.apache.log4j.Logger;

public class ParentPhasingPlugin
extends AbstractPlugin {
    private static Logger myLogger = Logger.getLogger(ParentPhasingPlugin.class);
    private static final byte N = 15;
    private PluginParameter<Boolean> phaseParents = new PluginParameter.Builder<Boolean>("phase", false, Boolean.class).guiName("Phase Parents").description("Phase parents").build();
    private PluginParameter<Boolean> rephaseParents = new PluginParameter.Builder<Boolean>("rephase", false, Boolean.class).guiName("Re-Phase Parents").description("Rephase parents").build();
    private PluginParameter<String> parentageFile = new PluginParameter.Builder<String>("parentage", null, String.class).guiName("Parentage File").inFile().description("The file containing the parentage which lists the parents of each progeny and whether they were derived by self or outcross.").build();
    private PluginParameter<Boolean> selfonly = new PluginParameter.Builder<Boolean>("self", false, Boolean.class).dependentOnParameter(this.phaseParents).guiName("Self Families Only").description("If checked or true, phases using only families created by selfing a single parent. The alternative is to use all families. Compared to using all families, self only generally does a better job of phasing with a lot less missing data.").build();
    private PluginParameter<Integer> windowSize = new PluginParameter.Builder<Integer>("window", 50, Integer.class).dependentOnParameter(this.selfonly).guiName("Window Size").description("").build();
    private PluginParameter<Double> maxMissing = new PluginParameter.Builder<Double>("maxMissing", 0.7, Double.class).dependentOnParameter(this.selfonly).guiName("Max Proportion Missing Data").description("Maximum allowable proportion of missing data for a site.").build();
    private PluginParameter<String> outputFile = new PluginParameter.Builder<String>("out", null, String.class).dependentOnParameter(this.phaseParents).guiName("Output File").outFile().description("The file contain the phased parent haplotypes in binary format. A .bin extension will be added to the filename.").build();
    private PluginParameter<String> separator1 = PluginParameter.getLabelInstance("Files  ------------------------------");
    private PluginParameter<String> parentCallFilename = new PluginParameter.Builder<String>("parentcalls", null, String.class).dependentOnParameter(this.rephaseParents).guiName("Progeny States (parentcalls)").inFile().description("The genotype file containing the imputed progeny states, probably identified as parentcalls.").build();
    private PluginParameter<String> parentHaplotypeFilename = new PluginParameter.Builder<String>("parentHaplotypes", null, String.class).dependentOnParameter(this.rephaseParents).guiName("Parent Haplotype File").inFile().description("The file containing the haplotypes of the parents. Rephasing parents uses the progeny states to improve these haplotype calls.").build();
    private PluginParameter<String> rephaseOutFile = new PluginParameter.Builder<String>("rephaseOut", null, String.class).dependentOnParameter(this.rephaseParents).guiName("Rephase Output File").outFile().description("The file that will contain the rephased, improved parent haplotype calls.").build();
    private PluginParameter<String> separator2 = PluginParameter.getLabelInstance("Combine phased data ------------------------------");
    private PluginParameter<Boolean> combine = new PluginParameter.Builder<Boolean>("combine", false, Boolean.class).guiName("Combine Phasing").description("Combines two methods of phasing parents. Any sites that disagree are set to missing. Uses binary files as input. A report comparing the sites in common between the files will be generated.").build();
    private PluginParameter<String> phased1 = new PluginParameter.Builder<String>("phased1", null, String.class).dependentOnParameter(this.combine).guiName("First Phased File").inFile().description("One of the binary phased parent haplotype files.").build();
    private PluginParameter<String> phased2 = new PluginParameter.Builder<String>("phased2", null, String.class).dependentOnParameter(this.combine).guiName("Second Phased File").inFile().description("The other binary phased parent haplotype file.").build();
    private PluginParameter<String> combineOut = new PluginParameter.Builder<String>("combineout", null, String.class).dependentOnParameter(this.combine).guiName("Combine Output Filename").outFile().description("The name of the combined output file. A .bin extension will be added. If this is blank, the files will not be combined and only a report comparing the two files will be generated.").build();
    private PluginParameter<String> separator3 = PluginParameter.getLabelInstance("Convert binary haplotypes to text ------------------------------");
    private PluginParameter<Boolean> convert = new PluginParameter.Builder<Boolean>("convert", false, Boolean.class).guiName("Convert Phasing").description("Converts a binary phasing results file to text.").build();
    private PluginParameter<String> phasedIn = new PluginParameter.Builder<String>("binaryinput", null, String.class).dependentOnParameter(this.convert).guiName("File to convert").inFile().description("The name of the binary file to be converted.").build();
    private PluginParameter<String> convertOut = new PluginParameter.Builder<String>("convertout", null, String.class).dependentOnParameter(this.convert).guiName("Combine Output Filename").outFile().description("The name of the converted output file. A .txt extension will be added if not present.").build();
    private PluginParameter<String> separator4 = PluginParameter.getLabelInstance("Correct self phasing ------------------------------");
    private PluginParameter<Boolean> correct = new PluginParameter.Builder<Boolean>("correct", false, Boolean.class).guiName("Correct Self Phasing").description("Exchanges sections of chromosomes so that self phase matches cross phase.").build();
    private PluginParameter<String> parentname = new PluginParameter.Builder<String>("parent", null, String.class).dependentOnParameter(this.correct).guiName("Parent Name").description("The parent for which phase will be corrected. Required for phase correction.").build();
    private PluginParameter<String> chrname = new PluginParameter.Builder<String>("chrom", null, String.class).dependentOnParameter(this.correct).guiName("Chromosome Name").description("The chromosome for which phase will be corrected. Required for phase correction.").build();
    private PluginParameter<String> selfPhased = new PluginParameter.Builder<String>("selfPhased", null, String.class).dependentOnParameter(this.correct).guiName("Self Phased File").inFile().description("Phased parent haplotype files from self progeny.").build();
    private PluginParameter<String> crossPhased = new PluginParameter.Builder<String>("crossPhased", null, String.class).dependentOnParameter(this.correct).guiName("Cross Phased File").inFile().description("Phased parent haplotype files from self progeny.").build();
    private PluginParameter<String> selfOut = new PluginParameter.Builder<String>("selfOut", null, String.class).dependentOnParameter(this.correct).guiName("Corrected Output Filename").outFile().description("The name of the corrected self phased output file. A .bin extension will be added. If this is blank, the files will not be combined and only a report comparing the two files will be generated.").build();

    public ParentPhasingPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        if (this.phaseParents.value().booleanValue()) {
            if (this.rephaseParents.value().booleanValue()) {
                throw new IllegalArgumentException("Both phase and rephase cannot be chosen. Check at most one of those.");
            }
            if (input.getDataOfType(GenotypeTable.class).size() != 1) {
                throw new IllegalArgumentException("Phasing parents requires exactly one genotype dataset as input.");
            }
            if (this.outputFile.value() == null || this.outputFile.value().length() < 1) {
                throw new IllegalArgumentException("No output file name for phaseParents.");
            }
            if (this.parentageFile.value() == null || this.parentageFile.value().length() < 1) {
                throw new IllegalArgumentException("No parentage file name for phaseParents.");
            }
        }
        if (this.combine.value().booleanValue()) {
            if (this.phased1.value() == null || this.phased1.value().trim().length() < 1) {
                throw new IllegalArgumentException("Combining haplotypes phased1 input filename is missing.");
            }
            if (this.phased2.value() == null || this.phased2.value().trim().length() < 1) {
                throw new IllegalArgumentException("Combining haplotypes phased2 input filename is missing.");
            }
            if (this.combineOut.value() == null || this.combineOut.value().trim().length() < 1) {
                throw new IllegalArgumentException("Combining haplotypes output filename is missing.");
            }
        }
        if (this.convert.value().booleanValue()) {
            if (this.phasedIn.value() == null || this.phasedIn.value().trim().length() < 1) {
                throw new IllegalArgumentException("Converting binary to text requires exactly one input file.");
            }
            if (this.convertOut.value() == null || this.convertOut.value().trim().length() < 1) {
                throw new IllegalArgumentException("Converting binary to text requires exactly one output file.");
            }
        }
        if (this.rephaseParents.value().booleanValue()) {
            if (this.parentageFile.value() == null || this.parentageFile.value().length() < 1) {
                throw new IllegalArgumentException("No parentage file name for rephaseParents.");
            }
            if (this.parentCallFilename.value() == null || this.parentCallFilename.value().length() < 1) {
                throw new IllegalArgumentException("No parent call file name for rephaseParents.");
            }
            if (this.parentHaplotypeFilename.value() == null || this.parentHaplotypeFilename.value().length() < 1) {
                throw new IllegalArgumentException("No parent haplotype input file name for rephaseParents.");
            }
            if (this.rephaseOutFile.value() == null || this.rephaseOutFile.value().length() < 1) {
                throw new IllegalArgumentException("No parent haplotype output file name for rephaseParents.");
            }
        }
        if (this.correct.value().booleanValue()) {
            if (this.selfPhased.value() == null || this.selfPhased.value().trim().length() < 1) {
                throw new IllegalArgumentException("Correcting haplotypes self input filename is missing.");
            }
            if (this.crossPhased.value() == null || this.crossPhased.value().trim().length() < 1) {
                throw new IllegalArgumentException("Correcting haplotypes cross input filename is missing.");
            }
            if (this.selfOut.value() == null || this.selfOut.value().trim().length() < 1) {
                throw new IllegalArgumentException("Correcting haplotypes output filename is missing.");
            }
            if (this.parentname.value() == null || this.parentname.value().trim().length() < 1) {
                throw new IllegalArgumentException("Correcting haplotypes requires a parent name.");
            }
            if (this.chrname.value() == null || this.chrname.value().trim().length() < 1) {
                throw new IllegalArgumentException("Correcting haplotypes requires a chromosome.");
            }
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        ArrayList<Datum> resultList = new ArrayList<Datum>();
        GenotypeTable myGeno = (GenotypeTable)input.getDataOfType(GenotypeTable.class).get(0).getData();
        if (this.phaseParents.value().booleanValue()) {
            Path parentPath = Paths.get(this.parentageFile.value(), new String[0]);
            Path savepath = Paths.get(this.appendbin(this.outputFile.value()), new String[0]);
            if (this.selfonly.value().booleanValue()) {
                int window = this.windowSize.value();
                double minNotMiss = 1.0 - this.maxMissing.value();
                SelfedHaplotypeFinder shf = new SelfedHaplotypeFinder(window, minNotMiss);
                shf.setGenotype(myGeno);
                shf.phaseSelfedParents(parentPath, savepath);
            } else {
                PhaseHighCoverage phc = new PhaseHighCoverage(myGeno);
                phc.setParentage(this.parentageFile.value());
                phc.phaseParentsUsingAllAvailableProgeny(2.0, savepath);
            }
        }
        if (this.rephaseParents.value().booleanValue()) {
            RephaseParents rp = new RephaseParents(myGeno, this.parentCallFilename.value(), this.parentageFile.value(), this.parentHaplotypeFilename.value());
            ImputationUtils.serializePhasedHaplotypes(rp.rephaseUsingCrossProgeny(), this.rephaseOutFile.value());
        }
        if (this.combine.value().booleanValue()) {
            String comment = String.format("Comparison of phasing for:\n%s\n%s.", this.phased1.value(), this.phased2.value());
            Datum report = new Datum("Phase Comparison Report", this.comparePhasing(myGeno), comment);
            resultList.add(report);
            if (this.combineOut.value() != null && this.combineOut.value().trim().length() > 0) {
                this.mergePhasedHaplotypes(myGeno);
            }
        }
        if (this.convert.value().booleanValue() && this.convertOut.value() != null && this.convertOut.value().trim().length() > 0) {
            this.formatPhasedDataAsText(myGeno);
        }
        if (this.correct.value().booleanValue()) {
            SelfedHaplotypeFinder shf = new SelfedHaplotypeFinder(50, 1.0);
            shf.setGenotype(myGeno);
            shf.correctSelfPhaseUsingCross(this.selfPhased.value(), this.crossPhased.value(), this.parentname.value(), Integer.parseInt(this.chrname.value()), this.selfOut.value());
        }
        return new DataSet(resultList, (Plugin)this);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Phase Parents";
    }

    @Override
    public String getToolTipText() {
        return "Phase parents using progeny genotypes";
    }

    @Override
    public String pluginDescription() {
        return "This plugin phases parents of full-sib families using parent and progeny genotypes and a parentage file as input.The method can use either selfed families only or all families.";
    }

    private TableReport comparePhasing(GenotypeTable myGenotype) {
        Object[] columnNames = new String[]{"parent", "chr", "phased_same", "phased_diff", "monoPhased", "phasedMono", "sameMono", "diffMono"};
        TableReportBuilder reportBuilder = TableReportBuilder.getInstance("Phasing Comparison", columnNames);
        byte N = 15;
        Map<String, byte[][]> hapmap1 = this.loadHaplotypes(this.phased1.value());
        Map<String, byte[][]> hapmap2 = this.loadHaplotypes(this.phased2.value());
        ArrayList<String> crossParents = new ArrayList<String>(hapmap1.keySet());
        Collections.sort(crossParents);
        int numberOfChromomsomes = myGenotype.numChromosomes();
        for (String parent : crossParents) {
            byte[][] firstHaps = hapmap1.get(parent);
            byte[][] secondHaps = hapmap2.get(parent);
            if (secondHaps == null) continue;
            myLogger.info((Object)String.format("Comparing phasing for %s\n", parent));
            int[] countPhaseSame = new int[numberOfChromomsomes];
            int[] countPhaseDifferent = new int[numberOfChromomsomes];
            int[] countMonoPhased = new int[numberOfChromomsomes];
            int[] countPhasedMono = new int[numberOfChromomsomes];
            int[] sameMono = new int[numberOfChromomsomes];
            int[] differentMono = new int[numberOfChromomsomes];
            int n = firstHaps[0].length;
            for (int s = 0; s < n; ++s) {
                if (firstHaps[0][s] == N || firstHaps[1][s] == N || secondHaps[0][s] == N || secondHaps[1][s] == N) continue;
                int chr = myGenotype.chromosome(s).getChromosomeNumber() - 1;
                if (firstHaps[0][s] == firstHaps[1][s]) {
                    if (secondHaps[0][s] == secondHaps[1][s]) {
                        if (firstHaps[0][s] == secondHaps[0][s]) {
                            int n2 = chr;
                            sameMono[n2] = sameMono[n2] + 1;
                            continue;
                        }
                        int n3 = chr;
                        differentMono[n3] = differentMono[n3] + 1;
                        continue;
                    }
                    int n4 = chr;
                    countMonoPhased[n4] = countMonoPhased[n4] + 1;
                    continue;
                }
                if (secondHaps[0][s] == secondHaps[1][s]) {
                    int n5 = chr;
                    countPhasedMono[n5] = countPhasedMono[n5] + 1;
                    continue;
                }
                if (firstHaps[0][s] == secondHaps[0][s]) {
                    int n6 = chr;
                    countPhaseSame[n6] = countPhaseSame[n6] + 1;
                    continue;
                }
                int n7 = chr;
                countPhaseDifferent[n7] = countPhaseDifferent[n7] + 1;
            }
            for (int c = 0; c < numberOfChromomsomes; ++c) {
                int diff;
                int same;
                if (countPhaseSame[c] >= countPhaseDifferent[c]) {
                    same = countPhaseSame[c];
                    diff = countPhaseDifferent[c];
                } else {
                    diff = countPhaseSame[c];
                    same = countPhaseDifferent[c];
                }
                Object[] row = new Object[]{parent, myGenotype.chromosomes()[c].getName(), same, diff, countMonoPhased[c], countPhasedMono[c], sameMono[c], differentMono[c]};
                reportBuilder.add(row);
            }
        }
        return reportBuilder.build();
    }

    private void mergePhasedHaplotypes(GenotypeTable myGeno) {
        System.out.println("merging self and cross haplotypes");
        int[] chrstart = myGeno.chromosomesOffsets();
        int numberOfChromosomes = chrstart.length;
        int[] chrend = new int[numberOfChromosomes];
        System.arraycopy(chrstart, 1, chrend, 0, numberOfChromosomes - 1);
        chrend[numberOfChromosomes - 1] = myGeno.numberOfSites();
        Map<String, byte[][]> hapmap1 = this.loadHaplotypes(this.phased1.value());
        Map<String, byte[][]> hapmap2 = this.loadHaplotypes(this.phased2.value());
        HashMap<String, byte[][]> combinedHapmap = new HashMap<String, byte[][]>();
        TreeSet<String> parentSet = new TreeSet<String>();
        parentSet.addAll(hapmap1.keySet());
        parentSet.addAll(hapmap2.keySet());
        for (String parent : parentSet) {
            byte[][] hap2;
            byte[][] hap1 = hapmap1.get(parent);
            Optional<byte[][]> combinedhap = this.smashHap(hap1, hap2 = hapmap2.get(parent), chrstart, chrend, parent);
            if (!combinedhap.isPresent()) continue;
            combinedHapmap.put(parent, combinedhap.get());
        }
        this.storeHaplotypes(combinedHapmap, this.appendbin(this.combineOut.value()));
        System.out.println("Finished merging self and cross haplotypes");
    }

    private Optional<byte[][]> smashHap(byte[][] hap0, byte[][] hap1, int[] chrstart, int[] chrend, String parent) {
        if (hap0 == null && hap1 == null) {
            return Optional.empty();
        }
        if (hap0 == null) {
            return Optional.of(hap1);
        }
        if (hap1 == null) {
            return Optional.of(hap0);
        }
        int nsites = hap0[0].length;
        byte[][] combined = new byte[][]{Arrays.copyOf(hap0[0], nsites), Arrays.copyOf(hap0[1], nsites)};
        int numberOfChromosomes = chrstart.length;
        for (int c = 0; c < numberOfChromosomes; ++c) {
            int s;
            byte[] chap00 = Arrays.copyOfRange(hap0[0], chrstart[c], chrend[c]);
            byte[] chap01 = Arrays.copyOfRange(hap0[1], chrstart[c], chrend[c]);
            byte[] chap10 = Arrays.copyOfRange(hap1[0], chrstart[c], chrend[c]);
            byte[] chap11 = Arrays.copyOfRange(hap1[1], chrstart[c], chrend[c]);
            int[] comp00 = this.compareHaplotypes(chap00, chap10);
            int[] comp01 = this.compareHaplotypes(chap00, chap11);
            int[] comp10 = this.compareHaplotypes(chap01, chap10);
            int[] comp11 = this.compareHaplotypes(chap01, chap11);
            double originalMatch = (double)(comp00[0] + comp11[0]) / (double)(comp00[1] + comp11[1]);
            double reverseMatch = (double)(comp01[0] + comp10[0]) / (double)(comp01[1] + comp10[1]);
            System.out.printf("%s, chr %d: original order match = %1.3f, reverse match = %1.3f\n", parent, c + 1, originalMatch, reverseMatch);
            if (originalMatch > reverseMatch && originalMatch > 0.9) {
                for (s = chrstart[c]; s < chrend[c]; ++s) {
                    if (hap0[0][s] == 15 && hap1[0][s] != 15) {
                        combined[0][s] = hap1[0][s];
                        combined[1][s] = hap1[1][s];
                        continue;
                    }
                    if (hap0[0][s] == 15 || hap1[0][s] == 15 || hap0[0][s] == hap1[0][s] && hap0[1][s] == hap1[1][s]) continue;
                    combined[0][s] = 15;
                    combined[1][s] = 15;
                }
                continue;
            }
            if (!(reverseMatch > originalMatch) || !(reverseMatch > 0.9)) continue;
            for (s = chrstart[c]; s < chrend[c]; ++s) {
                if (hap0[0][s] == 15 && hap1[0][s] != 15) {
                    combined[0][s] = hap1[1][s];
                    combined[1][s] = hap1[0][s];
                    continue;
                }
                if (hap0[0][s] == 15 || hap1[0][s] == 15 || hap0[0][s] == hap1[1][s] && hap0[1][s] == hap1[0][s]) continue;
                combined[0][s] = 15;
                combined[1][s] = 15;
            }
        }
        return Optional.of(combined);
    }

    private int[] compareHaplotypes(byte[] h0, byte[] h1) {
        int totalCount = 0;
        int sameCount = 0;
        for (int i = 0; i < h0.length; ++i) {
            if (!(h0[i] != 15 & h1[i] != 15)) continue;
            ++totalCount;
            if (h0[i] != h1[i]) continue;
            ++sameCount;
        }
        return new int[]{sameCount, totalCount};
    }

    private void formatPhasedDataAsText(GenotypeTable myGeno) {
        Map<String, byte[][]> myHaps = this.loadHaplotypes(this.phasedIn.value());
        ArrayList<String> taxa = new ArrayList<String>(myHaps.keySet());
        Collections.sort(taxa);
        int nsites = myHaps.get(taxa.get(0))[0].length;
        int ntaxa = taxa.size();
        try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(this.appendtxt(this.convertOut.value()), new String[0]), new OpenOption[0]);){
            bw.write("snpid\tchr\tpos");
            for (String name : taxa) {
                bw.write(String.format("\t%s\t%s", name + "_hap1", name + "_hap2"));
            }
            bw.write("\n");
            for (int s = 0; s < nsites; ++s) {
                String snpname = myGeno.siteName(s);
                String chrname = myGeno.chromosomeName(s);
                int pos = myGeno.chromosomalPosition(s);
                bw.write(String.format("%s\t%s\t%d", snpname, chrname, pos));
                for (String taxonName : taxa) {
                    byte[][] haps = myHaps.get(taxonName);
                    bw.write(String.format("\t%s\t%s", NucleotideAlignmentConstants.getHaplotypeNucleotide(haps[0][s]), NucleotideAlignmentConstants.getHaplotypeNucleotide(haps[1][s])));
                }
                bw.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Finished writing formatted data to file.");
    }

    private GenotypeTable loadGenotype(String filename) {
        FileLoadPlugin flp = new FileLoadPlugin(null, false);
        flp.setTheFileType(FileLoadPlugin.TasselFileType.Unknown);
        flp.setOpenFiles(new File[]{new File(filename)});
        return (GenotypeTable)flp.performFunction(null).getData(0).getData();
    }

    private Map<String, byte[][]> loadHaplotypes(String filename) {
        try {
            FileInputStream fis = new FileInputStream(new File(filename));
            ObjectInputStream ois = new ObjectInputStream(fis);
            Map phasedHaps = (Map)ois.readObject();
            ois.close();
            return phasedHaps;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void storeHaplotypes(Map<String, byte[][]> hapmap, String name) {
        try {
            FileOutputStream fos = new FileOutputStream(name);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(hapmap);
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save phased haplotypes.", e);
        }
    }

    private String appendbin(String original) {
        if (original.endsWith(".bin")) {
            return original;
        }
        return original + ".bin";
    }

    private String appendtxt(String original) {
        if (original.endsWith(".txt")) {
            return original;
        }
        return original + ".txt";
    }
}

