/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import net.maizegenetics.dna.snp.ExportUtils;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.ImportUtils;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.PluginParameter;
import org.apache.log4j.Logger;

public class RemoveIndelsForBeaglePlugin
extends AbstractPlugin {
    private PluginParameter<String> inFile = new PluginParameter.Builder<String>("inFile", null, String.class).guiName("inFileName").inFile().required(true).description("The input file to prepare for beagle input").build();
    private PluginParameter<String> outFile = new PluginParameter.Builder<String>("outFile", null, String.class).guiName("outFileName").outFile().required(true).description("the output file name. If not VCF, will be append .vcf to the name").build();
    private PluginParameter<Boolean> retainMono = new PluginParameter.Builder<Boolean>("retainMono", false, Boolean.class).guiName("Retain monomorphic sites").description("Retain monomorphic sites in the output file").build();
    private static final Logger myLogger = Logger.getLogger(RemoveIndelsForBeaglePlugin.class);

    @Override
    protected void postProcessParameters() {
    }

    public RemoveIndelsForBeaglePlugin() {
        super(null, false);
    }

    public RemoveIndelsForBeaglePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        GenotypeTable genos = this.removeIndelsForBeagle();
        String out = this.outFile.value();
        if (!this.outFile.value().contains(".vcf")) {
            out = this.outFile.value() + ".vcf.gz";
        }
        ExportUtils.writeToVCF(genos, out, false);
        System.out.println("Wrote " + out + " with " + genos.numberOfSites() + " sites remaining");
        return null;
    }

    public GenotypeTable removeIndelsForBeagle() {
        GenotypeTable genos = ImportUtils.readGuessFormat(this.inFile.value());
        GenotypeCallTableBuilder newGenos = GenotypeCallTableBuilder.getInstanceCopy(genos.genotypeMatrix());
        ArrayList<String> keepSites = new ArrayList<String>();
        byte gapInsert = GenotypeTableUtils.getUnphasedDiploidValue((byte)5, (byte)4);
        for (int site = 0; site < genos.numberOfSites(); ++site) {
            byte minmaj = GenotypeTableUtils.getUnphasedDiploidValue(genos.majorAllele(site), genos.minorAllele(site));
            if (GenotypeTableUtils.isPartiallyEqual(gapInsert, minmaj) || !this.retainMono.value().booleanValue() && !genos.isPolymorphic(site)) continue;
            keepSites.add(genos.siteName(site));
            if (genos.alleles(site).length <= 2) continue;
            byte badGeno = GenotypeTableUtils.getDiploidValue((byte)5, (byte)4);
            for (int taxon = 0; taxon < genos.numberOfTaxa(); ++taxon) {
                if (!GenotypeTableUtils.isPartiallyEqual(genos.genotype(taxon, site), badGeno)) continue;
                newGenos.setBase(taxon, site, (byte)-1);
            }
        }
        GenotypeCallTable newGenoCallTable = newGenos.build();
        GenotypeTable newGT = GenotypeTableBuilder.getInstance(newGenoCallTable, genos.positions(), genos.taxa());
        GenotypeTable fa = GenotypeTableBuilder.getGenotypeCopyInstance(FilterGenotypeTable.getInstance(newGT, keepSites));
        return fa;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Remove indels for input to Beagle v.4";
    }

    @Override
    public String getToolTipText() {
        return "Removes sites with an indel as major and minor and changes indels in the third allele state to missing";
    }
}

