/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.maizegenetics.analysis.clustering.Haplotype;
import net.maizegenetics.analysis.clustering.HaplotypeCluster;
import net.maizegenetics.analysis.clustering.HaplotypeClusterer;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.Taxon;
import org.apache.log4j.Logger;

public class SelfedHaplotypeFinder {
    private static final Logger myLogger = Logger.getLogger(SelfedHaplotypeFinder.class);
    private static byte NN = (byte)-1;
    private static byte N = (byte)15;
    private static byte AA = NucleotideAlignmentConstants.getNucleotideDiploidByte("AA");
    private static byte CC = NucleotideAlignmentConstants.getNucleotideDiploidByte("CC");
    private static byte GG = NucleotideAlignmentConstants.getNucleotideDiploidByte("GG");
    private static byte TT = NucleotideAlignmentConstants.getNucleotideDiploidByte("TT");
    private GenotypeTable myGenotype;
    private int window;
    private double minNotMissingProportion;

    public SelfedHaplotypeFinder(int window, double minProportionNotMissing) {
        this.window = window;
        this.minNotMissingProportion = minProportionNotMissing;
    }

    public static void main(String[] args) {
        SelfedHaplotypeFinder shf = new SelfedHaplotypeFinder(1, 1.0);
        new FileLoadPlugin(null, false);
        GenotypeTable genoTable = (GenotypeTable)FileLoadPlugin.runPlugin("/Users/pbradbury/Documents/projects/landraces/data/Combined_LR13_LR14_parents2_AGPv4.h5");
        shf.setGenotype(genoTable);
        shf.correctSelfPhaseUsingCross("/Users/pbradbury/temp/test_phasedSelfParents_lr_agpv4_dec12.bin", "/Users/pbradbury/Documents/projects/landraces/output/dec12/phaseHighCoverParents_lr_agpv4_dec12.bin", "165_7_Tuxpeno_El_Aguacatito_Mex_:250358062", 9, "/Users/pbradbury/temp/test_adjusted_phasedSelfParents_lr_agpv4_dec12.bin");
    }

    public Map<String, byte[][]> phaseSelfedParents(Path parentpath, Path savepath) {
        boolean singleParentChrom = false;
        int minFamilySize = 10;
        int nsites = this.myGenotype.numberOfSites();
        long startTime = System.currentTimeMillis();
        ArrayList<String[]> plotList = new ArrayList<String[]>();
        try (BufferedReader br = Files.newBufferedReader(parentpath);){
            String input;
            br.readLine();
            while ((input = br.readLine()) != null) {
                String[] plot = input.split("\t");
                if (!plot[3].equals("self")) continue;
                plotList.add(plot);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read parentage.", e);
        }
        TreeSet parentSet = plotList.stream().map(p -> p[1]).collect(Collectors.toCollection(TreeSet::new));
        if (singleParentChrom) {
            parentSet.clear();
            parentSet.add("165_7_Tuxpeno_El_Aguacatito_Mex_:250358062");
        }
        HashMap<String, byte[][]> phasedHaplotypes = new HashMap<String, byte[][]>();
        for (String parent : parentSet) {
            System.out.printf("Starting %s at %d ms.\n", parent, System.currentTimeMillis() - startTime);
            TaxaListBuilder taxaBuilder = new TaxaListBuilder();
            for (String[] plot : plotList) {
                if (!plot[1].equals(parent)) continue;
                taxaBuilder.add(new Taxon(plot[0]));
            }
            TaxaList familyTaxa = taxaBuilder.build();
            if (familyTaxa.numberOfTaxa() < minFamilySize) {
                myLogger.info((Object)String.format("%s not phase because family size is %d.", parent, familyTaxa.numberOfTaxa()));
                continue;
            }
            myLogger.info((Object)String.format("Phasing %s, %d self progeny.", parent, familyTaxa.numberOfTaxa()));
            GenotypeTable familyGeno = FilterGenotypeTable.getInstance(this.myGenotype, familyTaxa, false);
            myLogger.info((Object)String.format("%s, number of sites = %d, number of taxa = %d", parent, familyGeno.numberOfSites(), familyGeno.numberOfTaxa()));
            int polyCount = 0;
            double minMaf = 0.1;
            int minCount = (int)(0.5 * (double)familyGeno.numberOfTaxa());
            byte[][] myPhasedHap = new byte[2][nsites];
            Arrays.fill(myPhasedHap[0], N);
            Arrays.fill(myPhasedHap[1], N);
            int ntaxa = familyGeno.numberOfTaxa();
            Chromosome[] myChromosomes = this.myGenotype.chromosomes();
            int startIndex = 0;
            int limitIndex = myChromosomes.length;
            if (singleParentChrom) {
                startIndex = 8;
                limitIndex = 9;
            }
            for (int c = startIndex; c < limitIndex; ++c) {
                Chromosome myChr = myChromosomes[c];
                GenotypeTable chrGeno = FilterGenotypeTable.getInstance(familyGeno, myChr);
                myLogger.debug((Object)String.format("%s, chr %s has %d sites before filtering", parent, myChr.getName(), chrGeno.numberOfSites()));
                int[] sitesToKeep = new int[chrGeno.numberOfSites()];
                int nSitesKept = 0;
                for (int s = 0; s < chrGeno.numberOfSites(); ++s) {
                    double maf = chrGeno.minorAlleleFrequency(s);
                    if (!(maf >= minMaf) || chrGeno.totalNonMissingForSite(s) < minCount) continue;
                    sitesToKeep[nSitesKept++] = s;
                }
                sitesToKeep = Arrays.copyOf(sitesToKeep, nSitesKept);
                myLogger.debug((Object)String.format("%s, chr %s has %d sites retained", parent, myChr.getName(), nSitesKept));
                chrGeno = FilterGenotypeTable.getInstance(chrGeno, sitesToKeep);
                int minClusterSize = Math.max(ntaxa / 10, 3);
                int ibdClusterSize = ntaxa / 2;
                int chrSites = chrGeno.numberOfSites();
                if (singleParentChrom) {
                    System.out.printf("Chr %s has %d sites\n", myChr.getName(), chrSites);
                    System.out.printf("first position %d, last position %d\n", chrGeno.chromosomalPosition(0), chrGeno.chromosomalPosition(chrSites - 1));
                    int[] chrStart = this.myGenotype.chromosomesOffsets();
                    System.out.printf("myGenotype start pos = %d, end pos = %d\n", this.myGenotype.chromosomalPosition(chrStart[c]), this.myGenotype.chromosomalPosition(chrStart[c + 1] - 1));
                }
                int maxhet = 10;
                HaplotypeCluster chr0clusters = null;
                HaplotypeCluster chr1clusters = null;
                HaplotypeCluster previousChr0clusters = null;
                HaplotypeCluster previousChr1clusters = null;
                int startIncr = this.window;
                int diff = 6;
                for (int start = 0; start < chrSites; start += startIncr) {
                    int w;
                    int windowSize = this.window;
                    if (chrSites - start < 2 * this.window) {
                        startIncr = windowSize = chrSites - start;
                        diff = diff * windowSize / this.window;
                    }
                    int minNotMissingAdjusted = (int)((double)windowSize * this.minNotMissingProportion);
                    HaplotypeClusterer myClusterMaker = this.clusterWindow(chrGeno, start, windowSize, diff, minNotMissingAdjusted);
                    myClusterMaker.sortClusters();
                    myClusterMaker.moveAllHaplotypesToBiggestCluster(diff);
                    myClusterMaker.removeHeterozygousClusters(maxhet);
                    int nclus = 0;
                    int pos = 0;
                    if (singleParentChrom) {
                        pos = chrGeno.chromosomalPosition(start);
                        nclus = myClusterMaker.getNumberOfClusters();
                        System.out.printf("at chr %s, %d, %d clusters after remove hets.\n", myChr.getName(), pos, nclus);
                        if (pos > 146000000) {
                            System.out.print("");
                        }
                    }
                    if (myClusterMaker.getNumberOfClusters() == 0) continue;
                    ArrayList<HaplotypeCluster> clusterList = myClusterMaker.getClusterList();
                    Iterator hapit = clusterList.iterator();
                    HaplotypeCluster hchead = (HaplotypeCluster)hapit.next();
                    byte[] head = hchead.getHaplotype();
                    while (hapit.hasNext()) {
                        HaplotypeCluster hcComp = (HaplotypeCluster)hapit.next();
                        if (Haplotype.getDistance(head, hcComp.getHaplotype()) >= this.window) continue;
                        hapit.remove();
                    }
                    if (clusterList.size() > 2) {
                        for (int i = clusterList.size() - 1; i > 1; --i) {
                            clusterList.remove(i);
                        }
                    }
                    boolean twoGoodClusters = false;
                    boolean oneGoodCluster = false;
                    boolean isIbd = false;
                    boolean inChrOrder = true;
                    if (singleParentChrom) {
                        nclus = clusterList.size();
                        System.out.printf("at chr %s, %d, %d clusters: ", myChr.getName(), pos, nclus);
                        for (int i = 0; i < nclus; ++i) {
                            System.out.printf(" %d", ((HaplotypeCluster)clusterList.get(i)).getSize());
                            System.out.print(" " + this.clusterTaxa((HaplotypeCluster)clusterList.get(i)));
                        }
                        System.out.println();
                    }
                    int[] clusterSizes = new int[2];
                    int totalSize = 0;
                    int limit = Math.min(2, clusterList.size());
                    for (int i = 0; i < limit; ++i) {
                        if (clusterList.get(i) == null) continue;
                        clusterSizes[i] = ((HaplotypeCluster)clusterList.get(i)).getSize();
                        totalSize += clusterSizes[i];
                    }
                    if (totalSize >= minClusterSize) {
                        int order;
                        if (clusterList.size() == 2 && clusterSizes[0] > 1 && clusterSizes[1] > 1) {
                            twoGoodClusters = true;
                            if (previousChr0clusters == null || previousChr1clusters == null) {
                                previousChr0clusters = chr0clusters = (HaplotypeCluster)clusterList.get(0);
                                previousChr1clusters = chr1clusters = (HaplotypeCluster)clusterList.get(1);
                            } else {
                                order = this.sameOrder(previousChr0clusters, previousChr1clusters, clusterList);
                                if (order == 1 || order == 0) {
                                    previousChr0clusters = chr0clusters = (HaplotypeCluster)clusterList.get(0);
                                    previousChr1clusters = chr1clusters = (HaplotypeCluster)clusterList.get(1);
                                } else {
                                    previousChr0clusters = chr0clusters = (HaplotypeCluster)clusterList.get(1);
                                    previousChr1clusters = chr1clusters = (HaplotypeCluster)clusterList.get(0);
                                    inChrOrder = false;
                                }
                            }
                        } else if (clusterList.size() == 1 && clusterSizes[0] > ibdClusterSize) {
                            oneGoodCluster = true;
                            isIbd = true;
                            chr0clusters = (HaplotypeCluster)clusterList.get(0);
                            chr1clusters = null;
                        } else if (clusterList.size() == 1 && clusterSizes[0] > minClusterSize || clusterList.size() == 2 && clusterSizes[1] == 1 && ((HaplotypeCluster)clusterList.get(0)).getSize() > minClusterSize) {
                            oneGoodCluster = true;
                            order = this.sameOrder(previousChr0clusters, previousChr1clusters, clusterList);
                            if (order > -1) {
                                previousChr0clusters = chr0clusters = (HaplotypeCluster)clusterList.get(0);
                                chr1clusters = null;
                            } else {
                                chr0clusters = null;
                                previousChr1clusters = chr1clusters = (HaplotypeCluster)clusterList.get(0);
                                inChrOrder = false;
                            }
                        }
                    }
                    if (singleParentChrom) {
                        System.out.printf("twoGoodClusters, oneGoodCluster: %b, %b\n", twoGoodClusters, oneGoodCluster);
                    }
                    if (twoGoodClusters) {
                        byte[] hap0 = chr0clusters.getCensoredMajorityHaplotype(0.05, 1);
                        byte[] hap1 = chr1clusters.getCensoredMajorityHaplotype(0.05, 1);
                        for (w = 0; w < windowSize; ++w) {
                            byte allele0 = this.homozygousDiploidToAllele(hap0[w]);
                            byte allele1 = this.homozygousDiploidToAllele(hap1[w]);
                            if (allele0 <= -1 || allele1 <= -1 || allele0 == allele1) continue;
                            int filterSite = start + w;
                            int mygenoSite = this.myGenotype.siteOfPhysicalPosition(chrGeno.chromosomalPosition(filterSite), myChr);
                            myPhasedHap[0][mygenoSite] = allele0;
                            myPhasedHap[1][mygenoSite] = allele1;
                            ++polyCount;
                        }
                        continue;
                    }
                    if (oneGoodCluster && !isIbd) {
                        byte[] hap;
                        int ndx;
                        if (chr0clusters != null) {
                            ndx = 0;
                            hap = chr0clusters.getCensoredMajorityHaplotype(0.05, 1);
                        } else {
                            ndx = 1;
                            hap = chr1clusters.getCensoredMajorityHaplotype(0.05, 1);
                        }
                        for (w = 0; w < windowSize; ++w) {
                            byte allele = this.homozygousDiploidToAllele(hap[w]);
                            if (allele <= -1) continue;
                            int filterSite = start + w;
                            int mygenoSite = this.myGenotype.siteOfPhysicalPosition(chrGeno.chromosomalPosition(filterSite), myChr);
                            myPhasedHap[ndx][mygenoSite] = allele;
                            ++polyCount;
                        }
                        continue;
                    }
                    if (!oneGoodCluster || isIbd) continue;
                    byte[] hap = chr0clusters.getCensoredMajorityHaplotype(0.05, 1);
                    for (int w2 = 0; w2 < windowSize; ++w2) {
                        byte allele = this.homozygousDiploidToAllele(hap[w2]);
                        if (allele <= -1) continue;
                        int filterSite = start + w2;
                        int mygenoSite = this.myGenotype.siteOfPhysicalPosition(chrGeno.chromosomalPosition(filterSite), myChr);
                        myPhasedHap[0][mygenoSite] = allele;
                        myPhasedHap[1][mygenoSite] = allele;
                        ++polyCount;
                    }
                }
            }
            nsites = familyGeno.numberOfSites();
            ntaxa = familyGeno.numberOfTaxa();
            int minCoverage = 10;
            int monoCount = 0;
            for (int s = 0; s < nsites; ++s) {
                if (familyGeno.totalNonMissingForSite(s) < minCoverage || !(familyGeno.majorAlleleFrequency(s) > 0.9999)) continue;
                for (int i = 0; i < 2; ++i) {
                    myPhasedHap[i][s] = familyGeno.majorAllele(s);
                }
                ++monoCount;
            }
            phasedHaplotypes.put(parent, myPhasedHap);
            myLogger.info((Object)String.format("parent %s: %d polymorphic sites and %d monomorphic sites add to haplotypes.", parent, polyCount, monoCount));
        }
        if (savepath != null) {
            SelfedHaplotypeFinder.serializePhasedHaplotypes(phasedHaplotypes, savepath);
        }
        return phasedHaplotypes;
    }

    public HaplotypeClusterer clusterWindow(GenotypeTable a, int start, int length, int maxdif, int minNotMissingPerHaplotype) {
        int ntaxa = a.numberOfTaxa();
        int end = start + length;
        ArrayList<Haplotype> haps = new ArrayList<Haplotype>();
        for (int t = 0; t < ntaxa; ++t) {
            Haplotype hap = new Haplotype(a.genotypeRange(t, start, end), t);
            if (hap.notMissingCount < minNotMissingPerHaplotype) continue;
            haps.add(hap);
        }
        HaplotypeClusterer hc = new HaplotypeClusterer(haps);
        hc.makeClusters();
        if (maxdif > 0) {
            hc.mergeClusters(maxdif);
        }
        return hc;
    }

    private int sameOrder(HaplotypeCluster chr0, HaplotypeCluster chr1, List<HaplotypeCluster> next) {
        int diff;
        int nhaps = next.size();
        if (nhaps == 1) {
            int count0 = this.taxaInCommon(chr0, next.get(0));
            int count1 = this.taxaInCommon(chr1, next.get(0));
            if (count1 > count0) {
                return -1;
            }
            if (count0 > count1) {
                return 1;
            }
            return 0;
        }
        int same = this.taxaInCommon(chr0, next.get(0)) + this.taxaInCommon(chr1, next.get(1));
        if (same > (diff = this.taxaInCommon(chr0, next.get(1)) + this.taxaInCommon(chr1, next.get(0)))) {
            return 1;
        }
        if (diff > same) {
            return -1;
        }
        return 0;
    }

    private String clusterTaxa(HaplotypeCluster hc) {
        return hc.getHaplotypeList().stream().map(h -> Integer.toString(h.taxonIndex)).collect(Collectors.joining(",", "(", ")"));
    }

    private int taxaInCommon(HaplotypeCluster hc0, HaplotypeCluster hc1) {
        if (hc0 == null || hc1 == null) {
            return 0;
        }
        int commonCount = 0;
        block0: for (Haplotype hap0 : hc0.getHaplotypeList()) {
            int ndx = hap0.taxonIndex;
            for (Haplotype hap1 : hc1.getHaplotypeList()) {
                if (ndx != hap1.taxonIndex) continue;
                ++commonCount;
                continue block0;
            }
        }
        return commonCount;
    }

    private byte homozygousDiploidToAllele(byte value) {
        if (value == AA) {
            return 0;
        }
        if (value == CC) {
            return 1;
        }
        if (value == GG) {
            return 2;
        }
        if (value == TT) {
            return 3;
        }
        return -1;
    }

    public static void serializePhasedHaplotypes(Map<String, byte[][]> phasedHaps, Path savePath) {
        try {
            FileOutputStream fos = new FileOutputStream(savePath.toFile());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(phasedHaps);
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save phased haplotypes.", e);
        }
    }

    public static Map<String, byte[][]> restorePhasedHaplotypes(Path restorePath) {
        try {
            FileInputStream fis = new FileInputStream(restorePath.toFile());
            ObjectInputStream ois = new ObjectInputStream(fis);
            Map phasedHaps = (Map)ois.readObject();
            ois.close();
            return phasedHaps;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Unable to restore phased haplotypes.", e);
        }
    }

    public void setGenotype(GenotypeTable genotype) {
        this.myGenotype = genotype;
    }

    public void correctSelfPhaseUsingCross(String selfPhaseFilename, String crossPhaseFilename, String parent, int chr, String outfileName) {
        Map<String, byte[][]> selfMap = SelfedHaplotypeFinder.restorePhasedHaplotypes(Paths.get(selfPhaseFilename, new String[0]));
        Map<String, byte[][]> crossMap = SelfedHaplotypeFinder.restorePhasedHaplotypes(Paths.get(crossPhaseFilename, new String[0]));
        HashMap<String, byte[][]> outMap = new HashMap<String, byte[][]>();
        int[] chrOffsets = this.myGenotype.chromosomesOffsets();
        int start = chrOffsets[chr - 1];
        int end = chr != 10 ? chrOffsets[chr] : this.myGenotype.numberOfSites();
        int nchrSites = end - start;
        for (String taxonName : selfMap.keySet()) {
            if (taxonName.equals(parent)) {
                int s;
                byte[][] selfhaps = selfMap.get(taxonName);
                byte[][] crosshaps = crossMap.get(taxonName);
                int[] same = new int[nchrSites];
                for (int s2 = start; s2 < end; ++s2) {
                    if (selfhaps[0][s2] == N || selfhaps[1][s2] == N || crosshaps[0][s2] == N || crosshaps[1][s2] == N || selfhaps[0][s2] == selfhaps[1][s2] || crosshaps[0][s2] == crosshaps[1][s2]) continue;
                    int ndx = s2 - start;
                    same[ndx] = selfhaps[0][s2] == crosshaps[0][s2] ? 1 : -1;
                }
                int[] sameCount = new int[3];
                for (int s3 = 1; s3 < nchrSites; ++s3) {
                    int n = same[s3] + 1;
                    sameCount[n] = sameCount[n] + 1;
                }
                System.out.printf("For %s chr %d same counts -1: %d, 0: %d, 1: %d\n", parent, chr, sameCount[0], sameCount[1], sameCount[2]);
                int currentStart = 0;
                for (s = 1; s < nchrSites; ++s) {
                    int i;
                    if (same[s] == 0) continue;
                    if (same[currentStart] == 0) {
                        for (i = currentStart; i < s; ++i) {
                            same[i] = same[s];
                        }
                    } else if (same[currentStart] == same[s]) {
                        for (i = currentStart + 1; i < s; ++i) {
                            same[i] = same[s];
                        }
                    }
                    currentStart = s;
                }
                for (int i = currentStart + 1; i < nchrSites; ++i) {
                    same[i] = same[currentStart];
                }
                sameCount = new int[3];
                for (s = 1; s < nchrSites; ++s) {
                    int n = same[s] + 1;
                    sameCount[n] = sameCount[n] + 1;
                }
                System.out.printf("For %s chr %d same counts: -1 -> %d, 0 -> %d, 1 -> %d\n", parent, chr, sameCount[0], sameCount[1], sameCount[2]);
                for (s = start; s < end; ++s) {
                    int ndx = s - start;
                    if (same[ndx] == -1) {
                        byte tmp = selfhaps[0][s];
                        selfhaps[0][s] = selfhaps[1][s];
                        selfhaps[1][s] = tmp;
                        continue;
                    }
                    if (same[ndx] != 0) continue;
                    byte by = N;
                    selfhaps[1][s] = by;
                    selfhaps[0][s] = by;
                }
                outMap.put(taxonName, selfhaps);
                continue;
            }
            outMap.put(taxonName, selfMap.get(taxonName));
        }
        SelfedHaplotypeFinder.serializePhasedHaplotypes(outMap, Paths.get(outfileName, new String[0]));
    }
}

