/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.imputation;

import net.maizegenetics.analysis.imputation.EmissionProbability;
import net.maizegenetics.analysis.imputation.TransitionProbability;

public class ViterbiAlgorithm {
    TransitionProbability myTransitionMatrix;
    EmissionProbability probObservationGivenState;
    byte[] obs;
    byte[][] history;
    double[] distance;
    int numberOfStates;
    double[] probTrueStates;
    int numberOfObs;
    byte[] finalState;

    public ViterbiAlgorithm(byte[] observations, TransitionProbability transitionMatrix, EmissionProbability obsGivenTrue, double[] pTrue) {
        this.obs = observations;
        this.numberOfObs = this.obs.length;
        this.numberOfStates = transitionMatrix.getNumberOfStates();
        this.myTransitionMatrix = transitionMatrix;
        this.probObservationGivenState = obsGivenTrue;
        this.probTrueStates = new double[pTrue.length];
        for (int i = 0; i < pTrue.length; ++i) {
            this.probTrueStates[i] = Math.log(pTrue[i]);
        }
        this.history = new byte[this.numberOfStates][this.numberOfObs];
        this.distance = new double[this.numberOfStates];
    }

    public void calculate() {
        this.initialize();
        for (int i = 1; i < this.numberOfObs; ++i) {
            this.updateDistanceAndHistory(i);
        }
    }

    public void initialize() {
        for (int i = 0; i < this.numberOfStates; ++i) {
            try {
                this.distance[i] = this.probObservationGivenState.getLnProbObsGivenState(i, this.obs[0], 0) + this.probTrueStates[i];
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateDistanceAndHistory(int node) {
        int i;
        int j;
        double[][] candidateDistance = new double[this.numberOfStates][this.numberOfStates];
        this.myTransitionMatrix.setNode(node);
        for (int i2 = 0; i2 < this.numberOfStates; ++i2) {
            for (j = 0; j < this.numberOfStates; ++j) {
                candidateDistance[i2][j] = this.distance[i2] + this.myTransitionMatrix.getLnTransitionProbability(i2, j) + this.probObservationGivenState.getLnProbObsGivenState(j, this.obs[node], node);
            }
        }
        int[] max = new int[this.numberOfStates];
        for (int i3 = 0; i3 < this.numberOfStates; ++i3) {
            for (int j2 = 0; j2 < this.numberOfStates; ++j2) {
                if (!(candidateDistance[i3][j2] > candidateDistance[max[j2]][j2])) continue;
                max[j2] = i3;
            }
        }
        for (j = 0; j < this.numberOfStates; ++j) {
            this.distance[j] = candidateDistance[max[j]][j];
            this.history[j][node] = (byte)max[j];
        }
        double maxd = this.distance[0];
        double mind = 0.0;
        for (i = 0; i < this.numberOfStates; ++i) {
            if (this.distance[i] > maxd) {
                maxd = this.distance[i];
            }
            if (this.distance[i] == Double.NEGATIVE_INFINITY || !(this.distance[i] < mind)) continue;
            mind = this.distance[i];
        }
        if (mind < -1.0E100) {
            i = 0;
            while (i < this.numberOfStates) {
                int n = i++;
                this.distance[n] = this.distance[n] - maxd;
            }
        }
    }

    public byte[] getMostProbableStateSequence() {
        int i;
        byte[] seq = new byte[this.numberOfObs];
        byte finalState = 0;
        for (i = 1; i < this.numberOfStates; ++i) {
            if (!(this.distance[i] > this.distance[finalState])) continue;
            finalState = (byte)i;
        }
        seq[this.numberOfObs - 1] = finalState;
        for (i = this.numberOfObs - 2; i >= 0; --i) {
            seq[i] = this.history[seq[i + 1]][i + 1];
        }
        return seq;
    }

    public void setStateProbability(double[] probTrueState) {
        int n = probTrueState.length;
        this.probTrueStates = new double[n];
        for (int i = 0; i < n; ++i) {
            this.probTrueStates[i] = Math.log(probTrueState[i]);
        }
    }
}

