/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import net.maizegenetics.analysis.association.AssociationUtils;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.analysis.modelfitter.ForwardRegression;
import net.maizegenetics.analysis.modelfitter.GenotypeAdditiveSite;
import net.maizegenetics.analysis.modelfitter.RefProbAdditiveSite;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.phenotype.TaxaAttribute;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.FactorModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.taxa.TaxaListUtils;
import net.maizegenetics.taxa.Taxon;
import org.apache.log4j.Logger;

public abstract class AbstractForwardRegression
implements ForwardRegression {
    private Logger myLogger = Logger.getLogger(AbstractForwardRegression.class);
    protected double[] y;
    protected final GenotypePhenotype myGenotypePhenotype;
    protected final GenotypeTable myGenotype;
    protected final Phenotype myPhenotype;
    protected double enterLimit;
    protected int maxVariants;
    protected final int numberOfSites;
    protected final int numberOfObservations;
    protected List<AdditiveSite> siteList;
    protected final List<ModelEffect> myBaseModel;
    protected List<ModelEffect> myModel;
    protected List<Object[]> myFittedVariants = new ArrayList<Object[]>();
    protected String traitname;
    protected int[] taxaIndex = null;

    public AbstractForwardRegression(GenotypePhenotype data) {
        this.myGenotypePhenotype = data;
        this.myGenotype = this.myGenotypePhenotype.genotypeTable();
        this.myPhenotype = this.myGenotypePhenotype.phenotype();
        this.numberOfSites = data.genotypeTable().numberOfSites();
        this.numberOfObservations = data.numberOfObservations();
        this.myBaseModel = this.getBaseModel();
        this.myModel = new ArrayList<ModelEffect>(this.myBaseModel);
        this.siteList = new ArrayList<AdditiveSite>();
        long start = System.nanoTime();
        if (this.myGenotype.hasGenotype()) {
            for (int s = 0; s < this.numberOfSites; ++s) {
                Position pos = (Position)this.myGenotype.positions().get(s);
                this.siteList.add(new GenotypeAdditiveSite(s, pos.getChromosome().getName(), pos.getPosition(), pos.getSNPID(), AdditiveSite.CRITERION.pval, this.myGenotypePhenotype.genotypeAllTaxa(s), this.myGenotype.majorAllele(s), this.myGenotype.majorAlleleFrequency(s)));
            }
        } else if (this.myGenotype.hasReferenceProbablity()) {
            for (int s = 0; s < this.numberOfSites; ++s) {
                Position pos = (Position)this.myGenotype.positions().get(s);
                this.siteList.add(new RefProbAdditiveSite(s, pos.getChromosome().getName(), pos.getPosition(), pos.getSNPID(), AdditiveSite.CRITERION.pval, this.myGenotypePhenotype.referenceProb(s)));
            }
        } else {
            throw new IllegalArgumentException("Input has neither genotype nor reference probability.");
        }
        this.myLogger.debug((Object)String.format("site list created with %d sites in %d ms.", this.siteList.size(), (System.nanoTime() - start) / 1000000L));
    }

    public AbstractForwardRegression(String serialFilename, Phenotype pheno) {
        ObjectInputStream input2;
        Throwable throwable;
        FileInputStream fos;
        ArrayList<AdditiveSite> mySites = new ArrayList<AdditiveSite>();
        TaxaListBuilder taxaBuilder = new TaxaListBuilder();
        int ntaxa = 0;
        int nsites = 0;
        try {
            fos = new FileInputStream(serialFilename + "_taxa.bin");
            throwable = null;
            try {
                input2 = new ObjectInputStream(fos);
                ntaxa = (Integer)input2.readObject();
                nsites = (Integer)input2.readObject();
                for (int t2 = 0; t2 < ntaxa; ++t2) {
                    taxaBuilder.add(new Taxon((String)input2.readObject()));
                }
                input2.close();
            }
            catch (Throwable input2) {
                throwable = input2;
                throw input2;
            }
            finally {
                if (fos != null) {
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable input2) {
                            throwable.addSuppressed(input2);
                        }
                    } else {
                        fos.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to open taxa.bin input file.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("error deserializing taxa: ", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("error deserializing taxa: ", e);
        }
        try {
            fos = new FileInputStream(serialFilename + "_sites.bin");
            throwable = null;
            try {
                input2 = new ObjectInputStream(fos);
                for (int s = 0; s < nsites; ++s) {
                    mySites.add((AdditiveSite)input2.readObject());
                }
                input2.close();
            }
            catch (Throwable input3) {
                throwable = input3;
                throw input3;
            }
            finally {
                if (fos != null) {
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable input3) {
                            throwable.addSuppressed(input3);
                        }
                    } else {
                        fos.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to open sites.bin input file.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("error deserializing sites: ", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("error deserializing sites: ", e);
        }
        this.myGenotypePhenotype = null;
        this.myGenotype = null;
        this.siteList = mySites;
        this.numberOfSites = this.siteList.size();
        TaxaList siteTaxaList = taxaBuilder.build();
        TaxaList jointTaxaList = TaxaListUtils.getCommonTaxa(siteTaxaList, pheno.taxa());
        this.myLogger.debug((Object)String.format("The joint taxa list has %d taxa.", jointTaxaList.size()));
        this.myPhenotype = new PhenotypeBuilder().fromPhenotype(pheno).keepTaxa(jointTaxaList).build().get(0);
        this.numberOfObservations = this.myPhenotype.numberOfObservations();
        this.myBaseModel = this.getBaseModel();
        TaxaAttribute myTaxa = this.myPhenotype.taxaAttribute();
        int[] taxaIndex = myTaxa.allTaxaAsList().stream().mapToInt(t -> siteTaxaList.indexOf((Taxon)t)).toArray();
        TreeSet<Integer> taxaSet = new TreeSet<Integer>();
        for (int t3 : taxaIndex) {
            taxaSet.add(t3);
        }
        ArrayList<Integer> uniqueTaxa = new ArrayList<Integer>(taxaSet);
        long countOfNegativeIndices = uniqueTaxa.stream().filter(I -> I < 0).count();
        this.myLogger.debug((Object)String.format("siteIndices has %d negative values.", countOfNegativeIndices));
        for (AdditiveSite as : mySites) {
            as.reindexTaxa(taxaIndex, uniqueTaxa);
        }
        this.myLogger.debug((Object)"sites reindexed.");
    }

    @Override
    public void resetModel(int phenotypeIndex, double enterLimit, int maxVariants) {
        PhenotypeAttribute myTraitAttribute = this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data).get(phenotypeIndex);
        this.traitname = myTraitAttribute.name();
        this.myModel = new ArrayList<ModelEffect>(this.myBaseModel);
        this.y = AssociationUtils.convertFloatArrayToDouble((float[])myTraitAttribute.allValues());
        this.enterLimit = enterLimit;
        this.maxVariants = maxVariants;
    }

    protected List<ModelEffect> getBaseModel() {
        ArrayList<ModelEffect> base = new ArrayList<ModelEffect>();
        int[] mean = new int[this.numberOfObservations];
        FactorModelEffect meanEffect = new FactorModelEffect(mean, false, "mean");
        base.add(meanEffect);
        for (PhenotypeAttribute factor : this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor)) {
            FactorModelEffect factorEffect = new FactorModelEffect(((CategoricalAttribute)factor).allIntValues(), true, factor.name());
            base.add(factorEffect);
        }
        for (PhenotypeAttribute cov : this.myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate)) {
            double[] values = AssociationUtils.convertFloatArrayToDouble(((NumericAttribute)cov).floatValues());
            CovariateModelEffect covEffect = new CovariateModelEffect(values, cov.name());
            base.add(covEffect);
        }
        return base;
    }

    @Override
    public List<Object[]> fittedModel() {
        return this.myFittedVariants;
    }

    @Override
    public Phenotype phenotype() {
        return this.myPhenotype;
    }

    protected void addVariant(AdditiveSite site, double p, int iteration, int step) {
        this.myFittedVariants.add(new Object[]{this.traitname, iteration, step, site.siteName(), site.chromosomeName(), site.position(), p, -Math.log10(p)});
    }
}

