/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.maizegenetics.analysis.modelfitter.AddPlusDomModelEffect;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.analysis.modelfitter.CovariatePermutationTestSpliterator;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import org.apache.commons.math3.distribution.FDistribution;

public class AddDomPermutationTestSpliterator
extends CovariatePermutationTestSpliterator {
    public AddDomPermutationTestSpliterator(List<double[]> permutedData, List<AdditiveSite> siteList, List<ModelEffect> baseModel) {
        super(permutedData, siteList, baseModel);
    }

    @Override
    public boolean tryAdvance(Consumer<? super double[]> action) {
        if (this.origin == this.end) {
            return false;
        }
        AdditiveSite as = (AdditiveSite)this.mySites.get(this.origin);
        ArrayList<ModelEffect> myModel = new ArrayList<ModelEffect>(this.myBaseModel);
        AddPlusDomModelEffect effectToAdd = new AddPlusDomModelEffect(as, as);
        myModel.add(effectToAdd);
        SweepFastLinearModel sflm = new SweepFastLinearModel((List<ModelEffect>)myModel, (double[])this.myPermutedData.get(0));
        double dfError = sflm.getResidualSSdf()[1];
        DoubleMatrix G = sflm.getInverseOfXtX();
        FDistribution fdist = new FDistribution(1.0, dfError);
        double[] pvals = this.myPermutedData.stream().map(d -> DoubleMatrixFactory.DEFAULT.make(((double[])d).length, 1, (double[])d)).mapToDouble(y -> {
            double[] yarray = y.to1DArray();
            int nbase = this.myBaseModel.size();
            DoubleMatrix[][] xtyMatrices = new DoubleMatrix[nbase + 1][1];
            for (int i = 0; i < nbase; ++i) {
                xtyMatrices[i][0] = ((ModelEffect)this.myBaseModel.get(i)).getXty(yarray);
            }
            xtyMatrices[nbase][0] = effectToAdd.getXty(yarray);
            DoubleMatrix Xty = DoubleMatrixFactory.DEFAULT.compose(xtyMatrices);
            DoubleMatrix beta = G.mult(Xty);
            double ssTotal = y.crossproduct().get(0, 0);
            double ssModel = Xty.crossproduct(beta).get(0, 0);
            double ssError = ssTotal - ssModel;
            double kb = beta.get(beta.numberOfRows() - 1, beta.numberOfColumns() - 1);
            double kgk = G.get(G.numberOfRows() - 1, G.numberOfColumns() - 1);
            double F = kb * kb / kgk / ssError * dfError;
            double p = 1.0 - fdist.cumulativeProbability(F);
            return p;
        }).toArray();
        action.accept((double[])pvals);
        ++this.origin;
        return true;
    }
}

