/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.util.Arrays;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrix;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffect;

public class AddPlusDomModelEffect
implements ModelEffect {
    private AdditiveSite id;
    private final double[] addCovariate;
    private final double[] domCovariate;
    private final CovariateModelEffect addModelEffect;
    private final CovariateModelEffect domModelEffect;
    private final DoubleMatrix X;
    private final double delta = 1.0E-8;
    public static double MIN_HETS = 20.0;
    public static boolean IMPUTE_DOM = true;

    public AddPlusDomModelEffect(AdditiveSite id, AdditiveSite addSite) {
        this(id, addSite.getCovariate());
    }

    public AddPlusDomModelEffect(AdditiveSite id, double[] additiveCovariate) {
        this.id = id;
        this.addCovariate = additiveCovariate;
        double lower = 0.99999999;
        double upper = 1.00000001;
        this.domCovariate = IMPUTE_DOM ? Arrays.stream(this.addCovariate).map(add -> 1.0 - Math.abs(add - 1.0)).toArray() : Arrays.stream(this.addCovariate).map(add -> add > lower && add < upper ? 1.0 : 0.0).toArray();
        double domSum = Arrays.stream(this.domCovariate).sum();
        this.addModelEffect = new CovariateModelEffect(this.addCovariate, id);
        if (domSum >= MIN_HETS) {
            this.domModelEffect = new CovariateModelEffect(this.domCovariate, id);
            this.X = this.addModelEffect.getX().concatenate(this.domModelEffect.getX(), false);
        } else {
            this.domModelEffect = null;
            this.X = this.addModelEffect.getX();
        }
    }

    @Override
    public Object getID() {
        return this.id;
    }

    @Override
    public void setID(Object id) {
        this.id = (AdditiveSite)id;
    }

    @Override
    public int getSize() {
        return this.addCovariate.length;
    }

    @Override
    public DoubleMatrix getX() {
        return this.X;
    }

    @Override
    public DoubleMatrix getXtX() {
        return this.getX().crossproduct();
    }

    @Override
    public DoubleMatrix getXty(double[] y) {
        return this.getX().crossproduct(DoubleMatrixFactory.DEFAULT.make(y.length, 1, y));
    }

    @Override
    public DoubleMatrix getyhat(DoubleMatrix beta) {
        return this.getX().crossproduct(beta);
    }

    @Override
    public DoubleMatrix getyhat(double[] beta) {
        return this.getyhat(DoubleMatrixFactory.DEFAULT.make(1, beta.length, beta));
    }

    @Override
    public int[] getLevelCounts() {
        if (this.domModelEffect == null) {
            return new int[]{this.addCovariate.length};
        }
        return new int[]{this.addCovariate.length, this.domCovariate.length};
    }

    @Override
    public int getNumberOfLevels() {
        if (this.domModelEffect == null) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getEffectSize() {
        return this.getNumberOfLevels();
    }

    @Override
    public ModelEffect getCopy() {
        return new AddPlusDomModelEffect(this.id.copy(), Arrays.copyOf(this.addCovariate, this.addCovariate.length));
    }

    @Override
    public ModelEffect getSubSample(int[] sample) {
        double[] subsample = new double[sample.length];
        for (int i = 0; i < sample.length; ++i) {
            subsample[i] = this.addCovariate[sample[i]];
        }
        return new AddPlusDomModelEffect(this.id, subsample);
    }
}

