/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.maizegenetics.analysis.modelfitter.AbstractForwardRegression;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.analysis.modelfitter.ForwardStepAdditiveSpliterator;
import net.maizegenetics.analysis.modelfitter.ForwardStepSubsettingAdditiveSpliterator;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.stats.linearmodels.CovariateModelEffect;
import net.maizegenetics.stats.linearmodels.ModelEffect;
import net.maizegenetics.stats.linearmodels.SweepFastLinearModel;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.log4j.Logger;

public class AdditiveModelForwardRegression
extends AbstractForwardRegression {
    private static Logger myLogger = Logger.getLogger(AdditiveModelForwardRegression.class);
    double highestSS;
    int bestSite;
    int maxThreads;
    ForkJoinPool myPool = null;

    public AdditiveModelForwardRegression(GenotypePhenotype data, int maxThreads) {
        super(data);
        this.maxThreads = maxThreads;
        this.myPool = new ForkJoinPool(maxThreads);
    }

    public AdditiveModelForwardRegression(String serialFilename, Phenotype pheno, int maxThreads) {
        super(serialFilename, pheno);
        this.maxThreads = maxThreads;
        this.myPool = new ForkJoinPool(maxThreads);
    }

    public AdditiveModelForwardRegression(GenotypePhenotype data) {
        super(data);
        this.maxThreads = -1;
    }

    public AdditiveModelForwardRegression(String serialFilename, Phenotype pheno) {
        super(serialFilename, pheno);
        this.maxThreads = -1;
    }

    @Override
    public void fitModel() {
        int maxModelSize = this.myModel.size() + this.maxVariants;
        int step = 0;
        if (this.maxThreads > 0) {
            while (this.forwardStepParallelUseMaxThreads(true, step++) && this.myModel.size() < maxModelSize) {
            }
        } else {
            while (this.forwardStepParallel(true, step++) && this.myModel.size() < maxModelSize) {
            }
        }
    }

    @Override
    public void fitModelForSubsample(int[] subSample, int iteration) {
        this.myModel = this.myBaseModel.stream().map(me -> me.getSubSample(subSample)).collect(Collectors.toList());
        double[] original = this.y;
        this.y = Arrays.stream(subSample).mapToDouble(i -> original[i]).toArray();
        int maxModelSize = this.myModel.size() + this.maxVariants;
        int step = 0;
        if (this.maxThreads > 0) {
            while (this.forwardStepParallelUseMaxThreads(subSample, true, iteration, step++) && this.myModel.size() < maxModelSize) {
            }
        } else {
            while (this.forwardStepParallel(subSample, true, iteration, step++) && this.myModel.size() < maxModelSize) {
            }
        }
        this.y = original;
    }

    private boolean forwardStepParallel(boolean doParallel, int step) {
        double p;
        AdditiveSite bestSite = StreamSupport.stream(new ForwardStepAdditiveSpliterator(this.siteList, this.myModel, this.y), doParallel).max((a, b) -> a.compareTo(b)).get();
        CovariateModelEffect siteEffect = new CovariateModelEffect(bestSite.getCovariate());
        this.myModel.add(siteEffect);
        SweepFastLinearModel sflm = new SweepFastLinearModel(this.myModel, this.y);
        double[] errorSSdf = sflm.getResidualSSdf();
        double[] siteSSdf = sflm.getIncrementalSSdf(this.myModel.size() - 1);
        if (siteSSdf[1] < 1.0E-9 || errorSSdf[0] < 1.0E-9) {
            double F = Double.NaN;
            p = Double.NaN;
        } else {
            double F = siteSSdf[0] / siteSSdf[1] / errorSSdf[0] * errorSSdf[1];
            p = 1.0 - new FDistribution(siteSSdf[1], errorSSdf[1]).cumulativeProbability(F);
        }
        if (!Double.isNaN(p) && p <= this.enterLimit) {
            this.addVariant(bestSite, p, 0, step);
            return true;
        }
        return false;
    }

    private boolean forwardStepParallelUseMaxThreads(boolean doParallel, int step) {
        try {
            double p;
            AdditiveSite bestSite = (AdditiveSite)((ForkJoinTask)this.myPool.submit(() -> StreamSupport.stream(new ForwardStepAdditiveSpliterator(this.siteList, this.myModel, this.y), doParallel).max((a, b) -> a.compareTo(b)).get())).get();
            CovariateModelEffect siteEffect = new CovariateModelEffect(bestSite.getCovariate());
            this.myModel.add(siteEffect);
            SweepFastLinearModel sflm = new SweepFastLinearModel(this.myModel, this.y);
            double[] errorSSdf = sflm.getResidualSSdf();
            double[] siteSSdf = sflm.getIncrementalSSdf(this.myModel.size() - 1);
            if (siteSSdf[1] < 1.0E-9 || errorSSdf[0] < 1.0E-9) {
                double F = Double.NaN;
                p = Double.NaN;
            } else {
                double F = siteSSdf[0] / siteSSdf[1] / errorSSdf[0] * errorSSdf[1];
                p = 1.0 - new FDistribution(siteSSdf[1], errorSSdf[1]).cumulativeProbability(F);
            }
            if (!Double.isNaN(p) && p <= this.enterLimit) {
                this.addVariant(bestSite, p, 0, step);
                return true;
            }
            return false;
        }
        catch (InterruptedException | ExecutionException e) {
            myLogger.error((Object)"Thread execution failed in forwardStepParallelUseMaxThreads");
            e.printStackTrace();
            return false;
        }
    }

    private boolean forwardStepParallel(int[] subset, boolean doParallel, int iteration, int step) {
        double p;
        AdditiveSite bestSite = StreamSupport.stream(new ForwardStepSubsettingAdditiveSpliterator((List<AdditiveSite>)this.siteList, (List<ModelEffect>)this.myModel, this.y, subset), doParallel).max((a, b) -> a.compareTo(b)).get();
        CovariateModelEffect siteEffect = new CovariateModelEffect(bestSite.getCovariate(subset));
        this.myModel.add(siteEffect);
        SweepFastLinearModel sflm = new SweepFastLinearModel(this.myModel, this.y);
        double[] errorSSdf = sflm.getResidualSSdf();
        double[] siteSSdf = sflm.getIncrementalSSdf(this.myModel.size() - 1);
        if (siteSSdf[1] < 1.0E-9 || errorSSdf[0] < 1.0E-9) {
            double F = Double.NaN;
            p = Double.NaN;
        } else {
            double F = siteSSdf[0] / siteSSdf[1] / errorSSdf[0] * errorSSdf[1];
            p = 1.0 - new FDistribution(siteSSdf[1], errorSSdf[1]).cumulativeProbability(F);
        }
        if (!Double.isNaN(p) && p <= this.enterLimit) {
            this.addVariant(bestSite, p, iteration, step);
            return true;
        }
        return false;
    }

    private boolean forwardStepParallelUseMaxThreads(int[] subset, boolean doParallel, int iteration, int step) {
        try {
            double p;
            AdditiveSite bestSite = (AdditiveSite)((ForkJoinTask)this.myPool.submit(() -> StreamSupport.stream(new ForwardStepSubsettingAdditiveSpliterator((List<AdditiveSite>)this.siteList, (List<ModelEffect>)this.myModel, this.y, subset), doParallel).max((a, b) -> a.compareTo(b)).get())).get();
            CovariateModelEffect siteEffect = new CovariateModelEffect(bestSite.getCovariate(subset));
            this.myModel.add(siteEffect);
            SweepFastLinearModel sflm = new SweepFastLinearModel(this.myModel, this.y);
            double[] errorSSdf = sflm.getResidualSSdf();
            double[] siteSSdf = sflm.getIncrementalSSdf(this.myModel.size() - 1);
            if (siteSSdf[1] < 1.0E-9 || errorSSdf[0] < 1.0E-9) {
                double F = Double.NaN;
                p = Double.NaN;
            } else {
                double F = siteSSdf[0] / siteSSdf[1] / errorSSdf[0] * errorSSdf[1];
                p = 1.0 - new FDistribution(siteSSdf[1], errorSSdf[1]).cumulativeProbability(F);
            }
            if (!Double.isNaN(p) && p <= this.enterLimit) {
                this.addVariant(bestSite, p, iteration, step);
                return true;
            }
            return false;
        }
        catch (InterruptedException | ExecutionException e) {
            myLogger.error((Object)"Thread execution failed in forwardStepParallelUseMaxThreads");
            e.printStackTrace();
            return false;
        }
    }

    protected void finalize() throws Throwable {
        if (this.myPool != null) {
            this.myPool.shutdown();
        }
        super.finalize();
    }
}

