/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.util.Arrays;
import java.util.List;
import net.maizegenetics.analysis.modelfitter.AbstractAdditiveSite;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;

public class RefProbAdditiveSite
extends AbstractAdditiveSite {
    private static final long serialVersionUID = 2040665024409852166L;
    private int ntaxa;
    private float[] cov;
    private int[] taxaIndex = null;

    public RefProbAdditiveSite(int site, String chr, int pos, String id, AdditiveSite.CRITERION selectionCriteria, float[] covariate) {
        super(site, chr, pos, id, selectionCriteria);
        this.cov = covariate;
        this.ntaxa = this.cov.length;
    }

    @Override
    public double[] getCovariate() {
        double[] dcov = new double[this.ntaxa];
        if (this.taxaIndex == null) {
            for (int i = 0; i < this.ntaxa; ++i) {
                dcov[i] = this.cov[i];
            }
            return dcov;
        }
        for (int i = 0; i < this.ntaxa; ++i) {
            dcov[i] = this.cov[this.taxaIndex[i]];
        }
        return dcov;
    }

    @Override
    public double[] getCovariate(int[] subset) {
        if (this.taxaIndex == null) {
            return Arrays.stream(subset).mapToDouble(i -> this.cov[i]).toArray();
        }
        return Arrays.stream(subset).mapToDouble(i -> this.cov[this.taxaIndex[i]]).toArray();
    }

    @Override
    public void reindexTaxa(int[] taxaIndex, List<Integer> uniqueTaxa) {
        this.taxaIndex = taxaIndex;
    }

    @Override
    public AdditiveSite copy() {
        return new RefProbAdditiveSite(this.siteIndex, this.chrName, this.position, this.name, this.selectionCriterion, Arrays.copyOf(this.cov, this.cov.length));
    }
}

