/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.modelfitter;

import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.modelfitter.AddPlusDomModelEffect;
import net.maizegenetics.analysis.modelfitter.AdditiveSite;
import net.maizegenetics.analysis.modelfitter.StepwiseAddDomModelFitter;
import net.maizegenetics.analysis.modelfitter.StepwiseAdditiveModelFitter;
import net.maizegenetics.analysis.modelfitter.StepwiseOLSModelFitterPlugin;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.matrixalgebra.Matrix.DoubleMatrixFactory;
import net.maizegenetics.phenotype.GenotypePhenotype;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeUtils;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.TableReport;
import net.maizegenetics.util.TableReportUtils;
import org.apache.log4j.Logger;

public class StepwiseAdditiveModelFitterPlugin
extends AbstractPlugin {
    private static Logger myLogger = Logger.getLogger(StepwiseAdditiveModelFitterPlugin.class);
    private List<String> myFactorNameList;
    private GenotypePhenotype myGenoPheno;
    private String datasetName;
    private PluginParameter<AdditiveSite.CRITERION> modelCriterion = new PluginParameter.Builder<AdditiveSite.CRITERION>("criterion", AdditiveSite.CRITERION.pval, AdditiveSite.CRITERION.class).range((Comparable<T>[])AdditiveSite.CRITERION.values()).guiName("Model selection criterion").description("The model selection criterion used to determine which terms enter the model and how many. Value must be one of pval, bic, mbic, or aic").build();
    private PluginParameter<Boolean> useResiduals = new PluginParameter.Builder<Boolean>("useResidual", false, Boolean.class).description("Should the each new term be tested using residuals from the previous model instead of fitting a complete model each time?").guiName("Fit using residuals").build();
    private PluginParameter<Boolean> usePermutations = new PluginParameter.Builder<Boolean>("usePerm", true, Boolean.class).description("Should permutations be used to set the enter and exit limits for stepwise regression? A permutation test will be used to determine the enter limit. The exit limit will be set to 2 times the enter limit.").guiName("Use permutations").build();
    private PluginParameter<Integer> numberOfPermutations = new PluginParameter.Builder<Integer>("nPerm", 1000, Integer.class).description("The number of permutations used to determine the enter limit.").guiName("Number of permutations").dependentOnParameter(this.usePermutations).build();
    private PluginParameter<Double> permutationAlpha = new PluginParameter.Builder<Double>("permAlpha", 0.05, Double.class).description("Type I errors will be controlled at this level.").guiName("Alpha for permutations").dependentOnParameter(this.usePermutations).build();
    private PluginParameter<Double> enterLimit = new PluginParameter.Builder<Double>("enterLimit", 1.0E-5, Double.class).description("When p-value is the model selection criteria, model fitting will stop when the next term chosen has a p-value greater than the enterLimit. This value will be over-ridden the permutation test, if used.").guiName("enterLimit").dependentOnParameter(this.usePermutations, false).build();
    private PluginParameter<Double> exitLimit = new PluginParameter.Builder<Double>("exitLimit", 2.0E-5, Double.class).description("During the backward step of model fitting if p-value has been chosen as the selection criterion, if the term in model with the highest p-value has a p-value > exitLimit, it will be removed from the model.").guiName("exitLimit").dependentOnParameter(this.usePermutations, false).build();
    private PluginParameter<Integer> maxTerms = new PluginParameter.Builder<Integer>("maxterms", 1000, Integer.class).description("The maximum number of SNPs/markers that will be fit. If the model selection criterion is met first, then the fitting process will stop at that point.").guiName("Max SNPs/markers").build();
    private PluginParameter<Boolean> isNested = new PluginParameter.Builder<Boolean>("isNested", true, Boolean.class).description("Should SNPs/markers be nested within a factor, such as family?").guiName("").build();
    private PluginParameter<String> nestingFactor = new PluginParameter.Builder<String>("nestFactor", null, String.class).guiName("Nesting factor").description("Nest markers within this factor. This parameter cannot be set from the command line. Instead, the first factor in the data set will be used.").dependentOnParameter(this.isNested).objectListSingleSelect().build();
    private PluginParameter<GenotypeTable.GENOTYPE_TABLE_COMPONENT> myGenotypeTable = new PluginParameter.Builder<GenotypeTable.GENOTYPE_TABLE_COMPONENT>("genotypeComponent", GenotypeTable.GENOTYPE_TABLE_COMPONENT.Genotype, GenotypeTable.GENOTYPE_TABLE_COMPONENT.class).genotypeTable().range((Comparable<T>[])GenotypeTable.GENOTYPE_TABLE_COMPONENT.values()).description("If the genotype table contains more than one type of genotype data, choose the type to use for the analysis.").build();
    private PluginParameter<Boolean> createAnova = new PluginParameter.Builder<Boolean>("anova", true, Boolean.class).description("Create pre- and post-scan anova reports.").guiName("Create anova reports").build();
    private PluginParameter<Boolean> createEffects = new PluginParameter.Builder<Boolean>("effects", true, Boolean.class).description("Create a report of marker effects based on the scan results.").guiName("Create effects report").build();
    private PluginParameter<Boolean> createEffectsPrescan = new PluginParameter.Builder<Boolean>("effectsPrescan", false, Boolean.class).description("Create a report of marker effects based on the results pre-scan.").guiName("Create prescan effects").build();
    private PluginParameter<Boolean> createStep = new PluginParameter.Builder<Boolean>("step", true, Boolean.class).description("Create a report of the which markers enter and leave the model as it is being fit.").guiName("Create step report").build();
    private PluginParameter<Boolean> createResiduals = new PluginParameter.Builder<Boolean>("residuals", false, Boolean.class).description("Create a phenotype dataset of model residuals for each chromosome. For each chromosome, the residuals will be calculated from a model with all terms EXCEPT the markers on that chromosome.").guiName("Create residuals").build();
    private PluginParameter<Boolean> writeFiles = new PluginParameter.Builder<Boolean>("saveToFile", false, Boolean.class).description("Should the requested output be written to files?").guiName("Write to files").build();
    private PluginParameter<String> outputName = new PluginParameter.Builder<String>("savePath", "", String.class).description("The base file path for the save files. Each file saved will add a descriptive name to the base name.").guiName("Base file path").outFile().dependentOnParameter(this.writeFiles).build();
    private PluginParameter<Boolean> fitAddDom = new PluginParameter.Builder<Boolean>("addDom", false, Boolean.class).description("Should the plugin fit an additive plus dominance model? If false, an additive only model will be fit. Note this option does not implement a nested model. The isNested parameter will be ignored.").guiName("Fit AddDom Model").build();
    private PluginParameter<Integer> minHets = new PluginParameter.Builder<Integer>("minHets", 20, Integer.class).dependentOnParameter(this.fitAddDom).description("The minimum number of individuals that are heterozygous at a site for the dominance term to be included. If the number of hets is less than minHets at a site, an additive only model will be fit for that site.").guiName("Minimum number of heterozygotes").build();
    private PluginParameter<Boolean> imputedDominance = new PluginParameter.Builder<Boolean>("imputeDom", true, Boolean.class).description("Should the plugin impute a value for dominance if data is missing. If false, the dominance score in the design matrix will be 0 for missing genotypes.").guiName("Impute Dominance Score").build();

    public StepwiseAdditiveModelFitterPlugin() {
        super(null, false);
    }

    public StepwiseAdditiveModelFitterPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public String pluginDescription() {
        return "A stepwise model fitter designed to select variants tested for association with a large number of nucleotide variants. It can be multi-threaded to handle large number of variants efficiently. It can fit an additive only model or an additive + dominance model.";
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        DoubleMatrixFactory.setDefault(DoubleMatrixFactory.FactoryType.ejml);
        List<Datum> datumList = input.getDataOfType(GenotypePhenotype.class);
        if (datumList.size() != 1) {
            throw new IllegalArgumentException("Choose exactly one dataset that has combined genotype and phenotype data.");
        }
        this.myGenoPheno = (GenotypePhenotype)datumList.get(0).getData();
        this.datasetName = datumList.get(0).getName();
        this.myFactorNameList = this.myGenoPheno.phenotype().attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor).stream().map(pa -> pa.name()).collect(Collectors.toList());
        if (this.myFactorNameList.isEmpty()) {
            this.myFactorNameList.add("None");
        }
        this.nestingFactor = new PluginParameter<String>(this.nestingFactor, this.myFactorNameList);
    }

    @Override
    protected void postProcessParameters() {
        if (this.isNested.value().booleanValue() && this.myFactorNameList.size() > 1 && this.nestingFactor.value().isEmpty()) {
            throw new IllegalArgumentException("Is Nested was checked but no nesting factor was selected.");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        String filename;
        TableReport output;
        String comment;
        String name;
        StepwiseAdditiveModelFitter stamFitter;
        if (this.fitAddDom.value().booleanValue()) {
            stamFitter = new StepwiseAddDomModelFitter(this.myGenoPheno, this.datasetName);
            AddPlusDomModelEffect.MIN_HETS = this.minHets.value().intValue();
            AddPlusDomModelEffect.IMPUTE_DOM = this.imputedDominance.value();
        } else {
            stamFitter = new StepwiseAdditiveModelFitter(this.myGenoPheno, this.datasetName);
        }
        if (this.usePermutations.value().booleanValue()) {
            stamFitter.numberOfPermutations(this.numberOfPermutations.value());
            stamFitter.permutationAlpha(this.permutationAlpha.value());
        } else {
            stamFitter.enterLimit(this.enterLimit.value());
            stamFitter.exitLimit(this.exitLimit.value());
        }
        if (this.myGenotypeTable.value() == GenotypeTable.GENOTYPE_TABLE_COMPONENT.ReferenceProbability) {
            stamFitter.useReferenceProbability(true);
        } else if (!this.myGenoPheno.genotypeTable().hasGenotype() && this.myGenoPheno.genotypeTable().hasReferenceProbablity()) {
            stamFitter.useReferenceProbability(true);
        } else {
            stamFitter.useReferenceProbability(false);
        }
        if (this.isNested.value().booleanValue()) {
            if (this.isInteractive()) {
                String nestingList = this.nestingFactor.value();
                if (nestingList.isEmpty()) {
                    if (this.myFactorNameList.get(0).equals("None")) {
                        stamFitter.isNested(false);
                    } else {
                        stamFitter.isNested(true);
                        stamFitter.nestingEffectName(nestingList);
                    }
                } else {
                    String factorName = nestingList;
                    if (factorName.equals("None")) {
                        stamFitter.isNested(false);
                    } else {
                        stamFitter.isNested(true);
                        stamFitter.nestingEffectName(factorName);
                    }
                }
            } else {
                List<PhenotypeAttribute> factorList = this.myGenoPheno.phenotype().attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor);
                if (factorList.isEmpty()) {
                    stamFitter.isNested(false);
                } else {
                    stamFitter.isNested(true);
                    stamFitter.nestingEffectName(factorList.get(0).name());
                }
            }
        } else {
            stamFitter.isNested(false);
        }
        stamFitter.enterLimit(this.enterLimit.value());
        stamFitter.exitLimit(this.exitLimit.value());
        stamFitter.maxSitesInModel(this.maxTerms.value());
        stamFitter.modelSelectionCriterion(this.modelCriterion.value());
        stamFitter.createAnovaReport(this.createAnova.value());
        stamFitter.createPostScanEffectsReport(this.createEffects.value());
        stamFitter.createPreScanEffectsReport(this.createEffectsPrescan.value());
        stamFitter.createResidualsByChr(this.createResiduals.value());
        stamFitter.createStepReport(this.createStep.value());
        long start = System.nanoTime();
        stamFitter.runAnalysis();
        myLogger.debug((Object)String.format("ran analysis in %d ms.", (System.nanoTime() - start) / 1000000L));
        ArrayList<Datum> resultData = new ArrayList<Datum>();
        if (this.createStep.value().booleanValue()) {
            name = "Steps_" + this.datasetName;
            comment = "Stepwise regression results:\nModel fitting steps\n";
            output = stamFitter.getSteps();
            resultData.add(new Datum(name, output, comment));
            if (this.writeFiles.value().booleanValue()) {
                filename = this.outputName.value() + "_steps.txt";
                TableReportUtils.saveDelimitedTableReport(output, new File(filename));
            }
        }
        if (this.createAnova.value().booleanValue()) {
            TableReport output1 = stamFitter.getAnovaReport();
            String name2 = "Prescan_anova_" + this.datasetName;
            String comment2 = "Stepwise regression results:\nAnova for the initial model prior to rescanning\n";
            resultData.add(new Datum(name2, output1, comment2));
            TableReport output2 = stamFitter.getAnovaReportWithCI();
            name2 = "Anova_" + this.datasetName;
            comment2 = "Stepwise regression results:\nAnova for the final model with support intervals\n";
            resultData.add(new Datum(name2, output2, comment2));
            if (this.writeFiles.value().booleanValue()) {
                String filename2 = this.outputName.value() + "_prescan_anova.txt";
                TableReportUtils.saveDelimitedTableReport(output1, new File(filename2));
                filename2 = this.outputName.value() + "_anova.txt";
                TableReportUtils.saveDelimitedTableReport(output2, new File(filename2));
            }
        }
        if (this.createEffectsPrescan.value().booleanValue()) {
            name = "Prescan_effects_" + this.datasetName;
            comment = "Stepwise regression results:\nMarker effects estimated from the initial model before rescanning\n";
            output = stamFitter.getMarkerEffectReport();
            resultData.add(new Datum(name, output, comment));
            if (this.writeFiles.value().booleanValue()) {
                filename = this.outputName.value() + "_prescan_effects.txt";
                TableReportUtils.saveDelimitedTableReport(output, new File(filename));
            }
        }
        if (this.createEffects.value().booleanValue()) {
            name = "Effects_regression_" + this.datasetName;
            comment = "Stepwise regression results:\nMarker effects estimated from the final model\n";
            output = stamFitter.getMarkerEffectReportWithCI();
            resultData.add(new Datum(name, output, comment));
            if (this.writeFiles.value().booleanValue()) {
                filename = this.outputName.value() + "_effects.txt";
                TableReportUtils.saveDelimitedTableReport(output, new File(filename));
            }
        }
        if (this.createResiduals.value().booleanValue()) {
            List<Phenotype> phenoList = stamFitter.getResidualPhenotypesByChromosome();
            phenoList.stream().forEach(pheno -> {
                String traitname = pheno.attributeName(pheno.numberOfAttributes() - 1);
                String name = "Residuals_" + traitname + "_" + this.datasetName;
                String comment = "Stepwise regression results:\nResiduals for " + traitname + "\n";
                resultData.add(new Datum(name, pheno, comment));
            });
            if (this.writeFiles.value().booleanValue()) {
                phenoList.stream().forEach(pheno -> {
                    String traitname = pheno.attributeName(pheno.numberOfAttributes() - 1);
                    String filename = this.outputName.value() + "_" + traitname + ".txt";
                    PhenotypeUtils.write(pheno, filename);
                });
            }
        }
        return new DataSet(resultData, (Plugin)this);
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = StepwiseOLSModelFitterPlugin.class.getResource("stepwise.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Stepwise-Multithread";
    }

    @Override
    public String getToolTipText() {
        return "Fit a model using stepwise forward-backward regression.";
    }

    public AdditiveSite.CRITERION modelCriterion() {
        return this.modelCriterion.value();
    }

    public StepwiseAdditiveModelFitterPlugin modelCriterion(AdditiveSite.CRITERION value) {
        this.modelCriterion = new PluginParameter<AdditiveSite.CRITERION>(this.modelCriterion, value);
        return this;
    }

    public Boolean useResiduals() {
        return this.useResiduals.value();
    }

    public StepwiseAdditiveModelFitterPlugin useResiduals(Boolean value) {
        this.useResiduals = new PluginParameter<Boolean>(this.useResiduals, value);
        return this;
    }

    public Boolean usePermutations() {
        return this.usePermutations.value();
    }

    public StepwiseAdditiveModelFitterPlugin usePermutations(Boolean value) {
        this.usePermutations = new PluginParameter<Boolean>(this.usePermutations, value);
        return this;
    }

    public Integer numberOfPermutations() {
        return this.numberOfPermutations.value();
    }

    public StepwiseAdditiveModelFitterPlugin numberOfPermutations(Integer value) {
        this.numberOfPermutations = new PluginParameter<Integer>(this.numberOfPermutations, value);
        return this;
    }

    public Double permutationAlpha() {
        return this.permutationAlpha.value();
    }

    public StepwiseAdditiveModelFitterPlugin permutationAlpha(Double value) {
        this.permutationAlpha = new PluginParameter<Double>(this.permutationAlpha, value);
        return this;
    }

    public Double enterLimit() {
        return this.enterLimit.value();
    }

    public StepwiseAdditiveModelFitterPlugin enterLimit(Double value) {
        this.enterLimit = new PluginParameter<Double>(this.enterLimit, value);
        return this;
    }

    public Double exitLimit() {
        return this.exitLimit.value();
    }

    public StepwiseAdditiveModelFitterPlugin exitLimit(Double value) {
        this.exitLimit = new PluginParameter<Double>(this.exitLimit, value);
        return this;
    }

    public Integer maxTerms() {
        return this.maxTerms.value();
    }

    public StepwiseAdditiveModelFitterPlugin maxTerms(Integer value) {
        this.maxTerms = new PluginParameter<Integer>(this.maxTerms, value);
        return this;
    }

    public Boolean isNested() {
        return this.isNested.value();
    }

    public StepwiseAdditiveModelFitterPlugin isNested(Boolean value) {
        this.isNested = new PluginParameter<Boolean>(this.isNested, value);
        return this;
    }

    public String nestingFactor() {
        return this.nestingFactor.value();
    }

    public StepwiseAdditiveModelFitterPlugin nestingFactor(List<String> value) {
        this.nestingFactor = new PluginParameter<String>(this.nestingFactor, value);
        return this;
    }

    public GenotypeTable.GENOTYPE_TABLE_COMPONENT genotypeTable() {
        return this.myGenotypeTable.value();
    }

    public StepwiseAdditiveModelFitterPlugin genotypeTable(GenotypeTable.GENOTYPE_TABLE_COMPONENT value) {
        this.myGenotypeTable = new PluginParameter<GenotypeTable.GENOTYPE_TABLE_COMPONENT>(this.myGenotypeTable, value);
        return this;
    }

    public Boolean createAnova() {
        return this.createAnova.value();
    }

    public StepwiseAdditiveModelFitterPlugin createAnova(Boolean value) {
        this.createAnova = new PluginParameter<Boolean>(this.createAnova, value);
        return this;
    }

    public Boolean createEffects() {
        return this.createEffects.value();
    }

    public StepwiseAdditiveModelFitterPlugin createEffects(Boolean value) {
        this.createEffects = new PluginParameter<Boolean>(this.createEffects, value);
        return this;
    }

    public Boolean createEffectsPrescan() {
        return this.createEffectsPrescan.value();
    }

    public StepwiseAdditiveModelFitterPlugin createEffectsPrescan(Boolean value) {
        this.createEffectsPrescan = new PluginParameter<Boolean>(this.createEffectsPrescan, value);
        return this;
    }

    public Boolean createStep() {
        return this.createStep.value();
    }

    public StepwiseAdditiveModelFitterPlugin createStep(Boolean value) {
        this.createStep = new PluginParameter<Boolean>(this.createStep, value);
        return this;
    }

    public Boolean createResiduals() {
        return this.createResiduals.value();
    }

    public StepwiseAdditiveModelFitterPlugin createResiduals(Boolean value) {
        this.createResiduals = new PluginParameter<Boolean>(this.createResiduals, value);
        return this;
    }

    public Boolean writeFiles() {
        return this.writeFiles.value();
    }

    public StepwiseAdditiveModelFitterPlugin writeFiles(Boolean value) {
        this.writeFiles = new PluginParameter<Boolean>(this.writeFiles, value);
        return this;
    }

    public String outputName() {
        return this.outputName.value();
    }

    public StepwiseAdditiveModelFitterPlugin outputName(String value) {
        this.outputName = new PluginParameter<String>(this.outputName, value);
        return this;
    }

    public Boolean fitAddDom() {
        return this.fitAddDom.value();
    }

    public StepwiseAdditiveModelFitterPlugin fitAddDom(Boolean value) {
        this.fitAddDom = new PluginParameter<Boolean>(this.fitAddDom, value);
        return this;
    }

    public Integer minHets() {
        return this.minHets.value();
    }

    public StepwiseAdditiveModelFitterPlugin minHets(Integer value) {
        this.minHets = new PluginParameter<Integer>(this.minHets, value);
        return this;
    }

    public Boolean imputedDominance() {
        return this.imputedDominance.value();
    }

    public StepwiseAdditiveModelFitterPlugin imputedDominance(Boolean value) {
        this.imputedDominance = new PluginParameter<Boolean>(this.imputedDominance, value);
        return this;
    }
}

