/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.monetdb;

import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;

public class ColumnsToBinaryUtils {
    public static String refAlleleFromChromPos(byte[] refChromBytes, int allelePos) {
        byte[] oneAllele = new byte[]{refChromBytes[allelePos - 1]};
        return NucleotideAlignmentConstants.nucleotideBytetoString(oneAllele);
    }

    public static int getIntFromSeq(String seq) {
        int chunkSize = 16;
        int seqLength = seq.length();
        int v = 0;
        block8: for (int i = 0; i < seqLength; ++i) {
            switch (seq.charAt(i)) {
                case 'A': 
                case 'a': {
                    v <<= 2;
                    continue block8;
                }
                case 'C': 
                case 'c': {
                    v = (v << 2) + 1;
                    continue block8;
                }
                case 'G': 
                case 'g': {
                    v = (v << 2) + 2;
                    continue block8;
                }
                case 'T': 
                case 't': {
                    v = (v << 2) + 3;
                    continue block8;
                }
                case '+': {
                    v = (v << 2) + 4;
                    continue block8;
                }
                case '-': {
                    v = (v << 2) + 5;
                    continue block8;
                }
                default: {
                    return -1;
                }
            }
        }
        if (seqLength == chunkSize) {
            return v;
        }
        if (seqLength > chunkSize) {
            return -1;
        }
        return v;
    }
}

