/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.monetdb;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LittleEndianDataOutputStream
extends FilterOutputStream {
    public LittleEndianDataOutputStream(OutputStream out) {
        super(out);
    }

    public void writeByte(byte value) throws IOException {
        this.out.write(value);
    }

    public void writeShort(short value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putShort(value);
        this.out.write(buffer.array());
    }

    public void writeInt(int value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(value);
        this.out.write(buffer.array());
    }

    public void writeFloat(float value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putFloat(value);
        this.out.write(buffer.array());
    }

    public void writeLong(long value) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(value);
        this.out.write(buffer.array());
    }

    public void writeChars(byte[] data) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(data.length).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(data);
        this.out.write(buffer.array());
    }
}

