/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.stream.Collectors;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeUtils;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class AvgPhenotype {
    public Phenotype averagePheno(Phenotype pheno, boolean addSmallValue, long randomSeed) throws Exception {
        ArrayList attributes = (ArrayList)pheno.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data);
        attributes.addAll((ArrayList)pheno.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate));
        ArrayList phenoNames = (ArrayList)attributes.stream().map(phenoAttr -> phenoAttr.name()).collect(Collectors.toList());
        ArrayList taxonList = (ArrayList)pheno.taxaAttribute().allTaxaAsList();
        ArrayList uniqueTaxaNames = (ArrayList)pheno.taxaAttribute().allTaxaAsList().stream().map(taxon -> taxon.getName()).distinct().collect(Collectors.toList());
        HashMap rowMapByTaxa = new HashMap();
        for (String taxaName : uniqueTaxaNames) {
            ArrayList list = new ArrayList();
            rowMapByTaxa.put(taxaName, list);
        }
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < taxonList.size(); ++i) {
            ArrayList<Double> currentRow = new ArrayList<Double>();
            for (String varName : phenoNames) {
                currentRow.add(((Float)pheno.value(i, pheno.attributeIndexForName(varName))).doubleValue());
                if (!(((Float)pheno.value(i, pheno.attributeIndexForName(varName))).doubleValue() < minValue) || !(((Float)pheno.value(i, pheno.attributeIndexForName(varName))).doubleValue() > 0.0)) continue;
                minValue = ((Float)pheno.value(i, pheno.attributeIndexForName(varName))).doubleValue();
            }
            ((ArrayList)rowMapByTaxa.get(taxonList.get(i))).add(currentRow);
        }
        Random rand = new Random(randomSeed);
        ArrayList<ArrayList<Double>> avgValues = new ArrayList<ArrayList<Double>>();
        for (String taxaName : uniqueTaxaNames) {
            ArrayList currentValues = (ArrayList)rowMapByTaxa.get(taxaName);
            ArrayList<Double> currentAverages = new ArrayList<Double>();
            for (int col = 0; col < ((ArrayList)currentValues.get(0)).size(); ++col) {
                double[] values = new double[currentValues.size()];
                Mean meanObj = new Mean();
                for (int row = 0; row < currentValues.size(); ++row) {
                    values[row] = (Double)((ArrayList)currentValues.get(row)).get(col);
                    if (!addSmallValue) continue;
                    values[row] = values[row] + rand.nextDouble() * 0.5 * minValue;
                }
                currentAverages.add(meanObj.evaluate(values));
            }
            avgValues.add(currentAverages);
        }
        ArrayList<Phenotype.ATTRIBUTE_TYPE> originalTypes = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        for (int i = 0; i < pheno.attributeListCopy().size(); ++i) {
            originalTypes.add(pheno.attributeType(i));
        }
        return PhenotypeUtils.createPhenotypeFromTransform(uniqueTaxaNames, phenoNames, avgValues, pheno.name() + "_AveragedByTaxa", originalTypes);
    }
}

