/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.awt.Frame;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.numericaltransform.AvgPhenotype;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;

public class AvgPhenotypeByTaxaPlugin
extends AbstractPlugin {
    private PluginParameter<Boolean> addSmallValue = new PluginParameter.Builder<Boolean>("addSmallValue", false, Boolean.class).description("Boolean to allow for a small random value to be added to each observed value. The value is calculated by the following:\nrand(0:1) * .5 * minObservedValue").build();
    private PluginParameter<Long> randomSeed = new PluginParameter.Builder<Long>("randomSeed", 12345L, Long.class).description("Random Seed to be used in the Random Small Number Generation").dependentOnParameter(this.addSmallValue).build();

    public AvgPhenotypeByTaxaPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public DataSet processData(DataSet input) {
        List<Datum> datumList = input.getDataOfType(Phenotype.class);
        if (datumList.size() != 1) {
            throw new IllegalArgumentException("AvgPhenotypeByTaxaPlugin: select exactly one phenotype dataset to average.");
        }
        AvgPhenotype avgPheno = new AvgPhenotype();
        try {
            Phenotype myPhenotype = avgPheno.averagePheno((Phenotype)datumList.get(0).getData(), this.addSmallValue.value(), this.randomSeed.value());
            if (myPhenotype != null) {
                String name = myPhenotype.name();
                Datum td = new Datum(name, myPhenotype, null);
                DataSet tds = new DataSet(td, (Plugin)this);
                return tds;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Average Phenotypes By Taxa";
    }

    @Override
    public String getToolTipText() {
        return "Averages Phenotypes for Duplicate Taxa.";
    }

    @Override
    public String getCitation() {
        return "Bradbury PJ, Zhang Z, Kroon DE, Casstevens TM, Ramdoss Y, Buckler ES. (2007) TASSEL: Software for association mapping of complex traits in diverse samples. Bioinformatics 23:2633\u00ad2635.";
    }

    @Override
    public String pluginUserManualURL() {
        return "https://bitbucket.org/tasseladmin/tassel\u00ad5\u00adsource/wiki/UserManual/Kinship/Kinship";
    }

    public Phenotype runPlugin(DataSet input) {
        return (Phenotype)this.performFunction(input).getData(0).getData();
    }

    public Boolean addSmallValue() {
        return this.addSmallValue.value();
    }

    public AvgPhenotypeByTaxaPlugin addSmallValue(Boolean value) {
        this.addSmallValue = new PluginParameter<Boolean>(this.addSmallValue, value);
        return this;
    }

    public Long randomSeed() {
        return this.randomSeed.value();
    }

    public AvgPhenotypeByTaxaPlugin randomSeed(Long value) {
        this.randomSeed = new PluginParameter<Long>(this.randomSeed, value);
        return this;
    }
}

