/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.numericaltransform.ImputationByMean;
import net.maizegenetics.analysis.numericaltransform.kNearestNeighbors;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.score.ReferenceProbabilityBuilder;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.util.OpenBitSet;
import org.apache.log4j.Logger;

public class ImputationPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(ImputationPlugin.class);
    private PluginParameter<Boolean> byMean = new PluginParameter.Builder<Boolean>("ByMean", false, Boolean.class).guiName("Imputation by mean").description("If imputation is performed by computing mean of the respective column").build();
    private PluginParameter<Integer> nearestNeighbors = new PluginParameter.Builder<Integer>("nearestNeighbors", 5, Integer.class).guiName("Number of nearest neighbors to be evaluated").description("Choice of k in k-nearest neighbors algorithm. Default is 5.").build();
    private PluginParameter<distanceChoice> distance = new PluginParameter.Builder<distanceChoice>("distance", distanceChoice.Euclidean, distanceChoice.class).guiName("Choose Distance type").description("Distance choice for computing nearest neighbors. Default choice is Euclidean distance.").build();

    public ImputationPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    protected void preProcessParameters(DataSet input) {
        if (input == null || input.getSize() != 1) {
            throw new IllegalArgumentException("ImputationPlugin: preProcessParameters: Please select one Genotype Table or Phenotype.");
        }
        List<Datum> data = input.getDataOfType(new Class[]{GenotypeTable.class, Phenotype.class});
        if (data.size() != 1) {
            throw new IllegalArgumentException("ImputationPlugin: preProcessParameters: Please select one Genotype Table or Phenotype.");
        }
    }

    @Override
    public DataSet processData(DataSet input) {
        double[][] result;
        double[][] data;
        List<Datum> datumList = input.getDataOfType(GenotypeTable.class);
        if (datumList.size() != 1) {
            int i;
            double[][] result2;
            datumList = input.getDataOfType(Phenotype.class);
            if (datumList.size() != 1) {
                throw new IllegalArgumentException("ImputationPlugin: Input must me a genotype table or phenotype.");
            }
            Phenotype myPhenotype = (Phenotype)datumList.get(0).getData();
            int[] dataAttrIndices = myPhenotype.attributeIndicesOfType(Phenotype.ATTRIBUTE_TYPE.data);
            int dataAttributes = dataAttrIndices.length;
            int dataObservations = myPhenotype.numberOfObservations();
            double[][] data2 = new double[dataObservations][dataAttributes];
            for (int s = 0; s < dataObservations; ++s) {
                for (int t = 0; t < dataAttributes; ++t) {
                    data2[s][t] = !myPhenotype.isMissing(s, dataAttrIndices[t]) ? (double)((Float)myPhenotype.value(s, dataAttrIndices[t])).floatValue() : Double.NaN;
                }
            }
            Boolean imputationByMean = this.by_mean();
            if (imputationByMean.booleanValue()) {
                result2 = ImputationByMean.impute(data2);
            } else {
                boolean isManhattan = false;
                boolean isCosine = false;
                distanceChoice alpha = this.distance_choice();
                if (alpha == distanceChoice.Manhattan) {
                    isManhattan = true;
                }
                if (alpha == distanceChoice.Cosine) {
                    isCosine = true;
                }
                Integer Nbrs = this.nearest_neighbors();
                result2 = kNearestNeighbors.impute(data2, Nbrs, isManhattan, isCosine);
            }
            ArrayList<PhenotypeAttribute> attributes = new ArrayList<PhenotypeAttribute>();
            ArrayList<Phenotype.ATTRIBUTE_TYPE> types = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
            attributes.add(myPhenotype.taxaAttribute());
            types.add(Phenotype.ATTRIBUTE_TYPE.taxa);
            attributes.addAll(myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.factor));
            for (i = 0; i < myPhenotype.numberOfAttributesOfType(Phenotype.ATTRIBUTE_TYPE.factor); ++i) {
                types.add(Phenotype.ATTRIBUTE_TYPE.factor);
            }
            attributes.addAll(myPhenotype.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate));
            for (i = 0; i < myPhenotype.numberOfAttributesOfType(Phenotype.ATTRIBUTE_TYPE.covariate); ++i) {
                types.add(Phenotype.ATTRIBUTE_TYPE.covariate);
            }
            for (i = 0; i < dataAttributes; ++i) {
                float[] attrData = new float[dataObservations];
                for (int j = 0; j < dataObservations; ++j) {
                    attrData[j] = (float)result2[j][i];
                }
                PhenotypeAttribute oldAttribute = myPhenotype.attribute(dataAttrIndices[i]);
                NumericAttribute myAttribute = new NumericAttribute(oldAttribute.name(), attrData, new OpenBitSet(dataObservations));
                attributes.add(myAttribute);
                types.add(Phenotype.ATTRIBUTE_TYPE.data);
            }
            Phenotype imputedPhenotype = new PhenotypeBuilder().fromAttributeList(attributes, types).build().get(0);
            StringBuilder nameBuilder = new StringBuilder("Imputed_");
            nameBuilder.append(datumList.get(0).getName());
            StringBuilder commentBuilder = new StringBuilder(this.getMethodString());
            commentBuilder.append("\nfrom ").append(datumList.get(0).getName());
            Datum newDatum = new Datum(nameBuilder.toString(), imputedPhenotype, commentBuilder.toString());
            return new DataSet(newDatum, (Plugin)this);
        }
        GenotypeTable myGenotype = (GenotypeTable)datumList.get(0).getData();
        int nsites = myGenotype.numberOfSites();
        int ntaxa = myGenotype.numberOfTaxa();
        if (!myGenotype.hasReferenceProbablity()) {
            data = GenotypeTableUtils.convertGenotypeToDoubleProbability(myGenotype, true);
        } else {
            data = new double[nsites][ntaxa];
            for (int s = 0; s < nsites; ++s) {
                for (int t = 0; t < ntaxa; ++t) {
                    data[s][t] = myGenotype.referenceProbability(t, s);
                }
            }
        }
        Boolean imputationByMean = this.by_mean();
        if (imputationByMean.booleanValue()) {
            result = ImputationByMean.impute(data);
        } else {
            boolean isManhattan = false;
            boolean isCosine = false;
            distanceChoice alpha = this.distance_choice();
            if (alpha == distanceChoice.Manhattan) {
                isManhattan = true;
            }
            if (alpha == distanceChoice.Cosine) {
                isCosine = true;
            }
            Integer Nbrs = this.nearest_neighbors();
            result = kNearestNeighbors.impute(data, Nbrs, isManhattan, isCosine);
        }
        ReferenceProbabilityBuilder refBuilder = ReferenceProbabilityBuilder.getInstance(ntaxa, nsites, myGenotype.taxa());
        for (int t = 0; t < ntaxa; ++t) {
            float[] values = new float[nsites];
            for (int s = 0; s < nsites; ++s) {
                values[s] = (float)result[s][t];
            }
            refBuilder.addTaxon(t, values);
        }
        GenotypeTable imputedGenotype = GenotypeTableBuilder.getInstance(myGenotype.genotypeMatrix(), myGenotype.positions(), myGenotype.taxa(), myGenotype.depth(), myGenotype.alleleProbability(), refBuilder.build(), myGenotype.dosage(), myGenotype.annotations());
        StringBuilder nameBuilder = new StringBuilder("Imputed_");
        nameBuilder.append(datumList.get(0).getName());
        StringBuilder commentBuilder = new StringBuilder(this.getMethodString());
        commentBuilder.append("\nfrom ").append(datumList.get(0).getName());
        Datum newDatum = new Datum(nameBuilder.toString(), imputedGenotype, commentBuilder.toString());
        return new DataSet(newDatum, (Plugin)this);
    }

    private String getMethodString() {
        if (this.byMean.value().booleanValue()) {
            return "Missing values imputed as mean of trait.";
        }
        return String.format("Missing values imputed using K-nearest neigbor with %s distance.", this.distance.value().name());
    }

    @Override
    public String pluginDescription() {
        return "This plugin takes an input file (genotype/phenotype) with missing valuesand imputes the missing values using one the chosen methods.It returns the imputed file.";
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "Numerical Impute";
    }

    @Override
    public String getToolTipText() {
        return "Numerical Impute";
    }

    public distanceChoice distance_choice() {
        return this.distance.value();
    }

    public ImputationPlugin distance_choice(distanceChoice value) {
        this.distance = new PluginParameter<distanceChoice>(this.distance, value);
        return this;
    }

    public Boolean by_mean() {
        return this.byMean.value();
    }

    public ImputationPlugin by_mean(Boolean value) {
        this.byMean = new PluginParameter<Boolean>(this.byMean, value);
        return this;
    }

    public Integer nearest_neighbors() {
        return this.nearestNeighbors.value();
    }

    public ImputationPlugin nearest_neighbors(Integer value) {
        this.nearestNeighbors = new PluginParameter<Integer>(this.nearestNeighbors, value);
        return this;
    }

    private static enum distanceChoice {
        Euclidean,
        Manhattan,
        Cosine;

    }
}

