/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.GenotypeTableUtils;
import net.maizegenetics.dna.snp.score.ReferenceProbabilityBuilder;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import org.apache.log4j.Logger;

public class NumericalGenotypePlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(NumericalGenotypePlugin.class);
    private TRANSFORM_TYPE myTransformType = TRANSFORM_TYPE.as_minor;

    public NumericalGenotypePlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    public NumericalGenotypePlugin() {
        super(null, false);
    }

    @Override
    public DataSet processData(DataSet input) {
        GenotypeTable myNewGenotype;
        List<Datum> datumList = input.getDataOfType(GenotypeTable.class);
        if (datumList.size() != 1) {
            throw new IllegalArgumentException("NumericalGenotypePlugin: select exactly one genotype dataset to transform.");
        }
        String msg = "Genotypes will be converted to the probability that an allele selected at random at a site is \nthe major allele. In other words, homozygous major is 1.0, homozygous minor is 0.0, \nand heterozygous is 0.5. The results are equivalent to the TASSEL version 4 \"collapse\" method.";
        if (this.isInteractive()) {
            int convertGenotype = JOptionPane.showConfirmDialog(this.getParentFrame(), msg, "ReferenceProbability from Genotype", 2, 1);
            if (convertGenotype == 2 || convertGenotype == -1) {
                return null;
            }
        } else {
            myLogger.info((Object)msg);
        }
        GenotypeTable myGenotype = (GenotypeTable)datumList.get(0).getData();
        StringBuilder nameBuilder = new StringBuilder(datumList.get(0).getName());
        nameBuilder.append("_with_Probability");
        StringBuilder commentBuilder = new StringBuilder();
        if (datumList.get(0).getComment() != null) {
            commentBuilder.append(datumList.get(0).getComment());
        }
        switch (this.myTransformType) {
            case as_minor: {
                myNewGenotype = NumericalGenotypePlugin.setAlternateMinorAllelesToMinor(myGenotype);
                commentBuilder.append("\nReference Probability computed by setting alternate minor alleles");
                commentBuilder.append("\nto the most common minor allele.");
                break;
            }
            case as_major: {
                myNewGenotype = NumericalGenotypePlugin.setAlternateMinorAllelesToMajor(myGenotype);
                commentBuilder.append("\nReference Probability computed by setting alternate minor alleles");
                commentBuilder.append("\nto the major allele.");
                break;
            }
            case as_missing: {
                myNewGenotype = NumericalGenotypePlugin.setAlternateMinorAllelesToMissing(myGenotype);
                commentBuilder.append("\nReference Probability computed by setting alternate minor alleles");
                commentBuilder.append("\nto missing.");
                break;
            }
            case use_all_alleles: {
                myNewGenotype = NumericalGenotypePlugin.transformToAlleleProbability(myGenotype);
                commentBuilder.append("\nWith allele probabilities computed.");
                break;
            }
            default: {
                throw new IllegalStateException("NumericalGenotypePlugin: processData: unknown transform type: " + this.myTransformType.toString());
            }
        }
        Datum newDatum = new Datum(nameBuilder.toString(), myNewGenotype, commentBuilder.toString());
        return new DataSet(newDatum, (Plugin)this);
    }

    public static GenotypeTable setAlternateMinorAllelesToMinor(GenotypeTable myGenotype) {
        int nsites = myGenotype.numberOfSites();
        int ntaxa = myGenotype.numberOfTaxa();
        float[][] data = GenotypeTableUtils.convertGenotypeToFloatProbability(myGenotype, false);
        ReferenceProbabilityBuilder refBuilder = ReferenceProbabilityBuilder.getInstance(ntaxa, nsites, myGenotype.taxa());
        for (int t = 0; t < ntaxa; ++t) {
            refBuilder.addTaxon(t, data[t]);
        }
        return GenotypeTableBuilder.getInstance(myGenotype.genotypeMatrix(), myGenotype.positions(), myGenotype.taxa(), myGenotype.depth(), myGenotype.alleleProbability(), refBuilder.build(), myGenotype.dosage(), myGenotype.annotations());
    }

    public static GenotypeTable setAlternateMinorAllelesToMajor(GenotypeTable myGenotype) {
        throw new UnsupportedOperationException();
    }

    public static GenotypeTable setAlternateMinorAllelesToMissing(GenotypeTable myGenotype) {
        throw new UnsupportedOperationException();
    }

    public static GenotypeTable transformToAlleleProbability(GenotypeTable myGenotype) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String pluginDescription() {
        return "This plugin creates a numerical genotype table for input genotype data";
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = NumericalGenotypePlugin.class.getResource("/net/maizegenetics/analysis/images/NumericalGenotype.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Numerical Genotype";
    }

    @Override
    public String getToolTipText() {
        return "Numerical Genotype";
    }

    private void setTransformType(TRANSFORM_TYPE type) {
        this.myTransformType = type;
    }

    public static enum TRANSFORM_TYPE {
        as_minor,
        as_major,
        as_missing,
        use_all_alleles,
        collapse,
        separated;

    }
}

