/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.maizegenetics.phenotype.Phenotype;
import net.maizegenetics.phenotype.PhenotypeAttribute;
import net.maizegenetics.phenotype.PhenotypeUtils;

public class SubtractPhenotype {
    public Phenotype subtractPhenotype(Phenotype pheno1, Phenotype pheno2, boolean useAbsDiff) throws Exception {
        int i;
        ArrayList uniqueTaxaPheno1 = (ArrayList)pheno1.taxaAttribute().allTaxaAsList().stream().map(taxon -> taxon.getName()).distinct().collect(Collectors.toList());
        ArrayList uniqueTaxaPheno2 = (ArrayList)pheno2.taxaAttribute().allTaxaAsList().stream().map(taxon -> taxon.getName()).distinct().collect(Collectors.toList());
        ArrayList allTaxaPheno1 = (ArrayList)pheno1.taxaAttribute().allTaxaAsList().stream().map(taxon -> taxon.getName()).collect(Collectors.toList());
        ArrayList allTaxaPheno2 = (ArrayList)pheno2.taxaAttribute().allTaxaAsList().stream().map(taxon -> taxon.getName()).collect(Collectors.toList());
        boolean pheno1DuplicateTaxa = false;
        boolean pheno2DuplicateTaxa = false;
        if (allTaxaPheno1.size() != uniqueTaxaPheno1.size()) {
            pheno1DuplicateTaxa = true;
        }
        if (allTaxaPheno2.size() != uniqueTaxaPheno2.size()) {
            pheno2DuplicateTaxa = true;
        }
        if (pheno1DuplicateTaxa && pheno2DuplicateTaxa) {
            throw new Exception("Both phenotypes have duplicate taxa rows");
        }
        if (pheno1DuplicateTaxa) {
            throw new Exception("First Selected phenotype has duplicate taxa rows");
        }
        if (pheno2DuplicateTaxa) {
            throw new Exception("Second Selected phenotype has duplicate taxa rows");
        }
        ArrayList intersectionTaxaList = (ArrayList)uniqueTaxaPheno1.clone();
        intersectionTaxaList.retainAll(uniqueTaxaPheno2);
        HashMap pheno1NameToIndexMap = new HashMap();
        HashMap pheno2NameToIndexMap = new HashMap();
        for (i = 0; i < uniqueTaxaPheno1.size(); ++i) {
            pheno1NameToIndexMap.put(uniqueTaxaPheno1.get(i), i);
        }
        for (i = 0; i < uniqueTaxaPheno2.size(); ++i) {
            pheno2NameToIndexMap.put(uniqueTaxaPheno2.get(i), i);
        }
        ArrayList attributes1 = (ArrayList)pheno1.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data);
        attributes1.addAll((ArrayList)pheno1.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate));
        ArrayList phenoNames1 = (ArrayList)attributes1.stream().map(phenoAttr -> phenoAttr.name()).collect(Collectors.toList());
        ArrayList attributes2 = (ArrayList)pheno2.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data);
        attributes2.addAll((ArrayList)pheno2.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate));
        ArrayList phenoNames2 = (ArrayList)attributes2.stream().map(phenoAttr -> phenoAttr.name()).collect(Collectors.toList());
        ArrayList intersectionPhenoList = (ArrayList)phenoNames1.clone();
        intersectionPhenoList.retainAll(phenoNames2);
        HashMap<String, Phenotype.ATTRIBUTE_TYPE> nameToTypeMap = new HashMap<String, Phenotype.ATTRIBUTE_TYPE>();
        for (PhenotypeAttribute phenoAttribute : (ArrayList)pheno1.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data)) {
            nameToTypeMap.put(phenoAttribute.name(), Phenotype.ATTRIBUTE_TYPE.data);
        }
        for (PhenotypeAttribute phenoAttribute : (ArrayList)pheno1.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate)) {
            nameToTypeMap.put(phenoAttribute.name(), Phenotype.ATTRIBUTE_TYPE.covariate);
        }
        for (PhenotypeAttribute phenoAttribute : (ArrayList)pheno2.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.data)) {
            nameToTypeMap.put(phenoAttribute.name(), Phenotype.ATTRIBUTE_TYPE.data);
        }
        for (PhenotypeAttribute phenoAttribute : (ArrayList)pheno2.attributeListOfType(Phenotype.ATTRIBUTE_TYPE.covariate)) {
            nameToTypeMap.put(phenoAttribute.name(), Phenotype.ATTRIBUTE_TYPE.covariate);
        }
        ArrayList<ArrayList<Double>> data = new ArrayList<ArrayList<Double>>();
        ArrayList<Phenotype.ATTRIBUTE_TYPE> attrTypeList = new ArrayList<Phenotype.ATTRIBUTE_TYPE>();
        attrTypeList.add(Phenotype.ATTRIBUTE_TYPE.taxa);
        for (int row = 0; row < intersectionTaxaList.size(); ++row) {
            ArrayList<Double> currentRow = new ArrayList<Double>();
            for (int col = 0; col < intersectionPhenoList.size(); ++col) {
                attrTypeList.add((Phenotype.ATTRIBUTE_TYPE)((Object)nameToTypeMap.get(intersectionPhenoList.get(col))));
                double firstVal = ((Float)pheno1.value((Integer)pheno1NameToIndexMap.get(intersectionTaxaList.get(row)), pheno1.attributeIndexForName((String)intersectionPhenoList.get(col)))).doubleValue();
                double secondVal = ((Float)pheno2.value((Integer)pheno2NameToIndexMap.get(intersectionTaxaList.get(row)), pheno2.attributeIndexForName((String)intersectionPhenoList.get(col)))).doubleValue();
                if (useAbsDiff) {
                    currentRow.add(Math.abs(firstVal - secondVal));
                    continue;
                }
                currentRow.add(firstVal - secondVal);
            }
            data.add(currentRow);
        }
        return PhenotypeUtils.createPhenotypeFromTransform(intersectionTaxaList, intersectionPhenoList, data, pheno1.name() + "_minus_" + pheno2.name(), attrTypeList);
    }
}

