/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.maizegenetics.analysis.numericaltransform.TransformDataPlugin;
import net.maizegenetics.phenotype.CategoricalAttribute;
import net.maizegenetics.phenotype.NumericAttribute;
import net.maizegenetics.util.OpenBitSet;

public class TransformDataDialog
extends JDialog
implements ActionListener {
    private final List<NumericAttribute> dataAttributes;
    private final List<CategoricalAttribute> factorAttributes;
    private JList<NumericAttribute> lstTraits;
    private JList<CategoricalAttribute> lstFactors;
    private JCheckBox chkPower;
    private JCheckBox chkLog;
    private JRadioButton radNatural;
    private JRadioButton radBase2;
    private JRadioButton radBase10;
    private JTextField txtPower;
    private JCheckBox chkStandard;
    private JButton btnOk;
    private JButton btnCancel;
    private boolean wasCancelled = true;
    private final boolean hasFactors;

    public TransformDataDialog(Frame parentFrame, List<NumericAttribute> dataAttributes, List<CategoricalAttribute> factorAttributes) {
        super(parentFrame);
        this.dataAttributes = dataAttributes;
        this.factorAttributes = factorAttributes;
        this.hasFactors = factorAttributes != null && factorAttributes.size() != 0;
        this.init();
    }

    public static void main(String[] args) {
        ArrayList<NumericAttribute> dataAttributes = new ArrayList<NumericAttribute>();
        dataAttributes.add(new NumericAttribute("trait1", new float[]{1.0f, 2.0f, 3.0f}, new OpenBitSet(3L)));
        dataAttributes.add(new NumericAttribute("trait2", new float[]{1.0f, 2.0f, 3.0f}, new OpenBitSet(3L)));
        dataAttributes.add(new NumericAttribute("trait3", new float[]{1.0f, 2.0f, 3.0f}, new OpenBitSet(3L)));
        dataAttributes.add(new NumericAttribute("trait4", new float[]{1.0f, 2.0f, 3.0f}, new OpenBitSet(3L)));
        dataAttributes.add(new NumericAttribute("trait5", new float[]{1.0f, 2.0f, 3.0f}, new OpenBitSet(3L)));
        dataAttributes.add(new NumericAttribute("trait6", new float[]{1.0f, 2.0f, 3.0f}, new OpenBitSet(3L)));
        dataAttributes.add(new NumericAttribute("trait7", new float[]{1.0f, 2.0f, 3.0f}, new OpenBitSet(3L)));
        ArrayList<CategoricalAttribute> factorAttributes = new ArrayList<CategoricalAttribute>();
        factorAttributes.add(new CategoricalAttribute("factor1", new String[]{"one", "one", "two"}));
        TransformDataDialog tdd = new TransformDataDialog(null, dataAttributes, null);
        tdd.setVisible(true);
        System.out.printf("power transformation: %b; exponent = %1.1f\n", tdd.powerTransformation(), tdd.exponent());
        System.out.printf("log transformation: %b; base = %s\n", tdd.logTransformation(), tdd.base().name());
        System.out.println("Traits to transform:");
        for (NumericAttribute na : tdd.traitsToTransform()) {
            System.out.println(na.name());
        }
        System.out.println("Factors to standardize:");
        for (CategoricalAttribute ca : tdd.factorsForStandardizing()) {
            System.out.println(ca.name());
        }
        if (tdd.standardize()) {
            System.out.println("Standardize data.");
        } else {
            System.out.println("Do not standardize data.");
        }
        if (tdd.wasCancelled) {
            System.out.println("was cancelled.");
        } else {
            System.out.println("was not cancelled.");
        }
        System.exit(0);
    }

    private void init() {
        this.setTitle("Transform Data");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.lstTraits = new JList<NumericAttribute>(this.dataAttributes.toArray(new NumericAttribute[0]));
        if (this.hasFactors) {
            this.lstFactors = new JList<CategoricalAttribute>(this.factorAttributes.toArray(new CategoricalAttribute[0]));
        }
        this.chkPower = new JCheckBox("Power", false);
        this.chkPower.setActionCommand("power");
        this.chkPower.addActionListener(this);
        this.txtPower = new JTextField("Enter exponent");
        this.txtPower.setEnabled(false);
        this.chkLog = new JCheckBox("Log", false);
        this.chkLog.setActionCommand("log");
        this.chkLog.addActionListener(this);
        this.radNatural = new JRadioButton("Natural", true);
        this.radNatural.setEnabled(false);
        this.radBase2 = new JRadioButton("Base 2", false);
        this.radBase2.setEnabled(false);
        this.radBase10 = new JRadioButton("Base 10", false);
        this.radBase10.setEnabled(false);
        ButtonGroup logBaseGroup = new ButtonGroup();
        logBaseGroup.add(this.radNatural);
        logBaseGroup.add(this.radBase2);
        logBaseGroup.add(this.radBase10);
        this.chkStandard = new JCheckBox("Standardize");
        this.btnOk = new JButton("OK");
        this.btnOk.setActionCommand("ok");
        this.btnOk.addActionListener(this);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setActionCommand("cancel");
        this.btnCancel.addActionListener(this);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = this.hasFactors ? 1 : 2;
        gbc.anchor = 10;
        gbc.insets = !this.hasFactors ? new Insets(15, 60, 2, 60) : new Insets(15, 30, 2, 30);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JLabel lblTraits = new JLabel("Select Traits to Transform:");
        Font labelFont = lblTraits.getFont().deriveFont(1, 14.0f);
        lblTraits.setFont(labelFont);
        mainPanel.add((Component)lblTraits, gbc);
        if (this.hasFactors) {
            ++gbc.gridx;
            JLabel lblFactors = new JLabel("Standardize within Selected Factor:");
            lblFactors.setFont(labelFont);
            mainPanel.add((Component)lblFactors, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        JScrollPane traitScroller = new JScrollPane(this.lstTraits);
        traitScroller.setPreferredSize(new Dimension(150, 100));
        gbc.insets = new Insets(5, 30, 20, 30);
        mainPanel.add((Component)traitScroller, gbc);
        if (this.hasFactors) {
            ++gbc.gridx;
            JScrollPane factorScroller = new JScrollPane(this.lstFactors);
            factorScroller.setPreferredSize(new Dimension(150, 100));
            gbc.insets = new Insets(2, 30, 20, 30);
            mainPanel.add((Component)factorScroller, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 2, 5, 2);
        JLabel lblMethod = new JLabel("Select Transformation Method:");
        lblMethod.setFont(labelFont);
        mainPanel.add((Component)lblMethod, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        mainPanel.add((Component)this.chkPower, gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        mainPanel.add((Component)this.txtPower, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.insets = new Insets(20, 2, 2, 2);
        mainPanel.add((Component)this.chkLog, gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        mainPanel.add((Component)this.radNatural, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(2, 2, 2, 2);
        mainPanel.add((Component)this.radBase2, gbc);
        ++gbc.gridy;
        mainPanel.add((Component)this.radBase10, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(20, 2, 2, 2);
        mainPanel.add((Component)this.chkStandard, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.insets = new Insets(20, 2, 30, 2);
        mainPanel.add((Component)this.btnOk, gbc);
        ++gbc.gridx;
        gbc.anchor = 17;
        mainPanel.add((Component)this.btnCancel, gbc);
        this.getContentPane().add(mainPanel);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("power")) {
            if (this.chkPower.isSelected()) {
                this.txtPower.setEnabled(true);
            } else {
                this.txtPower.setEnabled(false);
            }
        } else if (e.getActionCommand().equals("log")) {
            if (this.chkLog.isSelected()) {
                this.radNatural.setEnabled(true);
                this.radBase2.setEnabled(true);
                this.radBase10.setEnabled(true);
            } else {
                this.radNatural.setEnabled(false);
                this.radBase2.setEnabled(false);
                this.radBase10.setEnabled(false);
            }
        } else if (e.getActionCommand().equals("ok")) {
            this.wasCancelled = false;
            this.setVisible(false);
        } else if (e.getActionCommand().equals("cancel")) {
            this.wasCancelled = true;
            this.setVisible(false);
        }
    }

    public List<NumericAttribute> traitsToTransform() {
        if (this.wasCancelled) {
            return new ArrayList<NumericAttribute>();
        }
        return this.lstTraits.getSelectedValuesList();
    }

    public List<CategoricalAttribute> factorsForStandardizing() {
        if (this.hasFactors && !this.wasCancelled) {
            return this.lstFactors.getSelectedValuesList();
        }
        return new ArrayList<CategoricalAttribute>();
    }

    public boolean powerTransformation() {
        return this.chkPower.isSelected();
    }

    public double exponent() {
        try {
            return Double.parseDouble(this.txtPower.getText());
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    public boolean logTransformation() {
        return this.chkLog.isSelected();
    }

    public TransformDataPlugin.BASE base() {
        if (this.radBase2.isSelected()) {
            return TransformDataPlugin.BASE.base_2;
        }
        if (this.radBase10.isSelected()) {
            return TransformDataPlugin.BASE.base_10;
        }
        return TransformDataPlugin.BASE.natural;
    }

    public boolean standardize() {
        return this.chkStandard.isSelected();
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }
}

