/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.numericaltransform;

import com.google.common.collect.MinMaxPriorityQueue;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class kNearestNeighbors {
    private kNearestNeighbors() {
    }

    public static double[][] impute(double[][] data, int k, boolean isManhattan, boolean isCosine) {
        int rows = data.length;
        int cols = data[0].length;
        double[][] result = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            double[][] neighbors = null;
            boolean neighborsCalculated = false;
            for (int j = 0; j < cols; ++j) {
                if (!Double.isNaN(data[i][j])) {
                    result[i][j] = data[i][j];
                    continue;
                }
                if (isCosine) {
                    neighbors = kNearestNeighbors.cosineSimRank(data, i, j, k);
                    result[i][j] = kNearestNeighbors.calcKNN(data, neighbors, j);
                    continue;
                }
                if (!neighborsCalculated) {
                    neighbors = kNearestNeighbors.KNearestNeighbor(data, i, k, isManhattan);
                    neighborsCalculated = true;
                }
                result[i][j] = kNearestNeighbors.calcKNN(data, neighbors, j);
            }
        }
        return result;
    }

    private static double calcKNN(double[][] data, double[][] neighbors, int col) {
        double num = 0.0;
        int numberOfNonMissingValues = 0;
        for (double[] neighbor : neighbors) {
            if (Double.isNaN(neighbor[col])) continue;
            num += neighbor[col];
            ++numberOfNonMissingValues;
        }
        if (numberOfNonMissingValues == 0) {
            return kNearestNeighbors.columnMean(data, col);
        }
        return num / (double)numberOfNonMissingValues;
    }

    public static double columnMean(double[][] data, int col) {
        double sum = 0.0;
        double count = 0.0;
        for (double[] row : data) {
            if (Double.isNaN(row[col])) continue;
            sum += row[col];
            count += 1.0;
        }
        if (count == 0.0) {
            return Double.NaN;
        }
        return sum / count;
    }

    public static double cosine(double[] data1, double[] data2) {
        int l1 = data1.length;
        int l2 = data2.length;
        double result = 0.0;
        for (int i = 0; i < l1; ++i) {
            if (Double.isNaN(data1[i]) || Double.isNaN(data2[i])) continue;
            result += data1[i] * data2[i];
        }
        double norm1 = 0.0;
        for (int i = 0; i < l1; ++i) {
            if (Double.isNaN(data1[i])) continue;
            norm1 += Math.pow(data1[i], 2.0);
        }
        double norm2 = 0.0;
        for (int j = 0; j < l2; ++j) {
            if (Double.isNaN(data2[j])) continue;
            norm2 += Math.pow(data2[j], 2.0);
        }
        double normProduct = norm1 * norm2;
        return result / normProduct;
    }

    public static double[][] cosineSimRank(double[][] data, int row, int col, int k) {
        int nRows = data.length;
        int nCols = data[0].length;
        double[] query = data[row];
        double[][] neighbors = new double[k][];
        HashMap<Integer, Double> distances = new HashMap<Integer, Double>();
        for (int i = 0; i < nRows; ++i) {
            if (i == col) continue;
            double[] alpha = data[i];
            distances.put(i, kNearestNeighbors.cosine(query, alpha));
        }
        for (int n = 0; n < k; ++n) {
            double longestDistance = -10000.0;
            int IndexS = 0;
            for (Map.Entry distance : distances.entrySet()) {
                if (!((Double)distance.getValue() > longestDistance)) continue;
                longestDistance = (Double)distance.getValue();
                IndexS = (Integer)distance.getKey();
            }
            neighbors[n] = data[IndexS];
            distances.remove(IndexS);
        }
        return neighbors;
    }

    public static double distance(double[] data1, double[] data2, boolean isManhattan) {
        int l1 = data1.length;
        double result = 0.0;
        double count = l1;
        if (isManhattan) {
            for (int i = 0; i < l1; ++i) {
                double diff = data1[i] - data2[i];
                if (Double.isNaN(diff)) {
                    count -= 1.0;
                    continue;
                }
                result += Math.abs(diff);
            }
        } else {
            for (int i = 0; i < l1; ++i) {
                double diff = data1[i] - data2[i];
                if (Double.isNaN(diff)) {
                    count -= 1.0;
                    continue;
                }
                result += diff * diff;
            }
        }
        return result / count;
    }

    public static double[][] KNearestNeighbor(double[][] data, int row, int k, boolean isManhattan) {
        int nRows = data.length;
        MinMaxPriorityQueue distances = MinMaxPriorityQueue.orderedBy((o1, o2) -> Double.compare((Double)o1.getKey(), (Double)o2.getKey())).maximumSize(k).create();
        double highestLowest = -1.0;
        for (int i = 0; i < nRows; ++i) {
            double current = kNearestNeighbors.distance(data[row], data[i], isManhattan);
            if (distances.size() >= k && !(current < highestLowest)) continue;
            distances.add(new AbstractMap.SimpleEntry<Double, double[]>(current, data[i]));
            highestLowest = (Double)((Map.Entry)distances.peekLast()).getKey();
        }
        double[][] neighbors = new double[k][];
        for (int n = 0; n < k; ++n) {
            neighbors[n] = (double[])((Map.Entry)distances.poll()).getValue();
        }
        return neighbors;
    }
}

