/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.phg;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.maizegenetics.util.Tuple;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ParseGVCF {
    private static final Logger myLogger = Logger.getLogger(ParseGVCF.class);
    private static final int NUM_LINES_PER_BLOCK = 10;

    private ParseGVCF() {
    }

    public static Tuple<List<String>, BlockingQueue<Future<ProcessLines>>> parse(String filename) {
        myLogger.info((Object)("ParseGVCF: filename: " + filename));
        ExecutorService pool = Executors.newWorkStealingPool();
        LinkedBlockingQueue<Future<ProcessLines>> queue = new LinkedBlockingQueue<Future<ProcessLines>>();
        pool.submit(new ReadLines(filename, queue, pool));
        ProcessLines header = null;
        try {
            header = (ProcessLines)((Future)queue.take()).get();
            if (!header.isHeader()) {
                throw new IllegalStateException("ParseGVCF: should be header.");
            }
        }
        catch (Exception e) {
            myLogger.debug((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException("ParseGVCF: problem getting header lines.");
        }
        return new Tuple<List<String>, BlockingQueue<Future<ProcessLines>>>(header.lines(), queue);
    }

    public static Tuple<List<String>, Stream<GVCFLine>> stream(String filename) {
        Tuple<List<String>, BlockingQueue<Future<ProcessLines>>> temp = ParseGVCF.parse(filename);
        return new Tuple<List<String>, Stream<GVCFLine>>(temp.getX(), StreamSupport.stream(new GVCFLineSpliterator(temp.getY()), false));
    }

    private static class ReadLines
    implements Runnable {
        private final String myFilename;
        private final BlockingQueue<Future<ProcessLines>> myQueue;
        private final ExecutorService myPool;

        public ReadLines(String filename, BlockingQueue<Future<ProcessLines>> queue, ExecutorService pool) {
            this.myFilename = filename;
            this.myQueue = queue;
            this.myPool = pool;
        }

        @Override
        public void run() {
            try (BufferedReader reader = Utils.getBufferedReader(this.myFilename);){
                int lineNum = 1;
                ArrayList<String> temp = new ArrayList<String>();
                String line = reader.readLine();
                while (line != null && line.startsWith("#")) {
                    temp.add(line);
                    line = reader.readLine();
                }
                this.myQueue.add(this.myPool.submit(new ProcessLines(temp)));
                lineNum += temp.size();
                int count = 0;
                temp = new ArrayList();
                while (line != null) {
                    temp.add(line);
                    if (++count == 10) {
                        this.myQueue.add(this.myPool.submit(new ProcessLines(lineNum, temp)));
                        temp = new ArrayList();
                        count = 0;
                        lineNum += 10;
                    }
                    line = reader.readLine();
                }
                if (!temp.isEmpty()) {
                    this.myQueue.add(this.myPool.submit(new ProcessLines(lineNum, temp)));
                }
                this.myQueue.add(this.myPool.submit(new ProcessLines()));
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("ParseGVCF: ReadLines: problem reading file: " + this.myFilename);
            }
            finally {
                this.myPool.shutdown();
            }
        }
    }

    public static class GVCFLine {
        private final String myLine;
        private final int myLineNum;
        private String myChromosome = null;
        private int myStartPosition = -1;
        private int myEndPosition = -1;
        private int mySeqLength = 0;
        private int myDepth = 0;
        private List<Integer> myAlleleDepths = null;
        private boolean myIsHomozygous = true;
        private String myReference = null;
        private List<String> myAlternates = null;
        private List<Integer> myGenotypeIndices = null;
        private List<String> myGenotypes = null;
        private boolean myIsPhased = false;
        private int myPloidy = -1;
        private boolean myIsReferenceBlock = false;

        public GVCFLine(int lineNum, String line) {
            this.myLineNum = lineNum;
            this.myLine = line;
            this.parseLine();
        }

        public int lineNum() {
            return this.myLineNum;
        }

        public String toString() {
            return this.myLine;
        }

        public String chromosome() {
            return this.myChromosome;
        }

        public int startPosition() {
            return this.myStartPosition;
        }

        public int endPosition() {
            return this.myEndPosition;
        }

        public int seqLength() {
            return this.mySeqLength;
        }

        public int depth() {
            return this.myDepth;
        }

        public List<Integer> alleleDepths() {
            return this.myAlleleDepths;
        }

        public boolean isHomozygous() {
            return this.myIsHomozygous;
        }

        public String reference() {
            return this.myReference;
        }

        public List<String> alternates() {
            return this.myAlternates;
        }

        public List<Integer> genotypeIndices() {
            return this.myGenotypeIndices;
        }

        public List<String> genotypes() {
            return this.myGenotypes;
        }

        public boolean phased() {
            return this.myIsPhased;
        }

        public int ploidy() {
            return this.myPloidy;
        }

        public boolean isReferenceBlock() {
            return this.myIsReferenceBlock;
        }

        private void parseLine() {
            String[] values;
            int numValues;
            if (this.myLine == null || this.myLine.startsWith("#")) {
                myLogger.error((Object)(this.myLineNum + ": " + this.myLine));
                throw new IllegalStateException("GVCFLine: line shouldn't be null or start with #");
            }
            String[] tokens = this.myLine.split("\t");
            this.myChromosome = tokens[0];
            this.myStartPosition = Integer.parseInt(tokens[1]);
            String id = tokens[2];
            this.myReference = tokens[3];
            String alt = tokens[4];
            ImmutableList.Builder altBuilder = new ImmutableList.Builder();
            altBuilder.add((Object[])alt.split(","));
            this.myAlternates = altBuilder.build();
            String qual = tokens[5];
            String filter = tokens[6];
            String[] info = tokens[7].split(";");
            boolean endSpecified = false;
            for (String current : info) {
                String[] keyValue = current.split("=");
                if (!keyValue[0].equals("END")) continue;
                endSpecified = true;
                this.myEndPosition = Integer.parseInt(keyValue[1]);
                if (this.myEndPosition >= this.myStartPosition) continue;
                myLogger.error((Object)(this.myLineNum + ": " + this.myLine));
                throw new IllegalStateException("GVCFLine: End position less than start position.");
            }
            if (!endSpecified) {
                this.myEndPosition = this.myStartPosition + this.myReference.length() - 1;
            }
            this.mySeqLength = this.myEndPosition - this.myStartPosition + 1;
            String[] formats = tokens[8].split(":");
            int numFormats = formats.length;
            if (numFormats < (numValues = (values = tokens[9].split(":")).length)) {
                myLogger.error((Object)(this.myLineNum + ": " + this.myLine));
                throw new IllegalArgumentException("GVCFLine: number of formats can't be less than number of values.");
            }
            boolean isHomoBasedOnGenotype = false;
            boolean isAlt = false;
            int alleleDepthSum = 0;
            for (int i = 0; i < numValues; ++i) {
                if (formats[i].equals("DP")) {
                    this.myDepth = Integer.parseInt(values[i]);
                    continue;
                }
                if (formats[i].equals("AD")) {
                    String[] alleleDepths = values[i].split(",");
                    ArrayList<Integer> temp = new ArrayList<Integer>();
                    for (String alleleDepth : alleleDepths) {
                        int depthValue = Integer.parseInt(alleleDepth);
                        alleleDepthSum += depthValue;
                        temp.add(depthValue);
                    }
                    this.myAlleleDepths = Collections.unmodifiableList(temp);
                    if (alleleDepths.length <= 1 || alleleDepths[0].equals("0") || alleleDepths[1].equals("0")) continue;
                    this.myIsHomozygous = false;
                    continue;
                }
                if (!formats[i].equals("GT")) continue;
                String[] alleles = null;
                if (values[i].contains("/")) {
                    this.myIsPhased = false;
                    if (values[i].contains("|")) {
                        throw new IllegalStateException("ParseGVCF: genotypes (GT) can't have both / and |");
                    }
                    alleles = values[i].split("/");
                    if (!alleles[0].equals(".") && !alleles[1].equals(".") && alleles[0].equals(alleles[1])) {
                        isHomoBasedOnGenotype = true;
                    }
                    if (!alleles[0].equals("0") || !alleles[1].equals("0")) {
                        isAlt = true;
                    }
                } else if (values[i].contains("|")) {
                    this.myIsPhased = true;
                    alleles = values[i].split("|");
                    if (!alleles[0].equals(".") && !alleles[1].equals(".") && alleles[0].equals(alleles[1])) {
                        isHomoBasedOnGenotype = true;
                    }
                    if (!alleles[0].equals("0") || !alleles[1].equals("0")) {
                        isAlt = true;
                    }
                } else {
                    this.myPloidy = 1;
                    if (!values[i].equals("0")) {
                        isAlt = true;
                    }
                    alleles = new String[]{values[i]};
                }
                ImmutableList.Builder genotypeIndices = new ImmutableList.Builder();
                ImmutableList.Builder genotypes = new ImmutableList.Builder();
                for (String current : alleles) {
                    int alleleIndex = -1;
                    try {
                        if (!current.equals(".")) {
                            alleleIndex = Integer.valueOf(current);
                        }
                    }
                    catch (NumberFormatException ne) {
                        myLogger.error((Object)(this.myLineNum + ": " + this.myLine));
                        throw new IllegalStateException("ParseGVCF: GT index not a number or .: " + current);
                    }
                    try {
                        if (alleleIndex == -1) {
                            genotypeIndices.add((Object)-1);
                            genotypes.add((Object)"N");
                            continue;
                        }
                        if (alleleIndex == 0) {
                            genotypeIndices.add((Object)0);
                            genotypes.add((Object)this.myReference);
                            continue;
                        }
                        genotypeIndices.add((Object)alleleIndex);
                        genotypes.add((Object)this.myAlternates.get(alleleIndex - 1));
                    }
                    catch (ArrayIndexOutOfBoundsException ae) {
                        myLogger.error((Object)(this.myLineNum + ": " + this.myLine));
                        throw new IllegalStateException("ParseGVCF: GT index not defined.");
                    }
                }
                this.myGenotypeIndices = genotypeIndices.build();
                this.myGenotypes = genotypes.build();
            }
            if (endSpecified) {
                for (int current : this.myGenotypeIndices) {
                    if (current == 0 || current == -1) continue;
                    myLogger.error((Object)(this.myLineNum + ": " + this.myLine));
                    throw new IllegalStateException("GVCFLine: END was specified, but GT is not 0 (reference) or . (missing): it is: " + current);
                }
                this.myIsReferenceBlock = true;
            }
            if (alleleDepthSum != 0 && alleleDepthSum != this.myDepth) {
                myLogger.error((Object)(this.myLineNum + ": " + this.myLine));
                throw new IllegalStateException("GVCFLine: DP: " + this.myDepth + " not equal to AD sum: " + alleleDepthSum);
            }
            if (this.myPloidy >= 2 && this.myIsHomozygous != isHomoBasedOnGenotype) {
                myLogger.error((Object)("Line: " + this.myLine));
                throw new IllegalStateException("GVCFLine: Homozygous doesn't match based on DP and GT");
            }
            if (this.myDepth <= 0 || !this.myIsHomozygous || !isAlt || this.myDepth == 1 || this.myDepth == 2) {
                // empty if block
            }
        }
    }

    public static class ProcessLines
    implements Callable<ProcessLines> {
        private final List<String> myLines;
        private final int myStartLine;
        private final int myNumLines;
        private final boolean myIsHeader;
        private List<GVCFLine> myProcessedLines = null;

        public ProcessLines(List<String> headerLines) {
            this.myLines = Collections.unmodifiableList(headerLines);
            this.myStartLine = 1;
            this.myNumLines = headerLines.size();
            this.myIsHeader = true;
        }

        public ProcessLines(int lineNum, List<String> lines) {
            this.myLines = Collections.unmodifiableList(lines);
            this.myStartLine = lineNum;
            this.myNumLines = lines.size();
            this.myIsHeader = false;
        }

        public ProcessLines() {
            this.myLines = null;
            this.myStartLine = -1;
            this.myNumLines = 0;
            this.myIsHeader = false;
        }

        @Override
        public ProcessLines call() throws Exception {
            if (this.isFinal() || this.isHeader()) {
                return this;
            }
            ArrayList<GVCFLine> temp = new ArrayList<GVCFLine>();
            int currentLineNum = this.myStartLine;
            for (String current : this.myLines) {
                temp.add(new GVCFLine(currentLineNum, current));
                ++currentLineNum;
            }
            this.myProcessedLines = temp;
            return this;
        }

        public List<String> lines() {
            return this.myLines;
        }

        public int startLine() {
            return this.myStartLine;
        }

        public int numLines() {
            return this.myNumLines;
        }

        public boolean isHeader() {
            return this.myIsHeader;
        }

        public boolean isFinal() {
            return this.myStartLine == -1;
        }

        public List<GVCFLine> processedLines() {
            return this.myProcessedLines;
        }
    }

    private static class GVCFLineSpliterator<GVCFLine>
    implements Spliterator<GVCFLine> {
        private final BlockingQueue<Future<ProcessLines>> myQueue;
        private List<GVCFLine> myLines = null;
        private int myIndex = 0;
        private int myNumLines = 0;

        public GVCFLineSpliterator(BlockingQueue<Future<ProcessLines>> queue) {
            this.myQueue = queue;
        }

        @Override
        public boolean tryAdvance(Consumer<? super GVCFLine> action) {
            try {
                if (this.myLines == null) {
                    ProcessLines next = this.myQueue.take().get();
                    if (next.isFinal()) {
                        return false;
                    }
                    this.myLines = next.processedLines();
                    this.myIndex = 0;
                    this.myNumLines = this.myLines.size();
                }
                action.accept(this.myLines.get(this.myIndex));
                ++this.myIndex;
                if (this.myIndex >= this.myNumLines) {
                    this.myLines = null;
                }
                return true;
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("ParseGVCF: problem creating stream.");
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super GVCFLine> action) {
            try {
                if (this.myLines != null) {
                    for (int i = this.myIndex; i < this.myNumLines; ++i) {
                        action.accept(this.myLines.get(i));
                    }
                    this.myLines = null;
                }
                ProcessLines next = this.myQueue.take().get();
                while (!next.isFinal()) {
                    for (GVCFLine current : next.processedLines()) {
                        action.accept(current);
                    }
                    next = this.myQueue.take().get();
                }
            }
            catch (Exception e) {
                myLogger.debug((Object)e.getMessage(), (Throwable)e);
                throw new IllegalStateException("ParseGVCF: problem creating stream.");
            }
        }

        @Override
        public Spliterator<GVCFLine> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1296;
        }
    }
}

