/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.popgen;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;
import net.maizegenetics.dna.snp.GenotypeTable;

public class LinkageDisequilibriumComponent
extends JComponent {
    public static final int P_VALUE = 0;
    public static final int DPRIME = 1;
    public static final int RSQUARE = 2;
    double minimumChromosomeLength = 10.0;
    LinkageDisequilibrium theLD;
    GenotypeTable theAA;
    boolean includeBlockSchematic;
    boolean chromosomalScale;
    boolean includeLabels = true;
    int totalVariableSites;
    int totalLoci;
    int totalChromosomes;
    int totalIntervals;
    int totalBlocks;
    double[] startPos;
    double[] endPos;
    double[] blockBeginPos;
    double[] blockEndPos;
    String[] blockNames;
    int[] xPos;
    int[] yPos;
    int[] xEndPos;
    int[] blockBeginX;
    int[] blockEndX;
    int ih;
    int iw;
    double[] blockStart;
    double[] blockEnd;
    String upperLabel;
    String lowerLabel;
    double[][] diseq;
    Color theColor = new Color(0, 0, 0);
    int distanceBetweenGraphAndGene = 40;
    int hoff = 70;
    int h2off = 70;
    int voff = 20;
    boolean probability = true;
    boolean upperProb = false;
    boolean lowerProb = true;
    int myWindowSize;
    int myWindowX;
    int myWindowY;
    int myXStart;
    int myXEnd;
    int myYStart;
    int myYEnd;
    int[] jump;

    public LinkageDisequilibriumComponent(LinkageDisequilibrium theLD, boolean includeBlockSchematic, boolean chromosomalScale, int windowSize, int windowX, int windowY) {
        this.theLD = theLD;
        this.theAA = theLD.getAlignment();
        this.includeBlockSchematic = includeBlockSchematic;
        this.chromosomalScale = chromosomalScale;
        this.myWindowSize = windowSize;
        this.myWindowX = windowX;
        this.myWindowY = windowY;
        this.totalVariableSites = theLD.getSiteCount();
        this.diseq = new double[windowSize][windowSize];
        this.setXStart();
        this.setYStart();
        this.jump = new int[this.totalVariableSites + this.theAA.numChromosomes() - 1];
        String locus = this.theAA.chromosomeName(0);
        int jumpValue = 0;
        for (int i = 0; i < this.jump.length; ++i) {
            if (!locus.equals(this.theAA.chromosomeName(i + jumpValue))) {
                locus = this.theAA.chromosomeName(i + jumpValue);
                --jumpValue;
                this.jump[i] = 1;
                continue;
            }
            this.jump[i] = jumpValue;
        }
        this.setUpperCorner(2);
        this.setLowerCorner(0);
        if (this.theAA != null) {
            this.countGenesAndChromosomes();
            this.calculateStartAndEndPositions();
        } else {
            includeBlockSchematic = false;
        }
        this.xPos = new int[windowSize + 1];
        this.yPos = new int[windowSize + 1];
        this.xEndPos = new int[windowSize + 1];
        this.setToolTipText("");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setXStart() {
        this.myXStart = (int)Math.floor((double)this.myWindowX - (double)this.myWindowSize / 2.0);
        this.myXEnd = this.myXStart + this.myWindowSize;
    }

    public void setYStart() {
        this.myYStart = (int)Math.floor((double)this.myWindowY - (double)this.myWindowSize / 2.0);
        this.myYEnd = this.myYStart + this.myWindowSize;
    }

    public void setWindowSize(int newSize, int newX, int newY, int ldMeasureLower, int ldMeasureUpper) {
        this.myWindowSize = newSize;
        this.myWindowX = newX;
        this.myWindowY = newY;
        this.diseq = new double[this.myWindowSize][this.myWindowSize];
        this.xPos = new int[this.myWindowSize + 1];
        this.yPos = new int[this.myWindowSize + 1];
        this.xEndPos = new int[this.myWindowSize + 1];
        this.setXStart();
        this.setYStart();
        this.setLowerCorner(ldMeasureLower);
        this.setUpperCorner(ldMeasureUpper);
        if (this.theAA != null) {
            this.countGenesAndChromosomes();
            this.calculateStartAndEndPositions();
        }
    }

    public void setWindowX(int newX, int ldMeasureLower, int ldMeasureUpper) {
        this.myWindowX = newX;
        this.setXStart();
        this.calculateStartAndEndPositions();
        this.setLowerCorner(ldMeasureLower);
        this.setUpperCorner(ldMeasureUpper);
    }

    public void setWindowY(int newY, int ldMeasureLower, int ldMeasureUpper) {
        this.myWindowY = newY;
        this.setYStart();
        this.calculateStartAndEndPositions();
        this.setLowerCorner(ldMeasureLower);
        this.setUpperCorner(ldMeasureUpper);
    }

    public void setLowerCorner(int ldMeasure) {
        for (int r = 0; r < this.myWindowSize; ++r) {
            if (this.jump[r + this.myXStart] == 1) continue;
            block6: for (int c = Math.max(r + this.myXStart - this.myYStart, 0); c < this.myWindowSize; ++c) {
                if (this.jump[c + this.myYStart] == 1) continue;
                switch (ldMeasure) {
                    case 0: {
                        this.diseq[r][c] = this.theLD.getPVal(c + this.myYStart + this.jump[c + this.myYStart], r + this.myXStart + this.jump[r + this.myXStart]);
                        this.lowerLabel = "P value";
                        continue block6;
                    }
                    case 1: {
                        this.diseq[r][c] = this.theLD.getDPrime(c + this.myYStart + this.jump[c + this.myYStart], r + this.myXStart + this.jump[r + this.myXStart]);
                        this.lowerLabel = "D'";
                        continue block6;
                    }
                    case 2: {
                        this.diseq[r][c] = this.theLD.getRSqr(c + this.myYStart + this.jump[c + this.myYStart], r + this.myXStart + this.jump[r + this.myXStart]);
                        this.lowerLabel = "R^2";
                    }
                }
            }
        }
        this.lowerProb = ldMeasure == 0;
    }

    public void setUpperCorner(int ldMeasure) {
        for (int c = 0; c < this.myWindowSize; ++c) {
            if (this.jump[c + this.myYStart] == 1) continue;
            block6: for (int r = Math.max(c + this.myYStart - this.myXStart, 0); r < this.myWindowSize; ++r) {
                if (this.jump[r + this.myXStart] == 1) continue;
                switch (ldMeasure) {
                    case 0: {
                        this.diseq[r][c] = this.theLD.getPVal(r + this.myXStart + this.jump[r + this.myXStart], c + this.myYStart + this.jump[c + this.myYStart]);
                        this.upperLabel = "P value";
                        continue block6;
                    }
                    case 1: {
                        this.diseq[r][c] = this.theLD.getDPrime(r + this.myXStart + this.jump[r + this.myXStart], c + this.myYStart + this.jump[c + this.myYStart]);
                        this.upperLabel = "D'";
                        continue block6;
                    }
                    case 2: {
                        this.diseq[r][c] = this.theLD.getRSqr(r + this.myXStart + this.jump[r + this.myXStart], c + this.myYStart + this.jump[c + this.myYStart]);
                        this.upperLabel = "R squared";
                    }
                }
            }
        }
        this.upperProb = ldMeasure == 0;
    }

    public void setScaleOfView(boolean chromosomalScale) {
        this.chromosomalScale = chromosomalScale;
        this.countGenesAndChromosomes();
        this.calculateStartAndEndPositions();
    }

    public void setShowSchematic(boolean includeBlockSchematic) {
        if (this.theAA == null) {
            return;
        }
        this.includeBlockSchematic = includeBlockSchematic;
        this.countGenesAndChromosomes();
        this.calculateStartAndEndPositions();
    }

    public void setShowLabels(boolean includeLabels) {
        if (this.includeLabels == includeLabels) {
            return;
        }
        this.includeLabels = includeLabels;
        this.countGenesAndChromosomes();
        this.calculateStartAndEndPositions();
    }

    private void countGenesAndChromosomes() {
        this.totalChromosomes = 0;
        this.totalLoci = 0;
        String currLocus = "";
        for (int r = 0; r < this.totalVariableSites; ++r) {
            if (currLocus.equals(this.theAA.chromosomeName(r))) continue;
            ++this.totalLoci;
            currLocus = this.theAA.chromosomeName(r);
        }
        int n = this.totalBlocks = this.chromosomalScale ? this.totalChromosomes : this.totalLoci;
        if (this.totalBlocks == 0) {
            this.totalBlocks = 1;
        }
        this.blockStart = new double[this.totalBlocks];
        this.blockEnd = new double[this.totalBlocks];
        this.blockNames = new String[this.totalBlocks];
        for (int i = 0; i < this.totalChromosomes; ++i) {
            this.blockStart[i] = 999999.0;
            this.blockEnd[i] = -999999.0;
        }
        int c = -1;
        currLocus = "unknown locus";
        for (int r = 0; r < this.totalVariableSites; ++r) {
            if (!currLocus.equals(this.theAA.chromosomeName(r))) {
                this.blockNames[++c] = currLocus = this.theAA.chromosomeName(r);
            }
            if (this.blockStart[c] > (double)this.theAA.chromosomalPosition(r)) {
                this.blockStart[c] = this.theAA.chromosomalPosition(r);
            }
            if (!(this.blockEnd[c] < (double)this.theAA.chromosomalPosition(r))) continue;
            this.blockEnd[c] = this.theAA.chromosomalPosition(r);
        }
        for (int i = 0; i < this.totalBlocks; ++i) {
            if (this.chromosomalScale && this.blockEnd[i] - this.blockStart[i] < this.minimumChromosomeLength) {
                this.blockEnd[i] = this.blockStart[i] + this.minimumChromosomeLength;
                continue;
            }
            if (!(this.blockEnd[i] - this.blockStart[i] < 1.0)) continue;
            this.blockEnd[i] = this.blockStart[i] + 1.0;
        }
    }

    void calculateStartAndEndPositions() {
        double proportionPerPolymorphism;
        if (this.includeBlockSchematic) {
            proportionPerPolymorphism = 1.0 / (double)this.myWindowSize;
            this.blockBeginPos = new double[this.totalBlocks];
            this.blockEndPos = new double[this.totalBlocks];
        } else {
            this.totalIntervals = this.myWindowSize;
            proportionPerPolymorphism = 1.0 / (double)this.totalIntervals;
        }
        this.startPos = new double[this.myWindowSize];
        this.endPos = new double[this.myWindowSize];
        this.startPos[0] = 0.0;
        this.endPos[0] = 0.0;
        for (int r = 0; r < this.myWindowSize; ++r) {
            this.startPos[r] = (double)r * proportionPerPolymorphism;
        }
        if (this.includeBlockSchematic) {
            for (int b = 0; b < this.totalBlocks; ++b) {
                this.blockBeginPos[b] = (double)b / (double)this.totalBlocks;
                this.blockEndPos[b] = (double)(b + 1) / (double)this.totalBlocks;
            }
            int currB = 0;
            for (int i = 1; i < this.myXStart; ++i) {
                if (this.theAA.chromosomeName(i + this.jump[i]).equals(this.theAA.chromosomeName(i + this.jump[i] - 1))) continue;
                ++currB;
            }
            this.endPos[0] = this.blockBeginPos[currB] + ((double)this.theAA.chromosomalPosition(this.myXStart + this.jump[this.myXStart]) - this.blockStart[currB]) / (this.blockEnd[currB] - this.blockStart[currB]) / (double)this.totalBlocks;
            for (int r = this.myXStart + 1; r < this.myXEnd; ++r) {
                if (!this.theAA.chromosomeName(r + this.jump[r]).equals(this.theAA.chromosomeName(r + this.jump[r] - 1))) {
                    ++currB;
                }
                this.endPos[r - this.myXStart] = this.blockBeginPos[currB] + ((double)this.theAA.chromosomalPosition(r + this.jump[r]) - this.blockStart[currB]) / (this.blockEnd[currB] - this.blockStart[currB]) / (double)this.totalBlocks;
            }
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.red);
        this.setSize(400, 400);
    }

    private Color getMagnitudeColor(int r, int c) {
        if (r + this.myWindowX == c + this.myWindowY) {
            return Color.getHSBColor(0.999f, (float)this.diseq[r][c], 1.0f);
        }
        if (Double.isNaN(this.diseq[r][c])) {
            return Color.lightGray;
        }
        if (this.diseq[r][c] > 0.999) {
            return Color.getHSBColor(1.0f, 1.0f, 1.0f);
        }
        if (this.diseq[r][c] < -998.0) {
            return Color.lightGray;
        }
        if ((float)this.diseq[r][c] + (1.0f - (float)this.diseq[r][c]) / 2.0f < 0.52f) {
            return Color.getHSBColor((float)this.diseq[r][c] + (1.0f - (float)this.diseq[r][c]) / 2.0f - 0.5f, (float)this.diseq[r][c] + (1.0f - (float)this.diseq[r][c]) / 2.0f - 0.5f, 1.0f);
        }
        return Color.getHSBColor((float)this.diseq[r][c] + (1.0f - (float)this.diseq[r][c]) / 2.0f, (float)this.diseq[r][c] + (1.0f - (float)this.diseq[r][c]) / 2.0f, 1.0f);
    }

    private Color getProbabilityColor(int r, int c) {
        double p1 = 0.01;
        double p2 = 0.001;
        double p3 = 1.0E-4;
        if (Double.isNaN(this.diseq[r][c])) {
            return Color.lightGray;
        }
        if (this.diseq[r][c] < -998.0) {
            return Color.lightGray;
        }
        if (this.diseq[r][c] > p1) {
            return Color.white;
        }
        if (this.diseq[r][c] > p2) {
            return Color.blue;
        }
        if (this.diseq[r][c] > p3) {
            return Color.green;
        }
        return Color.red;
    }

    private void addPolymorphismLabels(Graphics g, int ih) {
        g.setFont(new Font("Dialog", 0, 9));
        g.setColor(Color.black);
        for (int c = this.myYStart; c < this.myYEnd; ++c) {
            String s = this.jump[c] != 1 ? this.theAA.chromosomeName(c + this.jump[c]) + "s" + this.theAA.chromosomalPosition(c + this.jump[c]) : "";
            g.drawString(s, 4, this.yPos[c - this.myYStart] + ih - 1);
        }
    }

    private void calculateCoordinates(Graphics gr) {
        int r;
        Dimension d = this.getSize();
        double ySize = d.height - this.voff - this.distanceBetweenGraphAndGene;
        double ihf = ySize / (double)this.myWindowSize;
        double xSize = d.width - this.hoff - this.h2off;
        double iwf = xSize / (double)this.myWindowSize;
        this.ih = (int)Math.round(ihf);
        this.iw = (int)Math.round(iwf);
        for (r = 0; r < this.myWindowSize; ++r) {
            this.xPos[r] = (int)(this.startPos[r] * xSize + (double)this.hoff);
            this.yPos[r] = (int)(this.startPos[r] * ySize + (double)this.voff);
        }
        this.xPos[this.myWindowSize] = d.width - this.h2off;
        this.yPos[this.myWindowSize] = (int)ySize + this.voff;
        if (this.includeBlockSchematic) {
            for (r = 0; r < this.myWindowSize; ++r) {
                this.xEndPos[r] = (int)Math.round(this.endPos[r] * xSize + (double)this.hoff);
            }
            this.blockBeginX = new int[this.totalBlocks];
            this.blockEndX = new int[this.totalBlocks];
            for (int b = 0; b < this.totalBlocks; ++b) {
                this.blockBeginX[b] = (int)Math.round(this.blockBeginPos[b] * xSize + (double)this.hoff);
                this.blockEndX[b] = (int)Math.round(this.blockEndPos[b] * xSize + (double)this.hoff);
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.diseq == null) {
            return;
        }
        Dimension d = this.getSize();
        this.calculateCoordinates(g);
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(Color.darkGray);
        g.fillRect(this.xPos[0], this.yPos[0], this.xPos[this.myWindowSize] - this.xPos[0], this.yPos[this.myWindowSize] - this.yPos[0] + 2);
        for (int r = this.myXStart; r < this.myXEnd; ++r) {
            int c;
            if (this.jump[r] == 1) {
                g.setColor(Color.darkGray);
                for (c = this.myYStart; c < this.myYEnd; ++c) {
                    g.fillRect(this.xPos[r - this.myXStart], this.yPos[c - this.myYStart], this.iw + 1, this.ih + 1);
                }
                continue;
            }
            for (c = this.myYStart; c < this.myYEnd; ++c) {
                if (this.jump[c] == 1) {
                    g.setColor(Color.darkGray);
                } else if (c + this.jump[c] < r + this.jump[r] && this.upperProb || c + this.jump[c] > r + this.jump[r] && this.lowerProb) {
                    g.setColor(this.getProbabilityColor(r - this.myXStart, c - this.myYStart));
                } else if (r == c) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(this.getMagnitudeColor(r - this.myXStart, c - this.myYStart));
                }
                g.fillRect(this.xPos[r - this.myXStart], this.yPos[c - this.myYStart], this.iw + 1, this.ih + 1);
            }
        }
        if (this.includeLabels) {
            this.addPolymorphismLabels(g, this.ih);
        }
        if (this.includeBlockSchematic) {
            this.addGenePicture(g, this.ih, this.iw);
        }
        this.addLegend(g);
    }

    @Override
    public void paint(Graphics g) {
        this.paintComponent(g);
    }

    private void addLegend(Graphics g) {
        Dimension d = this.getSize();
        int localX = d.width - this.h2off + 10;
        int mid = d.height / 2;
        g.setColor(Color.black);
        g.drawString(this.upperLabel, localX, 10);
        this.addLegendGraph(g, this.upperProb, localX, 20, mid - 10);
        g.setColor(Color.black);
        g.drawString(this.lowerLabel, localX, mid + 10);
        this.addLegendGraph(g, this.lowerProb, localX, mid + 20, d.height - 10);
    }

    private void addLegendGraph(Graphics g, boolean prob, int xStart, int yStart, int yEnd) {
        int currY = yStart;
        int barWidth = 10;
        if (prob) {
            int yInc = (yEnd - yStart) / 4;
            g.setColor(Color.white);
            g.fillRect(xStart, currY, barWidth, yInc);
            g.setColor(Color.black);
            g.drawRect(xStart, currY, barWidth, yInc);
            g.drawString(">0.01", xStart + barWidth + 5, currY + 10);
            g.setColor(Color.blue);
            g.fillRect(xStart, currY += yInc, barWidth, yInc);
            g.setColor(Color.black);
            g.drawRect(xStart, currY, barWidth, yInc);
            g.drawString("<0.01", xStart + barWidth + 5, currY + 10);
            g.setColor(Color.green);
            g.fillRect(xStart, currY += yInc, barWidth, yInc);
            g.setColor(Color.black);
            g.drawRect(xStart, currY, barWidth, yInc);
            g.drawString("<0.001", xStart + barWidth + 5, currY + 10);
            g.setColor(Color.red);
            g.fillRect(xStart, currY += yInc, barWidth, yInc);
            g.setColor(Color.black);
            g.drawRect(xStart, currY, barWidth, yInc);
            g.drawString("<0.0001", xStart + barWidth + 5, currY + 10);
        } else {
            int yInc = (yEnd - yStart) / 11;
            DecimalFormat dF = new DecimalFormat("0.00");
            for (double d = 1.0; d >= 0.5; d -= 0.05) {
                g.setColor(Color.getHSBColor((float)d, (float)d, 1.0f));
                g.fillRect(xStart, currY, barWidth, yInc);
                g.setColor(Color.black);
                g.drawRect(xStart, currY, barWidth, yInc);
                g.drawString(dF.format(d - ((double)1.0001f - d)), xStart + barWidth + 5, currY + 10);
                currY += yInc;
            }
            g.setColor(Color.getHSBColor(0.0f, 0.0f, 1.0f));
            g.fillRect(xStart, currY, barWidth, yInc);
            g.setColor(Color.black);
            g.drawRect(xStart, currY, barWidth, yInc);
            g.drawString(dF.format(0.0), xStart + barWidth + 5, currY + 10);
        }
    }

    private void addGenePicture(Graphics g, int ih, int iw) {
        int halfIW = iw / 2;
        Dimension d = this.getSize();
        int yOfLinkBlock = this.yPos[this.myWindowSize];
        int yOfGene = yOfLinkBlock + this.distanceBetweenGraphAndGene / 2;
        int yOfGeneLabel = yOfLinkBlock + (int)((double)0.8f * (double)this.distanceBetweenGraphAndGene);
        for (int r = 0; r < this.myWindowSize; ++r) {
            if (this.jump[r + this.myXStart] == 1) continue;
            g.drawLine(this.xPos[r] + halfIW, yOfLinkBlock + 1, this.xEndPos[r], yOfGene);
        }
        for (int b = 0; b < this.totalBlocks; ++b) {
            g.setColor(this.iterColor(b));
            g.drawLine(this.blockBeginX[b], yOfGene, this.blockEndX[b], yOfGene);
            g.drawLine(this.blockBeginX[b], yOfGene + 1, this.blockEndX[b], yOfGene + 1);
            g.drawString(this.blockNames[b], this.blockBeginX[b], yOfGeneLabel);
        }
    }

    private Color iterColor(int iter) {
        Color newColor = iter % 5 == 0 ? Color.blue : (iter % 5 == 1 ? Color.red : (iter % 5 == 2 ? Color.green : (iter % 5 == 3 ? Color.cyan : Color.orange)));
        return newColor;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point graphPoint = this.getLocationOnScreen();
        Point mousePoint = e.getLocationOnScreen();
        double graphX = graphPoint.getX();
        double graphY = graphPoint.getY();
        double mouseX = mousePoint.getX() - graphX;
        double mouseY = mousePoint.getY() - graphY;
        DecimalFormat format = new DecimalFormat("0.###E0");
        for (int r = this.myXStart; r < this.myXEnd; ++r) {
            if (this.jump[r] == 1 || !(mouseX > (double)this.xPos[r - this.myXStart]) || !(mouseX < (double)this.xPos[r - this.myXStart + 1])) continue;
            for (int c = this.myYStart; c < this.myYEnd; ++c) {
                if (this.jump[c] == 1 || !(mouseY > (double)this.yPos[c - this.myYStart]) || !(mouseY < (double)this.yPos[c - this.myYStart + 1])) continue;
                return this.theAA.siteName(r + this.jump[r]) + ": " + this.theAA.chromosomalPosition(r + this.jump[r]) + ", " + this.theAA.siteName(c + this.jump[c]) + ": " + this.theAA.chromosomalPosition(c + this.jump[c]) + ", Value: " + format.format(this.diseq[r - this.myXStart][c - this.myYStart]);
            }
        }
        return null;
    }

    public void setGraphSize(int graphX, int graphY) {
        this.setPreferredSize(new Dimension(graphX, graphY));
        this.setSize(new Dimension(graphX, graphY));
    }
}

