/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.popgen;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.maizegenetics.analysis.popgen.LinkageDiseqDialog;
import net.maizegenetics.analysis.popgen.LinkageDisequilibrium;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.Plugin;
import net.maizegenetics.plugindef.PluginEvent;
import org.apache.log4j.Logger;

public class LinkageDisequilibriumPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(LinkageDisequilibriumPlugin.class);
    private boolean myIsRapidAnalysis = true;
    private int myPermutationNumber = 1000;
    private int myWindowSize = 50;
    private LinkageDisequilibrium.testDesign myLDType = LinkageDisequilibrium.testDesign.SlidingWindow;
    private int myTestSite = -1;
    private String myTestSiteName = null;
    private int myNumAccumulateIntervals = 100;
    private boolean myIsAccumulateResults = false;
    private GenotypeTable myPossibleAlignmentForSiteList;
    private String myPossibleAlignmentName;
    private int[] myPossibleSiteList;
    private LinkageDisequilibrium.HetTreatment myHetTreatment = LinkageDisequilibrium.HetTreatment.Homozygous;

    public LinkageDisequilibriumPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet performFunction(DataSet input) {
        try {
            GenotypeTable temp;
            List<Datum> alignInList = input.getDataOfType(GenotypeTable.class);
            if (alignInList.size() < 1) {
                JOptionPane.showMessageDialog(this.getParentFrame(), "Invalid selection.  Please select sequence or marker alignment.");
                DataSet dataSet = null;
                return dataSet;
            }
            Datum current = alignInList.get(0);
            if (alignInList.size() > 1 && alignInList.get(1).getData() instanceof GenotypeTable && (temp = (GenotypeTable)alignInList.get(1).getData()).hasSiteTranslations()) {
                this.myPossibleAlignmentForSiteList = temp;
                this.myPossibleAlignmentName = alignInList.get(1).getName();
            }
            if (this.isInteractive()) {
                LinkageDiseqDialog myDialog = new LinkageDiseqDialog(((GenotypeTable)current.getData()).numberOfSites(), this.myPossibleAlignmentName);
                myDialog.setLocationRelativeTo(this.getParentFrame());
                myDialog.setVisible(true);
                if (myDialog.isCancel()) {
                    DataSet dataSet = null;
                    return dataSet;
                }
                this.myLDType = myDialog.getLDType();
                if (this.myLDType == LinkageDisequilibrium.testDesign.SlidingWindow) {
                    this.myWindowSize = myDialog.getWindowSize();
                }
                this.myIsAccumulateResults = myDialog.isAccumulateResults();
                if (this.myIsAccumulateResults) {
                    this.myNumAccumulateIntervals = myDialog.getNumAccumulateIntervals();
                }
                if (this.myLDType == LinkageDisequilibrium.testDesign.SiteByAll) {
                    this.myTestSite = myDialog.getTestSite();
                }
                if (this.myLDType == LinkageDisequilibrium.testDesign.SiteList) {
                    this.myPossibleSiteList = this.myPossibleAlignmentForSiteList.siteTranslations();
                }
                this.myHetTreatment = myDialog.getHetTreatment();
            }
            ArrayList<DataSet> result = new ArrayList<DataSet>();
            DataSet tds = null;
            tds = this.processDatum(current);
            if (tds != null) {
                result.add(tds);
                this.fireDataSetReturned(new PluginEvent(tds, LinkageDisequilibriumPlugin.class));
            }
            DataSet dataSet = DataSet.getDataSet(result, this);
            return dataSet;
        }
        finally {
            this.fireProgress(100);
        }
    }

    private DataSet processDatum(Datum input) {
        GenotypeTable aa = (GenotypeTable)input.getData();
        try {
            if (this.myTestSiteName != null) {
                this.setTestSiteFromName(aa);
            }
            LinkageDisequilibrium theLD = new LinkageDisequilibrium(aa, this.myWindowSize, this.myLDType, this.myTestSite, this, this.myIsAccumulateResults, this.myNumAccumulateIntervals, this.myPossibleSiteList, this.myHetTreatment);
            theLD.run();
            Datum td = new Datum("LD:" + input.getName(), theLD, "LD Analysis");
            DataSet tds = new DataSet(td, (Plugin)this);
            return tds;
        }
        catch (Exception e) {
            myLogger.error((Object)e.getMessage(), (Throwable)e);
            StringBuilder builder = new StringBuilder();
            builder.append("Unable to run Linkage Disequilibrium analysis ");
            builder.append(e.getMessage());
            String str = builder.toString();
            if (this.isInteractive()) {
                JOptionPane.showMessageDialog(this.getParentFrame(), str);
            } else {
                myLogger.error((Object)("processDatum: " + str));
            }
            return null;
        }
    }

    public boolean isRapidAnalysis() {
        return this.myIsRapidAnalysis;
    }

    public void setRapidAnalysis(boolean rapidAnalysis) {
        this.myIsRapidAnalysis = rapidAnalysis;
    }

    public int isPermutationNumber() {
        return this.myPermutationNumber;
    }

    public void setPermutationNumber(int permutationNumber) {
        this.myPermutationNumber = permutationNumber;
    }

    public void setLDType(LinkageDisequilibrium.testDesign type) {
        this.myLDType = type;
    }

    public LinkageDisequilibrium.testDesign getLDType() {
        return this.myLDType;
    }

    public void setWinSize(int winSize) {
        this.myWindowSize = winSize;
    }

    public int getWinSize() {
        return this.myWindowSize;
    }

    public void setNumAccumulateIntervals(int numIntervals) {
        this.myNumAccumulateIntervals = numIntervals;
    }

    public int getNumAccumulateIntervals() {
        return this.myNumAccumulateIntervals;
    }

    public void setIsAccumulateResults(boolean accumulate) {
        this.myIsAccumulateResults = accumulate;
    }

    public boolean getIsAccumulateResults() {
        return this.myIsAccumulateResults;
    }

    public void setTestSite(int site) {
        this.myTestSite = site;
    }

    public int getTestSite() {
        return this.myTestSite;
    }

    public void setTestSiteName(String siteName) {
        this.myTestSiteName = siteName;
    }

    public String getTestSiteName() {
        return this.myTestSiteName;
    }

    public void setHetTreatment(LinkageDisequilibrium.HetTreatment treatment) {
        this.myHetTreatment = treatment;
    }

    public LinkageDisequilibrium.HetTreatment getHetTreatment() {
        return this.myHetTreatment;
    }

    private void setTestSiteFromName(GenotypeTable aa) {
        int[] matches = IntStream.range(0, aa.numberOfSites()).filter(i -> aa.siteName(i).equals(this.myTestSiteName)).toArray();
        if (matches.length == 0) {
            throw new IllegalArgumentException("Error: No sites match supplied name of " + this.myTestSiteName);
        }
        if (matches.length > 1) {
            throw new IllegalArgumentException("Error: " + matches.length + " sites match supplied name of " + this.myTestSiteName);
        }
        this.myTestSite = matches[0];
    }

    @Override
    public ImageIcon getIcon() {
        URL imageURL = LinkageDisequilibriumPlugin.class.getResource("/net/maizegenetics/analysis/images/LDPlot.gif");
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public String getButtonName() {
        return "Linkage Disequilibrium";
    }

    @Override
    public String getToolTipText() {
        return "Linkage Disequilibrium";
    }
}

