/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.analysis.rna;

import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import java.awt.Frame;
import java.io.BufferedReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.ImageIcon;
import net.maizegenetics.analysis.gbs.v2.EnzymeList;
import net.maizegenetics.analysis.gbs.v2.GBSUtils;
import net.maizegenetics.analysis.rna.FindMatchByWordHash;
import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.tag.TagDataSQLite;
import net.maizegenetics.dna.tag.TagDataWriter;
import net.maizegenetics.plugindef.AbstractPlugin;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.plugindef.Datum;
import net.maizegenetics.plugindef.GeneratePluginCode;
import net.maizegenetics.plugindef.PluginParameter;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListIOUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.DirectoryCrawler;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class RNADeMultiplexProductionPlugin
extends AbstractPlugin {
    private static final Logger myLogger = Logger.getLogger(RNADeMultiplexProductionPlugin.class);
    private PluginParameter<String> myInputDir = new PluginParameter.Builder<String>("i", null, String.class).guiName("Input Directory").required(true).inDir().description("Input directory containing fastq AND/OR qseq files.").build();
    private PluginParameter<String> myKeyFile = new PluginParameter.Builder<String>("k", null, String.class).guiName("Key File").required(true).inFile().description("Key file listing barcodes distinguishing the samples").build();
    private PluginParameter<String> myInputDB = new PluginParameter.Builder<String>("db", null, String.class).guiName("Input GBS Database").required(true).inFile().description("Input Database file if using SQLite").build();
    private PluginParameter<FindMatchByWordHash.MatchType> myMatchingType = new PluginParameter.Builder<FindMatchByWordHash.MatchType>("matchType", null, FindMatchByWordHash.MatchType.class).guiName("Matching approach").required(true).range((Range<Comparable<FindMatchByWordHash.MatchType>>)Range.encloseAll(Arrays.asList(FindMatchByWordHash.MatchType.values()))).description("Approach used for matching the reads to the contigs").build();
    private PluginParameter<Integer> myWordSizeMatching = new PluginParameter.Builder<Integer>("word", 16, Integer.class).guiName("Word size used by match").description("Word size used to find matches with reference sequences").build();
    private PluginParameter<Integer> myMaxWordRepeats = new PluginParameter.Builder<Integer>("wordRep", 10, Integer.class).guiName("Maximum repeats of word").description("Maximum repetitiveness of the word").build();
    private PluginParameter<Boolean> mySearchReverseComplement = new PluginParameter.Builder<Boolean>("searchRevComp", true, Boolean.class).guiName("Search reverse complement").description("Search of the reverse complements of the reference sequences").build();
    private PluginParameter<Integer> myBatchSize = new PluginParameter.Builder<Integer>("batchSize", 8, Integer.class).guiName("Batch size of fastq files").required(false).description("Number of flow cells being processed simultaneously").build();
    private PluginParameter<Integer> myMinQualScore = new PluginParameter.Builder<Integer>("mnQS", 0, Integer.class).guiName("Minimum quality score").required(false).description("Minimum quality score within the barcode and read length to be accepted").build();
    private TagDataWriter tdw = null;
    private Map<String, int[]> taxatissueCntMap;
    private FindMatchByWordHash findMatchByWordHash;
    protected static int readEndCutSiteRemnantLength;
    private static String myEnzyme;
    private static int maxTaxa;
    private static int maxTissue;
    private boolean taglenException;

    public RNADeMultiplexProductionPlugin() {
        super(null, false);
    }

    public RNADeMultiplexProductionPlugin(Frame parentFrame, boolean isInteractive) {
        super(parentFrame, isInteractive);
    }

    @Override
    public void postProcessParameters() {
        EnzymeList.Enzyme enzyme = EnzymeList.defaultCache.getEnzyme(myEnzyme);
        readEndCutSiteRemnantLength = enzyme.readEndCutSiteRemnantLength;
    }

    @Override
    public DataSet processData(DataSet input) {
        int batchSize = this.batchSize();
        List<Path> directoryFiles = DirectoryCrawler.listPaths("glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}", Paths.get(this.myInputDir.value(), new String[0]).toAbsolutePath());
        if (directoryFiles.isEmpty()) {
            myLogger.warn((Object)"No files matching:glob:*{.fq,fq.gz,fastq,fastq.txt,fastq.gz,fastq.txt.gz,_sequence.txt,_sequence.txt.gz}");
            return null;
        }
        List<Path> inputSeqFiles = directoryFiles;
        this.tdw = new TagDataSQLite(this.myInputDB.value());
        TaxaList masterTaxaList = TaxaListIOUtils.readTaxaAnnotationFile(this.keyFile(), "FullSampleName", new HashMap<String, String>(), true);
        Multimap<String, Taxon> temp = TaxaListIOUtils.getMapOfTaxonByAnnotation(masterTaxaList, "FileName");
        HashMap fileToTaxonMap = new HashMap();
        temp.entries().stream().forEach(entries -> {
            Taxon t = (Taxon)fileToTaxonMap.put(entries.getKey(), entries.getValue());
            if (t != null) {
                System.err.println("Duplicate file");
            }
        });
        ArrayList masterTissueList = (ArrayList)TaxaListIOUtils.readTissueAnnotationFile(this.keyFile(), "Tissue");
        this.tdw.putTaxaList(masterTaxaList);
        this.tdw.putAllTissue(masterTissueList);
        maxTaxa = masterTaxaList.size();
        maxTissue = masterTissueList.size();
        this.findMatchByWordHash = FindMatchByWordHash.getBuilder(this.tdw.getTags()).matchType(this.matchingType()).wordLength(this.wordSizeMatching()).maxWordCopies(this.maxWordRepeats()).searchBiDirectional(this.searchReverseComplement()).build();
        this.taxatissueCntMap = new ConcurrentHashMap<String, int[]>(maxTissue * maxTaxa * 2);
        int batchNum = inputSeqFiles.size() / batchSize;
        if (inputSeqFiles.size() % batchSize != 0) {
            ++batchNum;
        }
        System.out.println("RNADeMultiplexProductionPlugin: Total batches to process: " + batchNum);
        this.taglenException = false;
        for (int idx = 0; idx < inputSeqFiles.size(); idx += batchSize) {
            int end = idx + batchSize;
            if (end > inputSeqFiles.size()) {
                end = inputSeqFiles.size();
            }
            ArrayList<Path> sub = new ArrayList<Path>();
            for (int jdx = idx; jdx < end; ++jdx) {
                sub.add(inputSeqFiles.get(jdx));
            }
            System.out.println("\nStart processing batch " + String.valueOf(idx / batchSize + 1));
            sub.parallelStream().forEach(inputSeqFile -> {
                try {
                    if (fileToTaxonMap.get(inputSeqFile.getFileName().toString()) == null) {
                        return;
                    }
                    this.processFastQ((Path)inputSeqFile, (Taxon)fileToTaxonMap.get(inputSeqFile.getFileName().toString()), this.minQualScore());
                }
                catch (StringIndexOutOfBoundsException oobe) {
                    oobe.printStackTrace();
                    myLogger.error((Object)oobe.getMessage());
                    this.setTagLenException();
                    return;
                }
            });
            if (this.taglenException) {
                return null;
            }
            System.out.println("\nFinished processing batch " + String.valueOf(idx / batchSize + 1));
        }
        this.taxatissueCntMap.entrySet().stream().forEach(entry -> {
            String[] taxaTissueNames = ((String)entry.getKey()).split(",");
            this.tdw.putTaxaTissueDistribution(taxaTissueNames[0], taxaTissueNames[1], this.findMatchByWordHash.getTags(), (int[])entry.getValue());
        });
        return new DataSet(new Datum("DB Name", this.inputDB(), ""), null);
    }

    private void processFastQ(Path fastqFile, Taxon taxon, int minQual) throws StringIndexOutOfBoundsException {
        String tissuetaxaKey = taxon.getName() + "," + taxon.getAnnotation().getTextAnnotation("Tissue")[0];
        this.taxatissueCntMap.putIfAbsent(tissuetaxaKey, new int[this.findMatchByWordHash.totalNumberOfTags()]);
        int allReads = 0;
        int readsMatchedToContigs = 0;
        int lowQualityReads = 0;
        boolean shortReads = false;
        try {
            String[] seqAndQual;
            int qualityScoreBase = GBSUtils.determineQualityScoreBase(fastqFile);
            BufferedReader br = Utils.getBufferedReader(fastqFile.toString(), 0x400000);
            long time = System.nanoTime();
            String likelyReadEnd = "AGATCGGA";
            while ((seqAndQual = GBSUtils.readDeMultiPlexFastQBlock(br, allReads)) != null) {
                ++allReads;
                int adapterStart = 0;
                String sequence = seqAndQual[0];
                adapterStart = sequence.indexOf(likelyReadEnd);
                if (adapterStart > 0) {
                    sequence = sequence.substring(0, adapterStart - 1);
                }
                if (minQual > 0 && BaseEncoder.getFirstLowQualityPos(seqAndQual[1], minQual, qualityScoreBase) < sequence.length()) {
                    ++lowQualityReads;
                    continue;
                }
                FindMatchByWordHash.Match hitIndex = this.findMatchByWordHash.match(sequence);
                if (hitIndex.isEmpty()) continue;
                ++readsMatchedToContigs;
                int[] nArray = this.taxatissueCntMap.get(tissuetaxaKey);
                int n = hitIndex.tagIndex();
                nArray[n] = nArray[n] + 1;
            }
            myLogger.info((Object)("Total number of reads in FASTQ file=" + allReads + " rate:" + (System.nanoTime() - time) / (long)allReads + " ns/read"));
            myLogger.info((Object)("Total number of reads matched to <= " + this.maxWordRepeats() + " contigs/genes=" + readsMatchedToContigs + " (adjust upper limit using maxWordRepeats)"));
            myLogger.info((Object)("Total number of rejected low quality reads and reads with non-AGCT bases=" + lowQualityReads));
            myLogger.info((Object)"Timing process (sorting, collapsing, and writing TagCount to file).");
            myLogger.info((Object)("Process took " + (double)(System.nanoTime() - time) / 1.0E9 + " seconds for file " + fastqFile.toString()));
            br.close();
        }
        catch (Exception e) {
            myLogger.error((Object)("Matched reads: " + readsMatchedToContigs));
            e.printStackTrace();
        }
    }

    public void setTagLenException() {
        this.taglenException = true;
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getButtonName() {
        return "RNA Production Counter";
    }

    @Override
    public String getToolTipText() {
        return "RNA Production Counter";
    }

    public static void main(String[] args) {
        GeneratePluginCode.generate(RNADeMultiplexProductionPlugin.class);
    }

    public String runPlugin(DataSet input) {
        return (String)this.performFunction(input).getData(0).getData();
    }

    public String inputDir() {
        return this.myInputDir.value();
    }

    public RNADeMultiplexProductionPlugin inputDir(String value) {
        this.myInputDir = new PluginParameter<String>(this.myInputDir, value);
        return this;
    }

    public String keyFile() {
        return this.myKeyFile.value();
    }

    public RNADeMultiplexProductionPlugin keyFile(String value) {
        this.myKeyFile = new PluginParameter<String>(this.myKeyFile, value);
        return this;
    }

    public String inputDB() {
        return this.myInputDB.value();
    }

    public RNADeMultiplexProductionPlugin inputDB(String value) {
        this.myInputDB = new PluginParameter<String>(this.myInputDB, value);
        return this;
    }

    public FindMatchByWordHash.MatchType matchingType() {
        return this.myMatchingType.value();
    }

    public RNADeMultiplexProductionPlugin matchingType(FindMatchByWordHash.MatchType value) {
        this.myMatchingType = new PluginParameter<FindMatchByWordHash.MatchType>(this.myMatchingType, value);
        return this;
    }

    public Integer wordSizeMatching() {
        return this.myWordSizeMatching.value();
    }

    public RNADeMultiplexProductionPlugin wordSizeMatching(Integer value) {
        this.myWordSizeMatching = new PluginParameter<Integer>(this.myWordSizeMatching, value);
        return this;
    }

    public Integer maxWordRepeats() {
        return this.myMaxWordRepeats.value();
    }

    public RNADeMultiplexProductionPlugin maxWordRepeats(Integer value) {
        this.myMaxWordRepeats = new PluginParameter<Integer>(this.myMaxWordRepeats, value);
        return this;
    }

    public Boolean searchReverseComplement() {
        return this.mySearchReverseComplement.value();
    }

    public RNADeMultiplexProductionPlugin searchReverseComplement(Boolean value) {
        this.mySearchReverseComplement = new PluginParameter<Boolean>(this.mySearchReverseComplement, value);
        return this;
    }

    public Integer batchSize() {
        return this.myBatchSize.value();
    }

    public RNADeMultiplexProductionPlugin batchSize(Integer value) {
        this.myBatchSize = new PluginParameter<Integer>(this.myBatchSize, value);
        return this;
    }

    public Integer minQualScore() {
        return this.myMinQualScore.value();
    }

    public RNADeMultiplexProductionPlugin minQualScore(Integer value) {
        this.myMinQualScore = new PluginParameter<Integer>(this.myMinQualScore, value);
        return this;
    }

    static {
        myEnzyme = "ignore";
    }
}

