/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna;

public class BaseEncoder {
    public static final int chunkSize = 32;
    public static final int chunkSizeForInt = 16;
    public static final char[] bases = new char[]{'A', 'C', 'G', 'T'};

    private BaseEncoder() {
    }

    public static long getLongFromSeq(String seq) {
        int seqLength = seq.length();
        long v = 0L;
        block6: for (int i = 0; i < seqLength; ++i) {
            switch (seq.charAt(i)) {
                case 'A': 
                case 'a': {
                    v <<= 2;
                    continue block6;
                }
                case 'C': 
                case 'c': {
                    v = (v << 2) + 1L;
                    continue block6;
                }
                case 'G': 
                case 'g': {
                    v = (v << 2) + 2L;
                    continue block6;
                }
                case 'T': 
                case 't': {
                    v = (v << 2) + 3L;
                    continue block6;
                }
                default: {
                    return -1L;
                }
            }
        }
        if (seqLength == 32) {
            return v;
        }
        if (seqLength > 32) {
            return -1L;
        }
        return v <<= 2 * (32 - seqLength);
    }

    public static long[] getLongArrayFromSeq(String seq) {
        if (seq.length() % 32 != 0) {
            return null;
        }
        long[] result = new long[seq.length() / 32];
        for (int i = 0; i < result.length; ++i) {
            result[i] = BaseEncoder.getLongFromSeq(seq.substring(i * 32, (i + 1) * 32));
        }
        return result;
    }

    public static long[] getLongArrayFromSeq(String seq, int paddedLength) {
        if (seq.length() < paddedLength) {
            seq = seq + "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA".substring(0, paddedLength - seq.length());
        }
        return BaseEncoder.getLongArrayFromSeq(seq);
    }

    public static int getIntFromSeq(String seq) {
        int chunkSize = 16;
        int seqLength = seq.length();
        int v = 0;
        block6: for (int i = 0; i < seqLength; ++i) {
            switch (seq.charAt(i)) {
                case 'A': 
                case 'a': {
                    v <<= 2;
                    continue block6;
                }
                case 'C': 
                case 'c': {
                    v = (v << 2) + 1;
                    continue block6;
                }
                case 'G': 
                case 'g': {
                    v = (v << 2) + 2;
                    continue block6;
                }
                case 'T': 
                case 't': {
                    v = (v << 2) + 3;
                    continue block6;
                }
                default: {
                    return -1;
                }
            }
        }
        if (seqLength == chunkSize) {
            return v;
        }
        if (seqLength > chunkSize) {
            return -1;
        }
        return v;
    }

    public static long getReverseComplement(long seq, byte len) {
        long rev = 0L;
        long mask = 3L;
        seq ^= 0xFFFFFFFFFFFFFFFFL;
        for (int i = 0; i < len; ++i) {
            rev = (rev << 2) + (seq & mask);
            seq >>= 2;
        }
        return rev;
    }

    public static long getReverseComplement(long seq) {
        return BaseEncoder.getReverseComplement(seq, (byte)32);
    }

    public static long[] getReverseComplement(long[] seq) {
        long[] rev = new long[seq.length];
        for (int i = 0; i < rev.length; ++i) {
            rev[i] = BaseEncoder.getReverseComplement(seq[seq.length - i - 1], (byte)32);
        }
        return rev;
    }

    public static String getReverseComplement(String seq) {
        StringBuilder sb = new StringBuilder(seq.length());
        for (int i = seq.length() - 1; i >= 0; --i) {
            sb.append(BaseEncoder.getComplementBase(seq.charAt(i)));
        }
        return sb.toString();
    }

    public static char getComplementBase(char base) {
        switch (base) {
            case 'A': {
                return 'T';
            }
            case 'C': {
                return 'G';
            }
            case 'G': {
                return 'C';
            }
            case 'T': {
                return 'A';
            }
        }
        return 'N';
    }

    public static byte[] getByteSeqFromLong(long val) {
        byte[] b = new byte[32];
        long mask = 3L;
        for (int i = 0; i < 32; ++i) {
            b[32 - i - 1] = (byte)(val & mask);
            val >>= 2;
        }
        return b;
    }

    public static byte[] getByteSeqFromLong(long[] valA) {
        byte[] b = new byte[32 * valA.length];
        long mask = 3L;
        for (int j = 0; j < valA.length; ++j) {
            long val = valA[j];
            for (int i = 0; i < 32; ++i) {
                b[j * 32 + 32 - i - 1] = (byte)(val & mask);
                val >>= 2;
            }
        }
        return b;
    }

    public static long getLongSeqFromByteArray(byte[] b) {
        long v = 0L;
        if (b.length > 32) {
            return -1L;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] > 3) {
                return -1L;
            }
            v = (v << 2) + (long)b[i];
        }
        return v <<= 2 * (32 - b.length);
    }

    public static String getSequenceFromLong(long val, byte len) {
        StringBuilder seq = new StringBuilder(36);
        long mask = -4611686018427387904L;
        for (int i = 0; i < len; ++i) {
            byte base = (byte)((val & mask) >> 62 & 3L);
            seq.append(bases[base]);
            val <<= 2;
        }
        return seq.toString();
    }

    public static String getSequenceFromLong(long[] val) {
        StringBuilder seq = new StringBuilder();
        for (long v : val) {
            seq.append(BaseEncoder.getSequenceFromLong(v));
        }
        return seq.toString();
    }

    public static int[] getIntFromLong(long val) {
        int[] ival = new int[]{(int)(val >> 32), (int)val};
        return ival;
    }

    public static String getSequenceFromInt(int val) {
        StringBuilder seq = new StringBuilder(17);
        long mask = 3L;
        for (int i = 0; i < 16; ++i) {
            byte base = (byte)((long)val & mask);
            seq.insert(0, bases[base]);
            val >>= 2;
        }
        return seq.toString();
    }

    public static int getFirstLowQualityPos(String quality, int minQual) {
        int qualInt = 0;
        for (int i = 0; i < quality.length(); ++i) {
            qualInt = quality.charAt(i) - 64;
            if (qualInt >= minQual) continue;
            return i;
        }
        return quality.length();
    }

    public static int getFirstLowQualityPos(String quality, int minQual, int qualBase) {
        int qualInt = 0;
        for (int i = 0; i < quality.length(); ++i) {
            qualInt = quality.charAt(i) - qualBase;
            if (qualInt >= minQual) continue;
            return i;
        }
        return quality.length();
    }

    public static String getSequenceFromLong(long val) {
        return BaseEncoder.getSequenceFromLong(val, (byte)32);
    }

    public static byte seqDifferences(long seq1, long seq2, int maxDivergence) {
        long mask = 3L;
        byte cnt = 0;
        long diff = seq1 ^ seq2;
        for (int x = 0; x < 32 && cnt <= maxDivergence; ++x) {
            if ((diff & mask) > 0L) {
                cnt = (byte)(cnt + 1);
            }
            diff >>= 2;
        }
        if (cnt > maxDivergence) {
            cnt = 32;
        }
        return cnt;
    }

    public static byte seqDifferences(long seq1, long seq2) {
        long mask = 3L;
        byte cnt = 0;
        long diff = seq1 ^ seq2;
        for (int x = 0; x < 32; ++x) {
            if ((diff & mask) > 0L) {
                cnt = (byte)(cnt + 1);
            }
            diff >>= 2;
        }
        return cnt;
    }

    public static byte seqDifferencesForSubset(long seq1, long seq2, int lengthOfComp, int maxDivergence) {
        long mask = 3L;
        int cnt = 0;
        long diff = seq1 ^ seq2;
        diff >>= 2 * (32 - lengthOfComp);
        for (int x = 0; x < lengthOfComp && cnt < maxDivergence; ++x) {
            if ((diff & mask) > 0L) {
                cnt = (byte)(cnt + 1);
            }
            diff >>= 2;
        }
        return (byte)cnt;
    }

    public static String removePolyAFromEnd(String s) {
        int index = s.length() - 1;
        while (s.charAt(index) == 'A') {
            if (--index >= 1) continue;
            return null;
        }
        return s.substring(0, index + 1);
    }
}

