/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import com.google.common.collect.RangeMap;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GVCFGenomeSequence;
import net.maizegenetics.dna.map.GVCFPositionRecord;
import net.maizegenetics.dna.map.GenomeSequence;
import net.maizegenetics.dna.map.GenomeSequenceBuilder;
import net.maizegenetics.dna.map.HalfByteGenomeSequenceGVCF;
import net.maizegenetics.dna.map.HeaderPositions;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionArrayList;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.GeneralAnnotationStorage;
import net.maizegenetics.util.Utils;

public class GVCFGenomeSequenceBuilder
extends GenomeSequenceBuilder {
    private static final Pattern TAB_PATTERN = Pattern.compile("[\\t]+");

    public static GenomeSequence instance(String fastaFileName, String gvcfFileName) throws Exception {
        Function<Character, Character> charConversion = c -> c;
        return GVCFGenomeSequenceBuilder.instance(fastaFileName, charConversion, gvcfFileName);
    }

    public static GenomeSequence instance(String fastaFileName, Function<Character, Character> charConversion, String gvcfFileName) throws Exception {
        long chrPosMapStartTime = System.currentTimeMillis();
        Map<Chromosome, byte[]> chromPositionMap = GVCFGenomeSequenceBuilder.readReferenceGenomeChr(fastaFileName, charConversion);
        System.out.println("Done Reading in Reference: Total Time Taken: " + (System.currentTimeMillis() - chrPosMapStartTime) + "ms");
        System.out.println("Generating Position List");
        long startTime = System.currentTimeMillis();
        PositionList gvcfPositionsAndAnnotations = GVCFGenomeSequenceBuilder.readGVCFFilePositionList(gvcfFileName);
        System.out.println("Done Creating Pos list. Total Time Taken: " + (System.currentTimeMillis() - startTime) + "ms");
        return new HalfByteGenomeSequenceGVCF(chromPositionMap, gvcfPositionsAndAnnotations);
    }

    public static GenomeSequence instance(GVCFGenomeSequence base, BitSet maskedBitSet, BitSet filteredBitSet) throws Exception {
        return new HalfByteGenomeSequenceGVCF(base.getChrPosMap(), base.getGVCFPositions(), maskedBitSet, filteredBitSet);
    }

    private static Map<Chromosome, RangeMap<Integer, GeneralAnnotationStorage>> readGVCFFile(String gvcfFileName) {
        HashMap<Chromosome, RangeMap<Integer, GeneralAnnotationStorage>> chromosomeRangeMapHashMap = new HashMap<Chromosome, RangeMap<Integer, GeneralAnnotationStorage>>();
        return chromosomeRangeMapHashMap;
    }

    private static PositionList readGVCFFilePositionList(String gvcfFileName) throws Exception {
        ArrayList<Position> positionArrayList = new ArrayList<Position>();
        BufferedReader gvcfFileReader = Utils.getBufferedReader(gvcfFileName, -1);
        String currentLine = "";
        while (!(currentLine = gvcfFileReader.readLine()).startsWith("#CHROM")) {
        }
        String[] header = TAB_PATTERN.split(currentLine);
        HeaderPositions hp = new HeaderPositions(header);
        GVCFPositionRecord gvcfPositionRecord = new GVCFPositionRecord(hp);
        while ((currentLine = gvcfFileReader.readLine()) != null) {
            positionArrayList.add(gvcfPositionRecord.parseGVCFRecords(currentLine));
        }
        PositionArrayList instance = new PositionArrayList(positionArrayList, "AGPv4");
        return instance;
    }
}

