/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import com.google.common.base.Splitter;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.HeaderPositions;
import net.maizegenetics.dna.map.Position;

class GVCFPositionRecord {
    GeneralPosition ap = new GeneralPosition.Builder(new Chromosome("1"), 1232).maf(0.05f).build();
    HeaderPositions hp;

    public GVCFPositionRecord(HeaderPositions hp) {
        this.hp = hp;
    }

    public Position parseGVCFRecords(String input) {
        int[] tabPos = new int[this.hp.NUM_HAPMAP_NON_TAXA_HEADERS + 1];
        int tabIndex = 0;
        int len = input.length();
        for (int i = 0; tabIndex < this.hp.NUM_HAPMAP_NON_TAXA_HEADERS + 1 && i < len; ++i) {
            if (input.charAt(i) != '\t') continue;
            tabPos[tabIndex++] = i;
        }
        String chrName = input.substring(0, tabPos[this.hp.CHROMOSOME_INDEX]);
        Chromosome currChr = new Chromosome(new String(chrName));
        String snpID = null;
        if (this.hp.SNPID_INDEX > 0) {
            snpID = input.substring(tabPos[this.hp.SNPID_INDEX - 1] + 1, tabPos[this.hp.SNPID_INDEX]);
        }
        GeneralPosition.Builder apb = new GeneralPosition.Builder(currChr, Integer.parseInt(input.substring(tabPos[this.hp.POSITION_INDEX - 1] + 1, tabPos[this.hp.POSITION_INDEX])));
        if (snpID != null && !snpID.equals(".")) {
            apb.snpName(snpID);
        }
        String refS = input.substring(tabPos[this.hp.REF_INDEX - 1] + 1, tabPos[this.hp.REF_INDEX]);
        String alt = input.substring(tabPos[this.hp.ALT_INDEX - 1] + 1, tabPos[this.hp.ALT_INDEX]);
        String allAlleles = refS + "/" + alt.replace(",", "/");
        apb = apb.knownVariants(allAlleles);
        for (String annoS : Splitter.on((String)";").split((CharSequence)input.substring(tabPos[this.hp.INFO_INDEX - 1] + 1, tabPos[this.hp.INFO_INDEX]))) {
            apb.addAnno(annoS);
        }
        boolean iGT = false;
        int iAD = -1;
        int iDP = -1;
        int iGQ = -1;
        int iPL = -1;
        if (this.hp.FORMAT_INDEX >= 0) {
            if (tabPos[this.hp.FORMAT_INDEX] == 0) {
                throw new IllegalStateException("Error Processing VCF: Missing FORMAT tag.");
            }
            String unsplitInput = input.substring(tabPos[this.hp.FORMAT_INDEX - 1] + 1, tabPos[this.hp.FORMAT_INDEX]);
            if (unsplitInput.length() == 0 || !unsplitInput.startsWith("GT")) {
                if (unsplitInput.contains("GT")) {
                    throw new IllegalStateException("Error Processing VCF Block: GT field is not in first position of FORMAT.");
                }
                throw new IllegalStateException("Error Processing VCF Block: Missing FORMAT tag.");
            }
            String[] formatS = unsplitInput.split(":");
            iAD = GVCFPositionRecord.firstEqualIndex(formatS, "AD");
            iDP = GVCFPositionRecord.firstEqualIndex(formatS, "DP");
            iGQ = GVCFPositionRecord.firstEqualIndex(formatS, "GQ");
        }
        String taxaAllG = input.substring(tabPos[this.hp.NUM_HAPMAP_NON_TAXA_HEADERS - 1] + 1);
        int f = 0;
        for (String fieldS : Splitter.on((String)":").split((CharSequence)taxaAllG)) {
            if (f == 0) {
                apb.addAnno("GT", fieldS);
            }
            if (f == iAD) {
                apb.addAnno("AD", fieldS);
            }
            if (f == iDP) {
                apb.addAnno("DP", fieldS);
            }
            if (f == iGQ) {
                apb.addAnno("GQ", fieldS);
            }
            ++f;
        }
        return apb.build();
    }

    private static int firstEqualIndex(String[] sa, String match) {
        for (int i = 0; i < sa.length; ++i) {
            if (!sa[i].equals(match)) continue;
            return i;
        }
        return -1;
    }
}

