/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GenomeSequence;
import net.maizegenetics.dna.map.HalfByteGenomeSequence;
import net.maizegenetics.dna.snp.NucleotideAlignmentConstants;
import net.maizegenetics.util.GeneralAnnotationStorage;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class GenomeSequenceBuilder {
    private static final Logger myLogger = Logger.getLogger(GenomeSequenceBuilder.class);

    public static GenomeSequence instance(String fastaFileName) {
        Function<Character, Character> charConversion = c -> c;
        return GenomeSequenceBuilder.instance(fastaFileName, charConversion);
    }

    public static GenomeSequence instance(String fastaFileName, Function<Character, Character> charConversion) {
        Map<Chromosome, byte[]> chromPositionMap = GenomeSequenceBuilder.readReferenceGenomeChr(fastaFileName, charConversion);
        return new HalfByteGenomeSequence(chromPositionMap);
    }

    public static GenomeSequence instance(Chromosome chromosome, String sequence) {
        Function<Character, Character> charConversion = c -> c;
        HashMap<Chromosome, byte[]> chromPositionMap = new HashMap<Chromosome, byte[]>();
        Chromosome currChr = Chromosome.instance(chromosome.getName(), sequence.length(), chromosome.getAnnotation());
        chromPositionMap.put(currChr, GenomeSequenceBuilder.halfByteCompression(sequence.getBytes(), charConversion));
        return new HalfByteGenomeSequence(chromPositionMap);
    }

    protected static Map<Chromosome, byte[]> readReferenceGenomeChr(String fastaFileName, Function<Character, Character> charConversion) {
        String base = "ACGTNacgtn";
        String conv = base.chars().mapToObj(ci -> ((Character)charConversion.apply(Character.valueOf((char)ci))).toString()).collect(Collectors.joining());
        System.out.println("Genome FASTA character conversion: " + base + " to " + conv);
        HashMap<Chromosome, byte[]> chromPositionMap = new HashMap<Chromosome, byte[]>();
        Chromosome currChr = null;
        ByteArrayOutputStream currSeq = new ByteArrayOutputStream();
        String line = null;
        try {
            boolean found = false;
            BufferedReader br = Utils.getBufferedReader(fastaFileName);
            while ((line = br.readLine()) != null && !found) {
                if ((line = line.trim()).startsWith(">")) {
                    if (currChr != null) {
                        currChr = Chromosome.instance(currChr.getName(), currSeq.size(), currChr.getAnnotation());
                        chromPositionMap.put(currChr, GenomeSequenceBuilder.halfByteCompression(currSeq.toByteArray(), charConversion));
                    }
                    currChr = GenomeSequenceBuilder.parseChromosome(line);
                    currSeq = new ByteArrayOutputStream();
                    continue;
                }
                currSeq.write(line.getBytes());
            }
            if (currSeq.size() > 0) {
                currChr = Chromosome.instance(currChr.getName(), currSeq.size(), currChr.getAnnotation());
                chromPositionMap.put(currChr, GenomeSequenceBuilder.halfByteCompression(currSeq.toByteArray(), charConversion));
            }
            br.close();
        }
        catch (IOException ioe) {
            System.out.println("ReferenceGenomeSequence: caught buffered read exception");
        }
        return chromPositionMap;
    }

    private static byte[] halfByteCompression(byte[] unpkSequence, Function<Character, Character> charConversion) {
        int nBytes = (unpkSequence.length + 1) / 2;
        byte[] packedSequence = new byte[nBytes];
        for (int i = 0; i < unpkSequence.length; ++i) {
            byte halfByte = NucleotideAlignmentConstants.getNucleotideAlleleByte(charConversion.apply(Character.valueOf((char)unpkSequence[i])).charValue());
            if (i % 2 == 0) {
                halfByte = (byte)(halfByte << 4);
            }
            int n = i / 2;
            packedSequence[n] = (byte)(packedSequence[n] | halfByte);
        }
        return packedSequence;
    }

    private static Chromosome parseChromosome(String chromString) {
        String chrS = chromString.replace(">", "");
        chrS = chrS.toUpperCase();
        chrS = chrS.replace("CHROMOSOME", "");
        chrS = chrS.replace("CHR", "");
        GeneralAnnotationStorage myAnnotations = null;
        String currChrDesc = null;
        int spaceIndex = chrS.indexOf(" ");
        if (spaceIndex > 0) {
            currChrDesc = chrS.substring(chrS.indexOf(" ") + 1);
            myAnnotations = GeneralAnnotationStorage.getBuilder().addAnnotation("Description", currChrDesc).build();
            chrS = chrS.substring(0, chrS.indexOf(" "));
        }
        return Chromosome.instance(chrS, -1, myAnnotations);
    }
}

