/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

class HeaderPositions {
    final int NUM_HAPMAP_NON_TAXA_HEADERS;
    final int GENOIDX;
    final int SNPID_INDEX;
    final int FILTER_INDEX;
    final int QUAL_INDEX;
    final int CHROMOSOME_INDEX;
    final int POSITION_INDEX;
    final int REF_INDEX;
    final int ALT_INDEX;
    final int INFO_INDEX;
    final int FORMAT_INDEX;

    public HeaderPositions(String[] header) {
        int chrIdx = HeaderPositions.firstEqualIndex(header, "#CHROM");
        if (chrIdx < 0) {
            chrIdx = HeaderPositions.firstEqualIndex(header, "#CHR");
        }
        this.CHROMOSOME_INDEX = chrIdx;
        this.POSITION_INDEX = HeaderPositions.firstEqualIndex(header, "POS");
        this.SNPID_INDEX = HeaderPositions.firstEqualIndex(header, "ID");
        this.REF_INDEX = HeaderPositions.firstEqualIndex(header, "REF");
        this.ALT_INDEX = HeaderPositions.firstEqualIndex(header, "ALT");
        this.QUAL_INDEX = HeaderPositions.firstEqualIndex(header, "QUAL");
        this.FILTER_INDEX = HeaderPositions.firstEqualIndex(header, "FILTER");
        this.INFO_INDEX = HeaderPositions.firstEqualIndex(header, "INFO");
        this.FORMAT_INDEX = HeaderPositions.firstEqualIndex(header, "FORMAT");
        this.GENOIDX = this.NUM_HAPMAP_NON_TAXA_HEADERS = Math.max(this.INFO_INDEX, this.FORMAT_INDEX) + 1;
    }

    private static int firstEqualIndex(String[] sa, String match) {
        for (int i = 0; i < sa.length; ++i) {
            if (!sa[i].equals(match)) continue;
            return i;
        }
        return -1;
    }
}

