/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.util.GeneralAnnotation;

public interface Position
extends Comparable<Position> {
    public static final byte STRAND_PLUS = 1;
    public static final byte STRAND_MINUS = 0;
    public static final byte STRAND_UNKNOWN = -128;
    public static final String STRAND_PLUS_STR = "+";
    public static final String STRAND_MINUS_STR = "-";
    public static final String STRAND_UNKNOWN_STR = "N";

    public static Position of(int chromosomeNumber, int positionWithinChromosome) {
        return new GeneralPosition.Builder(Chromosome.instance(chromosomeNumber), positionWithinChromosome).build();
    }

    public static Position of(String chromosomeName, int positionWithinChromosome) {
        return new GeneralPosition.Builder(Chromosome.instance(chromosomeName), positionWithinChromosome).build();
    }

    public static Position of(Chromosome chromosome, int positionWithinChromosome) {
        return new GeneralPosition.Builder(chromosome, positionWithinChromosome).build();
    }

    public static GeneralPosition.Builder builder(int chromosomeNumber, int positionWithinChromosome) {
        return new GeneralPosition.Builder(Chromosome.instance(chromosomeNumber), positionWithinChromosome);
    }

    public static GeneralPosition.Builder builder(String chromosomeName, int positionWithinChromosome) {
        return new GeneralPosition.Builder(Chromosome.instance(chromosomeName), positionWithinChromosome);
    }

    public static String getStrand(byte value) {
        switch (value) {
            case 1: {
                return STRAND_PLUS_STR;
            }
            case 0: {
                return STRAND_MINUS_STR;
            }
            case -128: {
                return STRAND_UNKNOWN_STR;
            }
        }
        throw new IllegalStateException("Position: getStrand: unknown strand value: " + value);
    }

    public static byte getStrand(String value) {
        switch (value) {
            case "+": {
                return 1;
            }
            case "-": {
                return 0;
            }
            case "N": {
                return -128;
            }
        }
        throw new IllegalStateException("Position: getStrand: unknown strand value: " + value);
    }

    public Chromosome getChromosome();

    public int getPosition();

    public short getInsertionPosition();

    public byte getStrand();

    public String getStrandStr();

    public String getSNPID();

    public String getActualSNPID();

    public boolean isNucleotide();

    public boolean isIndel();

    public String[] getKnownVariants();

    public float getGlobalMAF();

    public float getGlobalSiteCoverage();

    public byte getAllele(WHICH_ALLELE var1);

    public GeneralAnnotation getAnnotation();
}

