/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionListBuilder;

public interface PositionList
extends List<Position> {
    public byte allele(WHICH_ALLELE var1, int var2);

    public byte[] alleles(WHICH_ALLELE var1, int var2, int var3);

    public byte[] alleleForAllSites(WHICH_ALLELE var1);

    public boolean hasReference();

    public String siteName(int var1);

    public int numberOfSites();

    public int chromosomeSiteCount(Chromosome var1);

    public int[] startAndEndOfChromosome(Chromosome var1);

    public int chromosomalPosition(int var1);

    public int siteOfPhysicalPosition(int var1, Chromosome var2);

    public int siteOfPhysicalPosition(int var1, Chromosome var2, String var3);

    public int[] physicalPositions();

    public String chromosomeName(int var1);

    public Chromosome chromosome(int var1);

    public Chromosome chromosome(String var1);

    public Chromosome[] chromosomes();

    public int numChromosomes();

    public int[] chromosomesOffsets();

    public int indelSize(int var1);

    public boolean isIndel(int var1);

    public String genomeVersion();

    public boolean isPositiveStrand(int var1);

    public static Collector<Position, ?, PositionList> collectValidateOrder() {
        return new PositionListCollector(true);
    }

    public static Collector<Position, ?, PositionList> collectReorder() {
        return new PositionListCollector(false);
    }

    public static class PositionListCollector
    implements Collector<Position, PositionListBuilder, PositionList> {
        private final boolean myValidateOrder;

        public PositionListCollector(boolean validateOrder) {
            this.myValidateOrder = validateOrder;
        }

        @Override
        public Supplier<PositionListBuilder> supplier() {
            return PositionListBuilder::new;
        }

        @Override
        public BiConsumer<PositionListBuilder, Position> accumulator() {
            return PositionListBuilder::add;
        }

        @Override
        public BinaryOperator<PositionListBuilder> combiner() {
            return (left, right) -> {
                left.addAll((PositionListBuilder)right);
                return left;
            };
        }

        @Override
        public Function<PositionListBuilder, PositionList> finisher() {
            return result -> {
                if (this.myValidateOrder && !result.validateOrdering()) {
                    throw new IllegalStateException("PositionList: PositionListCollector: Postions are not in order.");
                }
                return result.build();
            };
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            if (this.myValidateOrder) {
                return Collections.EMPTY_SET;
            }
            return Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED));
        }
    }
}

