/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import java.io.BufferedReader;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.GeneralPosition;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.util.Utils;

public class PositionListIOUtils {
    private PositionListIOUtils() {
    }

    public static PositionList readSNPConserveFile(String fileName) {
        try {
            BufferedReader fileIn = Utils.getBufferedReader(fileName, 1000000);
            PositionListBuilder plb = new PositionListBuilder();
            String line = fileIn.readLine();
            while ((line = fileIn.readLine()) != null) {
                String[] tokens = line.split("\\t");
                if (tokens.length != 2) {
                    System.err.println("Error in SNP Conserve File format:" + fileName);
                    System.err.println("Expecting tab-delimited file with 2 integer values per row");
                }
                Chromosome chrom = new Chromosome(tokens[0]);
                int pos = Integer.parseInt(tokens[1]);
                GeneralPosition position = new GeneralPosition.Builder(chrom, pos).build();
                plb.add(position);
            }
            return plb.build();
        }
        catch (Exception e) {
            System.err.println("Error in Reading SNP Conserve File:" + fileName);
            e.printStackTrace();
            return null;
        }
    }

    public static PositionList readQualityScoreFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        try {
            BufferedReader fileIn = Utils.getBufferedReader(fileName, 1000000);
            PositionListBuilder plb = new PositionListBuilder();
            String line = fileIn.readLine();
            while ((line = fileIn.readLine()) != null) {
                String[] tokens = line.split("\\t");
                if (tokens.length < 3) {
                    System.err.println("Error in SNP Position QualityScore file format:" + fileName);
                    System.err.println("Expecting tab-delimited file where first 3 values in each row are type: integer, integer, float   with header values CHROM POS QUALITYSCORE");
                }
                Chromosome chrom = new Chromosome(tokens[0]);
                int pos = Integer.parseInt(tokens[1]);
                double qscore = Double.parseDouble(tokens[2]);
                GeneralPosition position = new GeneralPosition.Builder(chrom, pos).addAnno("QualityScore", qscore).build();
                plb.add(position);
            }
            return plb.build();
        }
        catch (Exception e) {
            System.err.println("Error in Reading Quality Score File:" + fileName);
            e.printStackTrace();
            return null;
        }
    }
}

