/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.map;

import net.maizegenetics.dna.BaseEncoder;
import net.maizegenetics.dna.map.TagsOnPhysicalMap;
import net.maizegenetics.dna.tag.TagsByTaxa;

class SingleTagByTaxa {
    int tagTOPMIndex;
    int tagLength;
    int startPosition;
    byte tagStrand;
    int divergence;
    String tagTrimmed;
    int tagTBTIndex;
    int taxaWithTag;
    byte[] tagDist;

    SingleTagByTaxa(int tagTOPMIndex, TagsOnPhysicalMap theTOPM, TagsByTaxa theTBT, boolean includeRefGenome, boolean fuzzyStartPositions) {
        this.tagStrand = (byte)-128;
        this.tagTOPMIndex = tagTOPMIndex;
        long[] tag = theTOPM.getTag(tagTOPMIndex);
        this.tagTBTIndex = theTBT.getTagIndex(tag);
        int n = this.taxaWithTag = this.tagTBTIndex > -1 ? theTBT.getNumberOfTaxaWithTag(this.tagTBTIndex) : 0;
        if (this.taxaWithTag > 0) {
            this.startPosition = theTOPM.getStartPosition(tagTOPMIndex);
            this.tagLength = theTOPM.getTagLength(tagTOPMIndex);
            this.divergence = theTOPM.getDivergence(tagTOPMIndex);
            this.tagTrimmed = BaseEncoder.getSequenceFromLong(tag).substring(0, this.tagLength);
            this.tagStrand = theTOPM.getStrand(tagTOPMIndex);
            if (includeRefGenome && fuzzyStartPositions) {
                if (this.tagStrand == -1) {
                    this.tagTrimmed = BaseEncoder.getReverseComplement(this.tagTrimmed);
                }
            } else if (this.tagLength < theTOPM.getTagSizeInLong() * 32) {
                this.tagTrimmed = this.tagTrimmed + theTOPM.getNullTag().substring(0, theTOPM.getTagSizeInLong() * 32 - this.tagLength).replace("A", "N");
            }
            this.tagDist = theTBT.getTaxaReadCountsForTag(this.tagTBTIndex);
        }
    }

    SingleTagByTaxa(int startPosition, byte strand, String refTag, int nLongsPerTag, String nullTag) {
        this.tagTOPMIndex = Integer.MIN_VALUE;
        this.tagLength = (byte)refTag.length();
        this.startPosition = startPosition;
        this.tagStrand = strand;
        this.divergence = 0;
        this.tagTrimmed = refTag;
        if (this.tagLength < nLongsPerTag * 32) {
            this.tagTrimmed = this.tagTrimmed + nullTag.substring(0, nLongsPerTag * 32 - this.tagLength).replace("A", "N");
        }
        this.tagTBTIndex = Integer.MIN_VALUE;
        this.taxaWithTag = 0;
        this.tagDist = null;
    }
}

