/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.read;

import net.maizegenetics.dna.read.Read;
import org.apache.log4j.Logger;
import org.biojava.nbio.alignment.Alignments;
import org.biojava.nbio.alignment.SimpleGapPenalty;
import org.biojava.nbio.alignment.SubstitutionMatrixHelper;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.SequencePair;
import org.biojava.nbio.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.template.Sequence;

public class PERead {
    private static final Logger myLogger = Logger.getLogger(PERead.class);
    Read rf;
    Read rb;
    Read pContig = null;
    int overlapLength = Integer.MIN_VALUE;
    float identity = Float.MIN_VALUE;

    public PERead(Read rf, Read rb) {
        this.rf = rf;
        this.rb = rb;
    }

    public boolean merge(boolean ifPrintAlignment) {
        SimpleGapPenalty gapPen = new SimpleGapPenalty(10, 10);
        SubstitutionMatrix subMatrix = SubstitutionMatrixHelper.getNuc4_4();
        int minOverlap = 10;
        double minIden = 0.6;
        String queryS = this.rf.getSeq();
        DNASequence query = null;
        try {
            query = new DNASequence(queryS);
        }
        catch (CompoundNotFoundException ex) {
            myLogger.error((Object)("PERead:merge, compoundNotFound exception from DNASequence call for: " + queryS));
            myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        String hitS = this.rb.getReverseComplementarySeq();
        String hitQualS = this.rb.getReverseQual();
        DNASequence hit = null;
        try {
            hit = new DNASequence(hitS);
        }
        catch (CompoundNotFoundException ex) {
            myLogger.error((Object)("PERead:merge 2, compoundNotFound exception from DNASequence call for: " + hitS));
            myLogger.debug((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        SequencePair psa = null;
        psa = Alignments.getPairwiseAlignment((Sequence)query, (Sequence)hit, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)gapPen, (SubstitutionMatrix)subMatrix);
        int queryStart = 0;
        try {
            queryStart = psa.getIndexInQueryAt(1);
        }
        catch (NullPointerException e) {
            return false;
        }
        int queryEnd = psa.getIndexInQueryAt(psa.getLength());
        int hitStart = psa.getIndexInTargetAt(1);
        int hitEnd = psa.getIndexInTargetAt(psa.getLength());
        int overlap = psa.getLength();
        int idenNum = psa.getNumIdenticals();
        if (hitStart > 5) {
            return false;
        }
        if (queryEnd < queryS.length() - 5) {
            return false;
        }
        if (overlap < minOverlap) {
            return false;
        }
        double iden = (double)idenNum / (double)overlap;
        this.overlapLength = overlap;
        this.identity = (float)iden;
        if (iden < minIden) {
            return false;
        }
        StringBuilder sbSeq = new StringBuilder();
        StringBuilder sbQual = new StringBuilder();
        sbSeq.append(queryS.substring(0, queryEnd));
        sbQual.append(this.rf.getQual().substring(0, queryEnd));
        sbSeq.append(hitS.substring(hitEnd - 1, hitS.length()));
        sbQual.append(hitQualS.substring(hitEnd - 1, hitS.length()));
        String contigS = sbSeq.toString();
        String contigQualS = sbQual.toString();
        String ID = "@" + this.rf.ID.replaceFirst("@", "") + this.rb.ID.replaceFirst("@", "_____");
        String des = "+" + this.rf.des.replaceFirst("\\+", "") + this.rb.des.replaceFirst("\\+", "_____");
        this.pContig = new Read(ID, contigS, des, contigQualS);
        if (ifPrintAlignment) {
            System.out.println("********************************************************\n");
            System.out.println("QueryStart:\t" + String.valueOf(queryStart));
            System.out.println("QueryEnd:\t" + String.valueOf(queryEnd));
            System.out.println("QueryLength:\t" + String.valueOf(this.rf.getReadLength()));
            System.out.println("HitStart:\t" + String.valueOf(hitStart));
            System.out.println("HitEnd:\t" + String.valueOf(hitEnd));
            System.out.println("HitLength:\t" + String.valueOf(this.rb.getReadLength()));
            System.out.println("OverlapLength:\t" + String.valueOf(psa.getLength()));
            System.out.println("Identity:\t" + String.valueOf(iden) + "\t" + String.valueOf(idenNum));
            System.out.println("PE contig length:\t" + String.valueOf(contigS.length()));
            System.out.println(psa.toString(1000));
            System.out.println(contigS);
            System.out.println(queryS);
            System.out.println(hitS + "\n");
            System.out.println(contigQualS);
            System.out.println(this.rf.getQual());
            System.out.println(hitQualS);
            System.out.println("\n\n");
        }
        return true;
    }

    public Read getForwardRead() {
        return this.rf;
    }

    public Read getBackwardRead() {
        return this.rb;
    }

    public Read getPContig() {
        return this.pContig;
    }

    public int getOverlapLength() {
        return this.overlapLength;
    }

    public float getOverlapIdentity() {
        return this.identity;
    }
}

