/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.FilterGenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.bit.BitStorage;
import net.maizegenetics.dna.snp.genotypecall.CombineGenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.score.AlleleDepth;
import net.maizegenetics.dna.snp.score.AlleleProbability;
import net.maizegenetics.dna.snp.score.Dosage;
import net.maizegenetics.dna.snp.score.ReferenceProbability;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListUtils;
import net.maizegenetics.taxa.Taxon;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.GeneralAnnotationStorage;

public class CombineGenotypeTable
implements GenotypeTable {
    private final GenotypeTable[] myGenotypeTables;
    private final GenotypeCallTable myGenotype;
    private final int[] mySiteOffsets;
    private final Map<Chromosome, GenotypeTable> myChromosomes = new HashMap<Chromosome, GenotypeTable>();
    private Chromosome[] myChromosomesList;
    private int[] myChromosomesOffsets;
    private final TaxaList myTaxaList;
    private String[][] myAlleleStates;
    private PositionList myPositions = null;

    private CombineGenotypeTable(TaxaList taxaList, GenotypeTable[] genoTables) {
        this.myTaxaList = taxaList;
        this.myGenotypeTables = genoTables;
        this.mySiteOffsets = new int[genoTables.length + 1];
        this.mySiteOffsets[0] = 0;
        int count = 0;
        for (int i = 0; i < genoTables.length; ++i) {
            this.mySiteOffsets[i + 1] = count = genoTables[i].numberOfSites() + count;
            Chromosome[] chromosomes = genoTables[i].chromosomes();
            for (int j = 0; j < chromosomes.length; ++j) {
                this.myChromosomes.put(chromosomes[j], genoTables[i]);
            }
        }
        this.initChromosomes();
        GenotypeCallTable[] genotypeCallTables = new GenotypeCallTable[genoTables.length];
        for (int i = 0; i < genoTables.length; ++i) {
            genotypeCallTables[i] = genoTables[i].genotypeMatrix();
        }
        this.myGenotype = CombineGenotypeCallTable.getInstance(genotypeCallTables);
    }

    public static GenotypeTable getInstance(GenotypeTable[] genoTables) {
        if (genoTables == null || genoTables.length == 0) {
            throw new IllegalArgumentException("CombineGenotypeTable: getInstance: must provide genoTables.");
        }
        if (genoTables.length == 1) {
            return genoTables[0];
        }
        TaxaList firstGroup = genoTables[0].taxa();
        for (int i = 1; i < genoTables.length; ++i) {
            if (CombineGenotypeTable.areTaxaListsEqual(firstGroup, genoTables[i].taxa())) continue;
            throw new IllegalArgumentException("CombineGenotypeTable: getInstance: TaxaLists do not match.");
        }
        return new CombineGenotypeTable(firstGroup, genoTables);
    }

    public static GenotypeTable getInstance(GenotypeTable[] genoTables, boolean isUnion) {
        int i;
        if (genoTables == null || genoTables.length == 0) {
            throw new IllegalArgumentException("CombineGenotypeTable: getInstance: must provide genoTables.");
        }
        if (genoTables.length == 1) {
            return genoTables[0];
        }
        TaxaList[] groups = new TaxaList[genoTables.length];
        for (int i2 = 0; i2 < genoTables.length; ++i2) {
            groups[i2] = genoTables[i2].taxa();
        }
        TaxaList newTaxa = isUnion ? TaxaListUtils.getAllTaxa(groups, false) : TaxaListUtils.getCommonTaxa(groups, false);
        GenotypeTable[] newAlignmentNews = new GenotypeTable[genoTables.length];
        for (i = 0; i < genoTables.length; ++i) {
            newAlignmentNews[i] = FilterGenotypeTable.getInstance(genoTables[i], newTaxa, true);
        }
        for (i = 0; i < genoTables.length; ++i) {
            if (CombineGenotypeTable.areTaxaListsEqual(newTaxa, newAlignmentNews[i].taxa())) continue;
            throw new IllegalArgumentException("CombineGenotypeTable: getInstance: TaxaLists do not match.");
        }
        return new CombineGenotypeTable(newTaxa, newAlignmentNews);
    }

    private static boolean areTaxaListsEqual(TaxaList first, TaxaList second) {
        if (first.numberOfTaxa() != second.numberOfTaxa()) {
            return false;
        }
        int n = first.numberOfTaxa();
        for (int i = 0; i < n; ++i) {
            if (((Taxon)first.get(i)).equals(second.get(i))) continue;
            return false;
        }
        return true;
    }

    private void initChromosomes() {
        int i;
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>();
        for (i = 0; i < this.myGenotypeTables.length; ++i) {
            chromosomes.addAll(Arrays.asList(this.myGenotypeTables[i].chromosomes()));
            int[] tempOffsets = this.myGenotypeTables[i].chromosomesOffsets();
            for (int j = 0; j < tempOffsets.length; ++j) {
                offsets.add(tempOffsets[j] + this.mySiteOffsets[i]);
            }
        }
        this.myChromosomesList = new Chromosome[chromosomes.size()];
        this.myChromosomesList = chromosomes.toArray(this.myChromosomesList);
        this.myChromosomesOffsets = new int[offsets.size()];
        for (i = 0; i < offsets.size(); ++i) {
            this.myChromosomesOffsets[i] = (Integer)offsets.get(i);
        }
        if (this.myChromosomesOffsets.length != this.myChromosomesList.length) {
            throw new IllegalStateException("CombineGenotypeTable: initChromosomes: number chromosomes offsets should equal number of chromosomes.");
        }
    }

    @Override
    public byte genotype(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].genotype(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] genotypeRange(int taxon, int startSite, int endSite) {
        byte[] result = new byte[endSite - startSite];
        int count = 0;
        int firstAlign = this.translateSite(startSite);
        int secondAlign = this.translateSite(endSite - 1);
        for (int i = firstAlign; i <= secondAlign; ++i) {
            int firstSite = 0;
            if (i == firstAlign) {
                firstSite = startSite - this.mySiteOffsets[firstAlign];
            }
            int secondSite = 0;
            secondSite = firstAlign == secondAlign ? endSite - this.mySiteOffsets[firstAlign] : (i != secondAlign ? this.myGenotypeTables[i].numberOfSites() : endSite - this.mySiteOffsets[secondAlign]);
            for (int s = firstSite; s < secondSite; ++s) {
                result[count++] = this.myGenotypeTables[i].genotype(taxon, s);
            }
        }
        return result;
    }

    @Override
    public byte genotype(int taxon, Chromosome locus, int physicalPosition) {
        int site = this.siteOfPhysicalPosition(physicalPosition, locus);
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].genotype(taxon, site - this.mySiteOffsets[translate]);
    }

    public int translateSite(int site) {
        for (int i = 1; i < this.mySiteOffsets.length; ++i) {
            if (this.mySiteOffsets[i] <= site) continue;
            return i - 1;
        }
        throw new IndexOutOfBoundsException("CombineGenotypeTable: translateSite: index out of range: " + site);
    }

    private int findGenotypeTableIndex(GenotypeTable genotypeTable) {
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            if (genotypeTable != this.myGenotypeTables[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("CombineGenotypeTable: findGenotypeTableIndex: Genotype Table unknown.");
    }

    @Override
    public boolean hasReference() {
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            if (this.myGenotypeTables[i].hasReference()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String siteName(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].siteName(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int numberOfSites() {
        return this.mySiteOffsets[this.mySiteOffsets.length - 1];
    }

    @Override
    public int chromosomeSiteCount(Chromosome locus) {
        return this.myChromosomes.get(locus).chromosomeSiteCount(locus);
    }

    @Override
    public int chromosomalPosition(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].chromosomalPosition(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome locus) {
        GenotypeTable align = this.myChromosomes.get(locus);
        int i = -1;
        for (int j = 0; j < this.myGenotypeTables.length; ++j) {
            if (this.myGenotypeTables[j] != align) continue;
            i = j;
            break;
        }
        if (i == -1) {
            return -1;
        }
        return this.mySiteOffsets[i] + align.siteOfPhysicalPosition(physicalPosition, locus);
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome locus, String snpName) {
        GenotypeTable align = this.myChromosomes.get(locus);
        int i = -1;
        for (int j = 0; j < this.myGenotypeTables.length; ++j) {
            if (this.myGenotypeTables[j] != align) continue;
            i = j;
            break;
        }
        if (i == -1) {
            return -1;
        }
        return this.mySiteOffsets[i] + align.siteOfPhysicalPosition(physicalPosition, locus, snpName);
    }

    @Override
    public Chromosome chromosome(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].chromosome(site - this.mySiteOffsets[translate]);
    }

    @Override
    public Chromosome[] chromosomes() {
        return this.myChromosomesList;
    }

    @Override
    public int numChromosomes() {
        if (this.myChromosomesList == null) {
            return 0;
        }
        return this.myChromosomesList.length;
    }

    @Override
    public int indelSize(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].indelSize(site - this.mySiteOffsets[translate]);
    }

    @Override
    public boolean isIndel(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].isIndel(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte referenceAllele(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].referenceAllele(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte alternateAllele(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].alternateAllele(site - this.mySiteOffsets[translate]);
    }

    @Override
    public GenotypeTable[] compositeAlignments() {
        return this.myGenotypeTables;
    }

    @Override
    public byte majorAllele(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].majorAllele(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte minorAllele(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].minorAllele(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] minorAlleles(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].minorAlleles(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] alleles(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].alleles(site - this.mySiteOffsets[translate]);
    }

    @Override
    public double minorAlleleFrequency(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].minorAlleleFrequency(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int[][] allelesSortedByFrequency(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].allelesSortedByFrequency(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] genotypeArray(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].genotypeArray(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] genotypeAllTaxa(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].genotypeAllTaxa(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] genotypeAllSites(int taxon) {
        byte[] result = new byte[this.numberOfSites()];
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            byte[] current = this.myGenotypeTables[i].genotypeAllSites(taxon);
            System.arraycopy(current, 0, result, this.myChromosomesOffsets[i], current.length);
        }
        return result;
    }

    @Override
    public BitSet allelePresenceForAllSites(int taxon, WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("CombineGenotypeTable: getAllelePresenceForAllSites: This operation isn't possible as it spans multiple GenotypeTables.");
    }

    @Override
    public long[] allelePresenceForSitesBlock(int taxon, WHICH_ALLELE allele, int startBlock, int endBlock) {
        throw new UnsupportedOperationException("CombineGenotypeTable: getAllelePresenceForSitesBlock: This operation isn't possible as it spans multiple GenotypeTables.");
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].genotypeAsString(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public String[] genotypeAsStringArray(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].genotypeAsStringArray(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] referenceAlleles(int startSite, int endSite) {
        int numSites = endSite - startSite;
        byte[] result = new byte[numSites];
        for (int i = 0; i < numSites; ++i) {
            result[i] = this.referenceAllele(startSite + i);
        }
        return result;
    }

    @Override
    public byte[] referenceAlleleForAllSites() {
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            if (this.myGenotypeTables[i].hasReference()) continue;
            return null;
        }
        byte[] result = new byte[this.numberOfSites()];
        int count = 0;
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            byte[] current = this.myGenotypeTables[i].referenceAlleleForAllSites();
            for (int j = 0; j < current.length; ++j) {
                result[count++] = current[j];
            }
        }
        return result;
    }

    @Override
    public boolean isHeterozygous(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].isHeterozygous(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public int[] physicalPositions() {
        boolean allNull = true;
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            int[] current = this.myGenotypeTables[0].physicalPositions();
            if (current == null || current.length == 0) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            return null;
        }
        int[] result = new int[this.numberOfSites()];
        int count = 0;
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            int[] current = this.myGenotypeTables[i].physicalPositions();
            for (int j = 0; j < current.length; ++j) {
                result[count++] = current[j];
            }
        }
        return result;
    }

    @Override
    public String chromosomeName(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].chromosomeName(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int[] chromosomesOffsets() {
        return this.myChromosomesOffsets;
    }

    @Override
    public Set<SiteScore.SITE_SCORE_TYPE> siteScoreTypes() {
        LinkedHashSet<SiteScore.SITE_SCORE_TYPE> result = new LinkedHashSet<SiteScore.SITE_SCORE_TYPE>();
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            result.addAll(this.myGenotypeTables[i].siteScoreTypes());
        }
        return result;
    }

    @Override
    public boolean isAllPolymorphic() {
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            if (this.myGenotypeTables[i].isAllPolymorphic()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPolymorphic(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].isPolymorphic(site - this.mySiteOffsets[translate]);
    }

    @Override
    public double majorAlleleFrequency(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].majorAlleleFrequency(site - this.mySiteOffsets[translate]);
    }

    @Override
    public String genomeVersion() {
        String first = this.myGenotypeTables[0].genomeVersion();
        if (first == null) {
            return null;
        }
        for (int i = 1; i < this.myGenotypeTables.length; ++i) {
            String current = this.myGenotypeTables[i].genomeVersion();
            if (current == null || first.equals(current)) continue;
            return null;
        }
        return first;
    }

    @Override
    public boolean isPositiveStrand(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].isPositiveStrand(site - this.mySiteOffsets[translate]);
    }

    @Override
    public boolean isPhased() {
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            if (this.myGenotypeTables[i].isPhased()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainsRareAlleles() {
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            if (this.myGenotypeTables[i].retainsRareAlleles()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String[][] alleleDefinitions() {
        if (this.myAlleleStates != null) {
            return this.myAlleleStates;
        }
        boolean allTheSame = true;
        String[][] encodings = this.myGenotypeTables[0].alleleDefinitions();
        if (encodings.length == 1) {
            for (int i = 1; i < this.myGenotypeTables.length; ++i) {
                String[][] current = this.myGenotypeTables[i].alleleDefinitions();
                if (current.length != 1 || encodings[0].length != current[0].length) {
                    allTheSame = false;
                    break;
                }
                for (int j = 0; j < encodings[0].length; ++j) {
                    if (current[0][j].equals(encodings[0][j])) continue;
                    allTheSame = false;
                    break;
                }
                if (allTheSame) {
                    continue;
                }
                break;
            }
        } else {
            allTheSame = false;
        }
        if (allTheSame) {
            this.myAlleleStates = encodings;
        } else {
            String[][] result = new String[this.numberOfSites()][];
            int count = 0;
            for (int i = 0; i < this.myGenotypeTables.length; ++i) {
                int n = this.myGenotypeTables[i].numberOfSites();
                for (int j = 0; j < n; ++j) {
                    result[count++] = this.myGenotypeTables[i].alleleDefinitions(j);
                }
            }
            this.myAlleleStates = result;
        }
        return this.myAlleleStates;
    }

    @Override
    public String[] alleleDefinitions(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].alleleDefinitions(site - this.mySiteOffsets[translate]);
    }

    @Override
    public String genotypeAsString(int site, byte value) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].genotypeAsString(site - this.mySiteOffsets[translate], value);
    }

    @Override
    public int maxNumAlleles() {
        int result = 999999;
        for (int i = 0; i < this.myGenotypeTables.length; ++i) {
            if (this.myGenotypeTables[i].maxNumAlleles() >= result) continue;
            result = this.myGenotypeTables[i].maxNumAlleles();
        }
        return result;
    }

    @Override
    public int totalGametesNonMissingForSite(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].totalGametesNonMissingForSite(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int heterozygousCount(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].heterozygousCount(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int minorAlleleCount(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].minorAlleleCount(site - this.mySiteOffsets[translate]);
    }

    @Override
    public int majorAlleleCount(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].majorAlleleCount(site - this.mySiteOffsets[translate]);
    }

    @Override
    public Object[][] genosSortedByFrequency(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].genosSortedByFrequency(site - this.mySiteOffsets[translate]);
    }

    @Override
    public byte[] allelesBySortType(GenotypeTable.ALLELE_SORT_TYPE scope, int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].allelesBySortType(scope, site - this.mySiteOffsets[translate]);
    }

    @Override
    public BitSet allelePresenceForAllTaxa(int site, WHICH_ALLELE allele) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].allelePresenceForAllTaxa(site - this.mySiteOffsets[translate], allele);
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllSites(int taxon, boolean firstParent, WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllTaxa(int site, boolean firstParent, WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long[] haplotypeAllelePresenceForSitesBlock(int taxon, boolean firstParent, WHICH_ALLELE allele, int startBlock, int endBlock) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String genotypeAsStringRange(int taxon, int startSite, int endSite) {
        int secondGenotype;
        int firstGenotype = this.translateSite(startSite);
        if (firstGenotype == (secondGenotype = this.translateSite(endSite))) {
            return this.myGenotypeTables[firstGenotype].genotypeAsStringRange(taxon, startSite - this.mySiteOffsets[firstGenotype], endSite - this.mySiteOffsets[firstGenotype]);
        }
        if (secondGenotype - firstGenotype == 1) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.myGenotypeTables[firstGenotype].genotypeAsStringRange(taxon, startSite - this.mySiteOffsets[firstGenotype], this.myGenotypeTables[firstGenotype].numberOfSites()));
            builder.append(";");
            builder.append(this.myGenotypeTables[secondGenotype].genotypeAsStringRange(taxon, 0, endSite - this.mySiteOffsets[secondGenotype]));
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.myGenotypeTables[firstGenotype].genotypeAsStringRange(taxon, startSite - this.mySiteOffsets[firstGenotype], this.myGenotypeTables[firstGenotype].numberOfSites()));
        for (int i = firstGenotype + 1; i < secondGenotype; ++i) {
            builder.append(";");
            builder.append(this.myGenotypeTables[i].genotypeAsStringRow(taxon));
        }
        builder.append(";");
        builder.append(this.myGenotypeTables[secondGenotype].genotypeAsStringRange(taxon, 0, endSite - this.mySiteOffsets[secondGenotype]));
        return builder.toString();
    }

    @Override
    public String genotypeAsStringRow(int taxon) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (GenotypeTable current : this.myGenotypeTables) {
            if (first) {
                first = false;
            } else {
                builder.append(";");
            }
            builder.append(current.genotypeAsStringRow(taxon));
        }
        return builder.toString();
    }

    @Override
    public int[] firstLastSiteOfChromosome(Chromosome chromosome) {
        GenotypeTable genotypeTable = this.myChromosomes.get(chromosome);
        int index = this.findGenotypeTableIndex(genotypeTable);
        int[] result = genotypeTable.firstLastSiteOfChromosome(chromosome);
        result[0] = result[0] + this.myChromosomesOffsets[index];
        result[1] = result[1] + this.myChromosomesOffsets[index];
        return result;
    }

    @Override
    public int numberOfTaxa() {
        return this.myTaxaList.size();
    }

    @Override
    public Chromosome chromosome(String name) {
        for (Chromosome current : this.myChromosomesList) {
            if (!current.getName().equals(name)) continue;
            return current;
        }
        return null;
    }

    @Override
    public String majorAlleleAsString(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].majorAlleleAsString(site - this.mySiteOffsets[translate]);
    }

    @Override
    public String minorAlleleAsString(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].minorAlleleAsString(site - this.mySiteOffsets[translate]);
    }

    @Override
    public TaxaList taxa() {
        return this.myTaxaList;
    }

    @Override
    public String taxaName(int index) {
        return this.myTaxaList.taxaName(index);
    }

    @Override
    public String diploidAsString(int site, byte value) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].diploidAsString(site - this.mySiteOffsets[translate], value);
    }

    @Override
    public int totalNonMissingForSite(int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].totalNonMissingForSite(site - this.mySiteOffsets[translate]);
    }

    @Override
    public Object[][] genoCounts() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object[][] majorMinorCounts() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int totalGametesNonMissingForTaxon(int taxon) {
        int result = 0;
        for (GenotypeTable current : this.myGenotypeTables) {
            result += current.totalGametesNonMissingForTaxon(taxon);
        }
        return result;
    }

    @Override
    public int heterozygousCountForTaxon(int taxon) {
        int result = 0;
        for (GenotypeTable current : this.myGenotypeTables) {
            result += current.heterozygousCountForTaxon(taxon);
        }
        return result;
    }

    @Override
    public int totalNonMissingForTaxon(int taxon) {
        int result = 0;
        for (GenotypeTable current : this.myGenotypeTables) {
            result += current.totalNonMissingForTaxon(taxon);
        }
        return result;
    }

    @Override
    public boolean hasGenotype() {
        boolean result = true;
        for (GenotypeTable current : this.myGenotypeTables) {
            if (current.hasGenotype()) continue;
            result = false;
        }
        return result;
    }

    @Override
    public boolean hasDepth() {
        boolean result = true;
        for (GenotypeTable current : this.myGenotypeTables) {
            if (current.hasDepth()) continue;
            result = false;
        }
        return result;
    }

    @Override
    public boolean hasAlleleProbabilities() {
        boolean result = true;
        for (GenotypeTable current : this.myGenotypeTables) {
            if (current.hasAlleleProbabilities()) continue;
            result = false;
        }
        return result;
    }

    @Override
    public boolean hasReferenceProbablity() {
        boolean result = true;
        for (GenotypeTable current : this.myGenotypeTables) {
            if (current.hasReferenceProbablity()) continue;
            result = false;
        }
        return result;
    }

    @Override
    public boolean hasDosage() {
        boolean result = true;
        for (GenotypeTable current : this.myGenotypeTables) {
            if (current.hasDosage()) continue;
            result = false;
        }
        return result;
    }

    @Override
    public AlleleDepth depth() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int[] depthForAlleles(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].depthForAlleles(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public BitStorage bitStorage(WHICH_ALLELE allele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PositionList positions() {
        if (this.myPositions == null) {
            PositionListBuilder builder = new PositionListBuilder();
            for (GenotypeTable current : this.myGenotypeTables) {
                builder.addAll(current.positions());
            }
            this.myPositions = builder.build();
        }
        return this.myPositions;
    }

    @Override
    public GenotypeCallTable genotypeMatrix() {
        return this.myGenotype;
    }

    @Override
    public AlleleProbability alleleProbability() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float alleleProbability(int taxon, int site, SiteScore.SITE_SCORE_TYPE type) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].alleleProbability(taxon, site - this.mySiteOffsets[translate], type);
    }

    @Override
    public ReferenceProbability referenceProbability() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float referenceProbability(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].referenceProbability(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public Dosage dosage() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte dosage(int taxon, int site) {
        int translate = this.translateSite(site);
        return this.myGenotypeTables[translate].dosage(taxon, site - this.mySiteOffsets[translate]);
    }

    @Override
    public GeneralAnnotationStorage annotations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Stream<Byte> streamGenotype() {
        return this.myGenotype.stream();
    }

    @Override
    public Stream<Byte> streamGenotype(int taxon) {
        return this.myGenotype.stream(taxon);
    }

    @Override
    public boolean hasSiteTranslations() {
        return false;
    }

    @Override
    public int[] siteTranslations() {
        return null;
    }
}

