/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.maizegenetics.dna.WHICH_ALLELE;
import net.maizegenetics.dna.map.Chromosome;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.Translate;
import net.maizegenetics.dna.snp.bit.BitStorage;
import net.maizegenetics.dna.snp.bit.DynamicBitStorage;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.score.AlleleDepth;
import net.maizegenetics.dna.snp.score.AlleleProbability;
import net.maizegenetics.dna.snp.score.Dosage;
import net.maizegenetics.dna.snp.score.ReferenceProbability;
import net.maizegenetics.dna.snp.score.SiteScore;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.GeneralAnnotationStorage;
import org.apache.log4j.Logger;

public class CoreGenotypeTable
implements GenotypeTable {
    private static final Logger myLogger = Logger.getLogger(CoreGenotypeTable.class);
    private final GenotypeCallTable myGenotype;
    private final Map<WHICH_ALLELE, BitStorage> myBitStorage = new HashMap<WHICH_ALLELE, BitStorage>();
    private final PositionList myPositionList;
    private final TaxaList myTaxaList;
    private final AlleleProbability myAlleleProbability;
    private final ReferenceProbability myReferenceProbabily;
    private final AlleleDepth myAlleleDepth;
    private final Dosage myDosage;
    private final int mySiteCount;
    private final int myTaxaCount;
    private final GeneralAnnotationStorage myAnnotations;
    private final Translate myGenotypeTranslate;

    CoreGenotypeTable(GenotypeCallTable genotype, PositionList positionList, TaxaList taxaList, AlleleDepth alleleDepth, AlleleProbability alleleProbability, ReferenceProbability referenceProbability, Dosage dosage, GeneralAnnotationStorage annotations, Translate genotypeTranslate) {
        this.myPositionList = positionList;
        this.myTaxaList = taxaList;
        this.mySiteCount = this.myPositionList.numberOfSites();
        this.myTaxaCount = this.myTaxaList.numberOfTaxa();
        if (genotype != null && genotype.numberOfTaxa() != this.myTaxaCount) {
            throw new IllegalArgumentException("CoreGenotypeTable: init: genotype number of taxa: " + genotype.numberOfTaxa() + " doesn't match taxa list: " + this.myTaxaCount);
        }
        if (genotype != null && genotype.numberOfSites() != this.mySiteCount) {
            throw new IllegalArgumentException("CoreGenotypeTable: init: genotype number of sites: " + genotype.numberOfSites() + " doesn't match position list: " + this.mySiteCount);
        }
        this.myGenotype = genotype;
        this.myAlleleDepth = alleleDepth;
        this.myAlleleProbability = alleleProbability;
        this.myReferenceProbabily = referenceProbability;
        this.myDosage = dosage;
        this.myAnnotations = annotations;
        this.myGenotypeTranslate = genotypeTranslate;
    }

    CoreGenotypeTable(GenotypeCallTable genotype, PositionList positionList, TaxaList taxaList, AlleleDepth alleleDepth, AlleleProbability alleleProbability, ReferenceProbability referenceProbability, Dosage dosage, GeneralAnnotationStorage annotations) {
        this(genotype, positionList, taxaList, alleleDepth, alleleProbability, referenceProbability, dosage, annotations, null);
    }

    CoreGenotypeTable(GenotypeCallTable genotype, PositionList positionList, TaxaList taxaList) {
        this(genotype, positionList, taxaList, null, null, null, null, null);
    }

    @Override
    public GenotypeCallTable genotypeMatrix() {
        return this.myGenotype;
    }

    @Override
    public byte genotype(int taxon, int site) {
        return this.myGenotype.genotype(taxon, site);
    }

    @Override
    public byte[] genotypeArray(int taxon, int site) {
        return this.myGenotype.genotypeArray(taxon, site);
    }

    @Override
    public byte genotype(int taxon, Chromosome chromosome, int physicalPosition) {
        return this.myGenotype.genotype(taxon, this.myPositionList.siteOfPhysicalPosition(physicalPosition, chromosome));
    }

    @Override
    public byte[] genotypeRange(int taxon, int startSite, int endSite) {
        return this.myGenotype.genotypeRange(taxon, startSite, endSite);
    }

    @Override
    public byte[] genotypeAllTaxa(int site) {
        return this.myGenotype.genotypeForAllTaxa(site);
    }

    @Override
    public byte[] genotypeAllSites(int taxon) {
        return this.myGenotype.genotypeAllSites(taxon);
    }

    @Override
    public BitSet allelePresenceForAllSites(int taxon, WHICH_ALLELE allele) {
        return this.bitStorage(allele).allelePresenceForAllSites(taxon);
    }

    @Override
    public long[] allelePresenceForSitesBlock(int taxon, WHICH_ALLELE allele, int startBlock, int endBlock) {
        return this.bitStorage(allele).allelePresenceForSitesBlock(taxon, startBlock, endBlock);
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllSites(int taxon, boolean firstParent, WHICH_ALLELE allele) {
        return this.bitStorage(allele).haplotypeAllelePresenceForAllSites(taxon, firstParent);
    }

    @Override
    public BitSet haplotypeAllelePresenceForAllTaxa(int site, boolean firstParent, WHICH_ALLELE allele) {
        return this.bitStorage(allele).haplotypeAllelePresenceForAllTaxa(site, firstParent);
    }

    @Override
    public long[] haplotypeAllelePresenceForSitesBlock(int taxon, boolean firstParent, WHICH_ALLELE allele, int startBlock, int endBlock) {
        return this.bitStorage(allele).haplotypeAllelePresenceForSitesBlock(taxon, firstParent, startBlock, endBlock);
    }

    @Override
    public String genotypeAsString(int taxon, int site) {
        return this.myGenotype.genotypeAsString(taxon, site);
    }

    @Override
    public String genotypeAsStringRange(int taxon, int startSite, int endSite) {
        return this.myGenotype.genotypeAsStringRange(taxon, startSite, endSite);
    }

    @Override
    public String genotypeAsStringRow(int taxon) {
        return this.myGenotype.genotypeAsStringRow(taxon);
    }

    @Override
    public String[] genotypeAsStringArray(int taxon, int site) {
        return this.myGenotype.genotypeAsStringArray(taxon, site);
    }

    @Override
    public byte referenceAllele(int site) {
        return this.myPositionList.allele(WHICH_ALLELE.Reference, site);
    }

    @Override
    public byte alternateAllele(int site) {
        return this.myPositionList.allele(WHICH_ALLELE.Alternate, site);
    }

    @Override
    public byte[] referenceAlleles(int startSite, int endSite) {
        return this.myPositionList.alleles(WHICH_ALLELE.Reference, startSite, endSite);
    }

    @Override
    public byte[] referenceAlleleForAllSites() {
        return this.myPositionList.alleleForAllSites(WHICH_ALLELE.Reference);
    }

    @Override
    public boolean hasReference() {
        return this.myPositionList.hasReference();
    }

    @Override
    public boolean isHeterozygous(int taxon, int site) {
        return this.myGenotype.isHeterozygous(taxon, site);
    }

    @Override
    public int heterozygousCount(int site) {
        return this.myGenotype.heterozygousCount(site);
    }

    @Override
    public PositionList positions() {
        return this.myPositionList;
    }

    @Override
    public String siteName(int site) {
        return this.myPositionList.siteName(site);
    }

    @Override
    public int numberOfSites() {
        return this.mySiteCount;
    }

    @Override
    public int chromosomeSiteCount(Chromosome chromosome) {
        return this.myPositionList.chromosomeSiteCount(chromosome);
    }

    @Override
    public int[] firstLastSiteOfChromosome(Chromosome chromosome) {
        return this.myPositionList.startAndEndOfChromosome(chromosome);
    }

    @Override
    public int numberOfTaxa() {
        return this.myTaxaCount;
    }

    @Override
    public int chromosomalPosition(int site) {
        return this.myPositionList.chromosomalPosition(site);
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome chromosome) {
        return this.myPositionList.siteOfPhysicalPosition(physicalPosition, chromosome);
    }

    @Override
    public int siteOfPhysicalPosition(int physicalPosition, Chromosome chromosome, String snpName) {
        return this.myPositionList.siteOfPhysicalPosition(physicalPosition, chromosome, snpName);
    }

    @Override
    public int[] physicalPositions() {
        return this.myPositionList.physicalPositions();
    }

    @Override
    public String chromosomeName(int site) {
        return this.myPositionList.chromosomeName(site);
    }

    @Override
    public Chromosome chromosome(int site) {
        return this.myPositionList.chromosome(site);
    }

    @Override
    public Chromosome chromosome(String name) {
        return this.myPositionList.chromosome(name);
    }

    @Override
    public Chromosome[] chromosomes() {
        return this.myPositionList.chromosomes();
    }

    @Override
    public int numChromosomes() {
        return this.myPositionList.numChromosomes();
    }

    @Override
    public int[] chromosomesOffsets() {
        return this.myPositionList.chromosomesOffsets();
    }

    @Override
    public Set<SiteScore.SITE_SCORE_TYPE> siteScoreTypes() {
        HashSet<SiteScore.SITE_SCORE_TYPE> result = new HashSet<SiteScore.SITE_SCORE_TYPE>();
        if (this.hasAlleleProbabilities()) {
            result.addAll(this.myAlleleProbability.siteScoreTypes());
        }
        if (this.hasDosage()) {
            result.addAll(this.myDosage.siteScoreTypes());
        }
        if (this.hasReferenceProbablity()) {
            result.addAll(this.myReferenceProbabily.siteScoreTypes());
        }
        return result;
    }

    @Override
    public int indelSize(int site) {
        return this.myPositionList.indelSize(site);
    }

    @Override
    public boolean isIndel(int site) {
        return this.myPositionList.isIndel(site);
    }

    @Override
    public boolean isAllPolymorphic() {
        return this.myGenotype.isAllPolymorphic();
    }

    @Override
    public boolean isPolymorphic(int site) {
        return this.myGenotype.isPolymorphic(site);
    }

    @Override
    public byte majorAllele(int site) {
        return this.myGenotype.majorAllele(site);
    }

    @Override
    public String majorAlleleAsString(int site) {
        return this.myGenotype.majorAlleleAsString(site);
    }

    @Override
    public byte minorAllele(int site) {
        return this.myGenotype.minorAllele(site);
    }

    @Override
    public String minorAlleleAsString(int site) {
        return this.myGenotype.minorAlleleAsString(site);
    }

    @Override
    public byte[] minorAlleles(int site) {
        return this.myGenotype.minorAlleles(site);
    }

    @Override
    public byte[] alleles(int site) {
        return this.myGenotype.alleles(site);
    }

    @Override
    public double minorAlleleFrequency(int site) {
        return this.myGenotype.minorAlleleFrequency(site);
    }

    @Override
    public double majorAlleleFrequency(int site) {
        return this.myGenotype.majorAlleleFrequency(site);
    }

    @Override
    public TaxaList taxa() {
        return this.myTaxaList;
    }

    @Override
    public String taxaName(int index) {
        return this.myTaxaList.taxaName(index);
    }

    @Override
    public String genomeVersion() {
        return this.myPositionList.genomeVersion();
    }

    @Override
    public boolean isPositiveStrand(int site) {
        return this.myPositionList.isPositiveStrand(site);
    }

    @Override
    public GenotypeTable[] compositeAlignments() {
        return new GenotypeTable[]{this};
    }

    @Override
    public int[][] allelesSortedByFrequency(int site) {
        return this.myGenotype.allelesSortedByFrequency(site);
    }

    @Override
    public Object[][] genosSortedByFrequency(int site) {
        return this.myGenotype.genosSortedByFrequency(site);
    }

    @Override
    public boolean isPhased() {
        return this.myGenotype.isPhased();
    }

    @Override
    public boolean retainsRareAlleles() {
        return this.myGenotype.retainsRareAlleles();
    }

    @Override
    public String[][] alleleDefinitions() {
        return this.myGenotype.alleleDefinitions();
    }

    @Override
    public String[] alleleDefinitions(int site) {
        return this.myGenotype.alleleDefinitions(site);
    }

    @Override
    public String genotypeAsString(int site, byte value) {
        return this.myGenotype.genotypeAsString(site, value);
    }

    @Override
    public String diploidAsString(int site, byte value) {
        return this.myGenotype.diploidAsString(site, value);
    }

    @Override
    public int maxNumAlleles() {
        return this.myGenotype.maxNumAlleles();
    }

    @Override
    public int totalGametesNonMissingForSite(int site) {
        return this.myGenotype.totalGametesNonMissingForSite(site);
    }

    @Override
    public int totalNonMissingForSite(int site) {
        return this.myGenotype.totalNonMissingForSite(site);
    }

    @Override
    public int minorAlleleCount(int site) {
        return this.myGenotype.minorAlleleCount(site);
    }

    @Override
    public int majorAlleleCount(int site) {
        return this.myGenotype.majorAlleleCount(site);
    }

    @Override
    public Object[][] genoCounts() {
        return this.myGenotype.genoCounts();
    }

    @Override
    public Object[][] majorMinorCounts() {
        return this.myGenotype.majorMinorCounts();
    }

    @Override
    public int totalGametesNonMissingForTaxon(int taxon) {
        return this.myGenotype.totalGametesNonMissingForTaxon(taxon);
    }

    @Override
    public int heterozygousCountForTaxon(int taxon) {
        return this.myGenotype.heterozygousCountForTaxon(taxon);
    }

    @Override
    public int totalNonMissingForTaxon(int taxon) {
        return this.myGenotype.totalNonMissingForTaxon(taxon);
    }

    @Override
    public boolean hasGenotype() {
        return this.myGenotype != null;
    }

    @Override
    public boolean hasDepth() {
        return this.myAlleleDepth != null;
    }

    @Override
    public boolean hasAlleleProbabilities() {
        return this.myAlleleProbability != null;
    }

    @Override
    public boolean hasReferenceProbablity() {
        return this.myReferenceProbabily != null;
    }

    @Override
    public boolean hasDosage() {
        return this.myDosage != null;
    }

    @Override
    public AlleleDepth depth() {
        return this.myAlleleDepth;
    }

    @Override
    public int[] depthForAlleles(int taxon, int site) {
        return this.myAlleleDepth.values(taxon, site);
    }

    @Override
    public byte[] allelesBySortType(GenotypeTable.ALLELE_SORT_TYPE scope, int site) {
        switch (scope) {
            case Frequency: {
                return this.alleles(site);
            }
        }
        myLogger.warn((Object)("getAllelesByScope: Unsupported type: " + (Object)((Object)scope)));
        return null;
    }

    @Override
    public BitSet allelePresenceForAllTaxa(int site, WHICH_ALLELE allele) {
        return this.bitStorage(allele).allelePresenceForAllTaxa(site);
    }

    @Override
    public BitStorage bitStorage(WHICH_ALLELE allele) {
        BitStorage result = this.myBitStorage.get((Object)allele);
        if (result != null) {
            return result;
        }
        switch (allele) {
            case Major: {
                result = new DynamicBitStorage(this.myGenotype, allele, this.myGenotype.majorAlleleForAllSites());
                break;
            }
            case Minor: {
                result = new DynamicBitStorage(this.myGenotype, allele, this.myGenotype.minorAlleleForAllSites());
                break;
            }
            case Minor2: {
                result = new DynamicBitStorage(this.myGenotype, allele, this.myGenotype.thirdAlleleForAllSites());
                break;
            }
            case Unknown: {
                result = DynamicBitStorage.getUnknownInstance(this.myGenotype);
                break;
            }
            default: {
                myLogger.warn((Object)("bitStorage: Unsupported allele: " + (Object)((Object)allele)));
                return null;
            }
        }
        this.myBitStorage.put(allele, result);
        return result;
    }

    @Override
    public AlleleProbability alleleProbability() {
        return this.myAlleleProbability;
    }

    @Override
    public float alleleProbability(int taxon, int site, SiteScore.SITE_SCORE_TYPE type) {
        return this.myAlleleProbability.value(taxon, site, type);
    }

    @Override
    public ReferenceProbability referenceProbability() {
        return this.myReferenceProbabily;
    }

    @Override
    public float referenceProbability(int taxon, int site) {
        return this.myReferenceProbabily.value(taxon, site);
    }

    @Override
    public Dosage dosage() {
        return this.myDosage;
    }

    @Override
    public byte dosage(int taxon, int site) {
        return this.myDosage.value(taxon, site);
    }

    @Override
    public GeneralAnnotationStorage annotations() {
        return this.myAnnotations;
    }

    @Override
    public Stream<Byte> streamGenotype() {
        return this.myGenotype.stream();
    }

    @Override
    public Stream<Byte> streamGenotype(int taxon) {
        return this.myGenotype.stream(taxon);
    }

    @Override
    public boolean hasSiteTranslations() {
        return this.myGenotypeTranslate.hasSiteTranslations();
    }

    @Override
    public int[] siteTranslations() {
        return this.myGenotypeTranslate.siteTranslations();
    }
}

