/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import com.google.common.collect.SetMultimap;
import net.maizegenetics.dna.map.GVCFGenomeSequence;
import net.maizegenetics.dna.map.GVCFGenomeSequenceBuilder;
import net.maizegenetics.dna.map.Position;
import net.maizegenetics.dna.map.PositionList;
import net.maizegenetics.util.BitSet;
import org.apache.log4j.Logger;

public class FilterAndMaskGVCFGenomeSequence {
    private static final Logger myLogger = Logger.getLogger(FilterAndMaskGVCFGenomeSequence.class);

    private FilterAndMaskGVCFGenomeSequence() {
    }

    public static GVCFGenomeSequence getInstance(GVCFGenomeSequence base, String annoName, int symbol, int threshold, boolean mode) {
        PositionList positions = base.getGVCFPositions();
        BitSet currentBitSet = null;
        currentBitSet = mode ? base.getMaskBitSet() : base.getFilterBitSet();
        for (int i = 0; i < positions.size(); ++i) {
            boolean currentBitValue;
            Position position = (Position)positions.get(i);
            boolean alterPosition = FilterAndMaskGVCFGenomeSequence.filterPosition(position, annoName, symbol, threshold);
            boolean bl = currentBitValue = mode ? base.getMaskBitSet().fastGet(i) : base.getFilterBitSet().fastGet(i);
            if (currentBitValue || !alterPosition) continue;
            currentBitSet.fastFlip(i);
        }
        try {
            if (mode) {
                return (GVCFGenomeSequence)GVCFGenomeSequenceBuilder.instance(base, currentBitSet, base.getFilterBitSet());
            }
            return (GVCFGenomeSequence)GVCFGenomeSequenceBuilder.instance(base, base.getMaskBitSet(), currentBitSet);
        }
        catch (Exception e) {
            System.out.println("ERROR");
            e.printStackTrace();
            return null;
        }
    }

    private static boolean filterPosition(Position position, String annoName, int symbol, int threshold) {
        SetMultimap<String, String> annos = position.getAnnotation().getAnnotationAsMap();
        switch (symbol) {
            case 0: {
                if (!annos.containsKey((Object)annoName)) {
                    return false;
                }
                return Integer.parseInt((String)annos.get((Object)annoName).toArray()[0]) >= threshold;
            }
            case 1: {
                if (!annos.containsKey((Object)annoName)) {
                    return false;
                }
                return Integer.parseInt((String)annos.get((Object)annoName).toArray()[0]) > threshold;
            }
            case 2: {
                if (!annos.containsKey((Object)annoName)) {
                    return true;
                }
                return Integer.parseInt((String)annos.get((Object)annoName).toArray()[0]) != threshold;
            }
            case 3: {
                if (!annos.containsKey((Object)annoName)) {
                    return true;
                }
                return Integer.parseInt((String)annos.get((Object)annoName).toArray()[0]) < threshold;
            }
            case 4: {
                if (!annos.containsKey((Object)annoName)) {
                    return true;
                }
                return Integer.parseInt((String)annos.get((Object)annoName).toArray()[0]) <= threshold;
            }
        }
        return true;
    }
}

