/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.Map;
import net.maizegenetics.dna.snp.Filter;
import net.maizegenetics.dna.snp.FilterList;
import net.maizegenetics.dna.snp.FilterSite;
import net.maizegenetics.dna.snp.FilterTaxa;
import net.maizegenetics.util.TableReport;

public class FilterTableReport
implements TableReport {
    private static final String[] COLUMN_HEADERS = new String[]{"Key", "Value"};
    private final int myNumRows;
    private final String[] myRowHeaders;
    private final Object[] myFilterAttributes;

    public FilterTableReport(FilterList filters) {
        int numRows = 0;
        for (Filter filter : filters) {
            numRows += filter.numAttributes();
            ++numRows;
        }
        this.myNumRows = numRows;
        this.myFilterAttributes = new Object[this.myNumRows];
        this.myRowHeaders = new String[this.myNumRows];
        int count = 0;
        for (Filter filter : filters) {
            if (filter instanceof FilterSite) {
                for (Map.Entry<Enum, Object> entry : ((FilterSite)filter).attributes().entrySet()) {
                    this.myRowHeaders[count] = ((FilterSite.FILTER_SITES_ATTRIBUTES)entry.getKey()).name();
                    this.myFilterAttributes[count] = entry.getValue();
                    ++count;
                }
            } else if (filter instanceof FilterTaxa) {
                for (Map.Entry<Enum, Object> entry : ((FilterTaxa)filter).attributes().entrySet()) {
                    this.myRowHeaders[count] = ((FilterTaxa.FILTER_TAXA_ATTRIBUTES)entry.getKey()).name();
                    this.myFilterAttributes[count] = entry.getValue();
                    ++count;
                }
            }
            ++count;
        }
    }

    @Override
    public Object[] getTableColumnNames() {
        return COLUMN_HEADERS;
    }

    @Override
    public String getTableTitle() {
        return "Filter";
    }

    @Override
    public int getColumnCount() {
        return COLUMN_HEADERS.length;
    }

    @Override
    public long getRowCount() {
        return this.myNumRows;
    }

    @Override
    public long getElementCount() {
        return (long)this.getColumnCount() * this.getRowCount();
    }

    @Override
    public Object[] getRow(long row) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getValueAt(long row, int col) {
        switch (col) {
            case 0: {
                return this.myRowHeaders[(int)row];
            }
            case 1: {
                return this.myFilterAttributes[(int)row];
            }
        }
        throw new IllegalArgumentException("FilterTableReport: getValueAt: unknown column: " + col);
    }
}

