/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.maizegenetics.analysis.data.FileLoadPlugin;
import net.maizegenetics.dna.map.PositionListBuilder;
import net.maizegenetics.dna.snp.GenotypeTable;
import net.maizegenetics.dna.snp.GenotypeTableBuilder;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTableBuilder;
import net.maizegenetics.dna.snp.io.BuilderFromHapMap;
import net.maizegenetics.dna.snp.io.BuilderFromPLINK;
import net.maizegenetics.dna.snp.io.BuilderFromVCF;
import net.maizegenetics.plugindef.DataSet;
import net.maizegenetics.taxa.TaxaList;
import net.maizegenetics.taxa.TaxaListBuilder;
import net.maizegenetics.util.ProgressListener;
import net.maizegenetics.util.Utils;
import org.apache.log4j.Logger;

public class ImportUtils {
    private static final Logger myLogger = Logger.getLogger(ImportUtils.class);
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");
    public static final int NUM_HAPMAP_NON_TAXA_HEADERS = 11;

    private ImportUtils() {
    }

    public static GenotypeTable read(String filename) {
        return ImportUtils.read(filename, true, false);
    }

    public static GenotypeTable read(String filename, boolean keepDepth, boolean sortPositions) {
        FileLoadPlugin plugin = new FileLoadPlugin(null, false);
        plugin.setTheFileType(FileLoadPlugin.TasselFileType.Unknown);
        plugin.keepDepth(keepDepth);
        plugin.sortPositions(sortPositions);
        plugin.setOpenFiles(new String[]{filename});
        DataSet dataSet = plugin.performFunction(null);
        if (dataSet == null || dataSet.getSize() != 1) {
            throw new IllegalStateException("ImportUtils: read: nothing was loaded for: " + filename);
        }
        Object result = dataSet.getData(0).getData();
        if (result instanceof GenotypeTable) {
            return (GenotypeTable)result;
        }
        throw new IllegalStateException("ImportUtils: read: this file is not a Genotype Table: " + filename);
    }

    public static DataSet readDataSet(String filename) {
        FileLoadPlugin plugin = new FileLoadPlugin(null, false);
        plugin.setTheFileType(FileLoadPlugin.TasselFileType.Unknown);
        plugin.setOpenFiles(new String[]{filename});
        DataSet dataSet = plugin.performFunction(null);
        if (dataSet == null || dataSet.getSize() != 1) {
            throw new IllegalStateException("ImportUtils: readDataSet: nothing was loaded for: " + filename);
        }
        Object result = dataSet.getData(0).getData();
        if (result instanceof GenotypeTable) {
            return dataSet;
        }
        throw new IllegalStateException("ImportUtils: readDataSet: this file is not a Genotype Table: " + filename);
    }

    public static GenotypeTable readGuessFormat(String fileName) {
        if (fileName.endsWith(".h5")) {
            return GenotypeTableBuilder.getInstance(fileName);
        }
        if (fileName.endsWith("hmp.txt.gz") || fileName.endsWith("hmp.txt")) {
            return ImportUtils.readFromHapmap(fileName, null);
        }
        if (fileName.endsWith(".vcf") || fileName.endsWith(".vcf.gz")) {
            return ImportUtils.readFromVCF(fileName, null);
        }
        return null;
    }

    public static GenotypeTable readFromVCF(String filename, ProgressListener listener, boolean keepDepth, boolean sortPositions) {
        BuilderFromVCF builder = BuilderFromVCF.getBuilder(filename, listener);
        if (keepDepth) {
            builder.keepDepth();
        }
        if (sortPositions) {
            return builder.buildAndSortInMemory();
        }
        return builder.build();
    }

    public static GenotypeTable readFromVCF(String filename, ProgressListener listener, boolean keepDepth) {
        return ImportUtils.readFromVCF(filename, listener, keepDepth, false);
    }

    public static GenotypeTable readFromVCF(String filename, ProgressListener listener) {
        return ImportUtils.readFromVCF(filename, listener, true);
    }

    public static GenotypeTable readFromVCF(String filename) {
        return ImportUtils.readFromVCF(filename, null);
    }

    public static GenotypeTable readFromHapmap(String filename) {
        return ImportUtils.readFromHapmap(filename, null);
    }

    public static GenotypeTable readFromHapmap(String filename, ProgressListener listener) {
        return ImportUtils.readFromHapmap(filename, listener, false);
    }

    public static GenotypeTable readFromHapmap(String filename, ProgressListener listener, boolean sortPositions) {
        BuilderFromHapMap builder = BuilderFromHapMap.getBuilder(filename, listener);
        if (sortPositions) {
            builder.sortPositions();
        }
        return builder.build();
    }

    public static GenotypeTable readFromPLink(String pedFilename, String mapFilename, ProgressListener listener) {
        return BuilderFromPLINK.getBuilder(pedFilename, mapFilename, listener).build();
    }

    public static GenotypeTable readFromPLink(String pedFilename, String mapFilename, ProgressListener listener, boolean sortPositions) {
        if (sortPositions) {
            return BuilderFromPLINK.getBuilder(pedFilename, mapFilename, listener).sortPositions().build();
        }
        return BuilderFromPLINK.getBuilder(pedFilename, mapFilename, listener).build();
    }

    public static GenotypeTable readFasta(String filename) throws FileNotFoundException, IOException {
        BufferedReader reader = Utils.getBufferedReader(filename);
        ArrayList<String> taxa = new ArrayList<String>();
        ArrayList<String> sequences = new ArrayList<String>();
        String line = reader.readLine();
        boolean sequence = false;
        int sequenceLength = -1;
        int count = 1;
        while (line != null) {
            if ((line = line.trim()).startsWith(";")) {
                line = reader.readLine();
                continue;
            }
            if (line.startsWith(">")) {
                StringTokenizer tokens = new StringTokenizer(line);
                String taxaName = tokens.nextToken();
                taxaName = taxaName.length() == 1 ? tokens.nextToken() : taxaName.substring(1).trim();
                taxa.add(taxaName);
                sequence = true;
                line = reader.readLine();
                continue;
            }
            if (sequence) {
                StringBuilder builder = new StringBuilder();
                while (line != null && !line.startsWith(">") && !line.startsWith(";")) {
                    line = line.trim().toUpperCase();
                    builder.append(line);
                    line = reader.readLine();
                }
                String temp = builder.toString();
                if (sequenceLength == -1) {
                    sequenceLength = temp.length();
                } else if (sequenceLength != temp.length()) {
                    throw new IllegalStateException("ImportUtils: readFasta: Sequence: " + count + " Differs in Length.");
                }
                sequences.add(temp);
                sequence = false;
                ++count;
                continue;
            }
            myLogger.error((Object)("readFasta: file: " + filename + " invalid format."));
            throw new IllegalArgumentException("Import: readFasta: invalid format.");
        }
        String[] taxaNames = new String[taxa.size()];
        taxa.toArray(taxaNames);
        TaxaList taxaList = new TaxaListBuilder().addAll(taxaNames).build();
        String[] sequenceArray = new String[sequences.size()];
        sequences.toArray(sequenceArray);
        GenotypeCallTable genotype = GenotypeCallTableBuilder.getUnphasedNucleotideGenotypeBuilder(sequences.size(), sequenceLength).setBases(sequenceArray).build();
        return GenotypeTableBuilder.getInstance(genotype, PositionListBuilder.getInstance(sequenceLength), taxaList);
    }
}

