/*
 * Decompiled with CFR 0.152.
 */
package net.maizegenetics.dna.snp;

import java.util.function.BiPredicate;
import net.maizegenetics.dna.snp.AbstractMaskMatrix;
import net.maizegenetics.dna.snp.genotypecall.GenotypeCallTable;
import net.maizegenetics.dna.snp.genotypecall.ListStats;
import net.maizegenetics.dna.snp.genotypecall.Stats;
import net.maizegenetics.util.BitSet;
import net.maizegenetics.util.OpenBitSet;

public class MaskGenotypeStatsMatrix
extends AbstractMaskMatrix {
    private final GenotypeCallTable myGenotype;
    private final ListStats myStats;
    private ListStats myTaxaStats = null;
    private final BiPredicate<Byte, Stats> myPredicate;

    MaskGenotypeStatsMatrix(GenotypeCallTable genotype, BiPredicate<Byte, Stats> predicate) {
        super(genotype.numberOfTaxa(), genotype.numberOfSites());
        this.myGenotype = genotype;
        this.myPredicate = predicate;
        this.myStats = ListStats.getSiteInstance(genotype);
    }

    @Override
    protected BitSet siteMask(int site) {
        OpenBitSet result = new OpenBitSet(this.myNumTaxa);
        byte[] temp = this.myGenotype.genotypeForAllTaxa(site);
        for (int t = 0; t < this.myNumTaxa; ++t) {
            if (!this.myPredicate.test(temp[t], (Stats)this.myStats.get(site))) continue;
            result.fastSet(t);
        }
        return result;
    }

    @Override
    protected BitSet taxonMask(int taxon) {
        if (this.myTaxaStats == null) {
            this.myTaxaStats = ListStats.getTaxaInstance(this.myGenotype);
        }
        OpenBitSet result = new OpenBitSet(this.myNumSites);
        byte[] temp = this.myGenotype.genotypeForAllSites(taxon);
        for (int t = 0; t < this.myNumTaxa; ++t) {
            if (!this.myPredicate.test(temp[t], (Stats)this.myTaxaStats.get(taxon))) continue;
            result.fastSet(t);
        }
        return result;
    }

    @Override
    protected boolean isMasked(int taxon, int site) {
        return this.myPredicate.test(this.myGenotype.genotype(taxon, site), (Stats)this.myStats.get(site));
    }
}

